/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl.ciphers;

import java.util.HashMap;
import java.util.Map;

public enum Group {
    secp256r1(23),
    secp384r1(24),
    secp521r1(25),
    x25519(29),
    x448(30),
    ffdhe2048(256),
    ffdhe3072(257),
    ffdhe4096(258),
    ffdhe6144(259),
    ffdhe8192(260),
    MLKEM512(512),
    MLKEM768(513),
    MLKEM1024(514),
    SecP256r1MLKEM768(4587),
    X25519MLKEM768(4588),
    SecP384r1MLKEM1024(4589);

    private final int id;
    private static final Map<Integer, Group> idMap;

    private Group(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static Group valueOf(int groupId) {
        return idMap.get(groupId);
    }

    static {
        idMap = new HashMap<Integer, Group>();
        for (Group group : Group.values()) {
            int id = group.getId();
            if (id <= 0 || id >= 65535) continue;
            idMap.put(id, group);
        }
    }
}

