/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.function.IOStreams;

@FunctionalInterface
public interface IOConsumer<T> {
    public static final IOConsumer<?> NOOP_IO_CONSUMER = t -> {};

    @SafeVarargs
    public static <T> void forAll(IOConsumer<T> action, T ... array) throws IOExceptionList {
        IOStreams.forAll(IOStreams.of(array), action);
    }

    public static <T> IOConsumer<T> noop() {
        return NOOP_IO_CONSUMER;
    }

    public void accept(T var1) throws IOException;
}

