/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.log4j.Appender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.map.DatabaseConnectionMap;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleTransException;
import org.pentaho.di.core.logging.Log4jStringAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.di.trans.Messages;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransDependency;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.cluster.TransSplitter;
import org.pentaho.di.trans.performance.StepPerformanceSnapShot;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInitThread;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.WebResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trans
implements VariableSpace,
NamedParams {
    public static final String REPLAY_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static LogWriter log = LogWriter.getInstance();
    private TransMeta transMeta;
    private Repository repository;
    private Job parentJob;
    private Trans parentTrans;
    private String mappingStepName;
    private boolean monitored;
    private boolean preview;
    private Date startDate;
    private Date endDate;
    private Date currentDate;
    private Date logDate;
    private Date depDate;
    private Date jobStartDate;
    private Date jobEndDate;
    private long batchId;
    private long passedBatchId;
    private VariableSpace variables = new Variables();
    private List<RowSet> rowsets;
    private List<StepMetaDataCombi> steps;
    public int class_nr;
    private Date replayDate;
    public static final int TYPE_DISP_1_1 = 1;
    public static final int TYPE_DISP_1_N = 2;
    public static final int TYPE_DISP_N_1 = 3;
    public static final int TYPE_DISP_N_N = 4;
    public static final int TYPE_DISP_N_M = 5;
    public static final String STRING_FINISHED = "Finished";
    public static final String STRING_RUNNING = "Running";
    public static final String STRING_PREPARING = "Preparing executing";
    public static final String STRING_INITIALIZING = "Initializing";
    public static final String STRING_WAITING = "Waiting";
    public static final String STRING_STOPPED = "Stopped";
    public static final String STRING_HALTING = "Halting";
    public static final String CONFIGURATION_IN_EXPORT_FILENAME = "__job_execution_configuration__.xml";
    private boolean safeModeEnabled;
    private Log4jStringAppender stringAppender;
    private String threadName;
    private boolean preparing;
    private boolean initializing;
    private boolean running;
    private final AtomicBoolean finished;
    private AtomicBoolean paused;
    private AtomicBoolean stopped;
    private boolean readyToStart;
    private Map<String, List<StepPerformanceSnapShot>> stepPerformanceSnapShots;
    private Timer stepPerformanceSnapShotTimer;
    private List<TransListener> transListeners;
    private int nrOfFinishedSteps;
    private NamedParams namedParams = new NamedParamsDefault();
    private SocketRepository socketRepository;

    public Trans(TransMeta transMeta) {
        this.transMeta = transMeta;
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.TransformationIsPreloaded"), new Object[0]);
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("Trans.Log.NumberOfStepsToRun", String.valueOf(transMeta.nrSteps()), String.valueOf(transMeta.nrTransHops())), new Object[0]);
        }
        this.initializeVariablesFrom(transMeta);
        this.copyParametersFrom(transMeta);
        transMeta.activateParameters();
        this.threadName = Thread.currentThread().getName();
        this.transListeners = new ArrayList<TransListener>();
        this.finished = new AtomicBoolean(false);
        this.paused = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
    }

    public String getName() {
        if (this.transMeta == null) {
            return null;
        }
        return this.transMeta.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Trans(VariableSpace parentVariableSpace, Repository rep, String name, String dirname, String filename) throws KettleException {
        try {
            if (rep != null) {
                RepositoryDirectory repdir = rep.getDirectoryTree().findDirectory(dirname);
                if (repdir == null) throw new KettleException(Messages.getString("Trans.Exception.UnableToLoadTransformation", name, dirname));
                this.transMeta = new TransMeta(rep, name, repdir, false);
            } else {
                this.transMeta = new TransMeta(filename, false);
            }
            this.transMeta.initializeVariablesFrom(parentVariableSpace);
            this.initializeVariablesFrom(parentVariableSpace);
            this.transMeta.copyParametersFrom(this);
            this.transMeta.activateParameters();
            this.threadName = Thread.currentThread().getName();
        }
        catch (KettleException e) {
            throw new KettleException(Messages.getString("Trans.Exception.UnableToOpenTransformation", name), (Throwable)e);
        }
        this.transListeners = new ArrayList<TransListener>();
        this.finished = new AtomicBoolean(false);
        this.paused = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
    }

    public void execute(String[] arguments) throws KettleException {
        this.prepareExecution(arguments);
        this.startThreads();
    }

    public void prepareExecution(String[] arguments) throws KettleException {
        int i;
        int i2;
        int i3;
        this.preparing = true;
        this.startDate = null;
        this.running = false;
        if (arguments != null) {
            this.transMeta.setArguments(arguments);
        }
        this.activateParameters();
        this.transMeta.activateParameters();
        if (this.transMeta.getName() == null) {
            if (this.transMeta.getFilename() != null) {
                log.logMinimal(this.toString(), Messages.getString("Trans.Log.DispacthingStartedForFilename", this.transMeta.getFilename()), new Object[0]);
            }
        } else {
            log.logMinimal(this.toString(), Messages.getString("Trans.Log.DispacthingStartedForTransformation", this.transMeta.getName()), new Object[0]);
        }
        if (this.transMeta.getArguments() != null && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.NumberOfArgumentsDetected", String.valueOf(this.transMeta.getArguments().length)), new Object[0]);
        }
        if (this.isSafeModeEnabled() && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.SafeModeIsEnabled", this.transMeta.getName()), new Object[0]);
        }
        if (this.getReplayDate() != null) {
            SimpleDateFormat df = new SimpleDateFormat(REPLAY_DATE_FORMAT);
            log.logBasic(this.toString(), Messages.getString("Trans.Log.ThisIsAReplayTransformation") + df.format(this.getReplayDate()), new Object[0]);
        } else if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.ThisIsNotAReplayTransformation"), new Object[0]);
        }
        this.steps = new ArrayList<StepMetaDataCombi>();
        this.rowsets = new ArrayList<RowSet>();
        if (this.isMonitored()) {
            this.transMeta.sortStepsNatural();
        }
        List<StepMeta> hopsteps = this.transMeta.getTransHopSteps(false);
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.FoundDefferentSteps", String.valueOf(hopsteps.size())), new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.AllocatingRowsets"), new Object[0]);
        }
        for (i3 = 0; i3 < hopsteps.size(); ++i3) {
            StepMeta thisStep = hopsteps.get(i3);
            if (thisStep.isMapping()) continue;
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("Trans.Log.AllocateingRowsetsForStep", String.valueOf(i3), thisStep.getName()), new Object[0]);
            }
            List<StepMeta> nextSteps = this.transMeta.findNextSteps(thisStep);
            int nrTargets = nextSteps.size();
            for (int n = 0; n < nrTargets; ++n) {
                int nrCopies;
                int dispatchType;
                StepMeta nextStep = nextSteps.get(n);
                if (nextStep.isMapping()) continue;
                int thisCopies = thisStep.getCopies();
                int nextCopies = nextStep.getCopies();
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("Trans.Log.copiesInfo", String.valueOf(thisCopies), String.valueOf(nextCopies)), new Object[0]);
                }
                if (thisCopies == 1 && nextCopies == 1) {
                    dispatchType = 1;
                    nrCopies = 1;
                } else if (thisCopies == 1 && nextCopies > 1) {
                    dispatchType = 2;
                    nrCopies = nextCopies;
                } else if (thisCopies > 1 && nextCopies == 1) {
                    dispatchType = 3;
                    nrCopies = thisCopies;
                } else if (thisCopies == nextCopies) {
                    dispatchType = 4;
                    nrCopies = nextCopies;
                } else {
                    dispatchType = 5;
                    nrCopies = nextCopies;
                }
                if (dispatchType != 5) {
                    for (int c = 0; c < nrCopies; ++c) {
                        RowSet rowSet = new RowSet(this.transMeta.getSizeRowset());
                        switch (dispatchType) {
                            case 1: {
                                rowSet.setThreadNameFromToCopy(thisStep.getName(), 0, nextStep.getName(), 0);
                                break;
                            }
                            case 2: {
                                rowSet.setThreadNameFromToCopy(thisStep.getName(), 0, nextStep.getName(), c);
                                break;
                            }
                            case 3: {
                                rowSet.setThreadNameFromToCopy(thisStep.getName(), c, nextStep.getName(), 0);
                                break;
                            }
                            case 4: {
                                rowSet.setThreadNameFromToCopy(thisStep.getName(), c, nextStep.getName(), c);
                            }
                        }
                        this.rowsets.add(rowSet);
                        if (!log.isDetailed()) continue;
                        log.logDetailed(this.toString(), Messages.getString("Trans.TransformationAllocatedNewRowset", rowSet.toString()), new Object[0]);
                    }
                    continue;
                }
                for (int s = 0; s < thisCopies; ++s) {
                    for (int t = 0; t < nextCopies; ++t) {
                        RowSet rowSet = new RowSet(this.transMeta.getSizeRowset());
                        rowSet.setThreadNameFromToCopy(thisStep.getName(), s, nextStep.getName(), t);
                        this.rowsets.add(rowSet);
                        if (!log.isDetailed()) continue;
                        log.logDetailed(this.toString(), Messages.getString("Trans.TransformationAllocatedNewRowset", rowSet.toString()), new Object[0]);
                    }
                }
            }
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.AllocatedRowsets", String.valueOf(this.rowsets.size()), String.valueOf(i3), thisStep.getName()) + " ", new Object[0]);
        }
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.AllocatingStepsAndStepData"), new Object[0]);
        }
        for (i3 = 0; i3 < hopsteps.size(); ++i3) {
            StepMeta stepMeta = hopsteps.get(i3);
            String stepid = stepMeta.getStepID();
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("Trans.Log.TransformationIsToAllocateStep", stepMeta.getName(), stepid), new Object[0]);
            }
            int nrCopies = stepMeta.getCopies();
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("Trans.Log.StepHasNumberRowCopies", String.valueOf(nrCopies)), new Object[0]);
            }
            for (int c = 0; c < nrCopies; ++c) {
                List<String> partitionIDs;
                StepDataInterface data;
                if (this.hasStepStarted(stepMeta.getName(), c)) continue;
                StepMetaDataCombi combi = new StepMetaDataCombi();
                combi.stepname = stepMeta.getName();
                combi.copy = c;
                combi.stepMeta = stepMeta;
                combi.meta = stepMeta.getStepMetaInterface();
                combi.data = data = combi.meta.getStepData();
                StepInterface step = combi.meta.getStep(stepMeta, data, c, this.transMeta, this);
                ((BaseStep)step).initializeVariablesFrom(this);
                ((BaseStep)step).setUsingThreadPriorityManagment(this.transMeta.isUsingThreadPriorityManagment());
                if (stepMeta.isPartitioned() && (partitionIDs = stepMeta.getStepPartitioningMeta().getPartitionSchema().getPartitionIDs()) != null && partitionIDs.size() > 0) {
                    step.setPartitionID(partitionIDs.get(c));
                }
                ((BaseStep)step).setSafeModeEnabled(this.safeModeEnabled);
                combi.step = step;
                this.steps.add(combi);
                if (!log.isDetailed()) continue;
                log.logDetailed(this.toString(), Messages.getString("Trans.Log.TransformationHasAllocatedANewStep", stepMeta.getName(), String.valueOf(c)), new Object[0]);
            }
        }
        for (int s = 0; s < this.steps.size(); ++s) {
            StepMetaDataCombi combi = this.steps.get(s);
            if (!combi.stepMeta.isDoingErrorHandling()) continue;
            StepErrorMeta stepErrorMeta = combi.stepMeta.getStepErrorMeta();
            BaseStep baseStep = (BaseStep)combi.step;
            boolean stop = false;
            for (int rowsetNr = 0; rowsetNr < baseStep.outputRowSets.size() && !stop; ++rowsetNr) {
                RowSet outputRowSet = baseStep.outputRowSets.get(rowsetNr);
                if (!outputRowSet.getDestinationStepName().equalsIgnoreCase(stepErrorMeta.getTargetStep().getName())) continue;
                baseStep.errorRowSet = outputRowSet;
                baseStep.outputRowSets.remove(rowsetNr);
                stop = true;
            }
        }
        this.beginProcessing();
        for (i3 = 0; i3 < this.steps.size(); ++i3) {
            StepMetaDataCombi sid = this.steps.get(i3);
            StepMeta stepMeta = sid.stepMeta;
            BaseStep baseStep = (BaseStep)sid.step;
            baseStep.setPartitioned(stepMeta.isPartitioned());
            boolean isThisPartitioned = stepMeta.isPartitioned();
            PartitionSchema thisPartitionSchema = null;
            if (isThisPartitioned) {
                thisPartitionSchema = stepMeta.getStepPartitioningMeta().getPartitionSchema();
            }
            boolean isNextPartitioned = false;
            StepPartitioningMeta nextStepPartitioningMeta = null;
            PartitionSchema nextPartitionSchema = null;
            List<StepMeta> nextSteps = this.transMeta.findNextSteps(stepMeta);
            int nrNext = nextSteps.size();
            for (int p = 0; p < nrNext; ++p) {
                StepMeta nextStep = nextSteps.get(p);
                if (!nextStep.isPartitioned()) continue;
                isNextPartitioned = true;
                nextStepPartitioningMeta = nextStep.getStepPartitioningMeta();
                nextPartitionSchema = nextStepPartitioningMeta.getPartitionSchema();
            }
            baseStep.setRepartitioning(0);
            if ((isThisPartitioned || !isNextPartitioned) && (!isThisPartitioned || !isNextPartitioned || thisPartitionSchema.equals(nextPartitionSchema))) continue;
            baseStep.setRepartitioning(nextStepPartitioningMeta.getMethodType());
        }
        this.preparing = false;
        this.initializing = true;
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.InitialisingSteps", String.valueOf(this.steps.size())), new Object[0]);
        }
        StepInitThread[] initThreads = new StepInitThread[this.steps.size()];
        Thread[] threads = new Thread[this.steps.size()];
        Log4jStringAppender initAppender = null;
        if (this.preview) {
            initAppender = LogWriter.createStringAppender();
            log.addAppender((Appender)initAppender);
        }
        for (i2 = 0; i2 < this.steps.size(); ++i2) {
            StepMetaDataCombi sid = this.steps.get(i2);
            initThreads[i2] = new StepInitThread(sid, log);
            threads[i2] = new Thread(initThreads[i2]);
            threads[i2].setName("init of " + sid.stepname + "." + sid.copy + " (" + threads[i2].getName() + ")");
            threads[i2].start();
        }
        for (i2 = 0; i2 < threads.length; ++i2) {
            try {
                threads[i2].join();
                continue;
            }
            catch (Exception ex) {
                log.logError("Error with init thread: " + ex.getMessage(), ex.getMessage(), new Object[0]);
                log.logError(this.toString(), Const.getStackTracker((Throwable)ex), new Object[0]);
            }
        }
        this.initializing = false;
        boolean ok = true;
        for (i = 0; i < initThreads.length; ++i) {
            StepMetaDataCombi combi = initThreads[i].getCombi();
            if (!initThreads[i].isOk()) {
                log.logError(this.toString(), Messages.getString("Trans.Log.StepFailedToInit", combi.stepname + "." + combi.copy), new Object[0]);
                combi.data.setStatus(5);
                ok = false;
                continue;
            }
            combi.data.setStatus(3);
            if (!log.isDetailed()) continue;
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.StepInitialized", combi.stepname + "." + combi.copy), new Object[0]);
        }
        if (initAppender != null) {
            log.removeAppender((Appender)initAppender);
        }
        if (!ok) {
            for (i = 0; i < initThreads.length; ++i) {
                StepMetaDataCombi combi = initThreads[i].getCombi();
                combi.step.dispose(combi.meta, combi.data);
                if (initThreads[i].isOk()) {
                    combi.data.setStatus(7);
                    continue;
                }
                combi.data.setStatus(5);
            }
            this.fireTransFinishedListeners();
            this.finished.set(true);
            if (initAppender != null) {
                throw new KettleException(Messages.getString("Trans.Log.FailToInitializeAtLeastOneStep") + Const.CR + initAppender.getBuffer());
            }
            throw new KettleException(Messages.getString("Trans.Log.FailToInitializeAtLeastOneStep") + Const.CR);
        }
        this.readyToStart = true;
    }

    public void startThreads() throws KettleException {
        this.nrOfFinishedSteps = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            sid.step.markStart();
            sid.step.initBeforeStart();
            StepListener stepListener = new StepListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stepFinished(Trans trans, StepMeta stepMeta, StepInterface step) {
                    Trans trans2 = Trans.this;
                    synchronized (trans2) {
                        Trans.this.nrOfFinishedSteps++;
                        if (Trans.this.nrOfFinishedSteps >= Trans.this.steps.size()) {
                            Trans.this.finished.set(true);
                            Trans.this.addStepPerformanceSnapShot();
                            Trans.this.fireTransFinishedListeners();
                        }
                        if (step.getErrors() > 0L) {
                            log.logMinimal(Trans.this.getName(), Messages.getString("Trans.Log.TransformationDetectedErrors"), new Object[0]);
                            log.logMinimal(Trans.this.getName(), Messages.getString("Trans.Log.TransformationIsKillingTheOtherSteps"), new Object[0]);
                            Trans.this.killAllNoWait();
                        }
                    }
                }
            };
            sid.step.addStepListener(stepListener);
        }
        if (this.transMeta.isCapturingStepPerformanceSnapShots()) {
            this.stepPerformanceSnapShots = new HashMap<String, List<StepPerformanceSnapShot>>();
            this.stepPerformanceSnapShotTimer = new Timer();
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    Trans.this.addStepPerformanceSnapShot();
                }
            };
            this.stepPerformanceSnapShotTimer.schedule(timerTask, 100L, this.transMeta.getStepPerformanceCapturingDelay());
        }
        this.finished.set(false);
        this.paused.set(false);
        this.stopped.set(false);
        TransListener transListener = new TransListener(){

            public void transFinished(Trans trans) {
                if (Trans.this.transMeta.isCapturingStepPerformanceSnapShots() && Trans.this.stepPerformanceSnapShotTimer != null) {
                    Trans.this.stepPerformanceSnapShotTimer.cancel();
                }
                Trans.this.finished.set(true);
                Trans.this.running = false;
            }
        };
        this.addTransListener(transListener);
        this.running = true;
        for (int i = 0; i < this.steps.size(); ++i) {
            this.steps.get((int)i).step.start();
        }
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("Trans.Log.TransformationHasAllocated", String.valueOf(this.steps.size()), String.valueOf(this.rowsets.size())), new Object[0]);
        }
    }

    protected void fireTransFinishedListeners() {
        for (TransListener transListener : this.transListeners) {
            transListener.transFinished(this);
        }
    }

    protected void addStepPerformanceSnapShot() {
        if (this.transMeta.isCapturingStepPerformanceSnapShots()) {
            for (int i = 0; i < this.steps.size(); ++i) {
                StepPerformanceSnapShot previous;
                StepMeta stepMeta = this.steps.get((int)i).stepMeta;
                StepInterface step = this.steps.get((int)i).step;
                BaseStep baseStep = (BaseStep)step;
                StepPerformanceSnapShot snapShot = new StepPerformanceSnapShot(new Date(), stepMeta.getName(), step.getCopy(), step.getLinesRead(), step.getLinesWritten(), step.getLinesInput(), step.getLinesOutput(), step.getLinesUpdated(), step.getLinesRejected(), step.getErrors());
                List<StepPerformanceSnapShot> snapShotList = this.stepPerformanceSnapShots.get(step.toString());
                if (snapShotList == null) {
                    snapShotList = new ArrayList<StepPerformanceSnapShot>();
                    this.stepPerformanceSnapShots.put(step.toString(), snapShotList);
                    previous = null;
                } else {
                    previous = snapShotList.get(snapShotList.size() - 1);
                }
                snapShot.diff(previous, baseStep.rowsetInputSize(), baseStep.rowsetOutputSize());
                snapShotList.add(snapShot);
            }
        }
    }

    public void cleanup() {
        if (this.steps == null) {
            return;
        }
        for (StepMetaDataCombi combi : this.steps) {
            combi.step.cleanup();
        }
    }

    public void logSummary(StepInterface si) {
        log.logBasic(si.getStepname(), Messages.getString("Trans.Log.FinishedProcessing", String.valueOf(si.getLinesInput()), String.valueOf(si.getLinesOutput()), String.valueOf(si.getLinesRead())) + Messages.getString("Trans.Log.FinishedProcessing2", String.valueOf(si.getLinesWritten()), String.valueOf(si.getLinesUpdated()), String.valueOf(si.getErrors())), new Object[0]);
    }

    public void waitUntilFinished() {
        try {
            while (!this.finished.get()) {
                Thread.sleep(0L, 1);
            }
        }
        catch (Exception e) {
            log.logError(this.toString(), Messages.getString("Trans.Log.TransformationError") + e.toString(), new Object[0]);
            log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
        }
    }

    public int getErrors() {
        if (this.steps == null) {
            return 0;
        }
        int errors = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (sid.step.getErrors() == 0L) continue;
            ++errors;
        }
        if (errors > 0) {
            log.logError(this.toString(), Messages.getString("Trans.Log.TransformationErrorsDetected"), new Object[0]);
        }
        return errors;
    }

    public int getEnded() {
        int nrEnded = 0;
        if (this.steps == null) {
            return 0;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep thr = (BaseStep)sid.step;
            StepDataInterface data = sid.data;
            if ((thr == null || thr.isAlive()) && data.getStatus() != 4 && data.getStatus() != 7 && data.getStatus() != 5) continue;
            ++nrEnded;
        }
        return nrEnded;
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public void killAll() {
        if (this.steps == null) {
            return;
        }
        int nrStepsFinished = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep thr = (BaseStep)sid.step;
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("Trans.Log.LookingAtStep") + thr.getStepname(), new Object[0]);
            }
            while (thr.isAlive()) {
                thr.stopAll();
                try {
                    Thread.sleep(20L);
                }
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("Trans.Log.TransformationErrors") + e.toString(), new Object[0]);
                    return;
                }
            }
            if (thr.isAlive()) continue;
            ++nrStepsFinished;
        }
        if (nrStepsFinished == this.steps.size()) {
            this.finished.set(true);
        }
    }

    private void killAllNoWait() {
        if (this.steps == null) {
            return;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep thr = (BaseStep)sid.step;
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("Trans.Log.LookingAtStep") + thr.getStepname(), new Object[0]);
            }
            thr.stopAll();
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (Exception e) {
                log.logError(this.toString(), Messages.getString("Trans.Log.TransformationErrors") + e.toString(), new Object[0]);
                return;
            }
        }
    }

    public void printStats(int seconds) {
        log.logBasic(this.toString(), " ", new Object[0]);
        if (this.steps == null) {
            return;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep thr = (BaseStep)sid.step;
            long proc = thr.getProcessed();
            if (seconds != 0) {
                if (thr.getErrors() == 0L) {
                    log.logBasic(this.toString(), Messages.getString("Trans.Log.ProcessSuccessfullyInfo", thr.getStepname(), "." + thr.getCopy(), String.valueOf(proc), String.valueOf(proc / (long)seconds)), new Object[0]);
                    continue;
                }
                log.logError(this.toString(), Messages.getString("Trans.Log.ProcessErrorInfo", thr.getStepname(), "." + thr.getCopy(), String.valueOf(thr.getErrors()), String.valueOf(proc), String.valueOf(proc / (long)seconds)), new Object[0]);
                continue;
            }
            if (thr.getErrors() == 0L) {
                log.logBasic(this.toString(), Messages.getString("Trans.Log.ProcessSuccessfullyInfo", thr.getStepname(), "." + thr.getCopy(), String.valueOf(proc), seconds != 0 ? String.valueOf(proc / (long)seconds) : "-"), new Object[0]);
                continue;
            }
            log.logError(this.toString(), Messages.getString("Trans.Log.ProcessErrorInfo2", thr.getStepname(), "." + thr.getCopy(), String.valueOf(thr.getErrors()), String.valueOf(proc), String.valueOf(seconds)), new Object[0]);
        }
    }

    public long getLastProcessed() {
        if (this.steps == null) {
            return 0L;
        }
        int i = this.steps.size() - 1;
        if (i <= 0) {
            return 0L;
        }
        StepMetaDataCombi sid = this.steps.get(i);
        BaseStep thr = (BaseStep)sid.step;
        return thr.getProcessed();
    }

    public RowSet findRowSet(String rowsetname) {
        for (int i = 0; i < this.rowsets.size(); ++i) {
            RowSet rs = this.rowsets.get(i);
            if (!rs.getName().equalsIgnoreCase(rowsetname)) continue;
            return rs;
        }
        return null;
    }

    public RowSet findRowSet(String from, int fromcopy, String to, int tocopy) {
        for (int i = 0; i < this.rowsets.size(); ++i) {
            RowSet rs = this.rowsets.get(i);
            if (!rs.getOriginStepName().equalsIgnoreCase(from) || !rs.getDestinationStepName().equalsIgnoreCase(to) || rs.getOriginStepCopy() != fromcopy || rs.getDestinationStepCopy() != tocopy) continue;
            return rs;
        }
        return null;
    }

    public boolean hasStepStarted(String sname, int copy) {
        for (int i = 0; i < this.steps.size(); ++i) {
            boolean started;
            StepMetaDataCombi sid = this.steps.get(i);
            boolean bl = started = sid.stepname != null && sid.stepname.equalsIgnoreCase(sname) && sid.copy == copy;
            if (!started) continue;
            return true;
        }
        return false;
    }

    public void stopAll() {
        if (this.steps == null) {
            return;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep rt = (BaseStep)sid.step;
            rt.setStopped(true);
            rt.setPaused(false);
            BaseStep si = rt;
            try {
                si.stopRunning(sid.meta, sid.data);
            }
            catch (Exception e) {
                log.logError(this.toString(), "Something went wrong while trying to stop the transformation: " + e.toString(), new Object[0]);
                log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            }
            sid.data.setStatus(5);
        }
        this.paused.set(false);
        this.stopped.set(true);
    }

    public int nrSteps() {
        if (this.steps == null) {
            return 0;
        }
        return this.steps.size();
    }

    public int nrActiveSteps() {
        if (this.steps == null) {
            return 0;
        }
        int nr = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (!sid.step.isAlive()) continue;
            ++nr;
        }
        return nr;
    }

    public BaseStep getRunThread(int i) {
        if (this.steps == null) {
            return null;
        }
        StepMetaDataCombi sid = this.steps.get(i);
        return (BaseStep)sid.step;
    }

    public BaseStep getRunThread(String name, int copy) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep rt = (BaseStep)sid.step;
            if (!rt.getStepname().equalsIgnoreCase(name) || rt.getCopy() != copy) continue;
            return rt;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beginProcessing() throws KettleTransException {
        try {
            block42: {
                this.currentDate = new Date();
                this.logDate = new Date();
                this.startDate = Const.MIN_DATE;
                this.endDate = this.currentDate;
                SimpleDateFormat df = new SimpleDateFormat(REPLAY_DATE_FORMAT);
                log.logBasic(this.toString(), Messages.getString("Trans.Log.TransformationCanBeReplayed") + df.format(this.currentDate), new Object[0]);
                Database ldb = null;
                try {
                    try {
                        Date maxdesired;
                        String sql;
                        boolean lockedTable = false;
                        DatabaseMeta logcon = this.transMeta.getLogConnection();
                        if (logcon != null) {
                            Object[] lastr;
                            if (this.transMeta.getLogTable() == null) {
                                throw new KettleTransException(Messages.getString("Trans.Exception.NoLogTableDefined"));
                            }
                            ldb = new Database(logcon);
                            ldb.shareVariablesWith((VariableSpace)this);
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("Trans.Log.OpeningLogConnection", "" + this.transMeta.getLogConnection()), new Object[0]);
                            }
                            ldb.connect();
                            ldb.setCommit(100);
                            if (this.transMeta.isBatchIdUsed()) {
                                ldb.lockTables(new String[]{this.transMeta.getLogTable()});
                                lockedTable = true;
                                sql = "INSERT INTO " + logcon.quoteField(this.transMeta.getLogTable()) + "(" + logcon.quoteField("ID_BATCH") + ") values (-1)";
                                ldb.execStatement(sql);
                                Long id_batch = ldb.getNextValue(this.transMeta.getCounters(), this.transMeta.getLogTable(), "ID_BATCH");
                                this.setBatchId(id_batch);
                            }
                            if ((lastr = ldb.getLastLogDate(this.transMeta.getLogTable(), this.transMeta.getName(), false, Messages.getString("Trans.Row.Status.End"))) != null && lastr.length > 0) {
                                this.startDate = (Date)lastr[0];
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("Trans.Log.StartDateFound") + this.startDate, new Object[0]);
                                }
                            }
                            if (this.transMeta.getMaxDateConnection() != null && this.transMeta.getMaxDateTable() != null && this.transMeta.getMaxDateTable().length() > 0 && this.transMeta.getMaxDateField() != null && this.transMeta.getMaxDateField().length() > 0) {
                                DatabaseMeta maxcon;
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("Trans.Log.LookingForMaxdateConnection", "" + this.transMeta.getMaxDateConnection()), new Object[0]);
                                }
                                if ((maxcon = this.transMeta.getMaxDateConnection()) == null) throw new KettleTransException(Messages.getString("Trans.Exception.MaximumDateConnectionCouldNotBeFound", "" + this.transMeta.getMaxDateConnection()));
                                Database maxdb = new Database(maxcon);
                                maxdb.shareVariablesWith((VariableSpace)this);
                                try {
                                    block40: {
                                        try {
                                            if (log.isDetailed()) {
                                                log.logDetailed(this.toString(), Messages.getString("Trans.Log.OpeningMaximumDateConnection"), new Object[0]);
                                            }
                                            maxdb.connect();
                                            String sql2 = "SELECT MAX(" + this.transMeta.getMaxDateField() + ") FROM " + this.transMeta.getMaxDateTable();
                                            RowMetaAndData r1 = maxdb.getOneRow(sql2);
                                            if (r1 != null) {
                                                Date maxvalue = r1.getRowMeta().getDate(r1.getData(), 0);
                                                if (maxvalue != null) {
                                                    if (log.isDetailed()) {
                                                        log.logDetailed(this.toString(), Messages.getString("Trans.Log.LastDateFoundOnTheMaxdateConnection") + r1, new Object[0]);
                                                    }
                                                    this.endDate.setTime((long)((double)maxvalue.getTime() + this.transMeta.getMaxDateOffset() * 1000.0));
                                                }
                                                break block40;
                                            }
                                            if (log.isDetailed()) {
                                                log.logDetailed(this.toString(), Messages.getString("Trans.Log.NoLastDateFoundOnTheMaxdateConnection"), new Object[0]);
                                            }
                                        }
                                        catch (KettleException e) {
                                            throw new KettleTransException(Messages.getString("Trans.Exception.ErrorConnectingToDatabase", "" + this.transMeta.getMaxDateConnection()), (Throwable)e);
                                        }
                                    }
                                    Object var12_16 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var12_17 = null;
                                    maxdb.disconnect();
                                    throw throwable;
                                }
                                maxdb.disconnect();
                            }
                            if (this.transMeta.nrDependencies() > 0) {
                                Date dep;
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("Trans.Log.CheckingForMaxDependencyDate"), new Object[0]);
                                }
                                this.depDate = Const.MIN_DATE;
                                Date maxdepdate = Const.MIN_DATE;
                                if (lastr != null && lastr.length > 0 && (dep = (Date)lastr[1]) != null) {
                                    maxdepdate = dep;
                                    this.depDate = dep;
                                }
                                for (int i = 0; i < this.transMeta.nrDependencies(); ++i) {
                                    Object var15_22;
                                    TransDependency td = this.transMeta.getDependency(i);
                                    DatabaseMeta depcon = td.getDatabase();
                                    if (depcon == null) throw new KettleTransException(Messages.getString("Trans.Exception.ConnectionCouldNotBeFound", "" + td.getDatabase()));
                                    Database depdb = new Database(depcon);
                                    try {
                                        try {
                                            depdb.connect();
                                            String sql3 = "SELECT MAX(" + td.getFieldname() + ") FROM " + td.getTablename();
                                            RowMetaAndData r1 = depdb.getOneRow(sql3);
                                            if (r1 == null) throw new KettleTransException(Messages.getString("Trans.Exception.UnableToGetDependencyInfoFromDB", td.getDatabase().getName() + ".", td.getTablename() + ".", td.getFieldname()));
                                            Date maxvalue = (Date)r1.getData()[0];
                                            if (maxvalue == null) throw new KettleTransException(Messages.getString("Trans.Exception.UnableToGetDependencyInfoFromDB", td.getDatabase().getName() + ".", td.getTablename() + ".", td.getFieldname()));
                                            if (log.isDetailed()) {
                                                log.logDetailed(this.toString(), Messages.getString("Trans.Log.FoundDateFromTable", td.getTablename(), "." + td.getFieldname(), " = " + maxvalue.toString()), new Object[0]);
                                            }
                                            if (maxvalue.getTime() > maxdepdate.getTime()) {
                                                maxdepdate = maxvalue;
                                            }
                                            var15_22 = null;
                                        }
                                        catch (KettleException e) {
                                            throw new KettleTransException(Messages.getString("Trans.Exception.ErrorInDatabase", "" + td.getDatabase()), (Throwable)e);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var15_22 = null;
                                        depdb.disconnect();
                                        throw throwable;
                                    }
                                    depdb.disconnect();
                                    if (!log.isDetailed()) continue;
                                    log.logDetailed(this.toString(), Messages.getString("Trans.Log.Maxdepdate") + XMLHandler.date2string((Date)maxdepdate), new Object[0]);
                                }
                                if (maxdepdate.getTime() > this.depDate.getTime()) {
                                    this.depDate = maxdepdate;
                                    this.startDate = Const.MIN_DATE;
                                }
                            } else {
                                this.depDate = this.currentDate;
                            }
                        }
                        if (this.transMeta.getMaxDateDifference() > 0.0 && this.startDate.getTime() > Const.MIN_DATE.getTime() && this.endDate.compareTo(maxdesired = new Date(this.startDate.getTime() + (long)this.transMeta.getMaxDateDifference() * 1000L)) > 0) {
                            this.endDate = maxdesired;
                        }
                        if (Const.isEmpty((String)this.transMeta.getName()) && logcon != null && this.transMeta.getLogTable() != null) {
                            throw new KettleException(Messages.getString("Trans.Exception.NoTransnameAvailableForLogging"));
                        }
                        if (logcon != null && this.transMeta.getLogTable() != null && this.transMeta.getName() != null) {
                            ldb.writeLogRecord(this.transMeta.getLogTable(), this.transMeta.isBatchIdUsed(), this.getBatchId(), false, this.transMeta.getName(), "start", 0L, 0L, 0L, 0L, 0L, 0L, this.startDate, this.endDate, this.logDate, this.depDate, this.currentDate, null);
                        }
                        if (lockedTable) {
                            sql = "DELETE FROM " + logcon.quoteField(this.transMeta.getLogTable()) + " WHERE " + logcon.quoteField("ID_BATCH") + "= -1";
                            ldb.execStatement(sql);
                            ldb.unlockTables(new String[]{this.transMeta.getLogTable()});
                        }
                    }
                    catch (KettleException e) {
                        throw new KettleTransException(Messages.getString("Trans.Exception.ErrorWritingLogRecordToTable", this.transMeta.getLogTable()), (Throwable)e);
                    }
                    Object var17_24 = null;
                    if (ldb == null) break block42;
                }
                catch (Throwable throwable) {
                    Object var17_25 = null;
                    if (ldb == null) throw throwable;
                    ldb.disconnect();
                    throw throwable;
                }
                ldb.disconnect();
            }
            if (!this.transMeta.isLogfieldUsed()) return;
            this.stringAppender = LogWriter.createStringAppender();
            String logLimit = this.environmentSubstitute(this.transMeta.getLogSizeLimit());
            if (Const.isEmpty((String)logLimit)) {
                logLimit = this.environmentSubstitute("KETTLE_LOG_SIZE_LIMIT");
            }
            this.stringAppender.setMaxNrLines(Const.toInt((String)logLimit, (int)0));
            log.addAppender((Appender)this.stringAppender);
            this.stringAppender.setBuffer(new StringBuffer(Messages.getString("Trans.Log.Start") + Const.CR));
            return;
        }
        catch (KettleException e) {
            throw new KettleTransException(Messages.getString("Trans.Exception.UnableToBeginProcessingTransformation"), (Throwable)e);
        }
    }

    public Result getResult() {
        if (this.steps == null) {
            return null;
        }
        Result result = new Result();
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep rt = (BaseStep)sid.step;
            result.setNrErrors(result.getNrErrors() + sid.step.getErrors());
            result.getResultFiles().putAll(rt.getResultFiles());
            if (this.transMeta.getReadStep() != null && rt.getStepname().equals(this.transMeta.getReadStep().getName())) {
                result.setNrLinesRead(result.getNrLinesRead() + rt.getLinesRead());
            }
            if (this.transMeta.getInputStep() != null && rt.getStepname().equals(this.transMeta.getInputStep().getName())) {
                result.setNrLinesInput(result.getNrLinesInput() + rt.getLinesInput());
            }
            if (this.transMeta.getWriteStep() != null && rt.getStepname().equals(this.transMeta.getWriteStep().getName())) {
                result.setNrLinesWritten(result.getNrLinesWritten() + rt.getLinesWritten());
            }
            if (this.transMeta.getOutputStep() != null && rt.getStepname().equals(this.transMeta.getOutputStep().getName())) {
                result.setNrLinesOutput(result.getNrLinesOutput() + rt.getLinesOutput());
            }
            if (this.transMeta.getUpdateStep() != null && rt.getStepname().equals(this.transMeta.getUpdateStep().getName())) {
                result.setNrLinesUpdated(result.getNrLinesUpdated() + rt.getLinesUpdated());
            }
            if (this.transMeta.getRejectedStep() == null || !rt.getStepname().equals(this.transMeta.getRejectedStep().getName())) continue;
            result.setNrLinesRejected(result.getNrLinesRejected() + rt.getLinesRejected());
        }
        result.setRows(this.transMeta.getResultRows());
        result.setStopped(this.isStopped());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean endProcessing(String status) throws KettleException {
        DatabaseMeta logcon;
        Result result = this.getResult();
        if (this.transMeta.isUsingUniqueConnections()) {
            this.closeUniqueDatabaseConnections(result);
        }
        this.logDate = new Date();
        String log_string = null;
        if (this.transMeta.isLogfieldUsed() && this.stringAppender != null) {
            log_string = this.stringAppender.getBuffer().append(Const.CR + "END" + Const.CR).toString();
            log.removeAppender((Appender)this.stringAppender);
        }
        if ((logcon = this.transMeta.getLogConnection()) == null) return true;
        Database ldb = new Database(logcon);
        ldb.shareVariablesWith((VariableSpace)this);
        try {
            block9: {
                try {
                    ldb.connect();
                    if (!Const.isEmpty((String)this.transMeta.getLogTable())) {
                        ldb.writeLogRecord(this.transMeta.getLogTable(), this.transMeta.isBatchIdUsed(), this.getBatchId(), false, this.transMeta.getName(), status, result.getNrLinesRead(), result.getNrLinesWritten(), result.getNrLinesUpdated(), result.getNrLinesInput() + result.getNrFilesRetrieved(), result.getNrLinesOutput(), result.getNrErrors(), this.startDate, this.endDate, this.logDate, this.depDate, this.currentDate, log_string);
                    }
                    if (Const.isEmpty((String)this.transMeta.getStepPerformanceLogTable()) || !this.transMeta.isCapturingStepPerformanceSnapShots()) break block9;
                    RowMetaInterface rowMeta = Database.getStepPerformanceLogrecordFields();
                    ldb.prepareInsert(rowMeta, this.transMeta.getStepPerformanceLogTable());
                    for (String key : this.stepPerformanceSnapShots.keySet()) {
                        List<StepPerformanceSnapShot> snapshots = this.stepPerformanceSnapShots.get(key);
                        long seqNr = 1L;
                        for (StepPerformanceSnapShot snapshot : snapshots) {
                            Object[] row = new Object[rowMeta.size()];
                            int outputIndex = 0;
                            row[outputIndex++] = new Long(this.getBatchId());
                            row[outputIndex++] = new Long(seqNr++);
                            row[outputIndex++] = snapshot.getDate();
                            row[outputIndex++] = this.transMeta.getName();
                            row[outputIndex++] = snapshot.getStepName();
                            row[outputIndex++] = new Long(snapshot.getStepCopy());
                            row[outputIndex++] = new Long(snapshot.getLinesRead());
                            row[outputIndex++] = new Long(snapshot.getLinesWritten());
                            row[outputIndex++] = new Long(snapshot.getLinesUpdated());
                            row[outputIndex++] = new Long(snapshot.getLinesInput());
                            row[outputIndex++] = new Long(snapshot.getLinesOutput());
                            row[outputIndex++] = new Long(snapshot.getLinesRejected());
                            row[outputIndex++] = new Long(snapshot.getErrors());
                            row[outputIndex++] = new Long(snapshot.getInputBufferSize());
                            row[outputIndex++] = new Long(snapshot.getOutputBufferSize());
                            ldb.setValuesInsert(rowMeta, row);
                            ldb.insertRow(true);
                        }
                    }
                    ldb.insertFinished(true);
                }
                catch (Exception e) {
                    throw new KettleException(Messages.getString("Trans.Exception.ErrorWritingLogRecordToTable") + this.transMeta.getLogTable() + "]", (Throwable)e);
                }
            }
            Object var17_16 = null;
            ldb.disconnect();
            return true;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            ldb.disconnect();
            throw throwable;
        }
    }

    private void closeUniqueDatabaseConnections(Result result) {
        DatabaseConnectionMap map = DatabaseConnectionMap.getInstance();
        ArrayList databaseList = new ArrayList(map.getMap().values());
        for (Database database : databaseList) {
            if (!database.getConnectionGroup().equals(this.getThreadName())) continue;
            try {
                if (result.getNrErrors() > 0L) {
                    try {
                        database.rollback(true);
                        log.logBasic(this.toString(), Messages.getString("Trans.Exception.TransactionsRolledBackOnConnection", database.toString()), new Object[0]);
                    }
                    catch (Exception e) {
                        throw new KettleDatabaseException(Messages.getString("Trans.Exception.ErrorRollingBackUniqueConnection", database.toString()), (Throwable)e);
                    }
                }
                try {
                    database.commit(true);
                    log.logBasic(this.toString(), Messages.getString("Trans.Exception.TransactionsCommittedOnConnection", database.toString()), new Object[0]);
                }
                catch (Exception e) {
                    throw new KettleDatabaseException(Messages.getString("Trans.Exception.ErrorCommittingUniqueConnection", database.toString()), (Throwable)e);
                }
                database.closeConnectionOnly();
                map.removeConnection(database.getConnectionGroup(), database.getPartitionId(), database);
            }
            catch (Exception e) {
                log.logError(this.toString(), Messages.getString("Trans.Exception.ErrorHandlingTransformationTransaction", database.toString()), (Throwable)e);
                result.setNrErrors(result.getNrErrors() + 1L);
            }
        }
    }

    public BaseStep findRunThread(String stepname) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep rt = (BaseStep)sid.step;
            if (!rt.getStepname().equalsIgnoreCase(stepname)) continue;
            return rt;
        }
        return null;
    }

    public List<BaseStep> findBaseSteps(String stepname) {
        ArrayList<BaseStep> baseSteps = new ArrayList<BaseStep>();
        if (this.steps == null) {
            return baseSteps;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep rt = (BaseStep)sid.step;
            if (!rt.getStepname().equalsIgnoreCase(stepname)) continue;
            baseSteps.add(rt);
        }
        return baseSteps;
    }

    public StepDataInterface findDataInterface(String name) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            BaseStep rt = (BaseStep)sid.step;
            if (!rt.getStepname().equalsIgnoreCase(name)) continue;
            return sid.data;
        }
        return null;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isMonitored() {
        return this.monitored;
    }

    public void setMonitored(boolean monitored) {
        this.monitored = monitored;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public Date getDepDate() {
        return this.depDate;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public List<RowSet> getRowsets() {
        return this.rowsets;
    }

    public List<StepMetaDataCombi> getSteps() {
        return this.steps;
    }

    public String toString() {
        if (this.transMeta == null || this.transMeta.getName() == null) {
            return this.getClass().getSimpleName();
        }
        StringBuffer string = new StringBuffer();
        if (this.getParentTrans() != null) {
            string.append('[').append(this.getParentTrans().toString()).append(']').append('.');
        }
        if (!Const.isEmpty((String)this.mappingStepName)) {
            string.append('[').append(this.mappingStepName).append(']').append('.');
        }
        string.append(this.transMeta.getName());
        return string.toString();
    }

    public MappingInput[] findMappingInput() {
        if (this.steps == null) {
            return null;
        }
        ArrayList<MappingInput> list = new ArrayList<MappingInput>();
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi smdc = this.steps.get(i);
            StepInterface step = smdc.step;
            if (!step.getStepID().equalsIgnoreCase("MappingInput")) continue;
            list.add((MappingInput)step);
        }
        return list.toArray(new MappingInput[list.size()]);
    }

    public MappingOutput[] findMappingOutput() {
        ArrayList<MappingOutput> list = new ArrayList<MappingOutput>();
        if (this.steps != null) {
            for (int i = 0; i < this.steps.size(); ++i) {
                StepMetaDataCombi smdc = this.steps.get(i);
                StepInterface step = smdc.step;
                if (!step.getStepID().equalsIgnoreCase("MappingOutput")) continue;
                list.add((MappingOutput)step);
            }
        }
        return list.toArray(new MappingOutput[list.size()]);
    }

    public StepInterface getStepInterface(String stepname, int copy) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (!sid.stepname.equalsIgnoreCase(stepname) || sid.copy != copy) continue;
            return sid.step;
        }
        return null;
    }

    public Date getReplayDate() {
        return this.replayDate;
    }

    public void setReplayDate(Date replayDate) {
        this.replayDate = replayDate;
    }

    public void setSafeModeEnabled(boolean safeModeEnabled) {
        this.safeModeEnabled = safeModeEnabled;
    }

    public boolean isSafeModeEnabled() {
        return this.safeModeEnabled;
    }

    public RowProducer addRowProducer(String stepname, int copynr) throws KettleException {
        StepInterface stepInterface = this.getStepInterface(stepname, copynr);
        if (stepInterface == null) {
            throw new KettleException("Unable to find thread with name " + stepname + " and copy number " + copynr);
        }
        RowSet rowSet = new RowSet(this.transMeta.getSizeRowset());
        stepInterface.getInputRowSets().add(rowSet);
        return new RowProducer(stepInterface, rowSet);
    }

    public Job getParentJob() {
        return this.parentJob;
    }

    public void setParentJob(Job parentJob) {
        this.parentJob = parentJob;
    }

    public StepDataInterface getStepDataInterface(String stepname, int stepcopy) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (!sid.stepname.equals(stepname) || sid.copy != stepcopy) continue;
            return sid.data;
        }
        return null;
    }

    public boolean hasHaltedSteps() {
        if (this.steps == null) {
            return false;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (sid.data.getStatus() != 7) continue;
            return true;
        }
        return false;
    }

    public Date getJobStartDate() {
        return this.jobStartDate;
    }

    public Date getJobEndDate() {
        return this.jobEndDate;
    }

    public void setJobEndDate(Date jobEndDate) {
        this.jobEndDate = jobEndDate;
    }

    public void setJobStartDate(Date jobStartDate) {
        this.jobStartDate = jobStartDate;
    }

    public long getPassedBatchId() {
        return this.passedBatchId;
    }

    public void setPassedBatchId(long jobBatchId) {
        this.passedBatchId = jobBatchId;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getStatus() {
        String message;
        if (this.running) {
            if (this.isStopped()) {
                message = STRING_HALTING;
            } else if (this.isFinished()) {
                message = STRING_FINISHED;
                if (this.getResult().getNrErrors() > 0L) {
                    message = message + " (with errors)";
                }
            } else {
                message = STRING_RUNNING;
            }
        } else {
            message = this.isStopped() ? STRING_STOPPED : (this.preparing ? STRING_PREPARING : (this.initializing ? STRING_INITIALIZING : STRING_WAITING));
        }
        return message;
    }

    public boolean isInitializing() {
        return this.initializing;
    }

    public void setInitializing(boolean initializing) {
        this.initializing = initializing;
    }

    public boolean isPreparing() {
        return this.preparing;
    }

    public void setPreparing(boolean preparing) {
        this.preparing = preparing;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public static final TransSplitter executeClustered(TransMeta transMeta, TransExecutionConfiguration executionConfiguration) throws KettleException {
        if (Const.isEmpty((String)transMeta.getName())) {
            throw new KettleException("The transformation needs a name to uniquely identify it by on the remote server.");
        }
        TransSplitter transSplitter = new TransSplitter(transMeta);
        transSplitter.splitOriginalTransformation();
        Trans.executeClustered(transSplitter, executionConfiguration);
        return transSplitter;
    }

    public static final void executeClustered(final TransSplitter transSplitter, final TransExecutionConfiguration executionConfiguration) throws KettleException {
        try {
            int i;
            TransMeta master = transSplitter.getMaster();
            final SlaveServer[] slaves = transSplitter.getSlaveTargets();
            Thread[] threads = new Thread[slaves.length];
            final Throwable[] errors = new Throwable[slaves.length];
            SlaveServer masterServer = null;
            List<StepMeta> masterSteps = master.getTransHopSteps(false);
            if (masterSteps.size() > 0) {
                masterServer = transSplitter.getMasterServer();
                if (executionConfiguration.isClusterPosting()) {
                    TransConfiguration transConfiguration = new TransConfiguration(master, executionConfiguration);
                    Map<String, String> variables = transConfiguration.getTransExecutionConfiguration().getVariables();
                    variables.put("Internal.Cluster.Size", Integer.toString(slaves.length));
                    variables.put("Internal.Cluster.Master", "Y");
                    Map<String, String> params = transConfiguration.getTransExecutionConfiguration().getParams();
                    TransMeta ot = transSplitter.getOriginalTransformation();
                    for (String param : ot.listParameters()) {
                        String value = Const.NVL((String)ot.getParameterValue(param), (String)Const.NVL((String)ot.getParameterDefault(param), (String)ot.getVariable(param)));
                        params.put(param, value);
                    }
                    String masterReply = masterServer.sendXML(transConfiguration.getXML(), "/kettle/addTrans/?xml=Y");
                    WebResult webResult = WebResult.fromXMLString(masterReply);
                    if (!webResult.getResult().equalsIgnoreCase("OK")) {
                        throw new KettleException("An error occurred sending the master transformation: " + webResult.getMessage());
                    }
                }
            }
            for (i = 0; i < slaves.length; ++i) {
                final int index = i;
                final TransMeta slaveTrans = transSplitter.getSlaveTransMap().get(slaves[i]);
                if (!executionConfiguration.isClusterPosting()) continue;
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            TransExecutionConfiguration slaveTransExecutionConfiguration = (TransExecutionConfiguration)executionConfiguration.clone();
                            TransConfiguration transConfiguration = new TransConfiguration(slaveTrans, slaveTransExecutionConfiguration);
                            Map<String, String> variables = slaveTransExecutionConfiguration.getVariables();
                            variables.put("Internal.Slave.Transformation.Number", Integer.toString(index));
                            variables.put("Internal.Slave.Server.Name", slaves[index].getName());
                            variables.put("Internal.Cluster.Size", Integer.toString(slaves.length));
                            variables.put("Internal.Cluster.Master", "N");
                            Map<String, String> params = slaveTransExecutionConfiguration.getParams();
                            TransMeta ot = transSplitter.getOriginalTransformation();
                            for (String param : ot.listParameters()) {
                                String value = Const.NVL((String)ot.getParameterValue(param), (String)Const.NVL((String)ot.getParameterDefault(param), (String)ot.getVariable(param)));
                                params.put(param, value);
                            }
                            String slaveReply = slaves[index].sendXML(transConfiguration.getXML(), "/kettle/addTrans/?xml=Y");
                            WebResult webResult = WebResult.fromXMLString(slaveReply);
                            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                                throw new KettleException("An error occurred sending a slave transformation: " + webResult.getMessage());
                            }
                        }
                        catch (Throwable t) {
                            errors[index] = t;
                        }
                    }
                };
                threads[i] = new Thread(runnable);
            }
            for (i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                threads[i].join();
                if (errors[i] == null) continue;
                throw new KettleException(errors[i]);
            }
            if (executionConfiguration.isClusterPosting()) {
                WebResult webResult;
                String slaveReply;
                TransMeta slaveTrans;
                WebResult webResult2;
                if (executionConfiguration.isClusterPreparing()) {
                    String masterReply;
                    if (masterSteps.size() > 0 && !(webResult2 = WebResult.fromXMLString(masterReply = masterServer.getContentFromServer("/kettle/prepareExec/?name=" + URLEncoder.encode(master.getName(), "UTF-8") + "&xml=Y"))).getResult().equalsIgnoreCase("OK")) {
                        throw new KettleException("An error occurred while preparing the execution of the master transformation: " + webResult2.getMessage());
                    }
                    for (i = 0; i < slaves.length; ++i) {
                        slaveTrans = transSplitter.getSlaveTransMap().get(slaves[i]);
                        slaveReply = slaves[i].getContentFromServer("/kettle/prepareExec/?name=" + URLEncoder.encode(slaveTrans.getName(), "UTF-8") + "&xml=Y");
                        webResult = WebResult.fromXMLString(slaveReply);
                        if (webResult.getResult().equalsIgnoreCase("OK")) continue;
                        throw new KettleException("An error occurred while preparing the execution of a slave transformation: " + webResult.getMessage());
                    }
                }
                if (executionConfiguration.isClusterStarting()) {
                    String masterReply;
                    if (masterSteps.size() > 0 && !(webResult2 = WebResult.fromXMLString(masterReply = masterServer.getContentFromServer("/kettle/startExec/?name=" + URLEncoder.encode(master.getName(), "UTF-8") + "&xml=Y"))).getResult().equalsIgnoreCase("OK")) {
                        throw new KettleException("An error occurred while starting the execution of the master transformation: " + webResult2.getMessage());
                    }
                    for (int i2 = 0; i2 < slaves.length; ++i2) {
                        slaveTrans = transSplitter.getSlaveTransMap().get(slaves[i2]);
                        slaveReply = slaves[i2].getContentFromServer("/kettle/startExec/?name=" + URLEncoder.encode(slaveTrans.getName(), "UTF-8") + "&xml=Y");
                        webResult = WebResult.fromXMLString(slaveReply);
                        if (webResult.getResult().equalsIgnoreCase("OK")) continue;
                        throw new KettleException("An error occurred while starting the execution of a slave transformation: " + webResult.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("There was an error during transformation split", (Throwable)e);
        }
    }

    public static final long monitorClusteredTransformation(String logSubject, TransSplitter transSplitter, Job parentJob) {
        return Trans.monitorClusteredTransformation(logSubject, transSplitter, parentJob, 1);
    }

    public static final long monitorClusteredTransformation(String logSubject, TransSplitter transSplitter, Job parentJob, int sleepTimeSeconds) {
        WebResult webResult;
        int s;
        SlaveServer masterServer;
        long errors = 0L;
        SlaveServer[] slaveServers = transSplitter.getSlaveTargets();
        TransMeta[] slaves = transSplitter.getSlaves();
        try {
            masterServer = transSplitter.getMasterServer();
        }
        catch (KettleException e) {
            log.logError(logSubject, "Error getting the master server", (Throwable)e);
            masterServer = null;
            ++errors;
        }
        TransMeta masterTransMeta = transSplitter.getMaster();
        TransMeta transMeta = transSplitter.getOriginalTransformation();
        boolean allFinished = false;
        while (!(allFinished || errors != 0L || parentJob != null && parentJob.isStopped())) {
            allFinished = true;
            errors = 0L;
            for (s = 0; s < slaveServers.length && allFinished && errors == 0L; ++s) {
                try {
                    SlaveServerTransStatus transStatus = slaveServers[s].getTransStatus(slaves[s].getName());
                    if (transStatus.isRunning()) {
                        if (log.isDetailed()) {
                            log.logDetailed(logSubject, "Slave transformation on '" + slaveServers[s] + "' is still running.", new Object[0]);
                        }
                        allFinished = false;
                    } else if (log.isDetailed()) {
                        log.logDetailed(logSubject, "Slave transformation on '" + slaveServers[s] + "' has finished.", new Object[0]);
                    }
                    errors += transStatus.getNrStepErrors();
                    continue;
                }
                catch (Exception e) {
                    ++errors;
                    log.logError(logSubject, "Unable to contact slave server '" + slaveServers[s].getName() + "' to check slave transformation : " + e.toString(), new Object[0]);
                }
            }
            if (allFinished && errors == 0L && masterTransMeta != null && masterTransMeta.nrSteps() > 0) {
                try {
                    SlaveServerTransStatus transStatus = masterServer.getTransStatus(masterTransMeta.getName());
                    if (transStatus.isRunning()) {
                        if (log.isDetailed()) {
                            log.logDetailed(logSubject, "Master transformation is still running.", new Object[0]);
                        }
                        allFinished = false;
                    } else if (log.isDetailed()) {
                        log.logDetailed(logSubject, "Master transformation has finished.", new Object[0]);
                    }
                    Result result = transStatus.getResult(transSplitter.getOriginalTransformation());
                    errors += result.getNrErrors();
                }
                catch (Exception e) {
                    ++errors;
                    log.logError(logSubject, "Unable to contact master server '" + masterServer.getName() + "' to check master transformation : " + e.toString(), new Object[0]);
                }
            }
            if (parentJob != null && parentJob.isStopped() || errors != 0L) {
                for (s = 0; s < slaveServers.length && allFinished && errors == 0L; ++s) {
                    try {
                        webResult = slaveServers[s].stopTransformation(slaves[s].getName());
                        if ("OK".equals(webResult.getResult())) continue;
                        log.logError(logSubject, "Unable to stop slave transformation '" + slaves[s].getName() + "' : " + webResult.getMessage(), new Object[0]);
                        continue;
                    }
                    catch (Exception e) {
                        ++errors;
                        log.logError(logSubject, "Unable to contact slave server '" + slaveServers[s].getName() + "' to stop transformation : " + e.toString(), new Object[0]);
                    }
                }
                try {
                    WebResult webResult2 = masterServer.stopTransformation(masterTransMeta.getName());
                    if (!"OK".equals(webResult2.getResult())) {
                        log.logError(logSubject, "Unable to stop master transformation '" + masterServer.getName() + "' : " + webResult2.getMessage(), new Object[0]);
                    }
                }
                catch (Exception e) {
                    ++errors;
                    log.logError(logSubject, "Unable to contact master server '" + masterServer.getName() + "' to stop the master : " + e.toString(), new Object[0]);
                }
            }
            if (allFinished) continue;
            if (log.isDetailed()) {
                log.logDetailed(logSubject, "Clustered transformation is still running, waiting a few seconds...", new Object[0]);
            }
            try {
                Thread.sleep(sleepTimeSeconds * 2000);
            }
            catch (Exception e) {}
        }
        log.logMinimal(logSubject, "All transformations in the cluster have finished.", new Object[0]);
        for (s = 0; s < slaveServers.length; ++s) {
            try {
                webResult = slaveServers[s].cleanupTransformation(slaves[s].getName());
                if ("OK".equals(webResult.getResult())) continue;
                log.logError(logSubject, "Unable to run clean-up on slave transformation '" + slaves[s].getName() + "' : " + webResult.getMessage(), new Object[0]);
                ++errors;
                continue;
            }
            catch (Exception e) {
                ++errors;
                log.logError(logSubject, "Unable to contact slave server '" + slaveServers[s].getName() + "' to check slave transformation : " + e.toString(), new Object[0]);
            }
        }
        if (masterTransMeta != null && masterTransMeta.nrSteps() > 0) {
            try {
                WebResult webResult3 = masterServer.cleanupTransformation(masterTransMeta.getName());
                if (!"OK".equals(webResult3.getResult())) {
                    log.logError(logSubject, "Unable to run clean-up on master transformation '" + masterTransMeta.getName() + "' : " + webResult3.getMessage(), new Object[0]);
                    ++errors;
                }
                if (!"OK".equals((webResult3 = masterServer.deallocatePorts(transMeta.getName())).getResult())) {
                    log.logError(logSubject, "Unable to run clean-up on master transformation '" + masterTransMeta.getName() + "' : " + webResult3.getMessage(), new Object[0]);
                    ++errors;
                }
            }
            catch (Exception e) {
                ++errors;
                log.logError(logSubject, "Unable to contact master server '" + masterServer.getName() + "' to clean up master transformation : " + e.toString(), new Object[0]);
            }
        }
        return errors;
    }

    public static final Result getClusteredTransformationResult(String logSubject, TransSplitter transSplitter, Job parentJob) {
        SlaveServer masterServer;
        Result result = new Result();
        SlaveServer[] slaveServers = transSplitter.getSlaveTargets();
        TransMeta[] slaves = transSplitter.getSlaves();
        try {
            masterServer = transSplitter.getMasterServer();
        }
        catch (KettleException e) {
            log.logError(logSubject, "Error getting the master server", (Throwable)e);
            masterServer = null;
            result.setNrErrors(result.getNrErrors() + 1L);
        }
        TransMeta master = transSplitter.getMaster();
        for (int s = 0; s < slaveServers.length; ++s) {
            try {
                SlaveServerTransStatus transStatus = slaveServers[s].getTransStatus(slaves[s].getName());
                Result transResult = transStatus.getResult(slaves[s]);
                result.add(transResult);
                continue;
            }
            catch (Exception e) {
                result.setNrErrors(result.getNrErrors() + 1L);
                log.logError(logSubject, "Unable to contact slave server '" + slaveServers[s].getName() + "' to get result of slave transformation : " + e.toString(), new Object[0]);
            }
        }
        if (master != null && master.nrSteps() > 0) {
            try {
                SlaveServerTransStatus transStatus = masterServer.getTransStatus(master.getName());
                Result transResult = transStatus.getResult(master);
                result.add(transResult);
            }
            catch (Exception e) {
                result.setNrErrors(result.getNrErrors() + 1L);
                log.logError(logSubject, "Unable to contact master server '" + masterServer.getName() + "' to get result of master transformation : " + e.toString(), new Object[0]);
            }
        }
        return result;
    }

    public static void sendToSlaveServer(TransMeta transMeta, TransExecutionConfiguration executionConfiguration, Repository repository) throws KettleException {
        SlaveServer slaveServer = executionConfiguration.getRemoteServer();
        if (slaveServer == null) {
            throw new KettleException("No slave server specified");
        }
        if (Const.isEmpty((String)transMeta.getName())) {
            throw new KettleException("The transformation needs a name to uniquely identify it by on the remote server.");
        }
        try {
            for (String var : Const.INTERNAL_TRANS_VARIABLES) {
                executionConfiguration.getVariables().put(var, transMeta.getVariable(var));
            }
            for (String var : Const.INTERNAL_JOB_VARIABLES) {
                executionConfiguration.getVariables().put(var, transMeta.getVariable(var));
            }
            if (executionConfiguration.isPassingExport()) {
                FileObject tempFile = KettleVFS.createTempFile((String)"transExport", (String)".zip", (String)System.getProperty("java.io.tmpdir"));
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(tempFile.getName().toString(), transMeta, transMeta, repository, executionConfiguration.getXML(), CONFIGURATION_IN_EXPORT_FILENAME);
                String result = slaveServer.sendExport(topLevelResource.getArchiveName(), "trans", topLevelResource.getBaseResourceName());
                WebResult webResult = WebResult.fromXMLString(result);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new KettleException("There was an error passing the exported transformation to the remote server: " + Const.CR + webResult.getMessage());
                }
                String remoteFile = webResult.getMessage();
                LogWriter.getInstance().logBasic(transMeta.getName(), "Added the remote transformation to slave server [" + slaveServer.getName() + "] for remote file: " + remoteFile, new Object[0]);
            } else {
                String xml = new TransConfiguration(transMeta, executionConfiguration).getXML();
                String reply = slaveServer.sendXML(xml, "/kettle/addTrans/?xml=Y");
                WebResult webResult = WebResult.fromXMLString(reply);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new KettleException("There was an error posting the transformation on the remote server: " + Const.CR + webResult.getMessage());
                }
            }
            String reply = slaveServer.getContentFromServer("/kettle/prepareExec/?name=" + URLEncoder.encode(transMeta.getName(), "UTF-8") + "&xml=Y");
            WebResult webResult = WebResult.fromXMLString(reply);
            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                throw new KettleException("There was an error preparing the transformation for excution on the remote server: " + Const.CR + webResult.getMessage());
            }
            reply = slaveServer.getContentFromServer("/kettle/startExec/?name=" + URLEncoder.encode(transMeta.getName(), "UTF-8") + "&xml=Y");
            webResult = WebResult.fromXMLString(reply);
            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                throw new KettleException("There was an error starting the transformation on the remote server: " + Const.CR + webResult.getMessage());
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public boolean isReadyToStart() {
        return this.readyToStart;
    }

    public void setInternalKettleVariables(VariableSpace var) {
        if (this.transMeta != null && !Const.isEmpty((String)this.transMeta.getFilename())) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.transMeta.getFilename());
                FileName fileName = fileObject.getName();
                this.variables.setVariable("Internal.Transformation.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                this.variables.setVariable("Internal.Transformation.Filename.Directory", fileDir.getURI());
            }
            catch (IOException e) {
                this.variables.setVariable("Internal.Transformation.Filename.Directory", "");
                this.variables.setVariable("Internal.Transformation.Filename.Name", "");
            }
        } else {
            this.variables.setVariable("Internal.Transformation.Filename.Directory", "");
            this.variables.setVariable("Internal.Transformation.Filename.Name", "");
        }
        this.variables.setVariable("Internal.Transformation.Name", Const.NVL((String)this.transMeta.getName(), (String)""));
        this.variables.setVariable("Internal.Transformation.Repository.Directory", this.transMeta.getDirectory() != null ? this.transMeta.getDirectory().getPath() : "");
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void pauseRunning() {
        this.paused.set(true);
        for (StepMetaDataCombi combi : this.steps) {
            combi.step.pauseRunning();
        }
    }

    public void resumeRunning() {
        for (StepMetaDataCombi combi : this.steps) {
            combi.step.resumeRunning();
        }
        this.paused.set(false);
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Map<String, List<StepPerformanceSnapShot>> getStepPerformanceSnapShots() {
        return this.stepPerformanceSnapShots;
    }

    public void setStepPerformanceSnapShots(Map<String, List<StepPerformanceSnapShot>> stepPerformanceSnapShots) {
        this.stepPerformanceSnapShots = stepPerformanceSnapShots;
    }

    public List<TransListener> getTransListeners() {
        return this.transListeners;
    }

    public void setTransListeners(List<TransListener> transListeners) {
        this.transListeners = transListeners;
    }

    public void addTransListener(TransListener transListener) {
        this.transListeners.add(transListener);
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public static void monitorRemoteTransformation(String transName, SlaveServer remoteSlaveServer) {
        Trans.monitorRemoteTransformation(transName, remoteSlaveServer, 5);
    }

    public static void monitorRemoteTransformation(String transName, SlaveServer remoteSlaveServer, int sleepTimeSeconds) {
        long errors = 0L;
        boolean allFinished = false;
        while (!allFinished && errors == 0L) {
            allFinished = true;
            errors = 0L;
            if (allFinished && errors == 0L) {
                try {
                    SlaveServerTransStatus transStatus = remoteSlaveServer.getTransStatus(transName);
                    if (transStatus.isRunning()) {
                        if (log.isDetailed()) {
                            log.logDetailed(transName, "Remote transformation is still running.", new Object[0]);
                        }
                        allFinished = false;
                    } else if (log.isDetailed()) {
                        log.logDetailed(transName, "Remote transformation has finished.", new Object[0]);
                    }
                    Result result = transStatus.getResult();
                    errors += result.getNrErrors();
                }
                catch (Exception e) {
                    ++errors;
                    log.logError(transName, "Unable to contact remote slave server '" + remoteSlaveServer.getName() + "' to check transformation status : " + e.toString(), new Object[0]);
                }
            }
            if (allFinished) continue;
            if (log.isDetailed()) {
                log.logDetailed(transName, "The remote transformation is still running, waiting a few seconds...", new Object[0]);
            }
            try {
                Thread.sleep(sleepTimeSeconds * 1000);
            }
            catch (Exception e) {}
        }
        log.logMinimal(transName, "The remote transformation has finished.", new Object[0]);
        try {
            WebResult webResult = remoteSlaveServer.cleanupTransformation(transName);
            if (!"OK".equals(webResult.getResult())) {
                log.logError(transName, "Unable to run clean-up on remote transformation '" + transName + "' : " + webResult.getMessage(), new Object[0]);
                ++errors;
            }
        }
        catch (Exception e) {
            ++errors;
            log.logError(transName, "Unable to contact slave server '" + remoteSlaveServer.getName() + "' to clean up transformation : " + e.toString(), new Object[0]);
        }
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void eraseParameters() {
        this.namedParams.eraseParameters();
    }

    public void clearParameters() {
        this.namedParams.clearParameters();
    }

    public void activateParameters() {
        String[] keys;
        for (String key : keys = this.listParameters()) {
            String defValue;
            String value;
            try {
                value = this.getParameterValue(key);
            }
            catch (UnknownParamException e) {
                value = "";
            }
            try {
                defValue = this.getParameterDefault(key);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            if (Const.isEmpty((String)value)) {
                this.setVariable(key, Const.NVL((String)defValue, (String)""));
                continue;
            }
            this.setVariable(key, Const.NVL((String)value, (String)""));
        }
    }

    public void copyParametersFrom(NamedParams params) {
        this.namedParams.copyParametersFrom(params);
    }

    public Trans getParentTrans() {
        return this.parentTrans;
    }

    public void setParentTrans(Trans parentTrans) {
        this.parentTrans = parentTrans;
    }

    public String getMappingStepName() {
        return this.mappingStepName;
    }

    public void setMappingStepName(String mappingStepName) {
        this.mappingStepName = mappingStepName;
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }
}

