/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileNIO;
import org.hsqldb.persist.ScaledRAInterface;

public class ScaledRAFileHybrid
implements ScaledRAInterface {
    final Database database;
    final String fileName;
    final boolean isReadOnly;
    final boolean wasNio;
    long maxLength;
    ScaledRAInterface store;

    public ScaledRAFileHybrid(Database database, String string, boolean bl) throws IOException {
        this.database = database;
        this.fileName = string;
        this.isReadOnly = bl;
        this.newStore(0L);
        this.wasNio = this.store.wasNio();
    }

    public long length() throws IOException {
        return this.store.length();
    }

    public void seek(long l) throws IOException {
        this.checkSeek(l);
        this.store.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.store.getFilePointer();
    }

    public int read() throws IOException {
        this.checkLength(1);
        return this.store.read();
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.checkLength(n2);
        this.store.read(byArray, n, n2);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkLength(n2);
        this.store.write(byArray, n, n2);
    }

    public int readInt() throws IOException {
        this.checkLength(4);
        return this.store.readInt();
    }

    public void writeInt(int n) throws IOException {
        this.checkLength(4);
        this.store.writeInt(n);
    }

    public long readLong() throws IOException {
        this.checkLength(8);
        return this.store.readLong();
    }

    public void writeLong(long l) throws IOException {
        this.checkLength(8);
        this.store.writeLong(l);
    }

    public void close() throws IOException {
        this.store.close();
    }

    public boolean isReadOnly() {
        return this.store.isReadOnly();
    }

    public boolean wasNio() {
        return this.wasNio;
    }

    public boolean canAccess(int n) {
        return true;
    }

    public boolean canSeek(long l) {
        return true;
    }

    public Database getDatabase() {
        return null;
    }

    private void checkLength(int n) throws IOException {
        if (this.store.canAccess(n)) {
            return;
        }
        this.newStore(this.store.getFilePointer() + (long)n);
    }

    private void checkSeek(long l) throws IOException {
        if (this.store.canSeek(l)) {
            return;
        }
        this.newStore(l);
    }

    void newStore(long l) throws IOException {
        long l2 = 0L;
        if (this.store != null) {
            l2 = this.store.getFilePointer();
            this.store.close();
        }
        if (l <= 0x10000000L) {
            try {
                this.store = new ScaledRAFileNIO(this.database, this.fileName, this.isReadOnly, (int)l);
                this.store.seek(l2);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.store = new ScaledRAFile(this.database, this.fileName, this.isReadOnly);
        this.store.seek(l2);
    }
}

