/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.JavaPackage;
import jadx.api.ResourceFile;
import jadx.api.data.ICodeData;
import jadx.api.impl.InMemoryCodeCache;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginManager;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.rename.RenameVisitor;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.gui.settings.JadxProject;
import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.codecache.CodeStringCache;
import jadx.gui.utils.codecache.disk.BufferCodeCache;
import jadx.gui.utils.codecache.disk.DiskCodeCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(JadxWrapper.class);
    private static final Object DECOMPILER_UPDATE_SYNC = new Object();
    private final MainWindow mainWindow;
    @Nullable
    private volatile JadxDecompiler decompiler;

    public JadxWrapper(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        this.close();
        try {
            Object object = DECOMPILER_UPDATE_SYNC;
            synchronized (object) {
                JadxProject project = this.getProject();
                JadxArgs jadxArgs = this.getSettings().toJadxArgs();
                jadxArgs.setInputFiles(FileUtils.toFiles(project.getFilePaths()));
                jadxArgs.setCodeData((ICodeData)project.getCodeData());
                this.decompiler = new JadxDecompiler(jadxArgs);
                this.decompiler.load();
                this.initCodeCache();
            }
        }
        catch (Exception e) {
            LOG.error("Jadx decompiler wrapper init error", (Throwable)e);
            this.close();
        }
    }

    public void unloadClasses() {
        for (ClassNode cls : this.getDecompiler().getRoot().getClasses()) {
            ProcessState clsState = cls.getState();
            cls.unload();
            cls.setState(clsState == ProcessState.PROCESS_COMPLETE ? ProcessState.GENERATED_AND_UNLOADED : ProcessState.NOT_LOADED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = DECOMPILER_UPDATE_SYNC;
            synchronized (object) {
                if (this.decompiler != null) {
                    this.decompiler.close();
                    this.decompiler = null;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Jadx decompiler close error", (Throwable)e);
        }
        finally {
            this.mainWindow.getCacheObject().reset();
        }
    }

    private void initCodeCache() {
        switch (this.getSettings().getCodeCacheMode()) {
            case MEMORY: {
                this.getArgs().setCodeCache((ICodeCache)new InMemoryCodeCache());
                break;
            }
            case DISK_WITH_CACHE: {
                this.getArgs().setCodeCache((ICodeCache)new CodeStringCache(this.buildBufferedDiskCache()));
                break;
            }
            case DISK: {
                this.getArgs().setCodeCache((ICodeCache)this.buildBufferedDiskCache());
            }
        }
    }

    private BufferCodeCache buildBufferedDiskCache() {
        DiskCodeCache diskCache = new DiskCodeCache(this.getDecompiler().getRoot(), this.getProject().getCacheDir());
        return new BufferCodeCache(diskCache);
    }

    public List<JavaClass> getClasses() {
        return this.getDecompiler().getClasses();
    }

    public List<JavaClass> getIncludedClasses() {
        List classList = this.getDecompiler().getClasses();
        List<String> excludedPackages = this.getExcludedPackages();
        if (excludedPackages.isEmpty()) {
            return classList;
        }
        return classList.stream().filter(cls -> JadxWrapper.isClassIncluded(excludedPackages, cls)).collect(Collectors.toList());
    }

    public List<JavaClass> getIncludedClassesWithInners() {
        List classes = this.getDecompiler().getClassesWithInners();
        List<String> excludedPackages = this.getExcludedPackages();
        if (excludedPackages.isEmpty()) {
            return classes;
        }
        return classes.stream().filter(cls -> JadxWrapper.isClassIncluded(excludedPackages, cls)).collect(Collectors.toList());
    }

    private static boolean isClassIncluded(List<String> excludedPackages, JavaClass cls) {
        for (String exclude : excludedPackages) {
            String clsFullName = cls.getFullName();
            if (!clsFullName.equals(exclude) && !clsFullName.startsWith(exclude + '.')) continue;
            return false;
        }
        return true;
    }

    public List<List<JavaClass>> buildDecompileBatches(List<JavaClass> classes) {
        return this.getDecompiler().getDecompileScheduler().buildBatches(classes);
    }

    public List<String> getExcludedPackages() {
        String excludedPackages = this.getSettings().getExcludedPackages().trim();
        if (excludedPackages.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(excludedPackages.split(" +"));
    }

    public void setExcludedPackages(List<String> packagesToExclude) {
        this.getSettings().setExcludedPackages(String.join((CharSequence)" ", packagesToExclude).trim());
        this.getSettings().sync();
    }

    public void addExcludedPackage(String packageToExclude) {
        String newExclusion = this.getSettings().getExcludedPackages() + ' ' + packageToExclude;
        this.getSettings().setExcludedPackages(newExclusion.trim());
        this.getSettings().sync();
    }

    public void removeExcludedPackage(String packageToRemoveFromExclusion) {
        ArrayList<String> list = new ArrayList<String>(this.getExcludedPackages());
        list.remove(packageToRemoveFromExclusion);
        this.getSettings().setExcludedPackages(String.join((CharSequence)" ", list));
        this.getSettings().sync();
    }

    public List<JadxPlugin> getAllPlugins() {
        if (this.decompiler != null) {
            return this.decompiler.getPluginManager().getAllPlugins();
        }
        JadxPluginManager pluginManager = new JadxPluginManager();
        pluginManager.load();
        return pluginManager.getAllPlugins();
    }

    @NotNull
    public JadxDecompiler getDecompiler() {
        if (this.decompiler == null || this.decompiler.getRoot() == null) {
            throw new JadxRuntimeException("Decompiler not yet loaded");
        }
        return this.decompiler;
    }

    public RootNode getRootNode() {
        return this.getDecompiler().getRoot();
    }

    public void reInitRenameVisitor() {
        new RenameVisitor().init(this.getRootNode());
    }

    public void reloadCodeData() {
        this.getDecompiler().reloadCodeData();
    }

    public JavaNode getJavaNodeByRef(ICodeNodeRef nodeRef) {
        return this.getDecompiler().getJavaNodeByRef(nodeRef);
    }

    @Nullable
    public JavaNode getEnclosingNode(ICodeInfo codeInfo, int pos) {
        return this.getDecompiler().getEnclosingNode(codeInfo, pos);
    }

    public List<Runnable> getSaveTasks() {
        return this.getDecompiler().getSaveTasks();
    }

    public List<JavaPackage> getPackages() {
        return this.getDecompiler().getPackages();
    }

    public List<ResourceFile> getResources() {
        return this.getDecompiler().getResources();
    }

    public JadxArgs getArgs() {
        return this.getDecompiler().getArgs();
    }

    public JadxProject getProject() {
        return this.mainWindow.getProject();
    }

    public JadxSettings getSettings() {
        return this.mainWindow.getSettings();
    }

    @Nullable
    public JavaClass searchJavaClassByFullAlias(String fullName) {
        return this.getDecompiler().getClasses().stream().filter(cls -> cls.getFullName().equals(fullName)).findFirst().orElse(null);
    }

    @Nullable
    public JavaClass searchJavaClassByOrigClassName(String fullName) {
        return this.getDecompiler().searchJavaClassByOrigFullName(fullName);
    }

    @Nullable
    public JavaClass searchJavaClassByRawName(String rawName) {
        return this.getDecompiler().getClasses().stream().filter(cls -> cls.getRawName().equals(rawName)).findFirst().orElse(null);
    }
}

