/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jibri;

import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.EntityBareJid;

public class JibriIq
extends IQ {
    public static final String ACTION_ATTR_NAME = "action";
    static final String DISPLAY_NAME_ATTR_NAME = "displayname";
    public static final String ELEMENT = "jibri";
    public static final String NAMESPACE = "http://jitsi.org/protocol/jibri";
    static final String SIP_ADDRESS_ATTR_NAME = "sipaddress";
    static final String STATUS_ATTR_NAME = "status";
    static final String FAILURE_REASON_ATTR_NAME = "failure_reason";
    static final String SHOULD_RETRY_ATTR_NAME = "should_retry";
    static final String STREAM_ID_ATTR_NAME = "streamid";
    static final String YOUTUBE_BROADCAST_ID_ATTR_NAME = "you_tube_broadcast_id";
    static final String SESSION_ID_ATTR_NAME = "session_id";
    static final String APP_DATA_ATTR_NAME = "app_data";
    static final String RECORDING_MODE_ATTR_NAME = "recording_mode";
    static final String ROOM_ATTR_NAME = "room";
    private Action action = Action.UNDEFINED;
    private String displayName;
    private RecordingMode recordingMode = RecordingMode.UNDEFINED;
    private String sipAddress;
    private Status status = Status.UNDEFINED;
    private FailureReason failureReason = null;
    private Boolean shouldRetry = null;
    private String streamId = null;
    private String youTubeBroadcastId = null;
    private String sessionId = null;
    private String appData = null;
    private EntityBareJid room = null;

    public JibriIq() {
        super(ELEMENT, NAMESPACE);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getSipAddress() {
        return this.sipAddress;
    }

    public void setSipAddress(String sipAddress) {
        this.sipAddress = sipAddress;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getYoutubeBroadcastId() {
        return this.youTubeBroadcastId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public void setYouTubeBroadcastId(String youTubeBroadcastId) {
        this.youTubeBroadcastId = youTubeBroadcastId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getAppData() {
        return this.appData;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setAppData(String appData) {
        this.appData = appData;
    }

    public EntityBareJid getRoom() {
        return this.room;
    }

    public void setRoom(EntityBareJid room) {
        this.room = room;
    }

    public boolean isFailure() {
        return this.failureReason != null;
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        if (this.action != Action.UNDEFINED) {
            xml.attribute(ACTION_ATTR_NAME, this.action.toString());
        }
        if (this.status != Status.UNDEFINED) {
            xml.attribute(STATUS_ATTR_NAME, this.status.toString());
        }
        if (this.recordingMode != RecordingMode.UNDEFINED) {
            xml.attribute(RECORDING_MODE_ATTR_NAME, this.recordingMode.toString());
        }
        xml.optAttribute(ROOM_ATTR_NAME, this.room);
        xml.optAttribute(STREAM_ID_ATTR_NAME, this.streamId);
        xml.optAttribute(YOUTUBE_BROADCAST_ID_ATTR_NAME, this.youTubeBroadcastId);
        xml.optAttribute(DISPLAY_NAME_ATTR_NAME, this.displayName);
        xml.optAttribute(SIP_ADDRESS_ATTR_NAME, this.sipAddress);
        xml.optAttribute(SESSION_ID_ATTR_NAME, this.sessionId);
        xml.optAttribute(FAILURE_REASON_ATTR_NAME, this.failureReason);
        if (this.shouldRetry != null) {
            xml.attribute(SHOULD_RETRY_ATTR_NAME, this.shouldRetry);
        }
        xml.optAttribute(APP_DATA_ATTR_NAME, this.appData);
        xml.setEmptyElement();
        return xml;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public RecordingMode getRecordingMode() {
        return this.recordingMode;
    }

    public void setRecordingMode(RecordingMode mode) {
        this.recordingMode = mode;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setFailureReason(FailureReason failureReason) {
        this.failureReason = failureReason;
    }

    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public void setShouldRetry(Boolean shouldRetry) {
        this.shouldRetry = shouldRetry;
    }

    public Boolean getShouldRetry() {
        return this.shouldRetry;
    }

    public static JibriIq createResult(JibriIq request, String sessionId) {
        JibriIq result = new JibriIq();
        result.setType(IQ.Type.result);
        result.setStanzaId(request.getStanzaId());
        result.setTo(request.getFrom());
        result.setSessionId(sessionId);
        return result;
    }

    public static enum Status {
        ON("on"),
        OFF("off"),
        PENDING("pending"),
        UNDEFINED("undefined");

        private String name;

        private Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Status parse(String status) {
            if (StringUtils.isEmpty(status)) {
                return UNDEFINED;
            }
            try {
                return Status.valueOf(status.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }

    public static enum FailureReason {
        BUSY("busy"),
        ERROR("error"),
        UNDEFINED("undefined");

        private String name;

        private FailureReason(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static FailureReason parse(String status) {
            if (StringUtils.isEmpty(status)) {
                return UNDEFINED;
            }
            try {
                return FailureReason.valueOf(status.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }

    public static enum RecordingMode {
        FILE("file"),
        STREAM("stream"),
        UNDEFINED("undefined");

        private String mode;

        private RecordingMode(String mode) {
            this.mode = mode;
        }

        public String toString() {
            return this.mode;
        }

        public static RecordingMode parse(String status) {
            if (StringUtils.isEmpty(status)) {
                return UNDEFINED;
            }
            try {
                return RecordingMode.valueOf(status.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }

    public static enum Action {
        START("start"),
        STOP("stop"),
        UNDEFINED("undefined");

        private String name;

        private Action(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Action parse(String action) {
            if (StringUtils.isEmpty(action)) {
                return UNDEFINED;
            }
            try {
                return Action.valueOf(action.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }
}

