/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.paths.PathCollection;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.objectweb.asm.ClassVisitor;

public class RuntimeUpdatesClassVisitor
extends ClassVisitor {
    private final PathCollection sourcePaths;
    private final String classesPath;
    private String sourceFile;

    public RuntimeUpdatesClassVisitor(PathCollection sourcePaths, String classesPath) {
        super(589824);
        this.sourcePaths = sourcePaths;
        this.classesPath = classesPath;
    }

    public void visitSource(String source, String debug) {
        this.sourceFile = source;
    }

    public Path getSourceFileForClass(Path classFilePath) {
        for (Path sourcesDir : this.sourcePaths) {
            Path classesDir = Paths.get(this.classesPath, new String[0]);
            StringBuilder sourceRelativeDir = new StringBuilder();
            sourceRelativeDir.append(classesDir.relativize(classFilePath.getParent()));
            sourceRelativeDir.append(File.separator);
            sourceRelativeDir.append(this.sourceFile);
            Path sourceFilePath = sourcesDir.resolve(Path.of(sourceRelativeDir.toString(), new String[0]));
            if (!Files.exists(sourceFilePath, new LinkOption[0])) continue;
            return sourceFilePath;
        }
        return null;
    }
}

