%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/controlling-spanner-visibility-after-a-line-break.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: a8a85e19654e46d725563e6deba44083ef137a2c
  texidocja = "
改行のすぐ後の音符で終了するスパナの可視性は、@code{after-line-breaking} の@c
コールバック @code{ly:spanner::kill-zero-spanned-time} によりコントロール@c
されます。

グリッサンドやヘアピンのようなオブジェクトは、デフォルトで改行後のスパナを@c
表示しないようにしています。このコールバックを無効化することで、@c
改行後のスパナが表示されるようになります。

逆に、テキスト スパナなどはデフォルトで改行後に表示されるように@c
なっていますが、コールバックを有効にすることで削除することができます。
"
  doctitleja = "改行後のスパナの可視性をコントロールする"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
La visibilité des extensions qui se terminent sur la première note après
un saut de ligne est contrôlée par un appel de @code{after-line-breaking}
à la fonction @code{ly:spanner::kill-zero-spanned-time}.

Pour des objets tels qu'un glissando ou un soufflet, le comportement
par défaut est de ne pas être reportés après un saut de ligne.
L'extension sera donc reprise dès lors que l'appel aura été désactivé.

Il en va inversement pour les extensions qui, par défaut pour les textes
notamment, sont reportées après un saut de ligne ; il faudra alors
activer l'appel pour empêcher leur report.
"

  doctitlefr = "Contrôle de la visibilité des extensions d'objet après saut de ligne"

%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidoces = "
La visibilidad de los objetos de extensión que acaban en la primera
nota después de un salto de línea está controlada por la función de
callback de @code{after-line-breaking}
@code{ly:spanner::kill-zero-spanned-time}.

Para los objetos como los glissandos y los reguladores, el
comportamiento predeterminado es ocultar el objeto de extensión
después del salto; la inhabilitación de la función de callback hace
que el objeto de extensión roto por la izquierda pueda mostrarse.

De forma inversa, los objetos de extensión que son visibles
normalmente, como los objetos de extensión de texto, se pueden
ocultar habilitando la función de callback.
"
  doctitlees = "Controlar la visibilidad de los objetos de
  extensión después de un salto de línea"

%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidocca = "
La visibilitat dels objectes d'extensió que acaben a la primera
nota després d'un salt de línia està controlada per la funció de
crida de @code{after-line-breaking}
  @code{ly:spanner::kill-zero-spanned-time}.

Per als objectes com els glissandos i els reguladors, el
comportament predeterminat és ocultar l'objecte d'extensió després
del salt; la inhabilitació de la funció de callblack fa que
l'object d'extensió trencat per l'esquerra pot mostrar-se.

De forma inversa, els objectes d'extensió que són visibles
normalment, com els objectes d'extensió de text, es poden ocultar
habilitant la funció de callback.
"
  doctitleca = "Controlar la visibilitat dels objectes d'extensió després d'un salt de línia"

  lsrtags = "expressive-marks, tweaks-and-overrides"

  texidoc = "
The visibility of spanners which end on the first note following a line
break is controlled by the @code{after-line-breaking} callback
@code{ly:spanner::kill-zero-spanned-time}.

For objects such as glissandos and hairpins, the default behaviour is
to hide the spanner after a break; disabling the callback will allow
the left-broken span to be shown.

Conversely, spanners which are usually visible, such as text spans, can
be hidden by enabling the callback.
"

  doctitle = "Controlling spanner visibility after a line break"
} % begin verbatim


\paper { ragged-right = ##t }

\relative c'' {
  \override Hairpin.to-barline = ##f
  \override Glissando.breakable = ##t
  % show hairpin
  \override Hairpin.after-line-breaking = ##t
  % hide text span
  \override TextSpanner.after-line-breaking =
    #ly:spanner::kill-zero-spanned-time
  e2\<\startTextSpan
  % show glissando
  \override Glissando.after-line-breaking = ##t
  f2\glissando
  \break
  f,1\!\stopTextSpan
}



% ****************************************************************
% end ly snippet
% ****************************************************************
