%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.4/input/regression/scheme-list-splicing.ly"
\sourcefileline 0
\version "2.23.12"

\header {
  texidoc = "The @code{#@@} and @code{$@@} operators splice a list, returning
multiple values to the parser.  This is equivalent to returning the multiple
values directly using @code{values}."
}

{
  %% This should print a scale.
  #@(map (lambda (i)
           #{ $(ly:make-pitch 0 i) 4 #})
         (iota 8))
  %% This should print all notes of the scale in a chord.
  <
    $@(map (lambda (i)
             #{ $(ly:make-pitch 0 i) 4 #})
           (iota 8))
  >
}

%% Test #@ and $@ in embedded LilyPond #{ ... #}.
%% This score should look the same as the previous one.

scale =
#(define-music-function (n) (index?)
   #{ #@(map (lambda (i)
               #{ $(ly:make-pitch 0 i) 4 #})
             (iota n)) #})

chord =
#(define-music-function (n) (index?)
   #{
     <
       $@(map (lambda (i)
                #{ $(ly:make-pitch 0 i) 4 #})
              (iota n))
     >
   #})

{
  \scale 8
  \chord 8
}

%% This score should also look exactly the same.

chordII =
#(define-music-function (n) (index?)
   #{
     <
       #(apply values
               (map (lambda (i)
                      #{ $(ly:make-pitch 0 i) 4 #})
                    (iota n)))
     >
   #})

{
  $(apply values
          (map (lambda (i)
                 #{ $(ly:make-pitch 0 i) 4 #})
               (iota 8)))
  \chordII 8
}



% ****************************************************************
% end ly snippet
% ****************************************************************
