/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public abstract class CustomFieldValueReader {
    protected ProjectProperties m_properties;
    protected CustomFieldContainer m_container;
    protected VarMeta m_outlineCodeVarMeta;
    protected Var2Data m_outlineCodeVarData;
    protected FixedData m_outlineCodeFixedData;
    protected FixedData m_outlineCodeFixedData2;
    protected Props m_taskProps;
    public static final Integer VALUE_LIST_VALUE = 22;
    public static final Integer VALUE_LIST_DESCRIPTION = 8;
    public static final Integer VALUE_LIST_UNKNOWN = 23;

    public CustomFieldValueReader(ProjectProperties projectProperties, CustomFieldContainer customFieldContainer, VarMeta varMeta, Var2Data var2Data, FixedData fixedData, FixedData fixedData2, Props props) {
        this.m_properties = projectProperties;
        this.m_container = customFieldContainer;
        this.m_outlineCodeVarMeta = varMeta;
        this.m_outlineCodeVarData = var2Data;
        this.m_outlineCodeFixedData = fixedData;
        this.m_outlineCodeFixedData2 = fixedData2;
        this.m_taskProps = props;
    }

    public abstract void process() throws IOException;

    protected Object getTypedValue(int n, byte[] byArray) {
        Object object;
        switch (n) {
            case 4: {
                object = MPPUtility.getTimestamp(byArray, 0);
                break;
            }
            case 6: {
                TimeUnit timeUnit = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, 4), this.m_properties.getDefaultDurationUnits());
                object = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(byArray, 0), timeUnit);
                break;
            }
            case 9: {
                object = MPPUtility.getDouble(byArray, 0) / 100.0;
                break;
            }
            case 15: {
                object = MPPUtility.getDouble(byArray, 0);
                break;
            }
            case 21: 
            case 36058: {
                object = MPPUtility.getUnicodeString(byArray, 0);
                break;
            }
            default: {
                object = byArray;
            }
        }
        return object;
    }
}

