/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.formula;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jxls.area.Area;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.formula.AbstractFormulaProcessor;
import org.jxls.transform.Transformer;
import org.jxls.util.Util;

public class FastFormulaProcessor
extends AbstractFormulaProcessor {
    @Override
    public void processAreaFormulas(Transformer transformer, Area area) {
        Set<CellData> formulaCells = transformer.getFormulaCells();
        for (CellData formulaCellData : formulaCells) {
            if (area != null && area.getAreaRef() != null && !area.getAreaRef().getSheetName().equals(formulaCellData.getSheetName())) continue;
            List<CellRef> targetFormulaCells = formulaCellData.getTargetPos();
            Map<CellRef, List<CellRef>> targetCellRefMap = this.buildTargetCellRefMap(transformer, area, formulaCellData);
            Map<String, List<CellRef>> jointedCellRefMap = this.buildJointedCellRefMap(transformer, formulaCellData);
            ArrayList<CellRef> usedCellRefs = new ArrayList<CellRef>();
            for (int i = 0; i < targetFormulaCells.size(); ++i) {
                List<List<CellRef>> rangeList;
                Map.Entry<CellRef, List<CellRef>> cellRefEntry2;
                CellRef targetFormulaCellRef = targetFormulaCells.get(i);
                String targetFormulaString = formulaCellData.getFormula();
                if (formulaCellData.isParameterizedFormulaCell()) {
                    targetFormulaString = formulaCellData.getEvaluatedFormulas().get(i);
                }
                boolean isFormulaCellRefsEmpty = true;
                for (Map.Entry<CellRef, List<CellRef>> cellRefEntry2 : targetCellRefMap.entrySet()) {
                    String replacementString;
                    List<CellRef> targetCells = cellRefEntry2.getValue();
                    if (targetCells.isEmpty()) continue;
                    isFormulaCellRefsEmpty = false;
                    if (formulaCellData.getFormulaStrategy() == CellData.FormulaStrategy.BY_COLUMN) {
                        List<CellRef> targetCellRefs = Util.createTargetCellRefListByColumn(targetFormulaCellRef, targetCells, usedCellRefs);
                        usedCellRefs.addAll(targetCellRefs);
                        replacementString = Util.createTargetCellRef(targetCellRefs);
                    } else if (targetCells.size() == targetFormulaCells.size()) {
                        CellRef targetCellRefCellRef = targetCells.get(i);
                        replacementString = targetCellRefCellRef.getCellName();
                    } else {
                        rangeList = Util.groupByRanges(targetCells, targetFormulaCells.size());
                        if (rangeList.size() == targetFormulaCells.size()) {
                            List<CellRef> range = rangeList.get(i);
                            replacementString = Util.createTargetCellRef(range);
                        } else {
                            replacementString = Util.createTargetCellRef(targetCells);
                        }
                    }
                    String from = "(?<!U_\\([^)]{0,100})" + Util.sheetNameRegex(cellRefEntry2) + Util.getStrictCellNameRegex(Pattern.quote(((CellRef)cellRefEntry2.getKey()).getCellName()));
                    String to = Matcher.quoteReplacement(replacementString);
                    targetFormulaString = targetFormulaString.replaceAll(from, to);
                }
                boolean isFormulaJointedCellRefsEmpty = true;
                cellRefEntry2 = jointedCellRefMap.entrySet().iterator();
                while (cellRefEntry2.hasNext()) {
                    String replacementString;
                    Map.Entry jointedCellRefEntry = (Map.Entry)cellRefEntry2.next();
                    List targetCellRefList = (List)jointedCellRefEntry.getValue();
                    if (targetCellRefList.isEmpty()) continue;
                    isFormulaJointedCellRefsEmpty = false;
                    rangeList = Util.groupByRanges(targetCellRefList, targetFormulaCells.size());
                    if (rangeList.size() == targetFormulaCells.size()) {
                        List<CellRef> range = rangeList.get(i);
                        replacementString = Util.createTargetCellRef(range);
                    } else {
                        replacementString = Util.createTargetCellRef(targetCellRefList);
                    }
                    targetFormulaString = targetFormulaString.replaceAll(Pattern.quote((String)jointedCellRefEntry.getKey()), replacementString);
                }
                String sheetNameReplacementRegex = targetFormulaCellRef.getFormattedSheetName() + '!';
                targetFormulaString = targetFormulaString.replaceAll(sheetNameReplacementRegex, "");
                if (isFormulaCellRefsEmpty && isFormulaJointedCellRefsEmpty && (!formulaCellData.isParameterizedFormulaCell() || formulaCellData.isJointedFormulaCell())) {
                    targetFormulaString = formulaCellData.getDefaultValue() != null ? formulaCellData.getDefaultValue() : "0";
                }
                transformer.setFormula(new CellRef(targetFormulaCellRef.getSheetName(), targetFormulaCellRef.getRow(), targetFormulaCellRef.getCol()), targetFormulaString);
            }
        }
    }
}

