"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Foundation = void 0;
const enums_1 = require("./enums");
const status_1 = require("./status");
exports.Foundation = {
    /** Read Attributes */
    read: {
        ID: 0x00,
        parseStrategy: "repetitive",
        parameters: [{ name: "attrId", type: enums_1.DataType.UINT16 }],
        response: 0x01, // readRsp
    },
    /** Read Attributes Response */
    readRsp: {
        ID: 0x01,
        parseStrategy: "repetitive",
        parameters: [
            { name: "attrId", type: enums_1.DataType.UINT16 },
            { name: "status", type: enums_1.DataType.UINT8 },
            { name: "dataType", type: enums_1.DataType.UINT8, conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "status", value: status_1.Status.SUCCESS }] },
            {
                name: "attrData",
                type: enums_1.BuffaloZclDataType.USE_DATA_TYPE,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "status", value: status_1.Status.SUCCESS }],
            },
        ],
    },
    /** Write Attributes */
    write: {
        ID: 0x02,
        parseStrategy: "repetitive",
        parameters: [
            { name: "attrId", type: enums_1.DataType.UINT16 },
            { name: "dataType", type: enums_1.DataType.UINT8 },
            { name: "attrData", type: enums_1.BuffaloZclDataType.USE_DATA_TYPE },
        ],
        response: 0x04, // writeRsp
    },
    /** Write Attributes Undivided */
    writeUndiv: {
        ID: 0x03,
        parseStrategy: "repetitive",
        parameters: [
            { name: "attrId", type: enums_1.DataType.UINT16 },
            { name: "dataType", type: enums_1.DataType.UINT8 },
            { name: "attrData", type: enums_1.BuffaloZclDataType.USE_DATA_TYPE },
        ],
    },
    /** Write Attributes Response */
    writeRsp: {
        ID: 0x04,
        parseStrategy: "repetitive",
        parameters: [
            { name: "status", type: enums_1.DataType.UINT8 },
            {
                name: "attrId",
                type: enums_1.DataType.UINT16,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "status", reversed: true, value: status_1.Status.SUCCESS }],
            },
        ],
    },
    /** Write Attributes No Response */
    writeNoRsp: {
        ID: 0x05,
        parseStrategy: "repetitive",
        parameters: [
            { name: "attrId", type: enums_1.DataType.UINT16 },
            { name: "dataType", type: enums_1.DataType.UINT8 },
            { name: "attrData", type: enums_1.BuffaloZclDataType.USE_DATA_TYPE },
        ],
    },
    /** Configure Reporting */
    configReport: {
        ID: 0x06,
        parseStrategy: "repetitive",
        parameters: [
            { name: "direction", type: enums_1.DataType.UINT8 },
            { name: "attrId", type: enums_1.DataType.UINT16 },
            {
                name: "dataType",
                type: enums_1.DataType.UINT8,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.CLIENT_TO_SERVER }],
            },
            {
                name: "minRepIntval",
                type: enums_1.DataType.UINT16,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.CLIENT_TO_SERVER }],
            },
            {
                name: "maxRepIntval",
                type: enums_1.DataType.UINT16,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.CLIENT_TO_SERVER }],
            },
            {
                name: "repChange",
                type: enums_1.BuffaloZclDataType.USE_DATA_TYPE,
                conditions: [
                    { type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.CLIENT_TO_SERVER },
                    { type: enums_1.ParameterCondition.DATA_TYPE_CLASS_EQUAL, value: enums_1.DataTypeClass.ANALOG },
                ],
            },
            {
                name: "timeout",
                type: enums_1.DataType.UINT16,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.SERVER_TO_CLIENT }],
            },
        ],
        response: 0x07, // configReportRsp
    },
    /** Configure Reporting Response */
    configReportRsp: {
        ID: 0x07,
        parseStrategy: "repetitive",
        parameters: [
            { name: "status", type: enums_1.DataType.UINT8 },
            // minimumRemainingBufferBytes: if direction is present, attrId is also present
            // https://github.com/Koenkk/zigbee-herdsman/pull/115
            { name: "direction", type: enums_1.DataType.UINT8, conditions: [{ type: enums_1.ParameterCondition.MINIMUM_REMAINING_BUFFER_BYTES, value: 3 }] },
            { name: "attrId", type: enums_1.DataType.UINT16, conditions: [{ type: enums_1.ParameterCondition.MINIMUM_REMAINING_BUFFER_BYTES, value: 2 }] },
        ],
    },
    /** Read Reporting Configuration */
    readReportConfig: {
        ID: 0x08,
        parseStrategy: "repetitive",
        parameters: [
            { name: "direction", type: enums_1.DataType.UINT8 },
            { name: "attrId", type: enums_1.DataType.UINT16 },
        ],
        response: 0x09, // readReportConfigRsp
    },
    /** Read Reporting Configuration Response */
    readReportConfigRsp: {
        ID: 0x09,
        parseStrategy: "repetitive",
        parameters: [
            { name: "status", type: enums_1.DataType.UINT8 },
            { name: "direction", type: enums_1.DataType.UINT8 },
            { name: "attrId", type: enums_1.DataType.UINT16 },
            {
                name: "dataType",
                type: enums_1.DataType.UINT8,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.CLIENT_TO_SERVER }],
            },
            {
                name: "minRepIntval",
                type: enums_1.DataType.UINT16,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.CLIENT_TO_SERVER }],
            },
            {
                name: "maxRepIntval",
                type: enums_1.DataType.UINT16,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.CLIENT_TO_SERVER }],
            },
            {
                name: "repChange",
                type: enums_1.BuffaloZclDataType.USE_DATA_TYPE,
                conditions: [
                    { type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.CLIENT_TO_SERVER },
                    { type: enums_1.ParameterCondition.DATA_TYPE_CLASS_EQUAL, value: enums_1.DataTypeClass.ANALOG },
                ],
            },
            {
                name: "timeout",
                type: enums_1.DataType.UINT16,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "direction", value: enums_1.Direction.SERVER_TO_CLIENT }],
            },
        ],
    },
    /** Report attributes */
    report: {
        ID: 0x0a,
        parseStrategy: "repetitive",
        parameters: [
            { name: "attrId", type: enums_1.DataType.UINT16 },
            { name: "dataType", type: enums_1.DataType.UINT8 },
            { name: "attrData", type: enums_1.BuffaloZclDataType.USE_DATA_TYPE },
        ],
    },
    /** Default Response */
    defaultRsp: {
        ID: 0x0b,
        parseStrategy: "flat",
        parameters: [
            { name: "cmdId", type: enums_1.DataType.UINT8 },
            { name: "statusCode", type: enums_1.DataType.UINT8 },
        ],
    },
    /** Discover Attributes */
    discover: {
        ID: 0x0c,
        parseStrategy: "flat",
        parameters: [
            { name: "startAttrId", type: enums_1.DataType.UINT16 },
            { name: "maxAttrIds", type: enums_1.DataType.UINT8 },
        ],
    },
    /** Discover Attributes Response */
    discoverRsp: {
        ID: 0x0d,
        parseStrategy: "oneof",
        parameters: [
            { name: "attrId", type: enums_1.DataType.UINT16 },
            { name: "dataType", type: enums_1.DataType.UINT8 },
        ],
    },
    /** Read Attributes Structured */
    readStructured: {
        ID: 0x0e,
        parseStrategy: "repetitive",
        parameters: [
            { name: "attrId", type: enums_1.DataType.UINT16 },
            { name: "selector", type: enums_1.BuffaloZclDataType.STRUCTURED_SELECTOR },
        ],
    },
    /** Write Attributes Structured */
    writeStructured: {
        ID: 0x0f,
        parseStrategy: "repetitive",
        parameters: [
            { name: "attrId", type: enums_1.DataType.UINT16 },
            { name: "selector", type: enums_1.BuffaloZclDataType.STRUCTURED_SELECTOR },
            { name: "dataType", type: enums_1.DataType.UINT8 },
            { name: "elementData", type: enums_1.BuffaloZclDataType.USE_DATA_TYPE },
        ],
        response: 0x10, // writeStructuredRsp
    },
    /** Write Attributes Structured response */
    writeStructuredRsp: {
        ID: 0x10,
        parseStrategy: "repetitive",
        // contains only one SUCCESS record for all written attributes if all written successfully
        parameters: [
            { name: "status", type: enums_1.DataType.UINT8 },
            {
                name: "attrId",
                type: enums_1.DataType.UINT16,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "status", reversed: true, value: status_1.Status.SUCCESS }],
            },
            // always one zero-octet if failed attribute not of type array or structure, otherwise can also be zero if no info on which element caused failure
            {
                name: "selector",
                type: enums_1.BuffaloZclDataType.STRUCTURED_SELECTOR,
                conditions: [{ type: enums_1.ParameterCondition.FIELD_EQUAL, field: "status", reversed: true, value: status_1.Status.SUCCESS }],
            },
        ],
    },
    /** Discover Commands Received */
    discoverCommands: {
        ID: 0x11,
        parseStrategy: "flat",
        parameters: [
            { name: "startCmdId", type: enums_1.DataType.UINT8 },
            { name: "maxCmdIds", type: enums_1.DataType.UINT8 },
        ],
    },
    /** Discover Commands Received Response */
    discoverCommandsRsp: {
        ID: 0x12,
        parseStrategy: "oneof",
        parameters: [{ name: "cmdId", type: enums_1.DataType.UINT8 }],
    },
    /** Discover Commands Generated */
    discoverCommandsGen: {
        ID: 0x13,
        parseStrategy: "flat",
        parameters: [
            { name: "startCmdId", type: enums_1.DataType.UINT8 },
            { name: "maxCmdIds", type: enums_1.DataType.UINT8 },
        ],
    },
    /** Discover Commands Generated Response */
    discoverCommandsGenRsp: {
        ID: 0x14,
        parseStrategy: "oneof",
        parameters: [{ name: "cmdId", type: enums_1.DataType.UINT8 }],
    },
    /** Discover Attributes Extended */
    discoverExt: {
        ID: 0x15,
        parseStrategy: "flat",
        parameters: [
            { name: "startAttrId", type: enums_1.DataType.UINT16 },
            { name: "maxAttrIds", type: enums_1.DataType.UINT8 },
        ],
    },
    /** Discover Attributes Extended Response */
    discoverExtRsp: {
        ID: 0x16,
        parseStrategy: "oneof",
        parameters: [
            { name: "attrId", type: enums_1.DataType.UINT16 },
            { name: "dataType", type: enums_1.DataType.UINT8 },
            { name: "access", type: enums_1.DataType.UINT8 },
        ],
    },
};
//# sourceMappingURL=foundation.js.map