/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.util.threads;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class AWTBottleneck {
    private final Runnable myRunnable;
    private final long myMinimumPeriod;
    private State myState;
    private Timer myTimer;
    private final ActionListener myListener;
    private long myNextRunTime;
    private int myPendingRequestsCount;

    /*
     * WARNING - void declaration
     */
    public AWTBottleneck(long minimumPeriod, @NotNull Runnable runnable) {
        void runnable2;
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/almworks/util/threads/AWTBottleneck.<init> must not be null");
        }
        this.myState = State.IDLE;
        this.myListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWTBottleneck.this.onTimer();
            }
        };
        this.myNextRunTime = 0L;
        this.myPendingRequestsCount = 0;
        assert (minimumPeriod > 0L);
        this.myMinimumPeriod = minimumPeriod;
        this.myRunnable = new Runnable((Runnable)runnable2){
            final /* synthetic */ Runnable val$runnable;
            {
                this.val$runnable = runnable;
            }

            public void run() {
                AWTBottleneck.this.doRun(this.val$runnable);
            }
        };
    }

    public void request() {
        assert (EventQueue.isDispatchThread());
        boolean runNow = false;
        State state = this.myState;
        if (state == State.IDLE) {
            long waitTime = this.myNextRunTime - System.currentTimeMillis();
            if (waitTime <= 0L) {
                this.clearTimer();
                runNow = true;
                assert (this.myPendingRequestsCount == 0);
                this.myPendingRequestsCount = 0;
                this.myState = State.GATING;
            } else {
                assert (this.myPendingRequestsCount == 0);
                ++this.myPendingRequestsCount;
                this.armTimer(waitTime);
                this.myState = State.WAITING;
            }
        } else {
            ++this.myPendingRequestsCount;
        }
        if (runNow) {
            this.runInGate();
        }
    }

    public void requestDelayed() {
        assert (EventQueue.isDispatchThread());
        this.delay();
        this.request();
    }

    public void delay() {
        assert (EventQueue.isDispatchThread());
        this.delay(0L);
    }

    public void delay(long pause) {
        assert (EventQueue.isDispatchThread());
        this.myNextRunTime = Math.max(this.myNextRunTime, System.currentTimeMillis() + Math.max(pause, this.myMinimumPeriod));
    }

    private void armTimer(long waitTime) {
        Timer timer = new Timer((int)waitTime, this.myListener);
        timer.setRepeats(false);
        this.myTimer = timer;
        timer.start();
    }

    private void clearTimer() {
        Timer timer = this.myTimer;
        if (timer != null) {
            timer.stop();
            this.myTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doRun(Runnable runnable) {
        block43: {
            if (this.myState != State.GATING) {
                assert (false) : this.myState;
                return;
            }
            this.myState = State.RUNNING;
            runnable.run();
            Object var4_2 = null;
            try {
                this.delay();
                if (this.myPendingRequestsCount > 0) {
                    long waitTime = this.myNextRunTime - System.currentTimeMillis();
                    assert (waitTime > 0L);
                    if (waitTime > 0L) {
                        this.armTimer(waitTime);
                        if (this.myState == State.RUNNING) {
                            this.myState = State.WAITING;
                        } else assert (false) : this.myState;
                    } else {
                        this.myState = State.IDLE;
                    }
                } else if (this.myState == State.RUNNING) {
                    this.myState = State.IDLE;
                } else assert (false) : this.myState;
                break block43;
            }
            catch (Exception e2) {
                Logger.getLogger("com.almworks").log(Level.SEVERE, "delayed execution error", e2);
            }
            break block43;
            {
                catch (Exception e) {
                    Logger.getLogger("com.almworks").log(Level.SEVERE, "delayed execution error", e);
                    Object var4_3 = null;
                    try {
                        this.delay();
                        if (this.myPendingRequestsCount > 0) {
                            long waitTime = this.myNextRunTime - System.currentTimeMillis();
                            assert (waitTime > 0L);
                            if (waitTime > 0L) {
                                this.armTimer(waitTime);
                                if (this.myState == State.RUNNING) {
                                    this.myState = State.WAITING;
                                } else assert (false) : this.myState;
                            } else {
                                this.myState = State.IDLE;
                            }
                        } else if (this.myState == State.RUNNING) {
                            this.myState = State.IDLE;
                        } else assert (false) : this.myState;
                        break block43;
                    }
                    catch (Exception e2) {
                        Logger.getLogger("com.almworks").log(Level.SEVERE, "delayed execution error", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.delay();
                    if (this.myPendingRequestsCount > 0) {
                        long waitTime = this.myNextRunTime - System.currentTimeMillis();
                        assert (waitTime > 0L);
                        if (waitTime > 0L) {
                            this.armTimer(waitTime);
                            if (this.myState == State.RUNNING) {
                                this.myState = State.WAITING;
                            } else assert (false) : this.myState;
                        } else {
                            this.myState = State.IDLE;
                        }
                    } else if (this.myState == State.RUNNING) {
                        this.myState = State.IDLE;
                    } else assert (false) : this.myState;
                }
                catch (Exception e2) {
                    Logger.getLogger("com.almworks").log(Level.SEVERE, "delayed execution error", e2);
                }
                throw throwable;
            }
        }
    }

    private void onTimer() {
        boolean runNow = false;
        if (this.myState != State.WAITING || this.myPendingRequestsCount <= 0) {
            return;
        }
        this.clearTimer();
        long waitTime = this.myNextRunTime - System.currentTimeMillis();
        if (waitTime <= 0L) {
            runNow = true;
            this.myPendingRequestsCount = 0;
            this.myState = State.GATING;
        } else {
            this.armTimer(waitTime);
        }
        if (runNow) {
            this.runInGate();
        }
    }

    @Deprecated
    private void runInGate() {
        assert (EventQueue.isDispatchThread());
        this.myRunnable.run();
    }

    public void clearBacklog() {
        assert (EventQueue.isDispatchThread());
        this.myNextRunTime = 0L;
        this.myPendingRequestsCount = 0;
        this.clearTimer();
        if (this.myState == State.WAITING) {
            this.myState = State.IDLE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        WAITING,
        GATING,
        RUNNING;

    }
}

