/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.LoginMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.FreeColServerHolder;

public final class UserConnectionHandler
extends FreeColServerHolder
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(UserConnectionHandler.class.getName());

    public UserConnectionHandler(FreeColServer freeColServer) {
        super(freeColServer);
    }

    @Override
    public Message handle(Connection connection, Message message) throws FreeColException {
        FreeColServer freeColServer = this.getFreeColServer();
        ChangeSet cs = null;
        switch (message.getType()) {
            case "disconnect": {
                break;
            }
            case "login": {
                cs = ((LoginMessage)message).loginHandler(freeColServer, connection);
                break;
            }
            default: {
                cs = ChangeSet.clientError((Player)null, StringTemplate.template("server.couldNotLogin"));
            }
        }
        return cs == null ? null : cs.build(freeColServer.getPlayer(connection));
    }

    @Override
    public Message read(Connection connection) throws FreeColException, XMLStreamException {
        return Message.read(this.getGame(), connection.getFreeColXMLReader());
    }
}

