/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.javax.sdp.fields.EmailAddress;
import gov.nist.javax.sdp.fields.SDPField;
import javax.sdp.EMail;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;

public class EmailField
extends SDPField
implements EMail {
    protected EmailAddress emailAddress = new EmailAddress();

    public EmailField() {
        super("e=");
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(EmailAddress emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public String encode() {
        return "e=" + this.emailAddress.encode() + "\r\n";
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public String getValue() throws SdpParseException {
        if (this.emailAddress == null) {
            return null;
        }
        return this.emailAddress.getDisplayName();
    }

    @Override
    public void setValue(String value2) throws SdpException {
        if (value2 == null) {
            throw new SdpException("The value is null");
        }
        this.emailAddress.setDisplayName(value2);
    }

    @Override
    public Object clone() {
        EmailField retval = (EmailField)super.clone();
        if (this.emailAddress != null) {
            retval.emailAddress = (EmailAddress)this.emailAddress.clone();
        }
        return retval;
    }
}

