/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Breadcrumb;
import io.sentry.DiagnosticLogger;
import io.sentry.Dsn;
import io.sentry.DuplicateEventDetectionEventProcessor;
import io.sentry.EnvelopeReader;
import io.sentry.EventProcessor;
import io.sentry.ExperimentalOptions;
import io.sentry.ExternalOptions;
import io.sentry.FullyDisplayedReporter;
import io.sentry.Hint;
import io.sentry.IConnectionStatusProvider;
import io.sentry.IEnvelopeReader;
import io.sentry.ILogger;
import io.sentry.IOptionsObserver;
import io.sentry.IPerformanceCollector;
import io.sentry.IScopeObserver;
import io.sentry.ISentryExecutorService;
import io.sentry.ISerializer;
import io.sentry.ITransactionProfiler;
import io.sentry.ITransportFactory;
import io.sentry.Instrumenter;
import io.sentry.Integration;
import io.sentry.JsonSerializer;
import io.sentry.MainEventProcessor;
import io.sentry.NoOpConnectionStatusProvider;
import io.sentry.NoOpEnvelopeReader;
import io.sentry.NoOpLogger;
import io.sentry.NoOpReplayController;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.NoOpSerializer;
import io.sentry.NoOpTransactionPerformanceCollector;
import io.sentry.NoOpTransactionProfiler;
import io.sentry.NoOpTransportFactory;
import io.sentry.ReplayController;
import io.sentry.SamplingContext;
import io.sentry.SentryAutoDateProvider;
import io.sentry.SentryDateProvider;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryReplayEvent;
import io.sentry.SentryReplayOptions;
import io.sentry.SentryRuntimeEventProcessor;
import io.sentry.ShutdownHookIntegration;
import io.sentry.SpotlightIntegration;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.backpressure.IBackpressureMonitor;
import io.sentry.backpressure.NoOpBackpressureMonitor;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.clientreport.ClientReportRecorder;
import io.sentry.clientreport.IClientReportRecorder;
import io.sentry.clientreport.NoOpClientReportRecorder;
import io.sentry.internal.debugmeta.IDebugMetaLoader;
import io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.sentry.internal.gestures.GestureTargetLocator;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.internal.viewhierarchy.ViewHierarchyExporter;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryTransaction;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.NoOpTransportGate;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.Platform;
import io.sentry.util.SampleRateUtils;
import io.sentry.util.StringUtils;
import io.sentry.util.thread.IMainThreadChecker;
import io.sentry.util.thread.NoOpMainThreadChecker;
import java.io.File;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SentryOptions {
    @ApiStatus.Internal
    @NotNull
    public static final String DEFAULT_PROPAGATION_TARGETS = ".*";
    static final SentryLevel DEFAULT_DIAGNOSTIC_LEVEL = SentryLevel.DEBUG;
    private static final String DEFAULT_ENVIRONMENT = "production";
    @NotNull
    private final List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    @NotNull
    private final Set<Class<? extends Throwable>> ignoredExceptionsForType = new CopyOnWriteArraySet<Class<? extends Throwable>>();
    @NotNull
    private final List<Integration> integrations = new CopyOnWriteArrayList<Integration>();
    @NotNull
    private final Set<String> bundleIds = new CopyOnWriteArraySet<String>();
    @Nullable
    private String dsn;
    @NotNull
    private final LazyEvaluator<Dsn> parsedDsn = new LazyEvaluator<Dsn>(() -> new Dsn(this.dsn));
    @Nullable
    private String dsnHash;
    private long shutdownTimeoutMillis = 2000L;
    private long flushTimeoutMillis = 15000L;
    private long sessionFlushTimeoutMillis = 15000L;
    private boolean debug;
    @NotNull
    private ILogger logger = NoOpLogger.getInstance();
    @NotNull
    private SentryLevel diagnosticLevel = DEFAULT_DIAGNOSTIC_LEVEL;
    @NotNull
    private final LazyEvaluator<ISerializer> serializer = new LazyEvaluator<ISerializer>(() -> new JsonSerializer(this));
    @NotNull
    private final LazyEvaluator<IEnvelopeReader> envelopeReader = new LazyEvaluator<IEnvelopeReader>(() -> new EnvelopeReader(this.serializer.getValue()));
    private int maxDepth = 100;
    @Nullable
    private String sentryClientName;
    @Nullable
    private BeforeSendCallback beforeSend;
    @Nullable
    private BeforeSendTransactionCallback beforeSendTransaction;
    @Nullable
    private BeforeSendReplayCallback beforeSendReplay;
    @Nullable
    private BeforeBreadcrumbCallback beforeBreadcrumb;
    @Nullable
    private String cacheDirPath;
    private int maxCacheItems;
    private int maxQueueSize = this.maxCacheItems = 30;
    private int maxBreadcrumbs = 100;
    @Nullable
    private String release;
    @Nullable
    private String environment;
    @Nullable
    private Proxy proxy;
    @Nullable
    private Double sampleRate;
    @Nullable
    private Boolean enableTracing;
    @Nullable
    private Double tracesSampleRate;
    @Nullable
    private TracesSamplerCallback tracesSampler;
    @NotNull
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    @NotNull
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    @NotNull
    private ITransportFactory transportFactory = NoOpTransportFactory.getInstance();
    @NotNull
    private ITransportGate transportGate = NoOpTransportGate.getInstance();
    @Nullable
    private String dist;
    private boolean attachThreads;
    private boolean attachStacktrace = true;
    private boolean enableAutoSessionTracking = true;
    private long sessionTrackingIntervalMillis = 30000L;
    @Nullable
    private String distinctId;
    @Nullable
    private String serverName;
    private boolean attachServerName = true;
    private boolean enableUncaughtExceptionHandler = true;
    private boolean printUncaughtStackTrace = false;
    @NotNull
    private ISentryExecutorService executorService = NoOpSentryExecutorService.getInstance();
    private int connectionTimeoutMillis = 5000;
    private int readTimeoutMillis = 5000;
    @NotNull
    private IEnvelopeCache envelopeDiskCache = NoOpEnvelopeCache.getInstance();
    @Nullable
    private SdkVersion sdkVersion;
    private boolean sendDefaultPii = false;
    @Nullable
    private SSLSocketFactory sslSocketFactory;
    @NotNull
    private final List<IScopeObserver> observers = new CopyOnWriteArrayList<IScopeObserver>();
    @NotNull
    private final List<IOptionsObserver> optionsObservers = new CopyOnWriteArrayList<IOptionsObserver>();
    private boolean enableExternalConfiguration;
    @NotNull
    private final @NotNull Map<String, @NotNull String> tags = new ConcurrentHashMap<String, String>();
    private long maxAttachmentSize = 0x1400000L;
    private boolean enableDeduplication = true;
    private int maxSpans = 1000;
    private boolean enableShutdownHook = true;
    @NotNull
    private RequestSize maxRequestBodySize = RequestSize.NONE;
    private boolean traceSampling = true;
    @Nullable
    private Double profilesSampleRate;
    @Nullable
    private ProfilesSamplerCallback profilesSampler;
    private long maxTraceFileSize = 0x500000L;
    @NotNull
    private ITransactionProfiler transactionProfiler = NoOpTransactionProfiler.getInstance();
    @Nullable
    private List<String> tracePropagationTargets = null;
    @NotNull
    private final List<String> defaultTracePropagationTargets = Collections.singletonList(".*");
    @Nullable
    private String proguardUuid;
    @Nullable
    private Long idleTimeout = 3000L;
    @NotNull
    private final List<String> contextTags = new CopyOnWriteArrayList<String>();
    private boolean sendClientReports = true;
    @NotNull
    IClientReportRecorder clientReportRecorder = new ClientReportRecorder(this);
    @NotNull
    private IModulesLoader modulesLoader = NoOpModulesLoader.getInstance();
    @NotNull
    private IDebugMetaLoader debugMetaLoader = NoOpDebugMetaLoader.getInstance();
    private boolean enableUserInteractionTracing = false;
    private boolean enableUserInteractionBreadcrumbs = true;
    @NotNull
    private Instrumenter instrumenter = Instrumenter.SENTRY;
    @NotNull
    private final List<GestureTargetLocator> gestureTargetLocators = new ArrayList<GestureTargetLocator>();
    @NotNull
    private final List<ViewHierarchyExporter> viewHierarchyExporters = new ArrayList<ViewHierarchyExporter>();
    @NotNull
    private IMainThreadChecker mainThreadChecker = NoOpMainThreadChecker.getInstance();
    private boolean traceOptionsRequests = true;
    @ApiStatus.Internal
    @NotNull
    private final LazyEvaluator<SentryDateProvider> dateProvider = new LazyEvaluator<SentryDateProvider>(() -> new SentryAutoDateProvider());
    @NotNull
    private final List<IPerformanceCollector> performanceCollectors = new ArrayList<IPerformanceCollector>();
    @NotNull
    private TransactionPerformanceCollector transactionPerformanceCollector = NoOpTransactionPerformanceCollector.getInstance();
    private boolean enableTimeToFullDisplayTracing = false;
    @NotNull
    private FullyDisplayedReporter fullyDisplayedReporter = FullyDisplayedReporter.getInstance();
    @NotNull
    private IConnectionStatusProvider connectionStatusProvider = new NoOpConnectionStatusProvider();
    private boolean enabled = true;
    private boolean enablePrettySerializationOutput = true;
    private boolean sendModules = true;
    @Nullable
    private BeforeEnvelopeCallback beforeEnvelopeCallback;
    private boolean enableSpotlight = false;
    @Nullable
    private String spotlightConnectionUrl;
    private boolean enableScopePersistence = true;
    @ApiStatus.Experimental
    @Nullable
    private List<String> ignoredCheckIns = null;
    @NotNull
    private IBackpressureMonitor backpressureMonitor = NoOpBackpressureMonitor.getInstance();
    private boolean enableBackpressureHandling = true;
    private boolean enableAppStartProfiling = false;
    private boolean enableMetrics = false;
    private boolean enableDefaultTagsForMetrics = true;
    private boolean enableSpanLocalMetricAggregation = true;
    @Nullable
    private BeforeEmitMetricCallback beforeEmitMetricCallback = null;
    private int profilingTracesHz = 101;
    @ApiStatus.Experimental
    @Nullable
    private Cron cron = null;
    @NotNull
    private final ExperimentalOptions experimental;
    @NotNull
    private ReplayController replayController = NoOpReplayController.getInstance();
    @ApiStatus.Experimental
    private boolean enableScreenTracking = true;
    @NotNull
    private SentryReplayOptions sessionReplay;

    public void addEventProcessor(@NotNull EventProcessor eventProcessor) {
        this.eventProcessors.add(eventProcessor);
    }

    @NotNull
    public List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public void addIntegration(@NotNull Integration integration) {
        this.integrations.add(integration);
    }

    @NotNull
    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    @Nullable
    public String getDsn() {
        return this.dsn;
    }

    @ApiStatus.Internal
    @NotNull
    Dsn retrieveParsedDsn() throws IllegalArgumentException {
        return this.parsedDsn.getValue();
    }

    public void setDsn(@Nullable String dsn) {
        this.dsn = dsn;
        this.parsedDsn.resetValue();
        this.dsnHash = StringUtils.calculateStringHash(this.dsn, this.logger);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @NotNull
    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(@Nullable ILogger logger) {
        this.logger = logger == null ? NoOpLogger.getInstance() : new DiagnosticLogger(this, logger);
    }

    @NotNull
    public SentryLevel getDiagnosticLevel() {
        return this.diagnosticLevel;
    }

    public void setDiagnosticLevel(@Nullable SentryLevel diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel != null ? diagnosticLevel : DEFAULT_DIAGNOSTIC_LEVEL;
    }

    @NotNull
    public ISerializer getSerializer() {
        return this.serializer.getValue();
    }

    public void setSerializer(@Nullable ISerializer serializer) {
        this.serializer.setValue(serializer != null ? serializer : NoOpSerializer.getInstance());
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @NotNull
    public IEnvelopeReader getEnvelopeReader() {
        return this.envelopeReader.getValue();
    }

    public void setEnvelopeReader(@Nullable IEnvelopeReader envelopeReader) {
        this.envelopeReader.setValue(envelopeReader != null ? envelopeReader : NoOpEnvelopeReader.getInstance());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public long getShutdownTimeout() {
        return this.shutdownTimeoutMillis;
    }

    public long getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setShutdownTimeout(long shutdownTimeoutMillis) {
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
    }

    public void setShutdownTimeoutMillis(long shutdownTimeoutMillis) {
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
    }

    @Nullable
    public String getSentryClientName() {
        return this.sentryClientName;
    }

    public void setSentryClientName(@Nullable String sentryClientName) {
        this.sentryClientName = sentryClientName;
    }

    @Nullable
    public BeforeSendCallback getBeforeSend() {
        return this.beforeSend;
    }

    public void setBeforeSend(@Nullable BeforeSendCallback beforeSend) {
        this.beforeSend = beforeSend;
    }

    @Nullable
    public BeforeSendTransactionCallback getBeforeSendTransaction() {
        return this.beforeSendTransaction;
    }

    public void setBeforeSendTransaction(@Nullable BeforeSendTransactionCallback beforeSendTransaction) {
        this.beforeSendTransaction = beforeSendTransaction;
    }

    @Nullable
    public BeforeSendReplayCallback getBeforeSendReplay() {
        return this.beforeSendReplay;
    }

    public void setBeforeSendReplay(@Nullable BeforeSendReplayCallback beforeSendReplay) {
        this.beforeSendReplay = beforeSendReplay;
    }

    @Nullable
    public BeforeBreadcrumbCallback getBeforeBreadcrumb() {
        return this.beforeBreadcrumb;
    }

    public void setBeforeBreadcrumb(@Nullable BeforeBreadcrumbCallback beforeBreadcrumb) {
        this.beforeBreadcrumb = beforeBreadcrumb;
    }

    @Nullable
    public String getCacheDirPath() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        return this.dsnHash != null ? new File(this.cacheDirPath, this.dsnHash).getAbsolutePath() : this.cacheDirPath;
    }

    @Nullable
    String getCacheDirPathWithoutDsn() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        return this.cacheDirPath;
    }

    @Nullable
    public String getOutboxPath() {
        String cacheDirPath = this.getCacheDirPath();
        if (cacheDirPath == null) {
            return null;
        }
        return new File(cacheDirPath, "outbox").getAbsolutePath();
    }

    public void setCacheDirPath(@Nullable String cacheDirPath) {
        this.cacheDirPath = cacheDirPath;
    }

    public int getMaxBreadcrumbs() {
        return this.maxBreadcrumbs;
    }

    public void setMaxBreadcrumbs(int maxBreadcrumbs) {
        this.maxBreadcrumbs = maxBreadcrumbs;
    }

    @Nullable
    public String getRelease() {
        return this.release;
    }

    public void setRelease(@Nullable String release) {
        this.release = release;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment != null ? this.environment : DEFAULT_ENVIRONMENT;
    }

    public void setEnvironment(@Nullable String environment) {
        this.environment = environment;
    }

    @Nullable
    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
    }

    @Nullable
    public Double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Double sampleRate) {
        if (!SampleRateUtils.isValidSampleRate(sampleRate)) {
            throw new IllegalArgumentException("The value " + sampleRate + " is not valid. Use null to disable or values >= 0.0 and <= 1.0.");
        }
        this.sampleRate = sampleRate;
    }

    @Deprecated
    @Nullable
    public Boolean getEnableTracing() {
        return this.enableTracing;
    }

    @Deprecated
    public void setEnableTracing(@Nullable Boolean enableTracing) {
        this.enableTracing = enableTracing;
    }

    @Nullable
    public Double getTracesSampleRate() {
        return this.tracesSampleRate;
    }

    public void setTracesSampleRate(@Nullable Double tracesSampleRate) {
        if (!SampleRateUtils.isValidTracesSampleRate(tracesSampleRate)) {
            throw new IllegalArgumentException("The value " + tracesSampleRate + " is not valid. Use null to disable or values between 0.0 and 1.0.");
        }
        this.tracesSampleRate = tracesSampleRate;
    }

    @Nullable
    public TracesSamplerCallback getTracesSampler() {
        return this.tracesSampler;
    }

    public void setTracesSampler(@Nullable TracesSamplerCallback tracesSampler) {
        this.tracesSampler = tracesSampler;
    }

    @NotNull
    public List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    public void addInAppExclude(@NotNull String exclude) {
        this.inAppExcludes.add(exclude);
    }

    @NotNull
    public List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    public void addInAppInclude(@NotNull String include) {
        this.inAppIncludes.add(include);
    }

    @NotNull
    public ITransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public void setTransportFactory(@Nullable ITransportFactory transportFactory) {
        this.transportFactory = transportFactory != null ? transportFactory : NoOpTransportFactory.getInstance();
    }

    @Nullable
    public String getDist() {
        return this.dist;
    }

    public void setDist(@Nullable String dist) {
        this.dist = dist;
    }

    @NotNull
    public ITransportGate getTransportGate() {
        return this.transportGate;
    }

    public void setTransportGate(@Nullable ITransportGate transportGate) {
        this.transportGate = transportGate != null ? transportGate : NoOpTransportGate.getInstance();
    }

    public boolean isAttachStacktrace() {
        return this.attachStacktrace;
    }

    public void setAttachStacktrace(boolean attachStacktrace) {
        this.attachStacktrace = attachStacktrace;
    }

    public boolean isAttachThreads() {
        return this.attachThreads;
    }

    public void setAttachThreads(boolean attachThreads) {
        this.attachThreads = attachThreads;
    }

    public boolean isEnableAutoSessionTracking() {
        return this.enableAutoSessionTracking;
    }

    public void setEnableAutoSessionTracking(boolean enableAutoSessionTracking) {
        this.enableAutoSessionTracking = enableAutoSessionTracking;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(@Nullable String serverName) {
        this.serverName = serverName;
    }

    public boolean isAttachServerName() {
        return this.attachServerName;
    }

    public void setAttachServerName(boolean attachServerName) {
        this.attachServerName = attachServerName;
    }

    public long getSessionTrackingIntervalMillis() {
        return this.sessionTrackingIntervalMillis;
    }

    public void setSessionTrackingIntervalMillis(long sessionTrackingIntervalMillis) {
        this.sessionTrackingIntervalMillis = sessionTrackingIntervalMillis;
    }

    @ApiStatus.Internal
    @Nullable
    public String getDistinctId() {
        return this.distinctId;
    }

    @ApiStatus.Internal
    public void setDistinctId(@Nullable String distinctId) {
        this.distinctId = distinctId;
    }

    public long getFlushTimeoutMillis() {
        return this.flushTimeoutMillis;
    }

    public void setFlushTimeoutMillis(long flushTimeoutMillis) {
        this.flushTimeoutMillis = flushTimeoutMillis;
    }

    public boolean isEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    public void setEnableUncaughtExceptionHandler(boolean enableUncaughtExceptionHandler) {
        this.enableUncaughtExceptionHandler = enableUncaughtExceptionHandler;
    }

    public boolean isPrintUncaughtStackTrace() {
        return this.printUncaughtStackTrace;
    }

    public void setPrintUncaughtStackTrace(boolean printUncaughtStackTrace) {
        this.printUncaughtStackTrace = printUncaughtStackTrace;
    }

    @ApiStatus.Internal
    @NotNull
    public ISentryExecutorService getExecutorService() {
        return this.executorService;
    }

    @ApiStatus.Internal
    @TestOnly
    public void setExecutorService(@NotNull ISentryExecutorService executorService) {
        if (executorService != null) {
            this.executorService = executorService;
        }
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @NotNull
    public IEnvelopeCache getEnvelopeDiskCache() {
        return this.envelopeDiskCache;
    }

    public void setEnvelopeDiskCache(@Nullable IEnvelopeCache envelopeDiskCache) {
        this.envelopeDiskCache = envelopeDiskCache != null ? envelopeDiskCache : NoOpEnvelopeCache.getInstance();
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        if (maxQueueSize > 0) {
            this.maxQueueSize = maxQueueSize;
        }
    }

    @Nullable
    public SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    @Nullable
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(@Nullable SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    @ApiStatus.Internal
    public void setSdkVersion(@Nullable SdkVersion sdkVersion) {
        @Nullable SdkVersion replaySdkVersion = this.getSessionReplay().getSdkVersion();
        if (this.sdkVersion != null && replaySdkVersion != null && this.sdkVersion.equals(replaySdkVersion)) {
            this.getSessionReplay().setSdkVersion(sdkVersion);
        }
        this.sdkVersion = sdkVersion;
    }

    public boolean isSendDefaultPii() {
        return this.sendDefaultPii;
    }

    public void setSendDefaultPii(boolean sendDefaultPii) {
        this.sendDefaultPii = sendDefaultPii;
    }

    public void addScopeObserver(@NotNull IScopeObserver observer) {
        this.observers.add(observer);
    }

    @NotNull
    public List<IScopeObserver> getScopeObservers() {
        return this.observers;
    }

    public void addOptionsObserver(@NotNull IOptionsObserver observer) {
        this.optionsObservers.add(observer);
    }

    @NotNull
    public List<IOptionsObserver> getOptionsObservers() {
        return this.optionsObservers;
    }

    public boolean isEnableExternalConfiguration() {
        return this.enableExternalConfiguration;
    }

    public void setEnableExternalConfiguration(boolean enableExternalConfiguration) {
        this.enableExternalConfiguration = enableExternalConfiguration;
    }

    @NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTag(@NotNull String key, @NotNull String value2) {
        this.tags.put(key, value2);
    }

    public long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public void setMaxAttachmentSize(long maxAttachmentSize) {
        this.maxAttachmentSize = maxAttachmentSize;
    }

    public boolean isEnableDeduplication() {
        return this.enableDeduplication;
    }

    public void setEnableDeduplication(boolean enableDeduplication) {
        this.enableDeduplication = enableDeduplication;
    }

    public boolean isTracingEnabled() {
        if (this.enableTracing != null) {
            return this.enableTracing;
        }
        return this.getTracesSampleRate() != null || this.getTracesSampler() != null;
    }

    @NotNull
    public Set<Class<? extends Throwable>> getIgnoredExceptionsForType() {
        return this.ignoredExceptionsForType;
    }

    public void addIgnoredExceptionForType(@NotNull Class<? extends Throwable> exceptionType) {
        this.ignoredExceptionsForType.add(exceptionType);
    }

    boolean containsIgnoredExceptionForType(@NotNull Throwable throwable) {
        return this.ignoredExceptionsForType.contains(throwable.getClass());
    }

    @ApiStatus.Experimental
    public int getMaxSpans() {
        return this.maxSpans;
    }

    @ApiStatus.Experimental
    public void setMaxSpans(int maxSpans) {
        this.maxSpans = maxSpans;
    }

    public boolean isEnableShutdownHook() {
        return this.enableShutdownHook;
    }

    public void setEnableShutdownHook(boolean enableShutdownHook) {
        this.enableShutdownHook = enableShutdownHook;
    }

    public int getMaxCacheItems() {
        return this.maxCacheItems;
    }

    public void setMaxCacheItems(int maxCacheItems) {
        this.maxCacheItems = maxCacheItems;
    }

    @NotNull
    public RequestSize getMaxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    public void setMaxRequestBodySize(@NotNull RequestSize maxRequestBodySize) {
        this.maxRequestBodySize = maxRequestBodySize;
    }

    @ApiStatus.Experimental
    public boolean isTraceSampling() {
        return this.traceSampling;
    }

    @Deprecated
    public void setTraceSampling(boolean traceSampling) {
        this.traceSampling = traceSampling;
    }

    public long getMaxTraceFileSize() {
        return this.maxTraceFileSize;
    }

    public void setMaxTraceFileSize(long maxTraceFileSize) {
        this.maxTraceFileSize = maxTraceFileSize;
    }

    @NotNull
    public ITransactionProfiler getTransactionProfiler() {
        return this.transactionProfiler;
    }

    public void setTransactionProfiler(@Nullable ITransactionProfiler transactionProfiler) {
        if (this.transactionProfiler == NoOpTransactionProfiler.getInstance() && transactionProfiler != null) {
            this.transactionProfiler = transactionProfiler;
        }
    }

    public boolean isProfilingEnabled() {
        return this.getProfilesSampleRate() != null && this.getProfilesSampleRate() > 0.0 || this.getProfilesSampler() != null;
    }

    @Deprecated
    public void setProfilingEnabled(boolean profilingEnabled) {
        if (this.getProfilesSampleRate() == null) {
            this.setProfilesSampleRate(profilingEnabled ? Double.valueOf(1.0) : null);
        }
    }

    @Nullable
    public ProfilesSamplerCallback getProfilesSampler() {
        return this.profilesSampler;
    }

    public void setProfilesSampler(@Nullable ProfilesSamplerCallback profilesSampler) {
        this.profilesSampler = profilesSampler;
    }

    @Nullable
    public Double getProfilesSampleRate() {
        return this.profilesSampleRate;
    }

    public void setProfilesSampleRate(@Nullable Double profilesSampleRate) {
        if (!SampleRateUtils.isValidProfilesSampleRate(profilesSampleRate)) {
            throw new IllegalArgumentException("The value " + profilesSampleRate + " is not valid. Use null to disable or values between 0.0 and 1.0.");
        }
        this.profilesSampleRate = profilesSampleRate;
    }

    @Nullable
    public String getProfilingTracesDirPath() {
        String cacheDirPath = this.getCacheDirPath();
        if (cacheDirPath == null) {
            return null;
        }
        return new File(cacheDirPath, "profiling_traces").getAbsolutePath();
    }

    @Deprecated
    @NotNull
    public List<String> getTracingOrigins() {
        return this.getTracePropagationTargets();
    }

    @Deprecated
    public void addTracingOrigin(@NotNull String tracingOrigin) {
        if (this.tracePropagationTargets == null) {
            this.tracePropagationTargets = new CopyOnWriteArrayList<String>();
        }
        if (!tracingOrigin.isEmpty()) {
            this.tracePropagationTargets.add(tracingOrigin);
        }
    }

    @Deprecated
    @ApiStatus.Internal
    public void setTracingOrigins(@Nullable List<String> tracingOrigins) {
        this.setTracePropagationTargets(tracingOrigins);
    }

    @NotNull
    public List<String> getTracePropagationTargets() {
        if (this.tracePropagationTargets == null) {
            return this.defaultTracePropagationTargets;
        }
        return this.tracePropagationTargets;
    }

    @ApiStatus.Internal
    public void setTracePropagationTargets(@Nullable List<String> tracePropagationTargets) {
        if (tracePropagationTargets == null) {
            this.tracePropagationTargets = null;
        } else {
            @NotNull ArrayList<String> filteredTracePropagationTargets = new ArrayList<String>();
            for (String target : tracePropagationTargets) {
                if (target.isEmpty()) continue;
                filteredTracePropagationTargets.add(target);
            }
            this.tracePropagationTargets = filteredTracePropagationTargets;
        }
    }

    @Nullable
    public String getProguardUuid() {
        return this.proguardUuid;
    }

    public void setProguardUuid(@Nullable String proguardUuid) {
        this.proguardUuid = proguardUuid;
    }

    public void addBundleId(@Nullable String bundleId) {
        String trimmedBundleId;
        if (bundleId != null && !(trimmedBundleId = bundleId.trim()).isEmpty()) {
            this.bundleIds.add(trimmedBundleId);
        }
    }

    @NotNull
    public Set<String> getBundleIds() {
        return this.bundleIds;
    }

    @NotNull
    public List<String> getContextTags() {
        return this.contextTags;
    }

    public void addContextTag(@NotNull String contextTag) {
        this.contextTags.add(contextTag);
    }

    @Nullable
    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(@Nullable Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean isSendClientReports() {
        return this.sendClientReports;
    }

    public void setSendClientReports(boolean sendClientReports) {
        this.sendClientReports = sendClientReports;
        this.clientReportRecorder = sendClientReports ? new ClientReportRecorder(this) : new NoOpClientReportRecorder();
    }

    public boolean isEnableUserInteractionTracing() {
        return this.enableUserInteractionTracing;
    }

    public void setEnableUserInteractionTracing(boolean enableUserInteractionTracing) {
        this.enableUserInteractionTracing = enableUserInteractionTracing;
    }

    public boolean isEnableUserInteractionBreadcrumbs() {
        return this.enableUserInteractionBreadcrumbs;
    }

    public void setEnableUserInteractionBreadcrumbs(boolean enableUserInteractionBreadcrumbs) {
        this.enableUserInteractionBreadcrumbs = enableUserInteractionBreadcrumbs;
    }

    public void setInstrumenter(@NotNull Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }

    @NotNull
    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    @ApiStatus.Internal
    @NotNull
    public IClientReportRecorder getClientReportRecorder() {
        return this.clientReportRecorder;
    }

    @ApiStatus.Internal
    @NotNull
    public IModulesLoader getModulesLoader() {
        return this.modulesLoader;
    }

    @ApiStatus.Internal
    public void setModulesLoader(@Nullable IModulesLoader modulesLoader) {
        this.modulesLoader = modulesLoader != null ? modulesLoader : NoOpModulesLoader.getInstance();
    }

    @ApiStatus.Internal
    @NotNull
    public IDebugMetaLoader getDebugMetaLoader() {
        return this.debugMetaLoader;
    }

    @ApiStatus.Internal
    public void setDebugMetaLoader(@Nullable IDebugMetaLoader debugMetaLoader) {
        this.debugMetaLoader = debugMetaLoader != null ? debugMetaLoader : NoOpDebugMetaLoader.getInstance();
    }

    public List<GestureTargetLocator> getGestureTargetLocators() {
        return this.gestureTargetLocators;
    }

    public void setGestureTargetLocators(@NotNull List<GestureTargetLocator> locators) {
        this.gestureTargetLocators.clear();
        this.gestureTargetLocators.addAll(locators);
    }

    @NotNull
    public final List<ViewHierarchyExporter> getViewHierarchyExporters() {
        return this.viewHierarchyExporters;
    }

    public void setViewHierarchyExporters(@NotNull List<ViewHierarchyExporter> exporters) {
        this.viewHierarchyExporters.clear();
        this.viewHierarchyExporters.addAll(exporters);
    }

    @NotNull
    public IMainThreadChecker getMainThreadChecker() {
        return this.mainThreadChecker;
    }

    public void setMainThreadChecker(@NotNull IMainThreadChecker mainThreadChecker) {
        this.mainThreadChecker = mainThreadChecker;
    }

    @ApiStatus.Internal
    @NotNull
    public TransactionPerformanceCollector getTransactionPerformanceCollector() {
        return this.transactionPerformanceCollector;
    }

    @ApiStatus.Internal
    public void setTransactionPerformanceCollector(@NotNull TransactionPerformanceCollector transactionPerformanceCollector) {
        this.transactionPerformanceCollector = transactionPerformanceCollector;
    }

    public boolean isEnableTimeToFullDisplayTracing() {
        return this.enableTimeToFullDisplayTracing;
    }

    public void setEnableTimeToFullDisplayTracing(boolean enableTimeToFullDisplayTracing) {
        this.enableTimeToFullDisplayTracing = enableTimeToFullDisplayTracing;
    }

    @ApiStatus.Internal
    @NotNull
    public FullyDisplayedReporter getFullyDisplayedReporter() {
        return this.fullyDisplayedReporter;
    }

    @ApiStatus.Internal
    @TestOnly
    public void setFullyDisplayedReporter(@NotNull FullyDisplayedReporter fullyDisplayedReporter) {
        this.fullyDisplayedReporter = fullyDisplayedReporter;
    }

    public boolean isTraceOptionsRequests() {
        return this.traceOptionsRequests;
    }

    public void setTraceOptionsRequests(boolean traceOptionsRequests) {
        this.traceOptionsRequests = traceOptionsRequests;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled2) {
        this.enabled = enabled2;
    }

    public boolean isEnablePrettySerializationOutput() {
        return this.enablePrettySerializationOutput;
    }

    public boolean isSendModules() {
        return this.sendModules;
    }

    public void setEnablePrettySerializationOutput(boolean enablePrettySerializationOutput) {
        this.enablePrettySerializationOutput = enablePrettySerializationOutput;
    }

    public boolean isEnableAppStartProfiling() {
        return this.isProfilingEnabled() && this.enableAppStartProfiling;
    }

    public void setEnableAppStartProfiling(boolean enableAppStartProfiling) {
        this.enableAppStartProfiling = enableAppStartProfiling;
    }

    public void setSendModules(boolean sendModules) {
        this.sendModules = sendModules;
    }

    @ApiStatus.Experimental
    public void setIgnoredCheckIns(@Nullable List<String> ignoredCheckIns) {
        if (ignoredCheckIns == null) {
            this.ignoredCheckIns = null;
        } else {
            @NotNull ArrayList<String> filteredIgnoredCheckIns = new ArrayList<String>();
            for (String slug : ignoredCheckIns) {
                if (slug.isEmpty()) continue;
                filteredIgnoredCheckIns.add(slug);
            }
            this.ignoredCheckIns = filteredIgnoredCheckIns;
        }
    }

    @ApiStatus.Experimental
    @Nullable
    public List<String> getIgnoredCheckIns() {
        return this.ignoredCheckIns;
    }

    @ApiStatus.Internal
    @NotNull
    public SentryDateProvider getDateProvider() {
        return this.dateProvider.getValue();
    }

    @ApiStatus.Internal
    public void setDateProvider(@NotNull SentryDateProvider dateProvider) {
        this.dateProvider.setValue(dateProvider);
    }

    @ApiStatus.Internal
    public void addPerformanceCollector(@NotNull IPerformanceCollector collector) {
        this.performanceCollectors.add(collector);
    }

    @ApiStatus.Internal
    @NotNull
    public List<IPerformanceCollector> getPerformanceCollectors() {
        return this.performanceCollectors;
    }

    @NotNull
    public IConnectionStatusProvider getConnectionStatusProvider() {
        return this.connectionStatusProvider;
    }

    public void setConnectionStatusProvider(@NotNull IConnectionStatusProvider connectionStatusProvider) {
        this.connectionStatusProvider = connectionStatusProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public IBackpressureMonitor getBackpressureMonitor() {
        return this.backpressureMonitor;
    }

    @ApiStatus.Internal
    public void setBackpressureMonitor(@NotNull IBackpressureMonitor backpressureMonitor) {
        this.backpressureMonitor = backpressureMonitor;
    }

    @ApiStatus.Experimental
    public void setEnableBackpressureHandling(boolean enableBackpressureHandling) {
        this.enableBackpressureHandling = enableBackpressureHandling;
    }

    @ApiStatus.Internal
    public int getProfilingTracesHz() {
        return this.profilingTracesHz;
    }

    @ApiStatus.Internal
    public void setProfilingTracesHz(int profilingTracesHz) {
        this.profilingTracesHz = profilingTracesHz;
    }

    @ApiStatus.Experimental
    public boolean isEnableBackpressureHandling() {
        return this.enableBackpressureHandling;
    }

    @ApiStatus.Internal
    public long getSessionFlushTimeoutMillis() {
        return this.sessionFlushTimeoutMillis;
    }

    @ApiStatus.Internal
    public void setSessionFlushTimeoutMillis(long sessionFlushTimeoutMillis) {
        this.sessionFlushTimeoutMillis = sessionFlushTimeoutMillis;
    }

    @ApiStatus.Internal
    @Nullable
    public BeforeEnvelopeCallback getBeforeEnvelopeCallback() {
        return this.beforeEnvelopeCallback;
    }

    @ApiStatus.Internal
    public void setBeforeEnvelopeCallback(@Nullable BeforeEnvelopeCallback beforeEnvelopeCallback) {
        this.beforeEnvelopeCallback = beforeEnvelopeCallback;
    }

    @ApiStatus.Experimental
    @Nullable
    public String getSpotlightConnectionUrl() {
        return this.spotlightConnectionUrl;
    }

    @ApiStatus.Experimental
    public void setSpotlightConnectionUrl(@Nullable String spotlightConnectionUrl) {
        this.spotlightConnectionUrl = spotlightConnectionUrl;
    }

    @ApiStatus.Experimental
    public boolean isEnableSpotlight() {
        return this.enableSpotlight;
    }

    @ApiStatus.Experimental
    public void setEnableSpotlight(boolean enableSpotlight) {
        this.enableSpotlight = enableSpotlight;
    }

    public boolean isEnableScopePersistence() {
        return this.enableScopePersistence;
    }

    public void setEnableScopePersistence(boolean enableScopePersistence) {
        this.enableScopePersistence = enableScopePersistence;
    }

    @ApiStatus.Experimental
    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    @ApiStatus.Experimental
    public void setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    @ApiStatus.Experimental
    public boolean isEnableSpanLocalMetricAggregation() {
        return this.isEnableMetrics() && this.enableSpanLocalMetricAggregation;
    }

    @ApiStatus.Experimental
    public void setEnableSpanLocalMetricAggregation(boolean enableSpanLocalMetricAggregation) {
        this.enableSpanLocalMetricAggregation = enableSpanLocalMetricAggregation;
    }

    @ApiStatus.Experimental
    public boolean isEnableDefaultTagsForMetrics() {
        return this.isEnableMetrics() && this.enableDefaultTagsForMetrics;
    }

    @ApiStatus.Experimental
    public void setEnableDefaultTagsForMetrics(boolean enableDefaultTagsForMetrics) {
        this.enableDefaultTagsForMetrics = enableDefaultTagsForMetrics;
    }

    @ApiStatus.Experimental
    @Nullable
    public BeforeEmitMetricCallback getBeforeEmitMetricCallback() {
        return this.beforeEmitMetricCallback;
    }

    @ApiStatus.Experimental
    public void setBeforeEmitMetricCallback(@Nullable BeforeEmitMetricCallback beforeEmitMetricCallback) {
        this.beforeEmitMetricCallback = beforeEmitMetricCallback;
    }

    @Nullable
    public Cron getCron() {
        return this.cron;
    }

    @ApiStatus.Experimental
    public void setCron(@Nullable Cron cron) {
        this.cron = cron;
    }

    @NotNull
    public ExperimentalOptions getExperimental() {
        return this.experimental;
    }

    @NotNull
    public ReplayController getReplayController() {
        return this.replayController;
    }

    public void setReplayController(@Nullable ReplayController replayController) {
        this.replayController = replayController != null ? replayController : NoOpReplayController.getInstance();
    }

    @ApiStatus.Experimental
    public boolean isEnableScreenTracking() {
        return this.enableScreenTracking;
    }

    @ApiStatus.Experimental
    public void setEnableScreenTracking(boolean enableScreenTracking) {
        this.enableScreenTracking = enableScreenTracking;
    }

    @NotNull
    public SentryReplayOptions getSessionReplay() {
        return this.sessionReplay;
    }

    public void setSessionReplay(@NotNull SentryReplayOptions sessionReplayOptions) {
        this.sessionReplay = sessionReplayOptions;
    }

    void loadLazyFields() {
        this.getSerializer();
        this.retrieveParsedDsn();
        this.getEnvelopeReader();
        this.getDateProvider();
    }

    @ApiStatus.Internal
    @NotNull
    public static SentryOptions empty() {
        return new SentryOptions(true);
    }

    public SentryOptions() {
        this(false);
    }

    private SentryOptions(boolean empty) {
        @NotNull SdkVersion sdkVersion = this.createSdkVersion();
        this.experimental = new ExperimentalOptions(empty, sdkVersion);
        this.sessionReplay = new SentryReplayOptions(empty, sdkVersion);
        if (!empty) {
            this.executorService = new SentryExecutorService();
            this.integrations.add(new UncaughtExceptionHandlerIntegration());
            this.integrations.add(new ShutdownHookIntegration());
            this.integrations.add(new SpotlightIntegration());
            this.eventProcessors.add(new MainEventProcessor(this));
            this.eventProcessors.add(new DuplicateEventDetectionEventProcessor(this));
            if (Platform.isJvm()) {
                this.eventProcessors.add(new SentryRuntimeEventProcessor());
            }
            this.setSentryClientName("sentry.java/7.20.0");
            this.setSdkVersion(sdkVersion);
            this.addPackageInfo();
        }
    }

    public void merge(@NotNull ExternalOptions options2) {
        if (options2.getDsn() != null) {
            this.setDsn(options2.getDsn());
        }
        if (options2.getEnvironment() != null) {
            this.setEnvironment(options2.getEnvironment());
        }
        if (options2.getRelease() != null) {
            this.setRelease(options2.getRelease());
        }
        if (options2.getDist() != null) {
            this.setDist(options2.getDist());
        }
        if (options2.getServerName() != null) {
            this.setServerName(options2.getServerName());
        }
        if (options2.getProxy() != null) {
            this.setProxy(options2.getProxy());
        }
        if (options2.getEnableUncaughtExceptionHandler() != null) {
            this.setEnableUncaughtExceptionHandler(options2.getEnableUncaughtExceptionHandler());
        }
        if (options2.getPrintUncaughtStackTrace() != null) {
            this.setPrintUncaughtStackTrace(options2.getPrintUncaughtStackTrace());
        }
        if (options2.getEnableTracing() != null) {
            this.setEnableTracing(options2.getEnableTracing());
        }
        if (options2.getTracesSampleRate() != null) {
            this.setTracesSampleRate(options2.getTracesSampleRate());
        }
        if (options2.getProfilesSampleRate() != null) {
            this.setProfilesSampleRate(options2.getProfilesSampleRate());
        }
        if (options2.getDebug() != null) {
            this.setDebug(options2.getDebug());
        }
        if (options2.getEnableDeduplication() != null) {
            this.setEnableDeduplication(options2.getEnableDeduplication());
        }
        if (options2.getSendClientReports() != null) {
            this.setSendClientReports(options2.getSendClientReports());
        }
        HashMap<String, String> tags = new HashMap<String, String>(options2.getTags());
        for (Map.Entry entry : tags.entrySet()) {
            this.tags.put((String)entry.getKey(), (String)entry.getValue());
        }
        ArrayList<String> inAppIncludes = new ArrayList<String>(options2.getInAppIncludes());
        for (String string : inAppIncludes) {
            this.addInAppInclude(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(options2.getInAppExcludes());
        for (String string : arrayList) {
            this.addInAppExclude(string);
        }
        for (Class<? extends Throwable> clazz : new HashSet<Class<? extends Throwable>>(options2.getIgnoredExceptionsForType())) {
            this.addIgnoredExceptionForType(clazz);
        }
        if (options2.getTracePropagationTargets() != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>(options2.getTracePropagationTargets());
            this.setTracePropagationTargets(arrayList2);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>(options2.getContextTags());
        for (String contextTag : arrayList3) {
            this.addContextTag(contextTag);
        }
        if (options2.getProguardUuid() != null) {
            this.setProguardUuid(options2.getProguardUuid());
        }
        if (options2.getIdleTimeout() != null) {
            this.setIdleTimeout(options2.getIdleTimeout());
        }
        for (String bundleId : options2.getBundleIds()) {
            this.addBundleId(bundleId);
        }
        if (options2.isEnabled() != null) {
            this.setEnabled(options2.isEnabled());
        }
        if (options2.isEnablePrettySerializationOutput() != null) {
            this.setEnablePrettySerializationOutput(options2.isEnablePrettySerializationOutput());
        }
        if (options2.isSendModules() != null) {
            this.setSendModules(options2.isSendModules());
        }
        if (options2.getIgnoredCheckIns() != null) {
            ArrayList<String> arrayList4 = new ArrayList<String>(options2.getIgnoredCheckIns());
            this.setIgnoredCheckIns(arrayList4);
        }
        if (options2.isEnableBackpressureHandling() != null) {
            this.setEnableBackpressureHandling(options2.isEnableBackpressureHandling());
        }
        if (options2.getCron() != null) {
            if (this.getCron() == null) {
                this.setCron(options2.getCron());
            } else {
                if (options2.getCron().getDefaultCheckinMargin() != null) {
                    this.getCron().setDefaultCheckinMargin(options2.getCron().getDefaultCheckinMargin());
                }
                if (options2.getCron().getDefaultMaxRuntime() != null) {
                    this.getCron().setDefaultMaxRuntime(options2.getCron().getDefaultMaxRuntime());
                }
                if (options2.getCron().getDefaultTimezone() != null) {
                    this.getCron().setDefaultTimezone(options2.getCron().getDefaultTimezone());
                }
                if (options2.getCron().getDefaultFailureIssueThreshold() != null) {
                    this.getCron().setDefaultFailureIssueThreshold(options2.getCron().getDefaultFailureIssueThreshold());
                }
                if (options2.getCron().getDefaultRecoveryThreshold() != null) {
                    this.getCron().setDefaultRecoveryThreshold(options2.getCron().getDefaultRecoveryThreshold());
                }
            }
        }
    }

    @NotNull
    private SdkVersion createSdkVersion() {
        String version = "7.20.0";
        SdkVersion sdkVersion = new SdkVersion("sentry.java", "7.20.0");
        sdkVersion.setVersion("7.20.0");
        return sdkVersion;
    }

    private void addPackageInfo() {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry", "7.20.0");
    }

    public static interface BeforeSendCallback {
        @Nullable
        public SentryEvent execute(@NotNull SentryEvent var1, @NotNull Hint var2);
    }

    public static interface BeforeSendTransactionCallback {
        @Nullable
        public SentryTransaction execute(@NotNull SentryTransaction var1, @NotNull Hint var2);
    }

    public static interface BeforeSendReplayCallback {
        @Nullable
        public SentryReplayEvent execute(@NotNull SentryReplayEvent var1, @NotNull Hint var2);
    }

    public static interface BeforeBreadcrumbCallback {
        @Nullable
        public Breadcrumb execute(@NotNull Breadcrumb var1, @NotNull Hint var2);
    }

    public static final class Proxy {
        @Nullable
        private String host;
        @Nullable
        private String port;
        @Nullable
        private String user;
        @Nullable
        private String pass;
        @Nullable
        private Proxy.Type type;

        public Proxy() {
            this(null, null, null, null, null);
        }

        public Proxy(@Nullable String host, @Nullable String port2) {
            this(host, port2, null, null, null);
        }

        public Proxy(@Nullable String host, @Nullable String port2, @Nullable Proxy.Type type) {
            this(host, port2, type, null, null);
        }

        public Proxy(@Nullable String host, @Nullable String port2, @Nullable String user, @Nullable String pass) {
            this(host, port2, null, user, pass);
        }

        public Proxy(@Nullable String host, @Nullable String port2, @Nullable Proxy.Type type, @Nullable String user, @Nullable String pass) {
            this.host = host;
            this.port = port2;
            this.type = type;
            this.user = user;
            this.pass = pass;
        }

        @Nullable
        public String getHost() {
            return this.host;
        }

        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @Nullable
        public String getPort() {
            return this.port;
        }

        public void setPort(@Nullable String port2) {
            this.port = port2;
        }

        @Nullable
        public String getUser() {
            return this.user;
        }

        public void setUser(@Nullable String user) {
            this.user = user;
        }

        @Nullable
        public String getPass() {
            return this.pass;
        }

        public void setPass(@Nullable String pass) {
            this.pass = pass;
        }

        @Nullable
        public Proxy.Type getType() {
            return this.type;
        }

        public void setType(@Nullable Proxy.Type type) {
            this.type = type;
        }
    }

    public static interface TracesSamplerCallback {
        @Nullable
        public Double sample(@NotNull SamplingContext var1);
    }

    public static enum RequestSize {
        NONE,
        SMALL,
        MEDIUM,
        ALWAYS;

    }

    public static interface ProfilesSamplerCallback {
        @Nullable
        public Double sample(@NotNull SamplingContext var1);
    }

    @ApiStatus.Internal
    public static interface BeforeEnvelopeCallback {
        public void execute(@NotNull SentryEnvelope var1, @Nullable Hint var2);
    }

    @ApiStatus.Experimental
    public static interface BeforeEmitMetricCallback {
        public boolean execute(@NotNull String var1, @Nullable Map<String, String> var2);
    }

    public static final class Cron {
        @Nullable
        private Long defaultCheckinMargin;
        @Nullable
        private Long defaultMaxRuntime;
        @Nullable
        private String defaultTimezone;
        @Nullable
        private Long defaultFailureIssueThreshold;
        @Nullable
        private Long defaultRecoveryThreshold;

        @Nullable
        public Long getDefaultCheckinMargin() {
            return this.defaultCheckinMargin;
        }

        public void setDefaultCheckinMargin(@Nullable Long defaultCheckinMargin) {
            this.defaultCheckinMargin = defaultCheckinMargin;
        }

        @Nullable
        public Long getDefaultMaxRuntime() {
            return this.defaultMaxRuntime;
        }

        public void setDefaultMaxRuntime(@Nullable Long defaultMaxRuntime) {
            this.defaultMaxRuntime = defaultMaxRuntime;
        }

        @Nullable
        public String getDefaultTimezone() {
            return this.defaultTimezone;
        }

        public void setDefaultTimezone(@Nullable String defaultTimezone) {
            this.defaultTimezone = defaultTimezone;
        }

        @Nullable
        public Long getDefaultFailureIssueThreshold() {
            return this.defaultFailureIssueThreshold;
        }

        public void setDefaultFailureIssueThreshold(@Nullable Long defaultFailureIssueThreshold) {
            this.defaultFailureIssueThreshold = defaultFailureIssueThreshold;
        }

        @Nullable
        public Long getDefaultRecoveryThreshold() {
            return this.defaultRecoveryThreshold;
        }

        public void setDefaultRecoveryThreshold(@Nullable Long defaultRecoveryThreshold) {
            this.defaultRecoveryThreshold = defaultRecoveryThreshold;
        }
    }
}

