/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.BCExtendedSSLSession;

class OldCertUtil {
    OldCertUtil() {
    }

    static X509Certificate[] getPeerCertificateChain(BCExtendedSSLSession bCExtendedSSLSession) throws SSLPeerUnverifiedException {
        boolean bl = bCExtendedSSLSession.isFipsMode();
        Certificate[] certificateArray = bCExtendedSSLSession.getPeerCertificates();
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        int n = 0;
        try {
            for (int i = 0; i < certificateArray.length; ++i) {
                Certificate certificate = certificateArray[i];
                if (!(certificate instanceof java.security.cert.X509Certificate)) continue;
                java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)certificate;
                x509CertificateArray[n++] = bl ? new X509CertificateWrapper(x509Certificate) : X509Certificate.getInstance(x509Certificate.getEncoded());
            }
        }
        catch (Exception exception) {
            throw new SSLPeerUnverifiedException(exception.getMessage());
        }
        if (n >= x509CertificateArray.length) {
            return x509CertificateArray;
        }
        X509Certificate[] x509CertificateArray2 = new X509Certificate[n];
        System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, n);
        return x509CertificateArray2;
    }

    private static class X509CertificateWrapper
    extends X509Certificate {
        private final java.security.cert.X509Certificate c;

        private X509CertificateWrapper(java.security.cert.X509Certificate x509Certificate) {
            this.c = x509Certificate;
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            try {
                this.c.checkValidity();
            }
            catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
                throw new CertificateExpiredException(certificateExpiredException.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
                throw new CertificateNotYetValidException(certificateNotYetValidException.getMessage());
            }
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            try {
                this.c.checkValidity(date);
            }
            catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
                throw new CertificateExpiredException(certificateExpiredException.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
                throw new CertificateNotYetValidException(certificateNotYetValidException.getMessage());
            }
        }

        @Override
        public int getVersion() {
            return this.c.getVersion() - 1;
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.c.getSerialNumber();
        }

        @Override
        public Principal getIssuerDN() {
            return this.c.getIssuerX500Principal();
        }

        @Override
        public Principal getSubjectDN() {
            return this.c.getSubjectX500Principal();
        }

        @Override
        public Date getNotBefore() {
            return this.c.getNotBefore();
        }

        @Override
        public Date getNotAfter() {
            return this.c.getNotAfter();
        }

        @Override
        public String getSigAlgName() {
            return this.c.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return this.c.getSigAlgOID();
        }

        @Override
        public byte[] getSigAlgParams() {
            return this.c.getSigAlgParams();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            try {
                return this.c.getEncoded();
            }
            catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
                throw new CertificateEncodingException(certificateEncodingException.getMessage());
            }
        }

        @Override
        public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            try {
                this.c.verify(publicKey);
            }
            catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
                throw new CertificateEncodingException(certificateEncodingException.getMessage());
            }
            catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
                throw new CertificateExpiredException(certificateExpiredException.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
                throw new CertificateNotYetValidException(certificateNotYetValidException.getMessage());
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new javax.security.cert.CertificateParsingException(certificateParsingException.getMessage());
            }
            catch (java.security.cert.CertificateException certificateException) {
                throw new CertificateException(certificateException.getMessage());
            }
        }

        @Override
        public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            try {
                this.c.verify(publicKey, string);
            }
            catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
                throw new CertificateEncodingException(certificateEncodingException.getMessage());
            }
            catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
                throw new CertificateExpiredException(certificateExpiredException.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
                throw new CertificateNotYetValidException(certificateNotYetValidException.getMessage());
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new javax.security.cert.CertificateParsingException(certificateParsingException.getMessage());
            }
            catch (java.security.cert.CertificateException certificateException) {
                throw new CertificateException(certificateException.getMessage());
            }
        }

        @Override
        public String toString() {
            return this.c.toString();
        }

        @Override
        public PublicKey getPublicKey() {
            return this.c.getPublicKey();
        }
    }
}

