/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.metrics;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.BooleanMetric;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.DoubleGaugeMetric;
import org.jitsi.metrics.HistogramMetric;
import org.jitsi.metrics.InfoMetric;
import org.jitsi.metrics.LongGaugeMetric;
import org.jitsi.metrics.Metric;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.json.simple.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u00015B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bJ\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J2\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020\b2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0007J2\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020&2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0007J2\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020)2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0007J\"\u0010*\u001a\u00020+2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\n\u0010,\u001a\u00020-\"\u00020)J.\u0010.\u001a\u00020/2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bJ2\u00101\u001a\u0002022\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020&2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0007J\u0006\u00103\u001a\u000204R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00066"}, d2={"Lorg/jitsi/metrics/MetricsContainer;", "", "registry", "Lio/prometheus/client/CollectorRegistry;", "namespace", "", "(Lio/prometheus/client/CollectorRegistry;Ljava/lang/String;)V", "checkForNameConflicts", "", "getCheckForNameConflicts", "()Z", "setCheckForNameConflicts", "(Z)V", "jsonString", "getJsonString", "()Ljava/lang/String;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "metrics", "", "Lorg/jitsi/metrics/Metric;", "getNamespace", "getRegistry", "()Lio/prometheus/client/CollectorRegistry;", "getMetrics", "Lkotlin/Pair;", "accepts", "", "getPrometheusMetrics", "contentType", "registerBooleanMetric", "Lorg/jitsi/metrics/BooleanMetric;", "name", "help", "initialValue", "labelNames", "registerCounter", "Lorg/jitsi/metrics/CounterMetric;", "", "registerDoubleGauge", "Lorg/jitsi/metrics/DoubleGaugeMetric;", "", "registerHistogram", "Lorg/jitsi/metrics/HistogramMetric;", "buckets", "", "registerInfo", "Lorg/jitsi/metrics/InfoMetric;", "value", "registerLongGauge", "Lorg/jitsi/metrics/LongGaugeMetric;", "resetAll", "", "NoSupportedMediaTypeException", "jicoco-metrics"})
@SourceDebugExtension(value={"SMAP\nMetricsContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsContainer.kt\norg/jitsi/metrics/MetricsContainer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n526#2:282\n511#2,6:283\n453#2:289\n403#2:290\n1238#3,4:291\n1855#3,2:295\n1855#3,2:298\n1#4:297\n*S KotlinDebug\n*F\n+ 1 MetricsContainer.kt\norg/jitsi/metrics/MetricsContainer\n*L\n56#1:282\n56#1:283,6\n56#1:289\n56#1:290\n56#1:291,4\n88#1:295,2\n276#1:298,2\n*E\n"})
public class MetricsContainer {
    @NotNull
    private final CollectorRegistry registry;
    @NotNull
    private final String namespace;
    @NotNull
    private final Logger logger;
    private boolean checkForNameConflicts;
    @NotNull
    private final Map<String, Metric<?>> metrics;

    @JvmOverloads
    public MetricsContainer(@NotNull CollectorRegistry registry, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter(registry, "registry");
        Intrinsics.checkNotNullParameter(namespace, "namespace");
        this.registry = registry;
        this.namespace = namespace;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.checkForNameConflicts = true;
        this.metrics = new LinkedHashMap();
    }

    public /* synthetic */ MetricsContainer(CollectorRegistry collectorRegistry, String string, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            CollectorRegistry collectorRegistry2 = CollectorRegistry.defaultRegistry;
            Intrinsics.checkNotNullExpressionValue(collectorRegistry2, "defaultRegistry");
            collectorRegistry = collectorRegistry2;
        }
        if ((n & 2) != 0) {
            string = "jitsi";
        }
        this(collectorRegistry, string);
    }

    @NotNull
    public final CollectorRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    public final boolean getCheckForNameConflicts() {
        return this.checkForNameConflicts;
    }

    public final void setCheckForNameConflicts(boolean bl) {
        this.checkForNameConflicts = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getJsonString() {
        void $this$mapValuesTo$iv$iv;
        Map $this$filterTo$iv$iv;
        Map<String, Metric<?>> $this$filter$iv = this.metrics;
        boolean $i$f$filter = false;
        Map<String, Metric<?>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((Metric)it.getValue()).getSupportsJson$jicoco_metrics()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Object t2 = ((Metric)it.getValue()).get();
            map3.put(k, t2);
        }
        Map map4 = destination$iv$iv;
        String string = new JSONObject(map4).toJSONString();
        Intrinsics.checkNotNullExpressionValue(string, "toJSONString(...)");
        return string;
    }

    @NotNull
    public String getPrometheusMetrics(@NotNull String contentType) {
        Intrinsics.checkNotNullParameter(contentType, "contentType");
        StringWriter writer = new StringWriter();
        try {
            TextFormat.writeFormat(contentType, writer, this.registry.metricFamilySamples());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final Pair<String, String> getMetrics(@NotNull List<String> accepts) {
        Intrinsics.checkNotNullParameter(accepts, "accepts");
        if (accepts.isEmpty()) {
            return TuplesKt.to(this.getPrometheusMetrics("application/openmetrics-text; version=1.0.0; charset=utf-8"), "application/openmetrics-text; version=1.0.0; charset=utf-8");
        }
        Iterable $this$forEach$iv = accepts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            switch (it) {
                case "application/openmetrics-text": {
                    return TuplesKt.to(this.getPrometheusMetrics("application/openmetrics-text; version=1.0.0; charset=utf-8"), "application/openmetrics-text; version=1.0.0; charset=utf-8");
                }
                case "text/plain": {
                    return TuplesKt.to(this.getPrometheusMetrics("text/plain; version=0.0.4; charset=utf-8"), "text/plain; version=0.0.4; charset=utf-8");
                }
                case "application/json": {
                    return TuplesKt.to(this.getJsonString(), "application/json");
                }
                case "*/*": {
                    return TuplesKt.to(this.getPrometheusMetrics("application/openmetrics-text; version=1.0.0; charset=utf-8"), "application/openmetrics-text; version=1.0.0; charset=utf-8");
                }
            }
        }
        throw new NoSupportedMediaTypeException("Supported media types are application/openmetrics-text, text/plain and application/json");
    }

    @JvmOverloads
    @NotNull
    public final BooleanMetric registerBooleanMetric(@NotNull String name, @NotNull String help, boolean initialValue, @NotNull List<String> labelNames) {
        BooleanMetric booleanMetric;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        Intrinsics.checkNotNullParameter(labelNames, "labelNames");
        if (this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + name + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(name);
            Intrinsics.checkNotNull(metric, "null cannot be cast to non-null type org.jitsi.metrics.BooleanMetric");
            return (BooleanMetric)metric;
        }
        BooleanMetric $this$registerBooleanMetric_u24lambda_u243 = booleanMetric = new BooleanMetric(name, help, this.namespace, initialValue, labelNames);
        boolean bl = false;
        this.metrics.put(name, $this$registerBooleanMetric_u24lambda_u243.register$jicoco_metrics(this.registry));
        return booleanMetric;
    }

    public static /* synthetic */ BooleanMetric registerBooleanMetric$default(MetricsContainer metricsContainer, String string, String string2, boolean bl, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerBooleanMetric");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return metricsContainer.registerBooleanMetric(string, string2, bl, list);
    }

    @JvmOverloads
    @NotNull
    public final CounterMetric registerCounter(@NotNull String name, @NotNull String help, long initialValue, @NotNull List<String> labelNames) {
        String newName;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        Intrinsics.checkNotNullParameter(labelNames, "labelNames");
        if (StringsKt.endsWith$default(name, "_total", false, 2, null)) {
            object2 = name;
        } else {
            object = name + "_total";
            String it = object;
            boolean bl = false;
            this.logger.debug("Counter '" + name + "' was renamed to '" + it + "' to ensure consistent metric naming.");
            object2 = newName = object;
        }
        if (this.metrics.containsKey(newName) | this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + newName + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(newName);
            Intrinsics.checkNotNull(metric, "null cannot be cast to non-null type org.jitsi.metrics.CounterMetric");
            return (CounterMetric)metric;
        }
        Object $this$registerCounter_u24lambda_u245 = object = new CounterMetric(newName, help, this.namespace, initialValue, labelNames);
        boolean bl = false;
        this.metrics.put(newName, ((CounterMetric)$this$registerCounter_u24lambda_u245).register$jicoco_metrics(this.registry));
        return object;
    }

    public static /* synthetic */ CounterMetric registerCounter$default(MetricsContainer metricsContainer, String string, String string2, long l, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerCounter");
        }
        if ((n & 4) != 0) {
            l = 0L;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return metricsContainer.registerCounter(string, string2, l, list);
    }

    @JvmOverloads
    @NotNull
    public final LongGaugeMetric registerLongGauge(@NotNull String name, @NotNull String help, long initialValue, @NotNull List<String> labelNames) {
        LongGaugeMetric longGaugeMetric;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        Intrinsics.checkNotNullParameter(labelNames, "labelNames");
        if (this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + name + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(name);
            Intrinsics.checkNotNull(metric, "null cannot be cast to non-null type org.jitsi.metrics.LongGaugeMetric");
            return (LongGaugeMetric)metric;
        }
        LongGaugeMetric $this$registerLongGauge_u24lambda_u246 = longGaugeMetric = new LongGaugeMetric(name, help, this.namespace, initialValue, labelNames);
        boolean bl = false;
        this.metrics.put(name, $this$registerLongGauge_u24lambda_u246.register$jicoco_metrics(this.registry));
        return longGaugeMetric;
    }

    public static /* synthetic */ LongGaugeMetric registerLongGauge$default(MetricsContainer metricsContainer, String string, String string2, long l, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerLongGauge");
        }
        if ((n & 4) != 0) {
            l = 0L;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return metricsContainer.registerLongGauge(string, string2, l, list);
    }

    @JvmOverloads
    @NotNull
    public final DoubleGaugeMetric registerDoubleGauge(@NotNull String name, @NotNull String help, double initialValue, @NotNull List<String> labelNames) {
        DoubleGaugeMetric doubleGaugeMetric;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        Intrinsics.checkNotNullParameter(labelNames, "labelNames");
        if (this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + name + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(name);
            Intrinsics.checkNotNull(metric, "null cannot be cast to non-null type org.jitsi.metrics.DoubleGaugeMetric");
            return (DoubleGaugeMetric)metric;
        }
        DoubleGaugeMetric $this$registerDoubleGauge_u24lambda_u247 = doubleGaugeMetric = new DoubleGaugeMetric(name, help, this.namespace, initialValue, labelNames);
        boolean bl = false;
        this.metrics.put(name, $this$registerDoubleGauge_u24lambda_u247.register$jicoco_metrics(this.registry));
        return doubleGaugeMetric;
    }

    public static /* synthetic */ DoubleGaugeMetric registerDoubleGauge$default(MetricsContainer metricsContainer, String string, String string2, double d, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerDoubleGauge");
        }
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return metricsContainer.registerDoubleGauge(string, string2, d, list);
    }

    @NotNull
    public final InfoMetric registerInfo(@NotNull String name, @NotNull String help, @NotNull String value2, @NotNull List<String> labelNames) {
        InfoMetric infoMetric;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(labelNames, "labelNames");
        if (this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + name + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(name);
            Intrinsics.checkNotNull(metric, "null cannot be cast to non-null type org.jitsi.metrics.InfoMetric");
            return (InfoMetric)metric;
        }
        InfoMetric $this$registerInfo_u24lambda_u248 = infoMetric = new InfoMetric(name, help, this.namespace, value2, labelNames);
        boolean bl = false;
        this.metrics.put(name, $this$registerInfo_u24lambda_u248.register$jicoco_metrics(this.registry));
        return infoMetric;
    }

    public static /* synthetic */ InfoMetric registerInfo$default(MetricsContainer metricsContainer, String string, String string2, String string3, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerInfo");
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return metricsContainer.registerInfo(string, string2, string3, list);
    }

    @NotNull
    public final HistogramMetric registerHistogram(@NotNull String name, @NotNull String help, double ... buckets) {
        HistogramMetric histogramMetric;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        Intrinsics.checkNotNullParameter(buckets, "buckets");
        if (this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + name + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(name);
            Intrinsics.checkNotNull(metric, "null cannot be cast to non-null type org.jitsi.metrics.HistogramMetric");
            return (HistogramMetric)metric;
        }
        HistogramMetric $this$registerHistogram_u24lambda_u249 = histogramMetric = new HistogramMetric(name, help, this.namespace, Arrays.copyOf(buckets, buckets.length));
        boolean bl = false;
        this.metrics.put(name, $this$registerHistogram_u24lambda_u249.register$jicoco_metrics(this.registry));
        return histogramMetric;
    }

    public final void resetAll() {
        Iterable $this$forEach$iv = this.metrics.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Metric it = (Metric)element$iv;
            boolean bl = false;
            it.reset$jicoco_metrics();
        }
    }

    @JvmOverloads
    public MetricsContainer(@NotNull CollectorRegistry registry) {
        Intrinsics.checkNotNullParameter(registry, "registry");
        this(registry, null, 2, null);
    }

    @JvmOverloads
    public MetricsContainer() {
        this(null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final BooleanMetric registerBooleanMetric(@NotNull String name, @NotNull String help, boolean initialValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        return MetricsContainer.registerBooleanMetric$default(this, name, help, initialValue, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final BooleanMetric registerBooleanMetric(@NotNull String name, @NotNull String help) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        return MetricsContainer.registerBooleanMetric$default(this, name, help, false, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final CounterMetric registerCounter(@NotNull String name, @NotNull String help, long initialValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        return MetricsContainer.registerCounter$default(this, name, help, initialValue, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final CounterMetric registerCounter(@NotNull String name, @NotNull String help) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        return MetricsContainer.registerCounter$default(this, name, help, 0L, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final LongGaugeMetric registerLongGauge(@NotNull String name, @NotNull String help, long initialValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        return MetricsContainer.registerLongGauge$default(this, name, help, initialValue, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final LongGaugeMetric registerLongGauge(@NotNull String name, @NotNull String help) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        return MetricsContainer.registerLongGauge$default(this, name, help, 0L, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final DoubleGaugeMetric registerDoubleGauge(@NotNull String name, @NotNull String help, double initialValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        return MetricsContainer.registerDoubleGauge$default(this, name, help, initialValue, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final DoubleGaugeMetric registerDoubleGauge(@NotNull String name, @NotNull String help) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(help, "help");
        return MetricsContainer.registerDoubleGauge$default(this, name, help, 0.0, null, 12, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/metrics/MetricsContainer$NoSupportedMediaTypeException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "jicoco-metrics"})
    public static final class NoSupportedMediaTypeException
    extends Exception {
        public NoSupportedMediaTypeException(@NotNull String message) {
            Intrinsics.checkNotNullParameter(message, "message");
            super(message);
        }
    }
}

