/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class DnsClass
extends NamedNumber<Short, DnsClass> {
    private static final long serialVersionUID = -8563135157139346618L;
    public static final DnsClass IN = new DnsClass((short)1, "Internet (IN)");
    public static final DnsClass CH = new DnsClass((short)3, "Chaos (CH)");
    public static final DnsClass HS = new DnsClass((short)4, "Hesiod (HS)");
    public static final DnsClass NONE = new DnsClass((short)254, "NONE");
    public static final DnsClass ANY = new DnsClass((short)255, "ANY");
    private static final Map<Short, DnsClass> registry = new HashMap<Short, DnsClass>();

    public DnsClass(Short value2, String name) {
        super(value2, name);
    }

    public static DnsClass getInstance(Short value2) {
        if (registry.containsKey(value2)) {
            return registry.get(value2);
        }
        return new DnsClass(value2, "unknown");
    }

    public static DnsClass register(DnsClass cls) {
        return registry.put((Short)cls.value(), cls);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Short)this.value() & 0xFFFF);
    }

    @Override
    public int compareTo(DnsClass o) {
        return ((Short)this.value()).compareTo((Short)o.value());
    }

    static {
        registry.put((Short)IN.value(), IN);
        registry.put((Short)CH.value(), CH);
        registry.put((Short)HS.value(), HS);
        registry.put((Short)NONE.value(), NONE);
        registry.put((Short)ANY.value(), ANY);
    }
}

