/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls;

import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.tls.LetsEncryptEnabled;
import io.quarkus.tls.TlsCertificateBuildItem;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.TlsRegistryBuildItem;
import io.quarkus.tls.runtime.CertificateRecorder;
import io.quarkus.tls.runtime.KeyStoreProvider;
import io.quarkus.tls.runtime.LetsEncryptRecorder;
import io.quarkus.tls.runtime.TrustStoreProvider;
import io.quarkus.tls.runtime.config.TlsConfig;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.quarkus.vertx.http.deployment.spi.RouteBuildItem;
import io.smallrye.common.annotation.Identifier;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class CertificatesProcessor {
    static final DotName IDENTIFIER_DOT_NAME = DotName.createSimple(Identifier.class);
    static final DotName KEYSTORE_PROVIDER_DOT_NAME = DotName.createSimple(KeyStoreProvider.class);
    static final DotName TRUSTSTORE_PROVIDER_DOT_NAME = DotName.createSimple(TrustStoreProvider.class);

    @BuildStep
    public UnremovableBeanBuildItem unremovableBeans() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{KeyStoreProvider.class, TrustStoreProvider.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public TlsRegistryBuildItem initializeCertificate(TlsConfig config, Optional<VertxBuildItem> vertx, BeanDiscoveryFinishedBuildItem beadDiscovery, CertificateRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, List<TlsCertificateBuildItem> otherCertificates, ShutdownContextBuildItem shutdown) {
        if (vertx.isPresent()) {
            Set<String> providerBucketNames = CertificatesProcessor.getProviderBucketNames(beadDiscovery);
            recorder.validateCertificates((Set)providerBucketNames, config, vertx.get().getVertx(), (ShutdownContext)shutdown);
        }
        for (TlsCertificateBuildItem certificate : otherCertificates) {
            recorder.register(certificate.name, certificate.supplier);
        }
        Supplier supplier = recorder.getSupplier();
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TlsConfigurationRegistry.class).supplier(supplier).scope(Singleton.class)).unremovable()).setRuntimeInit();
        syntheticBeans.produce((BuildItem)configurator.done());
        return new TlsRegistryBuildItem(supplier);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={LetsEncryptEnabled.class})
    void createManagementRoutes(BuildProducer<RouteBuildItem> routes, LetsEncryptRecorder recorder, TlsRegistryBuildItem registryBuildItem) {
        if (!QuarkusClassLoader.isClassPresentAtRuntime((String)"io.vertx.ext.web.Router")) {
            throw new ConfigurationException("Cannot use Let's Encrypt without the quarkus-vertx-http extension");
        }
        recorder.initialize(registryBuildItem.registry());
        routes.produce((BuildItem)RouteBuildItem.newAbsoluteRoute((String)"/.well-known/acme-challenge/:token").withRequestHandler(recorder.challengeHandler()).build());
        routes.produce((BuildItem)RouteBuildItem.newManagementRoute((String)"lets-encrypt/challenge").withRequestHandler(recorder.chalengeAdminHandler()).withRouteCustomizer(recorder.setupCustomizer()).build());
        routes.produce((BuildItem)RouteBuildItem.newManagementRoute((String)"lets-encrypt/certs").withRequestHandler(recorder.reload()).build());
    }

    static Set<String> getProviderBucketNames(BeanDiscoveryFinishedBuildItem beanDiscovery) {
        HashSet<String> bucketNames = new HashSet<String>();
        for (BeanInfo beanInfo : beanDiscovery.getBeans()) {
            Optional identifier;
            if (!beanInfo.hasType(KEYSTORE_PROVIDER_DOT_NAME) && !beanInfo.hasType(TRUSTSTORE_PROVIDER_DOT_NAME) || !(identifier = beanInfo.getQualifier(IDENTIFIER_DOT_NAME)).isPresent()) continue;
            bucketNames.add(((AnnotationInstance)identifier.get()).value().asString());
        }
        return bucketNames;
    }
}

