/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.pipeline;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.plugins.pipeline.AbstractPipelineBus;
import org.logstash.plugins.pipeline.AddressState;
import org.logstash.plugins.pipeline.PipelineBus;
import org.logstash.plugins.pipeline.PipelineInput;
import org.logstash.plugins.pipeline.PipelineOutput;

class PipelineBusV2
extends AbstractPipelineBus
implements PipelineBus {
    protected final AddressStateMapping addressStates = new AddressStateMapping();
    protected final Map<PipelineOutput, Set<AddressState.ReadOnly>> addressStatesBySender = new ConcurrentHashMap<PipelineOutput, Set<AddressState.ReadOnly>>();
    protected volatile boolean blockOnUnlisten = false;
    private static final Logger LOGGER = LogManager.getLogger(PipelineBusV2.class);

    PipelineBusV2() {
    }

    @Override
    public void sendEvents(PipelineOutput sender, Collection<JrubyEventExtLibrary.RubyEvent> events, boolean ensureDelivery) {
        if (events.isEmpty()) {
            return;
        }
        Set<AddressState.ReadOnly> addressStates = this.addressStatesBySender.get(sender);
        if (addressStates == null) {
            throw new IllegalStateException("cannot send events from unregistered sender");
        }
        JrubyEventExtLibrary.RubyEvent[] orderedEvents = events.toArray(new JrubyEventExtLibrary.RubyEvent[0]);
        addressStates.forEach(addressState -> PipelineBusV2.doSendEvents(orderedEvents, addressState, ensureDelivery));
    }

    @Override
    public void registerSender(PipelineOutput sender, Iterable<String> addresses) {
        Objects.requireNonNull(sender, "sender must not be null");
        Objects.requireNonNull(addresses, "addresses must not be null");
        this.addressStatesBySender.compute(sender, (po, existing) -> StreamSupport.stream(addresses.spliterator(), false).map(addr -> this.addressStates.mutate((String)addr, as -> as.addOutput((PipelineOutput)po))).collect(Collectors.toUnmodifiableSet()));
    }

    @Override
    public void unregisterSender(PipelineOutput sender, Iterable<String> addresses) {
        Objects.requireNonNull(sender, "sender must not be null");
        Objects.requireNonNull(addresses, "addresses must not be null");
        this.addressStatesBySender.compute(sender, (po, existing) -> {
            addresses.forEach(addr -> this.addressStates.mutate((String)addr, as -> as.removeOutput((PipelineOutput)po)));
            return null;
        });
    }

    @Override
    public boolean listen(PipelineInput listener, String address) {
        Objects.requireNonNull(listener, "listener must not be null");
        Objects.requireNonNull(address, "address must not be null");
        AddressState.ReadOnly result = this.addressStates.mutate(address, addressState -> addressState.assignInputIfMissing(listener));
        return result != null && result.getInput() == listener;
    }

    @Override
    public void unlisten(PipelineInput listener, String address) throws InterruptedException {
        Objects.requireNonNull(listener, "listener must not be null");
        Objects.requireNonNull(address, "address must not be null");
        if (this.blockOnUnlisten) {
            this.unlistenBlocking(listener, address);
        } else {
            this.unlistenNonblock(listener, address);
        }
    }

    private void unlistenNonblock(PipelineInput listener, String address) {
        this.addressStates.mutate(address, addressState -> addressState.unassignInput(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlistenBlocking(PipelineInput listener, String address) throws InterruptedException {
        PipelineInput pipelineInput = Objects.requireNonNull(listener, "listener must not be null");
        synchronized (pipelineInput) {
            while (!this.tryUnlistenOrphan(listener, address)) {
                listener.wait(10000L);
            }
        }
    }

    private boolean tryUnlistenOrphan(PipelineInput listener, String address) {
        AddressState.ReadOnly result = this.addressStates.mutate(address, addressState -> {
            Set<PipelineOutput> outputs = addressState.getOutputs();
            if (outputs.isEmpty()) {
                addressState.unassignInput(listener);
            } else {
                LOGGER.trace(() -> String.format("input `%s` is not ready to unlisten from `%s` because the address still has attached senders (%s)", listener.getId(), address, outputs.stream().map(PipelineOutput::getId).collect(Collectors.toSet())));
            }
        });
        return result == null || result.getInput() != listener;
    }

    @Override
    public void setBlockOnUnlisten(boolean blockOnUnlisten) {
        this.blockOnUnlisten = blockOnUnlisten;
    }

    protected static class AddressStateMapping {
        private final Map<String, AddressState> mapping = new ConcurrentHashMap<String, AddressState>();

        protected AddressStateMapping() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AddressState.ReadOnly mutate(String address, Consumer<AddressState> consumer) {
            AddressState result = this.mapping.compute(address, (a, addressState) -> {
                if (addressState == null) {
                    addressState = new AddressState(address);
                }
                consumer.accept((AddressState)addressState);
                return addressState.isEmpty() ? null : addressState;
            });
            if (result == null) {
                return null;
            }
            PipelineInput currentInput = result.getInput();
            if (currentInput != null) {
                PipelineInput pipelineInput = currentInput;
                synchronized (pipelineInput) {
                    currentInput.notifyAll();
                }
            }
            return result.getReadOnlyView();
        }

        private AddressState.ReadOnly get(String address) {
            AddressState result = this.mapping.get(address);
            return result == null ? null : result.getReadOnlyView();
        }
    }

    @VisibleForTesting
    static class Testable
    extends PipelineBusV2
    implements PipelineBus.Testable {
        Testable() {
        }

        @Override
        @VisibleForTesting
        public boolean isBlockOnUnlisten() {
            return this.blockOnUnlisten;
        }

        @Override
        @VisibleForTesting
        public Optional<AddressState.ReadOnly> getAddressState(String address) {
            return Optional.ofNullable(this.addressStates.get(address));
        }

        @Override
        @VisibleForTesting
        public Optional<Set<AddressState.ReadOnly>> getAddressStates(PipelineOutput sender) {
            return Optional.ofNullable((Set)this.addressStatesBySender.get(sender));
        }
    }
}

