/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.ProductLevel;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Version;
import org.apache.derby.shared.common.info.JVMInfo;

public abstract class ClientDatabaseMetaData
implements DatabaseMetaData {
    private static final short SQL_BEST_ROWID = 1;
    private static final short SQL_ROWVER = 2;
    private static final short SQL_INDEX_UNIQUE = 0;
    private static final short SQL_INDEX_ALL = 1;
    private Agent agent_;
    protected ClientConnection connection_;
    private static final int numberOfMetaDataInfoMethods__ = 108;
    private Object[] metaDataInfoCache_ = new Object[108];
    private boolean metaDataInfoIsCached_ = false;
    ProductLevel productLevel_;
    private final int serverJdbcMajorVersion;
    private final int serverJdbcMinorVersion;
    private boolean supportsQryclsimp_;
    private boolean supportsLayerBStreaming_;
    private boolean supportsSessionDataCaching_;
    private boolean supportsUDTs_;
    private boolean supportsEXTDTAAbort_;
    private boolean supportsTimestampNanoseconds_;
    private boolean supportsBooleanValues_;
    private boolean supportsLongRDBNAM_;
    private boolean supportsBooleanParameterTransport_;
    private static final int allProceduresAreCallable__ = 0;
    private static final int allTablesAreSelectable__ = 1;
    private static final int nullsAreSortedHigh__ = 2;
    private static final int nullsAreSortedLow__ = 3;
    private static final int nullsAreSortedAtStart__ = 4;
    private static final int nullsAreSortedAtEnd__ = 5;
    private static final int usesLocalFiles__ = 6;
    private static final int usesLocalFilePerTable__ = 7;
    private static final int storesUpperCaseIdentifiers__ = 8;
    private static final int storesLowerCaseIdentifiers__ = 9;
    private static final int storesMixedCaseIdentifiers__ = 10;
    private static final int storesUpperCaseQuotedIdentifiers__ = 11;
    private static final int storesLowerCaseQuotedIdentifiers__ = 12;
    private static final int storesMixedCaseQuotedIdentifiers__ = 13;
    private static final int getSQLKeywords__ = 14;
    private static final int getNumericFunctions__ = 15;
    private static final int getStringFunctions__ = 16;
    private static final int getSystemFunctions__ = 17;
    private static final int getTimeDateFunctions__ = 18;
    private static final int getSearchStringEscape__ = 19;
    private static final int getExtraNameCharacters__ = 20;
    private static final int supportsAlterTableWithAddColumn__ = 21;
    private static final int supportsAlterTableWithDropColumn__ = 22;
    private static final int supportsConvert__ = 23;
    private static final int supportsConvertType__ = 24;
    private static final int supportsDifferentTableCorrelationNames__ = 25;
    private static final int supportsExpressionsInOrderBy__ = 26;
    private static final int supportsOrderByUnrelated__ = 27;
    private static final int supportsGroupBy__ = 28;
    private static final int supportsGroupByUnrelated__ = 29;
    private static final int supportsGroupByBeyondSelect__ = 30;
    private static final int supportsMultipleResultSets__ = 31;
    private static final int supportsMultipleTransactions__ = 32;
    private static final int supportsCoreSQLGrammar__ = 33;
    private static final int supportsExtendedSQLGrammar__ = 34;
    private static final int supportsANSI92IntermediateSQL__ = 35;
    private static final int supportsANSI92FullSQL__ = 36;
    private static final int supportsIntegrityEnhancementFacility__ = 37;
    private static final int supportsOuterJoins__ = 38;
    private static final int supportsFullOuterJoins__ = 39;
    private static final int supportsLimitedOuterJoins__ = 40;
    private static final int getSchemaTerm__ = 41;
    private static final int getProcedureTerm__ = 42;
    private static final int getCatalogTerm__ = 43;
    private static final int isCatalogAtStart__ = 44;
    private static final int getCatalogSeparator__ = 45;
    private static final int supportsSchemasInDataManipulation__ = 46;
    private static final int supportsSchemasInProcedureCalls__ = 47;
    private static final int supportsSchemasInTableDefinitions__ = 48;
    private static final int supportsSchemasInIndexDefinitions__ = 49;
    private static final int supportsSchemasInPrivilegeDefinitions__ = 50;
    private static final int supportsCatalogsInDataManipulation__ = 51;
    private static final int supportsCatalogsInProcedureCalls__ = 52;
    private static final int supportsCatalogsInTableDefinitions__ = 53;
    private static final int supportsCatalogsInIndexDefinitions__ = 54;
    private static final int supportsCatalogsInPrivilegeDefinitions__ = 55;
    private static final int supportsPositionedDelete__ = 56;
    private static final int supportsPositionedUpdate__ = 57;
    private static final int supportsSelectForUpdate__ = 58;
    private static final int supportsStoredProcedures__ = 59;
    private static final int supportsSubqueriesInComparisons__ = 60;
    private static final int supportsUnion__ = 61;
    private static final int supportsUnionAll__ = 62;
    private static final int supportsOpenCursorsAcrossCommit__ = 63;
    private static final int supportsOpenCursorsAcrossRollback__ = 64;
    private static final int supportsOpenStatementsAcrossCommit__ = 65;
    private static final int supportsOpenStatementsAcrossRollback__ = 66;
    private static final int getMaxBinaryLiteralLength__ = 67;
    private static final int getMaxCharLiteralLength__ = 68;
    private static final int getMaxColumnNameLength__ = 69;
    private static final int getMaxColumnsInGroupBy__ = 70;
    private static final int getMaxColumnsInIndex__ = 71;
    private static final int getMaxColumnsInOrderBy__ = 72;
    private static final int getMaxColumnsInSelect__ = 73;
    private static final int getMaxColumnsInTable__ = 74;
    private static final int getMaxConnections__ = 75;
    private static final int getMaxCursorNameLength__ = 76;
    private static final int getMaxIndexLength__ = 77;
    private static final int getMaxSchemaNameLength__ = 78;
    private static final int getMaxProcedureNameLength__ = 79;
    private static final int getMaxCatalogNameLength__ = 80;
    private static final int getMaxRowSize__ = 81;
    private static final int doesMaxRowSizeIncludeBlobs__ = 82;
    private static final int getMaxStatementLength__ = 83;
    private static final int getMaxStatements__ = 84;
    private static final int getMaxTableNameLength__ = 85;
    private static final int getMaxTablesInSelect__ = 86;
    private static final int getMaxUserNameLength__ = 87;
    private static final int getDefaultTransactionIsolation__ = 88;
    private static final int supportsTransactions__ = 89;
    private static final int supportsTransactionIsolationLevel__ = 90;
    private static final int supportsDataDefinitionAndDataManipulationTransactions__ = 91;
    private static final int supportsDataManipulationTransactionsOnly__ = 92;
    private static final int dataDefinitionCausesTransactionCommit__ = 93;
    private static final int dataDefinitionIgnoredInTransactions__ = 94;
    private static final int supportsResultSetType__ = 95;
    private static final int supportsResultSetConcurrency__ = 96;
    private static final int ownUpdatesAreVisible__ = 97;
    private static final int ownDeletesAreVisible__ = 98;
    private static final int ownInsertsAreVisible__ = 99;
    private static final int othersUpdatesAreVisible__ = 100;
    private static final int othersDeletesAreVisible__ = 101;
    private static final int othersInsertsAreVisible__ = 102;
    private static final int updatesAreDetected__ = 103;
    private static final int deletesAreDetected__ = 104;
    private static final int insertsAreDetected__ = 105;
    private static final int supportsBatchUpdates__ = 106;

    protected ClientDatabaseMetaData(Agent agent, ClientConnection connection, ProductLevel productLevel) {
        this.agent_ = agent;
        this.connection_ = connection;
        this.productLevel_ = productLevel;
        this.computeFeatureSet_();
        if (connection.isXAConnection()) {
            connection.xaHostVersion_ = this.productLevel_.versionLevel_;
        }
        if (this.productLevel_.lessThan(10, 2, 0)) {
            this.serverJdbcMajorVersion = 3;
            this.serverJdbcMinorVersion = 0;
        } else {
            this.serverJdbcMajorVersion = 4;
            this.serverJdbcMinorVersion = 0;
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(0);
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(1);
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(2);
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(3);
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(4);
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(5);
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(6);
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(7);
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(8);
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(9);
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(10);
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(11);
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(12);
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(13);
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(14);
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(15);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(16);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(17);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(18);
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(19);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(20);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(21);
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(22);
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(23);
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean_supportsConvert(24, fromType, toType);
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(25);
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(26);
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(27);
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(28);
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(29);
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(30);
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(31);
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(32);
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(33);
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(34);
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(35);
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(36);
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(37);
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(38);
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(39);
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(40);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(41);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(42);
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(43);
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(44);
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(45);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(46);
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(47);
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(48);
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(49);
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(50);
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(51);
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(52);
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(53);
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(54);
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(55);
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(56);
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(57);
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(58);
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(59);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(60);
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(61);
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(62);
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(63);
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(64);
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(65);
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(66);
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(67);
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(68);
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(69);
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(70);
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(71);
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(72);
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(73);
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(74);
    }

    @Override
    public int getMaxConnections() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(75);
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(76);
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(77);
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(78);
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(79);
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(80);
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(81);
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(82);
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(83);
    }

    @Override
    public int getMaxStatements() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(84);
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(85);
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(86);
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(87);
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(88);
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(89);
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(90, level);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(91);
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(92);
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(93);
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(94);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(95, type);
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt_SupportsResultSetConcurrency(96, type, concurrency);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(97, type);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(98, type);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(99, type);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(100, type);
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(101, type);
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(102, type);
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(103, type);
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(104, type);
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(105, type);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(106);
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.greaterThanOrEqualTo(5, 2, 0);
    }

    public abstract String getURL_() throws SqlException;

    @Override
    public String getURL() throws SQLException {
        try {
            this.checkForClosedConnection();
            return this.getURL_();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public String getUserName() throws SQLException {
        this.checkForClosedConnection();
        return this.connection_.user_;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.databaseProductName_;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.databaseProductVersion_;
    }

    @Override
    public String getDriverName() throws SQLException {
        this.checkForClosedConnection();
        return "Apache Derby Network Client JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        this.checkForClosedConnection();
        return Version.getDriverVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return Version.getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return Version.getMinorVersion();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        this.checkForClosedConnection();
        return "\"";
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getProcedures", catalog, schemaPattern, procedureNamePattern);
                }
                return this.getProceduresX(catalog, schemaPattern, procedureNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getProceduresX(String catalog, String schemaPattern, String procedureNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLPROCEDURES(?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, procedureNamePattern);
        cs.setStringX(4, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getProcedureColumns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
                }
                return this.getProcedureColumnsX(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getProcedureColumnsX(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLPROCEDURECOLS(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, procedureNamePattern);
        cs.setStringX(4, columnNamePattern);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getFunctions", catalog, schemaPattern, functionNamePattern);
                }
                return this.getFunctionsX(catalog, schemaPattern, functionNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getFunctionsX(String catalog, String schemaPattern, String functionNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        this.checkServerJdbcVersionX("getFunctions(String,String,String)", 4, 0);
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFUNCTIONS(?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, functionNamePattern);
        cs.setStringX(4, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String parameterNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getFunctionColumns", catalog, schemaPattern, functionNamePattern, parameterNamePattern);
                }
                return this.getFunctionColumnsX(catalog, schemaPattern, functionNamePattern, parameterNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getFunctionColumnsX(String catalog, String schemaPattern, String functionNamePattern, String parameterNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        this.checkServerJdbcVersionX("getFunctionColumns(String,String,String,String)", 4, 0);
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFUNCTIONPARAMS(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, functionNamePattern);
        cs.setStringX(4, parameterNamePattern);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTables", catalog, schemaPattern, tableNamePattern, types);
                }
                return this.getTablesX(catalog, schemaPattern, tableNamePattern, types);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getTablesX(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SqlException {
        try {
            this.checkForClosedConnection();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLES(?,?,?,?,?)");
        if (catalog == null) {
            cs.setNullX(1, 12);
        } else {
            cs.setStringX(1, catalog);
        }
        if (schemaPattern == null) {
            cs.setNullX(2, 12);
        } else {
            cs.setStringX(2, schemaPattern);
        }
        if (tableNamePattern == null) {
            cs.setNullX(3, 12);
        } else {
            cs.setStringX(3, tableNamePattern);
        }
        String tableTypes = "";
        if (types == null) {
            cs.setNullX(4, 12);
        } else if (types.length == 1 && types[0].trim().equals("%")) {
            cs.setStringX(4, types[0]);
        } else {
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    tableTypes = tableTypes.concat(",");
                }
                tableTypes = tableTypes.concat("'" + types[i] + "'");
            }
            cs.setStringX(4, tableTypes);
        }
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getSchemas", new Object[0]);
                }
                return this.getSchemasX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getSchemasX() throws SqlException {
        try {
            this.checkForClosedConnection();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLES('', '', '', '', 'GETSCHEMAS=1')");
        return cs.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCatalogs", new Object[0]);
                }
                return this.getCatalogsX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getCatalogsX() throws SqlException {
        this.checkForClosedConnectionX();
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLES('', '', '', '', 'GETCATALOGS=1')");
        return cs.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTableTypes", new Object[0]);
                }
                return this.getTableTypesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getTableTypesX() throws SqlException {
        this.checkForClosedConnectionX();
        ClientPreparedStatement cs = null;
        cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLES(?,?,?,?,?)");
        cs.setStringX(1, "");
        cs.setStringX(2, "");
        cs.setStringX(3, "");
        cs.setStringX(4, "%");
        int cursorHold = this.connection_.holdability() == 1 ? 1 : 0;
        cs.setStringX(5, "DATATYPE='JDBC';GETTABLETYPES=1; CURSORHOLD=" + cursorHold);
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
                }
                this.checkForClosedConnection();
                return this.getColumnsX(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getColumnsX(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLCOLUMNS(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, tableNamePattern);
        cs.setStringX(4, columnNamePattern);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getColumnPrivileges", catalog, schema, table, columnNamePattern);
                }
                return this.getColumnPrivilegesX(catalog, schema, table, columnNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getColumnPrivilegesX(String catalog, String schema, String table, String columnNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"), new Object[0]);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLCOLPRIVILEGES(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schema);
        cs.setStringX(3, table);
        cs.setStringX(4, columnNamePattern);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTablePrivileges", catalog, schemaPattern, tableNamePattern);
                }
                return this.getTablePrivilegesX(catalog, schemaPattern, tableNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getTablePrivilegesX(String catalog, String schemaPattern, String tableNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLEPRIVILEGES(?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, tableNamePattern);
        cs.setStringX(4, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBestRowIdentifier", catalog, schema, table, scope, nullable);
                }
                return this.getBestRowIdentifierX(catalog, schema, table, scope, nullable);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getBestRowIdentifierX(String catalog, String schema, String table, int scope, boolean nullable) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"), new Object[0]);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLSPECIALCOLUMNS(?,?,?,?,?,?,?)");
        cs.setIntX(1, 1);
        cs.setStringX(2, catalog);
        cs.setStringX(3, schema);
        cs.setStringX(4, table);
        cs.setIntX(5, scope);
        if (nullable) {
            cs.setShortX(6, (short)1);
        } else {
            cs.setShortX(6, (short)0);
        }
        cs.setStringX(7, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getVersionColumns", catalog, schema, table);
                }
                return this.getVersionColumnsX(catalog, schema, table);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getVersionColumnsX(String catalog, String schema, String table) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"), new Object[0]);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLSPECIALCOLUMNS(?,?,?,?,?,?,?)");
        cs.setIntX(1, 2);
        cs.setStringX(2, catalog);
        cs.setStringX(3, schema);
        cs.setStringX(4, table);
        cs.setIntX(5, 0);
        cs.setShortX(6, (short)0);
        cs.setStringX(7, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getPrimaryKeys", catalog, schema, table);
                }
                return this.getPrimaryKeysX(catalog, schema, table);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getPrimaryKeysX(String catalog, String schema, String table) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"), new Object[0]);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLPRIMARYKEYS(?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schema);
        cs.setStringX(3, table);
        cs.setStringX(4, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getImportedKeys", catalog, schema, table);
                }
                return this.getImportedKeysX(catalog, schema, table);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getImportedKeysX(String catalog, String schema, String table) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"), new Object[0]);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        cs.setStringX(1, "");
        cs.setStringX(2, null);
        cs.setStringX(3, "");
        cs.setStringX(4, catalog);
        cs.setStringX(5, schema);
        cs.setStringX(6, table);
        if (this.connection_.holdability() == 1) {
            cs.setStringX(7, "DATATYPE='JDBC';IMPORTEDKEY=1; CURSORHOLD=1");
        } else {
            cs.setStringX(7, "DATATYPE='JDBC';IMPORTEDKEY=1; CURSORHOLD=0");
        }
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getExportedKeys", catalog, schema, table);
                }
                return this.getExportedKeysX(catalog, schema, table);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getExportedKeysX(String catalog, String schema, String table) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"), new Object[0]);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schema);
        cs.setStringX(3, table);
        cs.setStringX(4, "");
        cs.setStringX(5, null);
        cs.setStringX(6, "");
        if (this.connection_.holdability() == 1) {
            cs.setStringX(7, "DATATYPE='JDBC';EXPORTEDKEY=1; CURSORHOLD=1");
        } else {
            cs.setStringX(7, "DATATYPE='JDBC';EXPORTEDKEY=1; CURSORHOLD=0");
        }
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCrossReference", primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
                }
                return this.getCrossReferenceX(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getCrossReferenceX(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SqlException {
        this.checkForClosedConnectionX();
        if (primaryTable == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ110.S"), new Object[0]);
        }
        if (foreignTable == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ111.S"), new Object[0]);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        cs.setStringX(1, primaryCatalog);
        cs.setStringX(2, primarySchema);
        cs.setStringX(3, primaryTable);
        cs.setStringX(4, foreignCatalog);
        cs.setStringX(5, foreignSchema);
        cs.setStringX(6, foreignTable);
        cs.setStringX(7, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTypeInfo", new Object[0]);
                }
                return this.getTypeInfoX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getTypeInfoX() throws SqlException {
        this.checkForClosedConnectionX();
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLGETTYPEINFO(?,?)");
        cs.setShortX(1, (short)0);
        cs.setStringX(2, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getIndexInfo", catalog, schema, table, unique, approximate);
                }
                return this.getIndexInfoX(catalog, schema, table, unique, approximate);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getIndexInfoX(String catalog, String schema, String table, boolean unique, boolean approximate) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"), new Object[0]);
        }
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLSTATISTICS(?,?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schema);
        cs.setStringX(3, table);
        if (unique) {
            cs.setShortX(4, (short)0);
        } else {
            cs.setShortX(4, (short)1);
        }
        if (approximate) {
            cs.setShortX(5, (short)1);
        } else {
            cs.setShortX(5, (short)0);
        }
        cs.setStringX(6, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getUDTs", catalog, schemaPattern, typeNamePattern, types);
                }
                return this.getUDTsX(catalog, schemaPattern, typeNamePattern, types);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getUDTsX(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SqlException {
        this.checkForClosedConnectionX();
        ClientPreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLUDTS(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, typeNamePattern);
        String udtTypes = "";
        for (int i = 0; types != null && i < types.length; ++i) {
            if (i > 0) {
                udtTypes = udtTypes.concat(",");
            }
            udtTypes = udtTypes.concat(String.valueOf(types[i]));
        }
        cs.setStringX(4, udtTypes);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    private String getOptions() {
        int cursorHold = this.connection_.holdability() == 1 ? 1 : 0;
        return "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=" + cursorHold;
    }

    private ClientResultSet executeCatalogQuery(ClientPreparedStatement cs) throws SqlException {
        try {
            return cs.executeQueryX();
        }
        catch (SqlException e) {
            if (e.getErrorCode() == -440) {
                SqlException newException = new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ209.S"), new Object[0]);
                newException.setNextException(e);
                throw newException;
            }
            if (e.getErrorCode() == -444) {
                SqlException newException = new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ210.S"), new Object[0]);
                newException.setNextException(e);
                throw newException;
            }
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkForClosedConnection();
        return this.connection_;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getSuperTypes", catalog, schemaPattern, typeNamePattern);
                }
                return this.getSuperTypesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getSuperTypesX() throws SqlException {
        this.checkForClosedConnectionX();
        String sql = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT,CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM,VARCHAR('', 128) AS TYPE_NAME,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_CAT,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_SCHEM,VARCHAR('', 128) AS SUPERTYPE_NAME FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR ";
        ClientPreparedStatement ps = this.connection_.prepareDynamicCatalogQuery(sql);
        return ps.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getSuperTables", catalog, schemaPattern, tableNamePattern);
                }
                return this.getSuperTablesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getSuperTablesX() throws SqlException {
        this.checkForClosedConnectionX();
        String sql = "SELECT CAST(NULL AS VARCHAR(128)) AS TABLE_CAT,CAST(NULL AS VARCHAR(128)) AS TABLE_SCHEM,VARCHAR('', 128) AS TABLE_NAME,VARCHAR('', 128) AS SUPERTABLE_NAME FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR";
        ClientPreparedStatement ps = this.connection_.prepareDynamicCatalogQuery(sql);
        return ps.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getAttributes", catalog, schemaPattern, typeNamePattern, attributeNamePattern);
                }
                return this.getAttributesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getAttributesX() throws SqlException {
        this.checkForClosedConnectionX();
        String sql = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT,CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM,VARCHAR('', 128) AS TYPE_NAME,VARCHAR('',128) AS ATTR_NAME,0 AS DATA_TYPE,VARCHAR('',129) AS ATTR_TYPE_NAME,0 AS ATTR_SIZE,0 AS DECIMAL_DIGITS,0 AS NUM_PREC_RADIX,2 AS NULLABLE,CAST(NULL AS VARCHAR(254)) AS REMARKS,CAST(NULL AS VARCHAR(128)) AS ATTR_DEF,0 AS SQL_DATA_TYPE,0 AS SQL_DATETIME_SUB,0 AS CHAR_OCTET_LENGTH,0 AS ORDINAL_POSITION,VARCHAR('',128) AS IS_NULLABLE,CAST(NULL AS VARCHAR(128)) AS SCOPE_CATALOG,CAST(NULL AS VARCHAR(128)) AS SCOPE_SCHEMA,CAST(NULL AS VARCHAR(128)) AS SCOPE_TABLE,CAST(NULL AS SMALLINT) AS SOURCE_DATA_TYPE FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR";
        ClientPreparedStatement ps = this.connection_.prepareDynamicCatalogQuery(sql);
        return ps.executeQueryX();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkForClosedConnection();
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.versionLevel_;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.releaseLevel_;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        this.checkForClosedConnection();
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        this.checkForClosedConnection();
        return JVMInfo.jdbcMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        this.checkForClosedConnection();
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    private void computeFeatureSet_() {
        this.supportsQryclsimp_ = this.productLevel_.greaterThanOrEqualTo(10, 2, 0);
        this.supportsLayerBStreaming_ = this.productLevel_.greaterThanOrEqualTo(10, 3, 0);
        this.supportsSessionDataCaching_ = this.productLevel_.greaterThanOrEqualTo(10, 4, 0);
        this.supportsUDTs_ = this.productLevel_.greaterThanOrEqualTo(10, 6, 0);
        this.supportsTimestampNanoseconds_ = this.productLevel_.greaterThanOrEqualTo(10, 6, 0);
        this.supportsEXTDTAAbort_ = this.productLevel_.greaterThanOrEqualTo(10, 6, 0);
        this.supportsBooleanValues_ = this.productLevel_.greaterThanOrEqualTo(10, 7, 0);
        this.supportsBooleanParameterTransport_ = this.productLevel_.greaterThanOrEqualTo(10, 8, 0);
        this.supportsLongRDBNAM_ = this.productLevel_.greaterThanOrEqualTo(10, 11, 0);
    }

    public final boolean serverSupportsQryclsimp() {
        return this.supportsQryclsimp_;
    }

    public final boolean serverSupportsLayerBStreaming() {
        return this.supportsLayerBStreaming_;
    }

    public final boolean serverSupportsSessionDataCaching() {
        return this.supportsSessionDataCaching_;
    }

    public final boolean serverSupportsUDTs() {
        return this.supportsUDTs_;
    }

    public final boolean serverSupportsTimestampNanoseconds() {
        return this.supportsTimestampNanoseconds_;
    }

    public final boolean serverSupportsEXTDTAAbort() {
        return this.supportsEXTDTAAbort_;
    }

    private boolean serverSupportsBooleanValues() {
        return this.supportsBooleanValues_;
    }

    public final boolean serverSupportsBooleanParameterTransport() {
        return this.supportsBooleanParameterTransport_;
    }

    public final boolean serverSupportLongRDBNAM() {
        return this.supportsLongRDBNAM_;
    }

    private boolean getMetaDataInfoBoolean(int infoCallIndex) throws SQLException {
        try {
            if (!this.metaDataInfoIsCached_) {
                this.metaDataInfoCall();
            }
            if (this.serverSupportsBooleanValues()) {
                return (Boolean)this.metaDataInfoCache_[infoCallIndex];
            }
            return (Integer)this.metaDataInfoCache_[infoCallIndex] != 0;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private int getMetaDataInfoInt(int infoCallIndex) throws SQLException {
        try {
            if (this.metaDataInfoIsCached_) {
                return (Integer)this.metaDataInfoCache_[infoCallIndex];
            }
            this.metaDataInfoCall();
            return (Integer)this.metaDataInfoCache_[infoCallIndex];
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private String getMetaDataInfoString(int infoCallIndex) throws SQLException {
        try {
            if (this.metaDataInfoIsCached_) {
                return (String)this.metaDataInfoCache_[infoCallIndex];
            }
            this.metaDataInfoCall();
            return (String)this.metaDataInfoCache_[infoCallIndex];
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean getMetaDataInfoBooleanWithType(int infoCallIndex, int type) throws SQLException {
        boolean clientValue = this.getMetaDataInfoBooleanWithTypeClient(infoCallIndex, type);
        return clientValue;
    }

    private boolean getMetaDataInfoBooleanWithTypeClient(int infoCallIndex, int type) throws SQLException {
        switch (infoCallIndex) {
            case 97: 
            case 98: 
            case 103: 
            case 104: {
                if (this.productLevel_.greaterThanOrEqualTo(10, 2, 0) && type == 1004) {
                    return true;
                }
                return this.getMetaDataInfoBooleanWithTypeServer(infoCallIndex, type);
            }
            case 99: 
            case 105: {
                if (this.productLevel_.greaterThanOrEqualTo(10, 2, 0) && type == 1004) {
                    return false;
                }
                return this.getMetaDataInfoBooleanWithTypeServer(infoCallIndex, type);
            }
        }
        return this.getMetaDataInfoBooleanWithTypeServer(infoCallIndex, type);
    }

    private boolean getMetaDataInfoBooleanWithTypeServer(int infoCallIndex, int type) throws SQLException {
        try {
            String returnedFromSP = null;
            if (this.metaDataInfoIsCached_) {
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            } else {
                this.metaDataInfoCall();
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            }
            StringTokenizer st = new StringTokenizer(returnedFromSP, ",");
            while (st.hasMoreTokens()) {
                if (Integer.parseInt(st.nextToken()) != type) continue;
                return true;
            }
            return false;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean getMetaDataInfoInt_SupportsResultSetConcurrency(int infoCallIndex, int type, int concurrency) throws SQLException {
        try {
            String returnedFromSP = null;
            if (this.metaDataInfoIsCached_) {
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            } else {
                this.metaDataInfoCall();
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            }
            StringTokenizer st = new StringTokenizer(returnedFromSP, ";");
            while (st.hasMoreTokens()) {
                StringTokenizer stForConc = new StringTokenizer(st.nextToken(), ",");
                if (Integer.parseInt(stForConc.nextToken()) != type) continue;
                while (stForConc.hasMoreTokens()) {
                    if (Integer.parseInt(stForConc.nextToken()) != concurrency) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean getMetaDataInfoBoolean_supportsConvert(int infoCallIndex, int fromType, int toType) throws SQLException {
        try {
            String returnedFromSP = null;
            if (this.metaDataInfoIsCached_) {
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            } else {
                this.metaDataInfoCall();
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            }
            StringTokenizer st = new StringTokenizer(returnedFromSP, ";");
            while (st.hasMoreTokens()) {
                StringTokenizer stForType = new StringTokenizer(st.nextToken(), ",");
                if (Integer.parseInt(stForType.nextToken()) != fromType) continue;
                while (st.hasMoreTokens()) {
                    if (Integer.parseInt(st.nextToken()) != toType) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void metaDataInfoCall() throws SqlException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            int ColumnCount;
            ClientPreparedStatement ps = this.prepareMetaDataQuery("SYSIBM.MetaData()");
            ClientResultSet rs = ps.executeQueryX();
            rs.nextX();
            try {
                ColumnCount = rs.getMetaDataX().getColumnCount();
            }
            catch (SQLException se) {
                throw new SqlException(se);
            }
            for (int infoCallIndex = 0; infoCallIndex < ColumnCount && infoCallIndex < this.metaDataInfoCache_.length; ++infoCallIndex) {
                this.metaDataInfoCache_[infoCallIndex] = rs.getObjectX(infoCallIndex + 1);
            }
            this.metaDataInfoIsCached_ = true;
            rs.closeX();
        }
    }

    @Override
    public final boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    @Override
    public final boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getSchemas", new Object[0]);
                }
                return this.getSchemasX(catalog, schemaPattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getSchemasX(String catalog, String schemaPattern) throws SqlException {
        this.checkForClosedConnectionX();
        this.checkServerJdbcVersionX("getSchemas(String, String)", 4, 0);
        String call = "SYSIBM.SQLTABLES(?, ?, '', '', 'GETSCHEMAS=2')";
        ClientPreparedStatement cs = this.prepareMetaDataQuery(call);
        if (catalog == null) {
            cs.setNullX(1, 12);
        } else {
            cs.setStringX(1, catalog);
        }
        if (schemaPattern == null) {
            cs.setNullX(2, 12);
        } else {
            cs.setStringX(2, schemaPattern);
        }
        return cs.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getClientInfoProperties", new Object[0]);
                }
                return this.getClientInfoPropertiesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getClientInfoPropertiesX() throws SqlException {
        this.checkForClosedConnectionX();
        String sql = "SELECT CAST(NULL AS VARCHAR(128)) AS NAME, CAST(NULL AS INT) AS MAX_LEN, CAST(NULL AS VARCHAR(128)) AS DEFAULT_VALUE, CAST(NULL AS VARCHAR(128)) AS DESCRIPTION FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR";
        ClientPreparedStatement ps = this.connection_.prepareDynamicCatalogQuery("SELECT CAST(NULL AS VARCHAR(128)) AS NAME, CAST(NULL AS INT) AS MAX_LEN, CAST(NULL AS VARCHAR(128)) AS DEFAULT_VALUE, CAST(NULL AS VARCHAR(128)) AS DESCRIPTION FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR");
        return ps.executeQueryX();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        this.checkForClosedConnection();
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        return interfaces.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        try {
            return interfaces.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), interfaces).getSQLException();
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getPseudoColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
                }
                return this.getPseudoColumnsX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet getPseudoColumnsX() throws SqlException {
        this.checkForClosedConnectionX();
        String sql = "SELECT \n        CAST(NULL AS VARCHAR(128)) AS TABLE_CAT, \n        CAST(NULL AS VARCHAR(128)) AS TABLE_SCHEM, \n        VARCHAR('', 128) AS TABLE_NAME, \n        VARCHAR('',128) AS COLUMN_NAME, \n        CAST(1 AS INT) AS DATA_TYPE, \n        CAST(1 AS INT) AS COLUMN_SIZE, \n        CAST(NULL AS INT) AS DECIMAL_DIGITS, \n        CAST(NULL AS INT) AS NUM_PREC_RADIX, \n        VARCHAR('',128) AS COLUMN_USAGE, \n        CAST(NULL AS VARCHAR(32672)) AS REMARKS, \n        CAST(NULL AS INT) AS CHAR_OCTET_LENGTH, \n        VARCHAR('NO',128) AS IS_NULLABLE \n    FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR";
        ClientPreparedStatement ps = this.connection_.prepareDynamicCatalogQuery(sql);
        return ps.executeQueryX();
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }

    private ClientPreparedStatement prepareMetaDataQuery(String cmd) throws SqlException {
        ClientPreparedStatement ps = this.connection_.prepareStatementX("CALL " + cmd, 1003, 1007, this.connection_.holdability(), 2, null, null);
        return ps;
    }

    protected void checkForClosedConnection() throws SQLException {
        try {
            this.checkForClosedConnectionX();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void checkForClosedConnectionX() throws SqlException {
        if (this.connection_.isClosedX()) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003"), new Object[0]);
        }
        this.agent_.checkForDeferredExceptions();
    }

    private void checkServerJdbcVersionX(String method, int major, int minor) throws SqlException {
        if (this.serverJdbcMajorVersion < major || this.serverJdbcMajorVersion == major && this.serverJdbcMinorVersion < minor) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.2"), method);
        }
    }
}

