/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.maxmind.db.Reader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

final class BufferHolder {
    private final ByteBuffer buffer;

    BufferHolder(File database, Reader.FileMode mode) throws IOException {
        try (RandomAccessFile file = new RandomAccessFile(database, "r");
             FileChannel channel = file.getChannel();){
            if (mode == Reader.FileMode.MEMORY) {
                ByteBuffer buf = ByteBuffer.wrap(new byte[(int)channel.size()]);
                if (channel.read(buf) != buf.capacity()) {
                    throw new IOException("Unable to read " + database.getName() + " into memory. Unexpected end of stream.");
                }
                this.buffer = buf.asReadOnlyBuffer();
            } else {
                this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size()).asReadOnlyBuffer();
            }
        }
    }

    BufferHolder(InputStream stream) throws IOException {
        int br;
        if (null == stream) {
            throw new NullPointerException("Unable to use a NULL InputStream");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[16384];
        while (-1 != (br = stream.read(bytes))) {
            baos.write(bytes, 0, br);
        }
        this.buffer = ByteBuffer.wrap(baos.toByteArray()).asReadOnlyBuffer();
    }

    ByteBuffer get() {
        return this.buffer.duplicate();
    }
}

