/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.project.api.ear.EarDDGenerator;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.j2ee.ui.wizard.BaseWizardIterator;
import org.netbeans.modules.maven.j2ee.ui.wizard.Bundle;
import org.netbeans.modules.maven.j2ee.ui.wizard.EAWizardPanel;
import org.netbeans.modules.maven.j2ee.ui.wizard.archetype.J2eeArchetypeFactory;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.openide.LifecycleManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EAWizardIterator
extends BaseWizardIterator {
    public Set<FileObject> instantiate() throws IOException {
        ProjectInfo earVersionInfo = (ProjectInfo)this.wiz.getProperty("ear_versionInfo");
        assert (earVersionInfo != null);
        ProjectInfo webVersionInfo = (ProjectInfo)this.wiz.getProperty("web_versionInfo");
        ProjectInfo ejbVersionInfo = (ProjectInfo)this.wiz.getProperty("ejb_versionInfo");
        ProjectInfo vi = new ProjectInfo((String)this.wiz.getProperty("groupId"), (String)this.wiz.getProperty("artifactId"), (String)this.wiz.getProperty("version"), (String)this.wiz.getProperty("package"));
        File rootFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        File earFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("ear_projdir")));
        ArchetypeWizards.createFromArchetype((File)rootFile, (ProjectInfo)vi, (Archetype)J2eeArchetypeFactory.getInstance().getAnyArchetypeFor(J2eeModule.Type.RAR), null, (boolean)true);
        ArchetypeWizards.createFromArchetype((File)earFile, (ProjectInfo)earVersionInfo, (Archetype)((Archetype)this.wiz.getProperty("ear_archetype")), null, (boolean)false);
        if (webVersionInfo != null) {
            ArchetypeWizards.createFromArchetype((File)FileUtil.normalizeFile((File)((File)this.wiz.getProperty("web_projdir"))), (ProjectInfo)webVersionInfo, (Archetype)((Archetype)this.wiz.getProperty("web_archetype")), null, (boolean)false);
        }
        if (ejbVersionInfo != null) {
            ArchetypeWizards.createFromArchetype((File)FileUtil.normalizeFile((File)((File)this.wiz.getProperty("ejb_projdir"))), (ProjectInfo)ejbVersionInfo, (Archetype)((Archetype)this.wiz.getProperty("ejb_archetype")), null, (boolean)false);
        }
        this.addEARDependencies((File)this.wiz.getProperty("ear_projdir"), ejbVersionInfo, webVersionInfo);
        LifecycleManager.getDefault().saveAll();
        Set projects = ArchetypeWizards.openProjects((File)rootFile, (File)earFile);
        for (FileObject projectFile : projects) {
            Project project = ProjectManager.getDefault().findProject(projectFile);
            if (project == null) continue;
            String projectDirName = projectFile.getName();
            if (projectDirName.endsWith("-web")) {
                String javaeeVersion = (String)this.wiz.getProperty("netbeans.hint.j2eeVersion");
                this.wiz.putProperty("netbeans.hint.j2eeVersion", (Object)(javaeeVersion + "-web"));
            }
            if (projectDirName.endsWith("-ejb") || projectDirName.endsWith("-ear") || projectDirName.endsWith("-web")) {
                this.saveSettingsToNbConfiguration(project);
                MavenProjectSupport.changeServer(project, true);
            }
            if (!projectDirName.endsWith("-ear")) continue;
            this.generateApplicationXML(projects);
        }
        return projects;
    }

    private void generateApplicationXML(Set<FileObject> projects) throws IOException {
        HashSet<Project> childProjects = new HashSet<Project>();
        Project earProject = null;
        for (FileObject projectFile : projects) {
            Project project = ProjectManager.getDefault().findProject(projectFile);
            if (project == null) continue;
            String projectDirName = projectFile.getName();
            if (projectDirName.endsWith("-web") || projectDirName.endsWith("-ejb")) {
                childProjects.add(project);
            }
            if (!projectDirName.endsWith("-ear")) continue;
            earProject = project;
        }
        if (earProject == null) {
            return;
        }
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)earProject.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider != null && moduleProvider.getConfigSupport().isDescriptorRequired()) {
            EarDDGenerator.setupDD(earProject, (boolean)true);
        }
    }

    @Override
    public void initialize(WizardDescriptor wiz) {
        super.initialize(wiz);
        wiz.putProperty("NewProjectWizard_Title", (Object)Bundle.template_EA());
    }

    private void addEARDependencies(File earDir, ProjectInfo ejbInfo, ProjectInfo webInfo) {
        FileObject earPom;
        FileObject earDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)earDir));
        if (earDirFO == null) {
            return;
        }
        ArrayList<ModelOperation> operations = new ArrayList<ModelOperation>();
        if (ejbInfo != null) {
            operations.add(ArchetypeWizards.addDependencyOperation((ProjectInfo)ejbInfo, (String)"ejb"));
        }
        if (webInfo != null) {
            operations.add(ArchetypeWizards.addDependencyOperation((ProjectInfo)webInfo, (String)"war"));
        }
        if ((earPom = earDirFO.getFileObject("pom.xml")) != null) {
            Utilities.performPOMModelOperations((FileObject)earPom, operations);
        }
    }

    @Override
    protected WizardDescriptor.Panel[] createPanels(ValidationGroup vg) {
        return new WizardDescriptor.Panel[]{ArchetypeWizards.basicWizardPanel((ValidationGroup)vg, (boolean)false, null), new EAWizardPanel(vg)};
    }
}

