/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.bridge.AuxClassLoader;
import org.apache.tools.ant.module.bridge.BridgeInterface;
import org.apache.tools.ant.module.bridge.DummyBridgeImpl;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.ChangeSupport;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.io.NullOutputStream;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AntBridge {
    private static final Logger LOG = Logger.getLogger(AntBridge.class.getName());
    private static Reference<AntInstance> antInstance = null;
    private static final ChangeSupport cs = new ChangeSupport(AntBridge.class);
    public static boolean NO_MODULE_SYSTEM;
    private static MiscListener miscListener;
    private static Lookup.Result<ModuleInfo> modulesResult;
    private static int delegating;
    private static InputStream origIn;
    private static PrintStream origOut;
    private static PrintStream origErr;
    private static Map<ThreadGroup, InputStream> delegateIns;
    private static Map<ThreadGroup, PrintStream> delegateOuts;
    private static Map<ThreadGroup, PrintStream> delegateErrs;
    private static List<Thread> suspendedDelegationTasks;

    private AntBridge() {
    }

    public static synchronized void addChangeListener(ChangeListener l) {
        cs.addChangeListener(l);
    }

    public static synchronized void removeChangeListener(ChangeListener l) {
        cs.removeChangeListener(l);
    }

    private static void fireChange() {
        antInstance = null;
        cs.fireChange();
    }

    public static ClassLoader getMainClassLoader() {
        return AntBridge.getAntInstance().mainClassLoader;
    }

    public static Map<String, Map<String, Class>> getCustomDefsWithNamespace() {
        return AntBridge.getAntInstance().customDefs;
    }

    public static Map<String, Map<String, Class>> getCustomDefsNoNamespace() {
        HashMap<String, Map<String, Class>> m = new HashMap<String, Map<String, Class>>();
        for (Map.Entry<String, Map<String, Class>> entry : AntBridge.getCustomDefsWithNamespace().entrySet()) {
            String type = entry.getKey();
            Map<String, Class> defs = entry.getValue();
            HashMap<String, Class> m2 = new HashMap<String, Class>();
            for (Map.Entry<String, Class> entry2 : defs.entrySet()) {
                String fqn = entry2.getKey();
                Class clazz = entry2.getValue();
                int idx = fqn.lastIndexOf(58);
                String name = idx != -1 ? fqn.substring(idx + 1) : fqn;
                m2.put(name, clazz);
            }
            m.put(type, m2);
        }
        return m;
    }

    public static Map<String, ClassLoader> getCustomDefClassLoaders() throws IOException {
        return AntBridge.getAntInstance().customDefClassLoaders;
    }

    public static BridgeInterface getInterface() {
        return AntBridge.getAntInstance().bridge;
    }

    private static synchronized AntInstance getAntInstance() {
        AntInstance ai = antInstance != null ? antInstance.get() : null;
        if (ai == null) {
            ai = AntBridge.createAntInstance();
            antInstance = new SoftReference<AntInstance>(ai);
        }
        return ai;
    }

    private static AntInstance createAntInstance() {
        LOG.fine("AntBridge.createAntInstance - loading Ant installation...");
        try {
            List<File> mainClassPath = AntBridge.createMainClassPath();
            LOG.log(Level.FINER, "mainClassPath={0}", mainClassPath);
            ClassLoader main = AntBridge.createMainClassLoader(mainClassPath);
            ClassLoader bridgeLoader = AntBridge.createBridgeClassLoader(main);
            Class<?> ihClazz = Class.forName("org.apache.tools.ant.input.InputHandler", false, bridgeLoader);
            Class<BridgeInterface> impl = bridgeLoader.loadClass("org.apache.tools.ant.module.bridge.impl.BridgeImpl").asSubclass(BridgeInterface.class);
            if (AntSettings.getAntHome() != null) {
                ClassLoader loaderUsedForAnt = ihClazz.getClassLoader();
                if (loaderUsedForAnt != main) {
                    throw new IllegalStateException("Wrong class loader is finding Ant: " + loaderUsedForAnt);
                }
                Class<?> ihClazz2 = Class.forName("org.apache.tools.ant.input.InputHandler", false, main);
                if (ihClazz2 != ihClazz) {
                    throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + ihClazz2.getClassLoader());
                }
                try {
                    Class<?> alClazz = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, bridgeLoader);
                    if (alClazz.getClassLoader() != main) {
                        throw new IllegalStateException("Bridge loader is loading stuff from elsewhere: " + alClazz.getClassLoader());
                    }
                    Class<?> alClazz2 = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, main);
                    if (alClazz2 != alClazz) {
                        throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + alClazz2.getClassLoader());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (impl.getClassLoader() != bridgeLoader) {
                    throw new IllegalStateException("Wrong class loader is finding bridge impl: " + impl.getClassLoader());
                }
            }
            Map<String, ClassLoader> cDCLs = AntBridge.createCustomDefClassLoaders(main);
            return new AntInstance(AntBridge.classPathToString(mainClassPath), main, bridgeLoader, impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), AntBridge.createCustomDefs(cDCLs), cDCLs);
        }
        catch (Exception e) {
            return AntBridge.fallback(e);
        }
        catch (LinkageError e) {
            return AntBridge.fallback(e);
        }
    }

    private static AntInstance fallback(Throwable e) {
        ClassLoader dummy = ClassLoader.getSystemClassLoader();
        HashMap<String, Map<String, Class>> defs = new HashMap<String, Map<String, Class>>();
        defs.put("task", new HashMap());
        defs.put("type", new HashMap());
        return new AntInstance("", dummy, dummy, new DummyBridgeImpl(e), defs, Collections.emptyMap());
    }

    private static String classPathToString(List<File> cp) {
        StringBuffer b = new StringBuffer();
        Iterator<File> it = cp.iterator();
        while (it.hasNext()) {
            b.append(it.next().getAbsolutePath());
            if (!it.hasNext()) continue;
            b.append(File.pathSeparator);
        }
        return b.toString();
    }

    public static String getMainClassPath() {
        return AntBridge.getAntInstance().mainClassPath;
    }

    private static List<File> createMainClassPath() throws Exception {
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        File antHome = AntSettings.getAntHome();
        if (antHome != null) {
            File libdir = new File(antHome, "lib");
            if (!libdir.isDirectory()) {
                throw new IOException("No such Ant library dir: " + libdir);
            }
            LOG.log(Level.FINE, "Creating main class loader from {0}", libdir);
            AntBridge.addJARs(cp, new File(libdir.getParentFile(), "patches"));
            AntBridge.addJARs(cp, libdir);
        }
        AntBridge.addJARs(cp, new File(new File(System.getProperty("user.home"), ".ant"), "lib"));
        cp.addAll(AntSettings.getExtraClasspath());
        cp.addAll(AntSettings.getAutomaticExtraClasspath());
        return new ArrayList<File>(cp);
    }

    private static void addJARs(Collection<File> cp, File dir) {
        File[] libs = dir.listFiles(new JarFilter());
        if (libs != null) {
            Collections.addAll(cp, libs);
        }
    }

    private static URL[] toURLs(List<? extends File> classPath) throws MalformedURLException {
        URL[] urls = new URL[classPath.size()];
        int i = 0;
        for (File file : classPath) {
            urls[i++] = Utilities.toURI((File)file).toURL();
        }
        return urls;
    }

    private static boolean hasJavac(ClassLoader cl) {
        return cl.getResource("com/sun/tools/javac/Main.class") != null;
    }

    private static List<File> prependTools(List<File> origCp) {
        LinkedHashSet<File> tools = new LinkedHashSet<File>();
        AntBridge.addJARs(tools, new File(new File(System.getProperty("java.home")).getParentFile(), "lib"));
        tools.removeAll(origCp);
        ArrayList<File> res = new ArrayList<File>(tools.size() + origCp.size());
        res.addAll(tools);
        res.addAll(origCp);
        return res;
    }

    private static ClassLoader createMainClassLoader(List<File> mainClassPath) throws Exception {
        if (AntSettings.getAntHome() != null) {
            ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
            ClassLoader parent = sysClassLoader.getParent();
            if (LOG.isLoggable(Level.FINE)) {
                List<URL> parentURLs = parent instanceof URLClassLoader ? Arrays.asList(((URLClassLoader)parent).getURLs()) : null;
                LOG.log(Level.FINER, "AntBridge.createMainClassLoader: cp={0} parent.urls={1}", new Object[]{mainClassPath, parentURLs});
            }
            if (!AntBridge.hasJavac(parent)) {
                if (AntBridge.hasJavac(sysClassLoader)) {
                    parent = new AddJavacClassLoader(parent, sysClassLoader);
                } else {
                    mainClassPath = AntBridge.prependTools(mainClassPath);
                }
            }
            return new MainClassLoader(AntBridge.toURLs(mainClassPath), parent);
        }
        ClassLoader existing = AntBridge.class.getClassLoader();
        if (!AntBridge.hasJavac(existing)) {
            mainClassPath = AntBridge.prependTools(mainClassPath);
        }
        URL[] cp = AntBridge.toURLs(mainClassPath);
        if (existing instanceof URLClassLoader) {
            try {
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                for (URL u : cp) {
                    addURL.invoke((Object)existing, u);
                }
                return existing;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
        return new AllPermissionURLClassLoader(cp, existing);
    }

    private static ClassLoader createBridgeClassLoader(ClassLoader main) throws Exception {
        File bridgeJar = InstalledFileLocator.getDefault().locate("ant/nblib/bridge.jar", "org.apache.tools.ant.module", false);
        if (bridgeJar == null) {
            return main;
        }
        return AntBridge.createAuxClassLoader(bridgeJar, main, AntBridge.class.getClassLoader());
    }

    private static ClassLoader createAuxClassLoader(File lib, ClassLoader main, ClassLoader moduleLoader) throws IOException {
        return new AuxClassLoader(moduleLoader, main, Utilities.toURI((File)lib).toURL());
    }

    private static Map<String, ClassLoader> createCustomDefClassLoaders(ClassLoader main) throws IOException {
        HashMap<String, ClassLoader> m = new HashMap<String, ClassLoader>();
        ModuleInfo[] modules = miscListener.getEnabledModules();
        InstalledFileLocator ifl = InstalledFileLocator.getDefault();
        for (ModuleInfo module : modules) {
            String cnb = module.getCodeNameBase();
            String cnbDashes = cnb.replace('.', '-');
            File lib = ifl.locate("ant/nblib/" + cnbDashes + ".jar", cnb, false);
            if (lib == null) {
                if (main.getResource(cnb.replace('.', '/') + "/antlib.xml") == null) continue;
                m.put(cnb, main);
                continue;
            }
            ClassLoader l = AntBridge.createAuxClassLoader(lib, main, module.getClassLoader());
            m.put(cnb, l);
        }
        return m;
    }

    private static Map<String, Map<String, Class>> createCustomDefs(Map<String, ClassLoader> cDCLs) throws IOException {
        HashMap<String, Map<String, Class>> m = new HashMap<String, Map<String, Class>>();
        HashMap<String, Class> tasks = new HashMap<String, Class>();
        HashMap<String, Class> types = new HashMap<String, Class>();
        m.put("task", tasks);
        m.put("type", types);
        for (Map.Entry<String, ClassLoader> entry : cDCLs.entrySet()) {
            Document doc;
            String resource;
            String cnb = entry.getKey();
            ClassLoader l = entry.getValue();
            URL antlib = l.getResource(resource = cnb.replace('.', '/') + "/antlib.xml");
            if (antlib == null) {
                throw new IOException("Could not find " + resource + " in ant/nblib/" + cnb.replace('.', '-') + ".jar");
            }
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(antlib.toExternalForm()), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            Element docEl = doc.getDocumentElement();
            if (!docEl.getLocalName().equals("antlib")) {
                throw new IOException("Bad root element for " + antlib + ": " + docEl);
            }
            NodeList nl = docEl.getChildNodes();
            HashMap<String, String> newTaskDefs = new HashMap<String, String>();
            HashMap<String, String> newTypeDefs = new HashMap<String, String>();
            for (int i = 0; i < nl.getLength(); ++i) {
                boolean type;
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                Element def = (Element)n;
                if (def.getNodeName().equals("taskdef")) {
                    type = false;
                } else if (def.getNodeName().equals("typedef")) {
                    type = true;
                } else {
                    LOG.warning("Warning: unrecognized definition " + def + " in " + antlib);
                    continue;
                }
                String name = def.getAttribute("name");
                if (name == null) {
                    LOG.warning("Warning: skipping definition " + def + " with no 'name' in " + antlib);
                    continue;
                }
                String classname = def.getAttribute("classname");
                if (classname == null) {
                    throw new IOException("No 'classname' attr on def of " + name + " in " + antlib);
                }
                String nsname = "antlib:" + cnb + ":" + name;
                (type ? newTypeDefs : newTaskDefs).put(nsname, classname);
            }
            AntBridge.loadDefs(newTaskDefs, tasks, l);
            AntBridge.loadDefs(newTypeDefs, types, l);
        }
        return m;
    }

    private static void loadDefs(Map<String, String> p, Map<String, Class> defs, ClassLoader l) throws IOException {
        for (Map.Entry<String, String> entry : p.entrySet()) {
            String name = entry.getKey();
            String clazzname = entry.getValue();
            try {
                Class<?> clazz = l.loadClass(clazzname);
                defs.put(name, clazz);
            }
            catch (ClassNotFoundException cnfe) {
                throw (IOException)new IOException("Could not load class " + clazzname + ": " + cnfe).initCause(cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                LOG.log(Level.FINE, "AntBridge.loadDefs: skipping {0}: {1}", new Object[]{clazzname, ncdfe});
            }
            catch (LinkageError e) {
                throw (IOException)new IOException("Could not load class " + clazzname + ": " + e).initCause(e);
            }
        }
    }

    public static synchronized void pushSystemInOutErr(InputStream in, PrintStream out, PrintStream err) {
        if (delegating++ == 0) {
            origIn = System.in;
            origOut = System.out;
            origErr = System.err;
            System.setIn(new MultiplexInputStream());
            System.setOut(new MultiplexPrintStream(false));
            System.setErr(new MultiplexPrintStream(true));
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        delegateIns.put(tg, in);
        delegateOuts.put(tg, out);
        delegateErrs.put(tg, err);
    }

    public static synchronized void restoreSystemInOutErr() {
        assert (delegating > 0);
        if (--delegating == 0) {
            System.setIn(origIn);
            System.setOut(origOut);
            System.setErr(origErr);
            origIn = null;
            origOut = null;
            origErr = null;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        delegateIns.remove(tg);
        delegateOuts.remove(tg);
        delegateErrs.remove(tg);
    }

    public static synchronized void suspendDelegation() {
        Thread t = Thread.currentThread();
        suspendedDelegationTasks.add(t);
    }

    public static synchronized void resumeDelegation() {
        Thread t = Thread.currentThread();
        assert (suspendedDelegationTasks.contains(t)) : "Have not suspended delegation in " + t;
        suspendedDelegationTasks.remove(t);
    }

    public static synchronized InputStream delegateInputStream() {
        ThreadGroup tg;
        Thread t = Thread.currentThread();
        for (tg = t.getThreadGroup(); tg != null && !delegateIns.containsKey(tg); tg = tg.getParent()) {
        }
        InputStream is = delegateIns.get(tg);
        return is != null ? is : origIn;
    }

    public static synchronized PrintStream delegateOutputStream(boolean err) {
        ThreadGroup tg;
        Thread t = Thread.currentThread();
        for (tg = t.getThreadGroup(); tg != null && !delegateIns.containsKey(tg); tg = tg.getParent()) {
        }
        PrintStream ps = (err ? delegateErrs : delegateOuts).get(tg);
        return ps != null ? ps : (err ? origErr : origOut);
    }

    static {
        miscListener = new MiscListener();
        modulesResult = Lookup.getDefault().lookupResult(ModuleInfo.class);
        AntSettings.addPropertyChangeListener(miscListener);
        modulesResult.addLookupListener((LookupListener)miscListener);
        delegating = 0;
        delegateIns = new HashMap<ThreadGroup, InputStream>();
        delegateOuts = new HashMap<ThreadGroup, PrintStream>();
        delegateErrs = new HashMap<ThreadGroup, PrintStream>();
        suspendedDelegationTasks = new ArrayList<Thread>();
    }

    private static final class AntInstance {
        public final String mainClassPath;
        public final ClassLoader mainClassLoader;
        public final ClassLoader bridgeClassLoader;
        public final BridgeInterface bridge;
        public final Map<String, Map<String, Class>> customDefs;
        public final Map<String, ClassLoader> customDefClassLoaders;

        public AntInstance(String mainClassPath, ClassLoader mainClassLoader, ClassLoader bridgeClassLoader, BridgeInterface bridge, Map<String, Map<String, Class>> customDefs, Map<String, ClassLoader> customDefClassLoaders) {
            this.mainClassPath = mainClassPath;
            this.mainClassLoader = mainClassLoader;
            this.bridgeClassLoader = bridgeClassLoader;
            this.bridge = bridge;
            this.customDefs = customDefs;
            this.customDefClassLoaders = customDefClassLoaders;
            if (mainClassLoader instanceof MainClassLoader) {
                ((MainClassLoader)mainClassLoader).antInstance = this;
            }
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase(Locale.US).endsWith(".jar");
        }
    }

    private static final class AddJavacClassLoader
    extends ClassLoader {
        private static final Iterable<? extends String> javacPackages = Arrays.asList("com.sun.jarsigner.", "com.sun.javadoc.", "com.sun.mirror.", "com.sun.source.", "com.sun.tools.", "javax.annotation.processing.", "javax.lang.model.", "javax.tools.", "sun.rmi.", "sun.security.", "sun.tools.");
        private static final int INITIAL_BUFSIZ = 16384;
        private final ClassLoader contextClassLoader;
        private byte[] buffer;
        private static final String META_INF_PLATFORM_PROVIDER_REGISTRATION_NAME = "META-INF/services/com.sun.tools.javac.platform.PlatformProvider";
        private static final FileSystem META_INF_PLATFORM_PROVIDER_FS;
        private static final URL META_INF_PLATFORM_PROVIDER_REGISTRATION;

        public AddJavacClassLoader(@NonNull ClassLoader parentClassLoader, @NonNull ClassLoader contextClassLoader) {
            super(parentClassLoader);
            this.contextClassLoader = contextClassLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (AddJavacClassLoader.isFromContextClassLoader(name, true)) {
                try {
                    Object object = this.getClassLoadingLock(name);
                    synchronized (object) {
                        Class<?> c = this.findLoadedClass(name);
                        if (c == null) {
                            InputStream in = this.contextClassLoader.getResourceAsStream(name.replace('.', '/').concat(".class"));
                            if (in != null) {
                                try {
                                    String pack;
                                    in = new BufferedInputStream(in, 16384);
                                    int len = this.readFully(in);
                                    int lastDot = name.lastIndexOf(46);
                                    if (lastDot >= 0 && this.getPackage(pack = name.substring(0, lastDot)) == null) {
                                        this.definePackage(pack, null, null, null, null, null, null, null);
                                    }
                                    c = this.defineClass(name, this.buffer, 0, len);
                                }
                                finally {
                                    in.close();
                                }
                            } else {
                                throw new ClassNotFoundException(String.format("The class: %s is not found in %s", name, this.contextClassLoader));
                            }
                        }
                        if (resolve) {
                            this.resolveClass(c);
                        }
                        return c;
                    }
                }
                catch (IOException ioe) {
                    throw new ClassNotFoundException(String.format("IO Error while loading: %s", name), ioe);
                }
            }
            return super.loadClass(name, resolve);
        }

        @Override
        public URL getResource(String name) {
            if (AddJavacClassLoader.isFromContextClassLoader(name, false)) {
                return this.contextClassLoader.getResource(name);
            }
            if (META_INF_PLATFORM_PROVIDER_REGISTRATION_NAME.equals(name)) {
                return META_INF_PLATFORM_PROVIDER_REGISTRATION;
            }
            return super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration res = super.getResources(name);
            if (AddJavacClassLoader.isFromContextClassLoader(name, false)) {
                Enumeration<URL> cclRes = this.contextClassLoader.getResources(name);
                res = Enumerations.concat(res, cclRes);
            }
            if (META_INF_PLATFORM_PROVIDER_REGISTRATION_NAME.equals(name)) {
                res = Enumerations.concat(res, (Enumeration)Enumerations.singleton((Object)META_INF_PLATFORM_PROVIDER_REGISTRATION));
            }
            return res;
        }

        private static boolean isFromContextClassLoader(@NonNull String name, boolean pkg) {
            char f;
            char c = f = name.length() > 4 ? name.charAt(4) : (char)'\u0000';
            if (f == 'x' || f == 's' || f == 'r' || f == 't') {
                if (!pkg) {
                    name = name.replace('/', '.');
                }
                for (String string : javacPackages) {
                    if (!name.startsWith(string)) continue;
                    return true;
                }
            }
            return false;
        }

        private int readFully(@NonNull InputStream in) throws IOException {
            if (this.buffer == null) {
                this.buffer = new byte[16384];
            }
            int capacity = this.buffer.length;
            int nread = 0;
            while (true) {
                int n;
                if ((n = in.read(this.buffer, nread, capacity - nread)) > 0) {
                    nread += n;
                    continue;
                }
                if (n < 0 || (n = in.read()) < 0) break;
                this.buffer = Arrays.copyOf(this.buffer, capacity <<= 1);
                this.buffer[nread++] = (byte)n;
            }
            return nread;
        }

        static {
            try {
                META_INF_PLATFORM_PROVIDER_FS = FileUtil.createMemoryFileSystem();
                FileObject file = FileUtil.createData((FileObject)META_INF_PLATFORM_PROVIDER_FS.getRoot(), (String)META_INF_PLATFORM_PROVIDER_REGISTRATION_NAME);
                try (OutputStream out = file.getOutputStream();){
                    out.write("com.sun.tools.javac.platform.JDKPlatformProvider\n".getBytes(StandardCharsets.UTF_8));
                }
                META_INF_PLATFORM_PROVIDER_REGISTRATION = file.toURL();
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    private static final class MainClassLoader
    extends AllPermissionURLClassLoader {
        AntInstance antInstance;

        public MainClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("com.sun.jdi.")) {
                throw new ClassNotFoundException("Will not load JDI separately from tools.jar: " + name);
            }
            return super.findClass(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            if (name.equals("META-INF/services/javax.xml.stream.XMLInputFactory")) {
                return super.getResourceAsStream(name);
            }
            if (name.startsWith("META-INF/services/javax.xml.")) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return super.getResourceAsStream(name);
        }
    }

    static class AllPermissionURLClassLoader
    extends URLClassLoader {
        private static PermissionCollection allPermission;

        private static synchronized PermissionCollection getAllPermissions() {
            if (allPermission == null) {
                allPermission = new Permissions();
                allPermission.add(new AllPermission());
            }
            return allPermission;
        }

        public AllPermissionURLClassLoader(URL[] urls, ClassLoader parent) {
            super(AllPermissionURLClassLoader.sanitize(urls), parent);
        }

        private static URL[] sanitize(URL[] urls) {
            for (int i = 0; i < urls.length; ++i) {
                try {
                    urls[i] = URI.create(urls[i].toURI().toASCIIString()).toURL();
                    continue;
                }
                catch (Exception x) {
                    assert (false) : "converting " + urls[i] + ": " + x;
                    continue;
                }
            }
            return urls;
        }

        @Override
        protected final PermissionCollection getPermissions(CodeSource cs) {
            return AllPermissionURLClassLoader.getAllPermissions();
        }

        public String toString() {
            return super.toString() + "[parent=" + this.getParent() + ",urls=" + Arrays.asList(this.getURLs()) + "]";
        }

        @Override
        public URL getResource(String name) {
            URL u = super.getResource(name);
            LOG.log(Level.FINER, "APURLCL.gR: {0} -> {1} [{2}]", new Object[]{name, u, this});
            return u;
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            try {
                Enumeration<URL> us = super.findResources(name);
                if (LOG.isLoggable(Level.FINER)) {
                    ArrayList<URL> resources = Collections.list(us);
                    us = Collections.enumeration(resources);
                    LOG.finer("APURLCL.fRs: " + name + " -> " + resources + " [" + this + "]");
                }
                return us;
            }
            catch (IOException e) {
                LOG.log(Level.FINE, null, e);
                throw e;
            }
        }
    }

    private static final class MiscListener
    implements PropertyChangeListener,
    LookupListener {
        private ModuleInfo[] modules = null;

        MiscListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if ("antHome".equals(prop) || "extraClasspath".equals(prop) || "automaticExtraClasspath".equals(prop)) {
                LOG.log(Level.FINE, "AntBridge got settings change in {0}", prop);
                AntBridge.fireChange();
            } else if ("enabled".equals(prop)) {
                LOG.log(Level.FINE, "AntBridge got module enablement change on {0}", ev.getSource());
                AntBridge.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            LOG.fine("AntModule got ModuleInfo change");
            MiscListener miscListener = this;
            synchronized (miscListener) {
                if (this.modules != null) {
                    for (ModuleInfo module : this.modules) {
                        module.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.modules = null;
                }
            }
            AntBridge.fireChange();
        }

        public synchronized ModuleInfo[] getEnabledModules() {
            if (NO_MODULE_SYSTEM) {
                return new ModuleInfo[0];
            }
            if (this.modules == null) {
                Collection c = modulesResult.allInstances();
                for (ModuleInfo module : this.modules = c.toArray(new ModuleInfo[0])) {
                    module.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            ArrayList<ModuleInfo> enabledModules = new ArrayList<ModuleInfo>(this.modules.length);
            for (ModuleInfo module : this.modules) {
                if (!module.isEnabled()) continue;
                enabledModules.add(module);
            }
            return enabledModules.toArray(new ModuleInfo[0]);
        }
    }

    private static final class MultiplexInputStream
    extends InputStream {
        private InputStream delegate() {
            ThreadGroup tg;
            Thread t = Thread.currentThread();
            for (tg = t.getThreadGroup(); tg != null && !delegateIns.containsKey(tg); tg = tg.getParent()) {
            }
            InputStream is = (InputStream)delegateIns.get(tg);
            if (is != null && !suspendedDelegationTasks.contains(t)) {
                return is;
            }
            if (delegating > 0) {
                assert (origIn != null);
                return origIn;
            }
            return System.in;
        }

        @Override
        public int read() throws IOException {
            return this.delegate().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate().read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.delegate().available();
        }

        @Override
        public boolean markSupported() {
            return this.delegate().markSupported();
        }

        @Override
        public void mark(int readlimit) {
            this.delegate().mark(readlimit);
        }

        @Override
        public void close() throws IOException {
            this.delegate().close();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate().skip(n);
        }

        @Override
        public void reset() throws IOException {
            this.delegate().reset();
        }
    }

    private static final class MultiplexPrintStream
    extends PrintStream {
        private final boolean err;

        public MultiplexPrintStream(boolean err) {
            this(new NullOutputStream(), err);
        }

        private MultiplexPrintStream(NullOutputStream nos, boolean err) {
            super((OutputStream)nos);
            nos.throwException = true;
            this.err = err;
        }

        private PrintStream delegate() {
            ThreadGroup tg;
            Map delegates;
            Thread t = Thread.currentThread();
            Map map = delegates = this.err ? delegateErrs : delegateOuts;
            for (tg = t.getThreadGroup(); tg != null && !delegates.containsKey(tg); tg = tg.getParent()) {
            }
            PrintStream ps = (PrintStream)delegates.get(tg);
            if (ps != null && !suspendedDelegationTasks.contains(t)) {
                assert (!(ps instanceof MultiplexPrintStream));
                return ps;
            }
            if (delegating > 0) {
                PrintStream orig;
                PrintStream printStream = orig = this.err ? origErr : origOut;
                assert (orig != null);
                assert (!(orig instanceof MultiplexPrintStream));
                return orig;
            }
            return new PrintStream(new ByteArrayOutputStream());
        }

        @Override
        public boolean checkError() {
            return this.delegate().checkError();
        }

        @Override
        public void close() {
            this.delegate().close();
        }

        @Override
        public void flush() {
            this.delegate().flush();
        }

        @Override
        public void print(long l) {
            this.delegate().print(l);
        }

        @Override
        public void print(char[] s) {
            this.delegate().print(s);
        }

        @Override
        public void print(int i) {
            this.delegate().print(i);
        }

        @Override
        public void print(boolean b) {
            this.delegate().print(b);
        }

        @Override
        public void print(char c) {
            this.delegate().print(c);
        }

        @Override
        public void print(float f) {
            this.delegate().print(f);
        }

        @Override
        public void print(double d) {
            this.delegate().print(d);
        }

        @Override
        public void print(Object obj) {
            this.delegate().print(obj);
        }

        @Override
        public void print(String s) {
            this.delegate().print(s);
        }

        @Override
        public void println(double x) {
            this.delegate().println(x);
        }

        @Override
        public void println(Object x) {
            this.delegate().println(x);
        }

        @Override
        public void println(float x) {
            this.delegate().println(x);
        }

        @Override
        public void println(int x) {
            this.delegate().println(x);
        }

        @Override
        public void println(char x) {
            this.delegate().println(x);
        }

        @Override
        public void println(boolean x) {
            this.delegate().println(x);
        }

        @Override
        public void println(String x) {
            this.delegate().println(x);
        }

        @Override
        public void println(char[] x) {
            this.delegate().println(x);
        }

        @Override
        public void println() {
            this.delegate().println();
        }

        @Override
        public void println(long x) {
            this.delegate().println(x);
        }

        @Override
        public void write(int b) {
            this.delegate().write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.delegate().write(b, off, len);
        }

        @Override
        public PrintStream append(CharSequence csq) {
            return this.delegate().append(csq);
        }

        @Override
        public PrintStream append(char c) {
            return this.delegate().append(c);
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            return this.delegate().append(csq, start, end);
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            return this.delegate().format(format, args);
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            return this.delegate().format(l, format, args);
        }
    }
}

