/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import org.netbeans.modules.autoupdate.services.MessageValidator;
import org.netbeans.modules.autoupdate.services.Utilities;

public class MessageDigestValidator
implements MessageValidator {
    private final MessageDigest messageDigest;
    private final byte[] expectedValue;
    private byte[] digestValue;

    public MessageDigestValidator(MessageDigest messageDigest, byte[] expectedValue) {
        Objects.requireNonNull(messageDigest, "messageDigenst must not be NULL");
        Objects.requireNonNull(expectedValue, "expectedValue must not be NULL");
        this.messageDigest = messageDigest;
        this.expectedValue = expectedValue;
    }

    @Override
    public void update(byte input) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.messageDigest.update(input);
    }

    @Override
    public void update(byte[] input, int offset, int len) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.messageDigest.update(input, offset, len);
    }

    @Override
    public void update(byte[] input) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.messageDigest.update(input);
    }

    @Override
    public void reset() {
        this.digestValue = null;
        this.messageDigest.reset();
    }

    @Override
    public boolean isValid() {
        return Arrays.equals(this.getDigestValue(), this.expectedValue);
    }

    private byte[] getDigestValue() {
        if (this.digestValue == null) {
            this.digestValue = this.messageDigest.digest();
        }
        return this.digestValue;
    }

    @Override
    public String getName() {
        return "Message Digest (" + this.messageDigest.getAlgorithm() + ")";
    }

    @Override
    public String getExpectedValueAsString() {
        if (this.expectedValue == null) {
            return "";
        }
        return Utilities.hexEncode(this.expectedValue);
    }

    @Override
    public String getRealValueAsString() {
        if (this.expectedValue == null) {
            return "";
        }
        return Utilities.hexEncode(this.getDigestValue());
    }
}

