/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.jaxws.actions.JaxWsRefreshAction;
import org.netbeans.modules.maven.jaxws.actions.WSEditAttributesAction;
import org.netbeans.modules.maven.jaxws.nodes.ClientHandlerButtonListener;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientChildren;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.maven.jaxws.nodes.WsImportFailedMessage;
import org.netbeans.modules.maven.jaxws.wizards.JaxWsClientCreator;
import org.netbeans.modules.maven.jaxws.wseditor.EditWSAttributesCookieImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandler;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerChain;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerChains;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerClass;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModel;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModelFactory;
import org.netbeans.modules.websvc.api.jaxws.bindings.DefinitionsBindings;
import org.netbeans.modules.websvc.api.jaxws.bindings.GlobalBindings;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.support.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.api.support.RefreshClientDialog;
import org.netbeans.modules.websvc.api.support.RefreshCookie;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.spi.support.ConfigureHandlerAction;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class JaxWsClientNode
extends AbstractNode
implements OpenCookie,
RefreshCookie,
ConfigureHandlerCookie {
    JaxWsService client;
    JAXWSLightSupport jaxWsSupport;
    InstanceContent content;
    private FileObject wsdlFileObject;
    boolean modelGenerationFinished;
    WsdlModel wsdlModel;
    private static final String WAITING_BADGE = "org/netbeans/modules/maven/jaxws/resources/waiting.png";
    private static final String ERROR_BADGE = "org/netbeans/modules/maven/jaxws/resources/error-badge.gif";
    private static final String SERVICE_BADGE = "org/netbeans/modules/maven/jaxws/resources/XMLServiceDataIcon.png";
    private Image cachedWaitingBadge;
    private Image cachedErrorBadge;
    private Image cachedServiceBadge;

    public JaxWsClientNode(JAXWSLightSupport jaxWsSupport, JaxWsService client) {
        this(jaxWsSupport, client, new InstanceContent());
    }

    private JaxWsClientNode(JAXWSLightSupport jaxWsSupport, JaxWsService client, InstanceContent content) {
        super((Children)new JaxWsClientChildren(jaxWsSupport, client), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.jaxWsSupport = jaxWsSupport;
        this.client = client;
        this.content = content;
        content.add((Object)this);
        content.add((Object)client);
        content.add((Object)jaxWsSupport);
        final WsdlModeler modeler = this.getWsdlModeler();
        if (modeler != null) {
            this.changeIcon();
            modeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel model) {
                    JaxWsClientNode.this.modelGenerationFinished = true;
                    JaxWsClientNode.this.changeIcon();
                    if (modeler.getCreationException() == null && model != null) {
                        JaxWsClientNode.this.wsdlModel = model;
                    }
                }
            });
        }
        content.add((Object)new EditWSAttributesCookieImpl((Node)this));
    }

    public WsdlModel getWsdlModel() {
        return this.getWsdlModeler().getAndWaitForWsdlModel();
    }

    public String getName() {
        return this.client.getId();
    }

    public String getDisplayName() {
        return this.client.getId();
    }

    public String getShortDescription() {
        return this.client.getLocalWsdl();
    }

    public Image getIcon(int type) {
        if (this.wsdlModel != null) {
            return this.getServiceImage();
        }
        WsdlModeler wsdlModeler = this.getWsdlModeler();
        if (wsdlModeler != null && wsdlModeler.getCreationException() == null) {
            if (this.modelGenerationFinished) {
                return this.getServiceImage();
            }
            return ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getWaitingBadge(), (int)15, (int)8);
        }
        Image dirtyNodeImage = ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getErrorBadge(), (int)6, (int)6);
        if (this.modelGenerationFinished) {
            return dirtyNodeImage;
        }
        return ImageUtilities.mergeImages((Image)dirtyNodeImage, (Image)this.getWaitingBadge(), (int)15, (int)8);
    }

    private Image getServiceImage() {
        if (this.cachedServiceBadge == null) {
            this.cachedServiceBadge = ImageUtilities.loadImage((String)SERVICE_BADGE);
        }
        return this.cachedServiceBadge;
    }

    private Image getErrorBadge() {
        if (this.cachedErrorBadge == null) {
            this.cachedErrorBadge = ImageUtilities.loadImage((String)ERROR_BADGE);
        }
        return this.cachedErrorBadge;
    }

    private Image getWaitingBadge() {
        if (this.cachedWaitingBadge == null) {
            this.cachedWaitingBadge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        return this.cachedWaitingBadge;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public void open() {
        EditCookie ec = this.getEditCookie();
        if (ec != null) {
            ec.edit();
        }
    }

    void changeIcon() {
        this.fireIconChange();
    }

    private EditCookie getEditCookie() {
        try {
            FileObject wsdlFolder = this.jaxWsSupport.getWsdlFolder(false);
            if (wsdlFolder == null) {
                return null;
            }
            FileObject wsdlFo = wsdlFolder.getFileObject(this.client.getLocalWsdl());
            if (wsdlFo != null) {
                DataObject dObj = DataObject.find((FileObject)wsdlFo);
                return (EditCookie)dObj.getCookie(EditCookie.class);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(ex.getLocalizedMessage());
            return null;
        }
        return null;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean context) {
        ArrayList<CallableSystemAction> actions = new ArrayList<CallableSystemAction>(Arrays.asList((CallableSystemAction)SystemAction.get(OpenAction.class), (CallableSystemAction)SystemAction.get(JaxWsRefreshAction.class), (CallableSystemAction)SystemAction.get(WSEditAttributesAction.class), (CallableSystemAction)SystemAction.get(ConfigureHandlerAction.class), null, (CallableSystemAction)SystemAction.get(DeleteAction.class), null, (CallableSystemAction)SystemAction.get(PropertiesAction.class)));
        this.addFromLayers(actions, "WebServices/Clients/Actions");
        return actions.toArray(new Action[0]);
    }

    private void addFromLayers(ArrayList<Action> actions, String path) {
        Lookup look = Lookups.forPath((String)path);
        for (Object next : look.lookupAll(Object.class)) {
            if (next instanceof Action) {
                actions.add((Action)next);
                continue;
            }
            if (!(next instanceof JSeparator)) continue;
            actions.add(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        FileObject wsdlFolder = this.jaxWsSupport.getWsdlFolder(false);
        if (wsdlFolder != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)wsdlFolder);
            if (project != null) {
                final String clientId = this.client.getId();
                ModelOperation<POMModel> oper = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel model) {
                        MavenModelUtils.removeWsimportExecution(model, clientId);
                    }
                };
                final FileObject pom = project.getProjectDirectory().getFileObject("pom.xml");
                RequestProcessor.getDefault().post(new Runnable(){
                    final /* synthetic */ ModelOperation val$oper;
                    {
                        this.val$oper = modelOperation;
                    }

                    @Override
                    public void run() {
                        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(this.val$oper));
                    }
                });
                if (this.wsdlFileObject != null) {
                    boolean hasOtherServices = false;
                    List services = this.jaxWsSupport.getServices();
                    for (JaxWsService s : services) {
                        if (clientId == null || clientId.equals(s.getId()) || !this.client.getLocalWsdl().equals(s.getLocalWsdl())) continue;
                        hasOtherServices = true;
                        break;
                    }
                    if (!hasOtherServices) {
                        this.wsdlFileObject.delete();
                    }
                }
                try {
                    this.removeStaleFile(project, clientId);
                }
                catch (IOException ex) {
                    Logger.getLogger(JaxWsClientNode.class.getName()).log(Level.FINE, "Cannot remove stale file", ex);
                }
            }
            super.destroy();
        }
    }

    public void configureHandler() {
        DefinitionsBindings db;
        GlobalBindings gb;
        Project project = FileOwnerQuery.getOwner((FileObject)this.wsdlFileObject);
        ArrayList<String> handlerClasses = new ArrayList<String>();
        BindingsModel bindingsModel = this.getBindingsModel();
        if (bindingsModel != null && (gb = bindingsModel.getGlobalBindings()) != null && (db = gb.getDefinitionsBindings()) != null) {
            BindingsHandlerChains handlerChains = db.getHandlerChains();
            BindingsHandlerChain handlerChain = (BindingsHandlerChain)handlerChains.getHandlerChains().iterator().next();
            Collection handlers = handlerChain.getHandlers();
            for (BindingsHandler handler : handlers) {
                BindingsHandlerClass handlerClass = handler.getHandlerClass();
                handlerClasses.add(handlerClass.getClassName());
            }
        }
        MessageHandlerPanel panel = new MessageHandlerPanel(project, handlerClasses, true, this.client.getServiceName());
        String title = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, title);
        dialogDesc.setButtonListener((ActionListener)new ClientHandlerButtonListener(panel, bindingsModel, this.client, (Node)this));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
    }

    WsdlModeler getWsdlModeler() {
        if (this.getLocalWsdl() != null) {
            WsdlModeler modeler = WsdlModelerFactory.getDefault().getWsdlModeler(this.wsdlFileObject.toURL());
            if (modeler != null) {
                modeler.setCatalog(this.jaxWsSupport.getCatalog());
                return modeler;
            }
        } else {
            ErrorManager.getDefault().log(65536, NbBundle.getMessage(JaxWsNode.class, (String)"ERR_missingLocalWsdl"));
        }
        return null;
    }

    FileObject getLocalWsdl() {
        String relativePath;
        FileObject localWsdlocalFolder;
        if (this.wsdlFileObject == null && (localWsdlocalFolder = this.jaxWsSupport.getWsdlFolder(false)) != null && (relativePath = this.client.getLocalWsdl()) != null) {
            this.wsdlFileObject = localWsdlocalFolder.getFileObject(relativePath);
        }
        return this.wsdlFileObject;
    }

    void setModelGenerationFinished(boolean value) {
        this.modelGenerationFinished = value;
    }

    public void refreshService(boolean replaceLocalWsdl) {
        if (replaceLocalWsdl) {
            RefreshClientDialog.Result result;
            Project project;
            Preferences prefs;
            String wsdlUrl = this.client.getWsdlUrl();
            if (wsdlUrl == null && this.wsdlFileObject != null && (prefs = ProjectUtils.getPreferences((Project)(project = FileOwnerQuery.getOwner((FileObject)this.wsdlFileObject)), MavenWebService.class, (boolean)true)) != null && (wsdlUrl = prefs.get("_C_" + this.client.getId(), null)) != null) {
                this.client.setWsdlUrl(wsdlUrl);
            }
            if (RefreshClientDialog.Result.CLOSE.equals((Object)(result = RefreshClientDialog.open((boolean)true, (String)wsdlUrl)))) {
                return;
            }
            if (RefreshClientDialog.Result.REFRESH_ONLY.equals((Object)result)) {
                this.updateNode();
            } else {
                FileObject localWsdlFolder = this.jaxWsSupport.getWsdlFolder(true);
                if (localWsdlFolder != null) {
                    NotifyDescriptor.Message desc;
                    String mes;
                    String newWsdlUrl = result.getWsdlUrl();
                    boolean wsdlUrlChanged = false;
                    if (newWsdlUrl.length() > 0 && !newWsdlUrl.equals(wsdlUrl)) {
                        wsdlUrlChanged = true;
                    }
                    FileObject wsdlFo = null;
                    try {
                        wsdlFo = WSUtils.retrieveResource(localWsdlFolder, new URI("src/jax-ws-catalog.xml"), new URI(newWsdlUrl));
                    }
                    catch (URISyntaxException ex) {
                        mes = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_IncorrectURI", (Object)wsdlUrl);
                        desc = new NotifyDescriptor.Message((Object)mes, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    }
                    catch (UnknownHostException ex) {
                        mes = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_UnknownHost", (Object)ex.getMessage());
                        desc = new NotifyDescriptor.Message((Object)mes, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    }
                    catch (IOException ex) {
                        mes = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_WsdlRetrieverFailure", (Object)wsdlUrl);
                        desc = new NotifyDescriptor.Message((Object)mes, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    }
                    if (wsdlFo != null) {
                        final String relativePath = FileUtil.getRelativePath((FileObject)localWsdlFolder, (FileObject)wsdlFo);
                        Project project2 = FileOwnerQuery.getOwner((FileObject)wsdlFo);
                        final String oldId = this.client.getId();
                        ArrayList<JaxWsService> servicesToCheck = new ArrayList<JaxWsService>();
                        for (JaxWsService s : this.jaxWsSupport.getServices()) {
                            String serviceId = s.getId();
                            if (serviceId == null || serviceId.equals(oldId)) continue;
                            servicesToCheck.add(s);
                        }
                        final String newId = WSUtils.getUniqueId(wsdlFo.getName(), servicesToCheck);
                        if (wsdlUrlChanged) {
                            wsdlUrl = newWsdlUrl;
                            this.client.setWsdlUrl(wsdlUrl);
                            Preferences prefs2 = ProjectUtils.getPreferences((Project)project2, MavenWebService.class, (boolean)true);
                            if (prefs2 != null) {
                                prefs2.remove("_C_" + oldId);
                                prefs2.put("_C_" + newId, newWsdlUrl);
                            }
                        }
                        if (!relativePath.equals(this.client.getLocalWsdl())) {
                            this.wsdlFileObject = wsdlFo;
                            ModelOperation<POMModel> oper = new ModelOperation<POMModel>(){

                                public void performOperation(POMModel model) {
                                    MavenModelUtils.renameWsdlFile(model, oldId, newId, JaxWsClientNode.this.client.getLocalWsdl(), relativePath);
                                }
                            };
                            FileObject pom = project2.getProjectDirectory().getFileObject("pom.xml");
                            Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(oper));
                            try {
                                this.removeStaleFile(project2, oldId);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(JaxWsClientNode.class.getName()).log(Level.FINE, "Cannot remove stale file", ex);
                            }
                        }
                    }
                    this.updateNode();
                }
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsClientNode.class, (String)"MSG_RefreshClient")));
            this.updateNode();
        }
        if (this.wsdlFileObject != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)this.wsdlFileObject);
            RunConfig cfg = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (Project)project, (String)"JAX-WS:wsimport", Collections.singletonList("compile"));
            RunUtils.executeMaven((RunConfig)cfg);
        }
    }

    private void updateNode() {
        final WsdlModeler wsdlModeler = this.getWsdlModeler();
        if (wsdlModeler != null) {
            wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel model) {
                    JaxWsClientNode.this.wsdlModel = model;
                    JaxWsClientNode.this.setModelGenerationFinished(true);
                    JaxWsClientNode.this.changeIcon();
                    if (model == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new WsImportFailedMessage(false, wsdlModeler.getCreationException()));
                    }
                    ((JaxWsClientChildren)JaxWsClientNode.this.getChildren()).setWsdlModel(JaxWsClientNode.this.wsdlModel);
                    ((JaxWsClientChildren)JaxWsClientNode.this.getChildren()).updateKeys();
                }
            });
        }
    }

    private BindingsModel getBindingsModel() {
        String handlerBindingFile = this.client.getHandlerBindingFile();
        BindingsModel bindingsModel = null;
        try {
            FileObject handlerBindingFO;
            FileObject bindingsFolder;
            if (handlerBindingFile != null && (bindingsFolder = this.jaxWsSupport.getBindingsFolder(false)) != null && (handlerBindingFO = bindingsFolder.getFileObject(handlerBindingFile)) != null) {
                ModelSource ms = org.netbeans.modules.xml.retriever.catalog.Utilities.getModelSource((FileObject)handlerBindingFO, (boolean)true);
                bindingsModel = BindingsModelFactory.getDefault().getModel(ms);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        return bindingsModel;
    }

    private void removeStaleFile(Project prj, String name) throws IOException {
        FileObject staleFile = prj.getProjectDirectory().getFileObject("target/jaxws/stale/" + name + ".stale");
        if (staleFile != null) {
            staleFile.delete();
        }
    }
}

