/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public final class ExtraProjectJavadocForBinaryQueryImpl
extends ProjectOpenedHook
implements JavadocForBinaryQueryImplementation {
    private static final String REF_START = "file.reference.";
    private static final String JAVADOC_START = "javadoc.reference.";
    private static final Pattern REMOTE_POTOCOL = Pattern.compile("^http(s)?:.*");
    private static final Logger LOG = Logger.getLogger(ExtraProjectJavadocForBinaryQueryImpl.class.getName());
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final Map<URL, ExtraResult> cache = new HashMap<URL, ExtraResult>();
    private PropertyChangeListener listener;
    private Map<URL, URL> mappings = new HashMap<URL, URL>();
    private final Object MAPPINGS_LOCK = new Object();
    private Project project;

    public ExtraProjectJavadocForBinaryQueryImpl(Project prj, AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.project = prj;
        this.listener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().startsWith(ExtraProjectJavadocForBinaryQueryImpl.JAVADOC_START)) {
                    ExtraProjectJavadocForBinaryQueryImpl.this.checkAndRegisterExtraJavadoc(ExtraProjectJavadocForBinaryQueryImpl.this.getExtraSources());
                    ArrayList results = null;
                    Map map = ExtraProjectJavadocForBinaryQueryImpl.this.cache;
                    synchronized (map) {
                        results = new ArrayList(ExtraProjectJavadocForBinaryQueryImpl.this.cache.values());
                    }
                    for (ExtraResult res : results) {
                        res.fire();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        Map<URL, ExtraResult> map = this.cache;
        synchronized (map) {
            ExtraResult res = this.cache.get(binaryRoot);
            if (res != null) {
                return res;
            }
            if (this.mappings.containsKey(binaryRoot)) {
                res = new ExtraResult(binaryRoot);
                this.cache.put(binaryRoot, res);
                return res;
            }
        }
        return null;
    }

    protected void projectOpened() {
        this.checkAndRegisterExtraJavadoc(this.getExtraSources());
        this.evaluator.addPropertyChangeListener(this.listener);
    }

    protected void projectClosed() {
        this.checkAndRegisterExtraJavadoc(new HashMap<URL, URL>());
        this.evaluator.removePropertyChangeListener(this.listener);
    }

    private Map<URL, URL> getExtraSources() {
        HashMap<URL, URL> result = new HashMap<URL, URL>();
        Map props = this.evaluator.getProperties();
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                if (!((String)entry.getKey()).startsWith(REF_START)) continue;
                String val = ((String)entry.getKey()).substring(REF_START.length());
                String sourceKey = JAVADOC_START + val;
                String sourceValue = (String)props.get(sourceKey);
                File bin = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), (String)((String)entry.getValue()));
                URL binURL = FileUtil.urlForArchiveOrDir((File)bin);
                if (sourceValue == null || binURL == null) continue;
                if (ExtraProjectJavadocForBinaryQueryImpl.isRemoteJavaDoc(sourceValue)) {
                    try {
                        result.put(binURL, new URL(sourceValue));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.INFO, "Ignoring invalid javadoc root: {0} for binary: {1}", new Object[]{sourceValue, bin.getAbsolutePath()});
                    }
                    continue;
                }
                String[] source = ExtraProjectJavadocForBinaryQueryImpl.stripJARPath((String)props.get(sourceKey));
                File src = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), (String)source[0]);
                if (!src.exists()) continue;
                try {
                    URL url = FileUtil.urlForArchiveOrDir((File)src);
                    if (url == null) continue;
                    if (source[1] != null) {
                        assert (url.toExternalForm().endsWith("!/")) : url.toExternalForm();
                        url = new URL(url.toExternalForm() + source[1]);
                    }
                    result.put(binURL, url);
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return result;
    }

    static String[] stripJARPath(String value) {
        if (value == null) {
            return new String[]{null, null};
        }
        int index = value.indexOf("!/");
        if (index == -1) {
            return new String[]{value, null};
        }
        return new String[]{value.substring(0, index), value.substring(index + 2)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRegisterExtraJavadoc(Map<URL, URL> newvalues) {
        URL jaradd;
        HashSet<URL> added;
        HashSet<URL> removed;
        Iterator iterator = this.MAPPINGS_LOCK;
        synchronized (iterator) {
            removed = new HashSet<URL>(this.mappings.keySet());
            removed.removeAll(newvalues.keySet());
            added = new HashSet<URL>(newvalues.keySet());
            added.removeAll(this.mappings.keySet());
            this.mappings = newvalues;
        }
        for (URL rem : removed) {
            Map<URL, ExtraResult> map = this.cache;
            synchronized (map) {
                ExtraResult res = this.cache.remove(rem);
                if (res != null) {
                    res.fire();
                }
            }
            try {
                jaradd = FileUtil.getArchiveFile((URL)rem);
                if (jaradd != null) {
                    rem = jaradd;
                }
                FileOwnerQuery.markExternalOwner((URI)rem.toURI(), null, (int)0);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        for (URL add : added) {
            try {
                jaradd = FileUtil.getArchiveFile((URL)add);
                if (jaradd != null) {
                    add = jaradd;
                }
                FileOwnerQuery.markExternalOwner((URI)add.toURI(), (Project)this.project, (int)0);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static boolean isRemoteJavaDoc(@NonNull String javadoc) {
        return REMOTE_POTOCOL.matcher(javadoc).matches();
    }

    private class ExtraResult
    implements JavadocForBinaryQuery.Result {
        private URL binaryroot;
        private ChangeSupport chs = new ChangeSupport((Object)this);

        public ExtraResult(URL binary) {
            this.binaryroot = binary;
        }

        public URL[] getRoots() {
            URL source = (URL)ExtraProjectJavadocForBinaryQueryImpl.this.mappings.get(this.binaryroot);
            if (source != null) {
                return new URL[]{source};
            }
            return new URL[0];
        }

        public void fire() {
            this.chs.fireChange();
        }

        public void addChangeListener(ChangeListener l) {
            this.chs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.chs.removeChangeListener(l);
        }
    }
}

