/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.branch.HgBranch;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.util.RequestProcessor;

public class WorkingCopyInfo {
    public static final String PROPERTY_WORKING_COPY_PARENT = WorkingCopyInfo.class.getName() + ".workingCopyParents";
    public static final String PROPERTY_CURRENT_BRANCH = WorkingCopyInfo.class.getName() + ".currBranch";
    private static final WeakHashMap<File, WorkingCopyInfo> cache = new WeakHashMap(5);
    private static final Logger LOG = Logger.getLogger(WorkingCopyInfo.class.getName());
    private static final RequestProcessor rp = new RequestProcessor("WorkingCopyInfo", 1, true);
    private static final RequestProcessor.Task refreshTask = rp.create((Runnable)new RepositoryRefreshTask());
    private static final Set<WorkingCopyInfo> repositoriesToRefresh = new HashSet<WorkingCopyInfo>(2);
    private final WeakReference<File> rootRef;
    private final PropertyChangeSupport propertyChangeSupport;
    private HgLogMessage[] parents = new HgLogMessage[0];
    private String branch = HgBranch.DEFAULT_NAME;

    private WorkingCopyInfo(File root) {
        this.rootRef = new WeakReference<File>(root);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkingCopyInfo getInstance(File repositoryRoot) {
        WorkingCopyInfo info = null;
        File repositoryRootSingleInstance = Mercurial.getInstance().getRepositoryRoot(repositoryRoot);
        if (repositoryRoot.equals(repositoryRootSingleInstance)) {
            WeakHashMap<File, WorkingCopyInfo> weakHashMap = cache;
            synchronized (weakHashMap) {
                info = cache.get(repositoryRootSingleInstance);
                if (info == null) {
                    info = new WorkingCopyInfo(repositoryRootSingleInstance);
                    cache.put(repositoryRootSingleInstance, info);
                    info.refresh();
                }
            }
        }
        return info;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void refresh() {
        assert (!EventQueue.isDispatchThread());
        File root = (File)this.rootRef.get();
        try {
            if (root == null) {
                LOG.log(Level.WARNING, "refresh (): root is null, it has been collected in the meantime");
            } else {
                LOG.log(Level.FINE, "refresh (): starting for {0}", root);
                List<HgLogMessage> parentInfo = HgCommand.getParents(root, null, null);
                this.setParents(parentInfo);
                String branch = HgCommand.getBranch(root);
                this.setBranch(branch);
            }
        }
        catch (HgException.HgCommandCanceledException parentInfo) {
        }
        catch (HgException ex) {
            Level level = root.exists() ? Level.INFO : Level.FINE;
            LOG.log(level, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAsync(File repositoryRoot) {
        WorkingCopyInfo info = null;
        WeakHashMap<File, WorkingCopyInfo> weakHashMap = cache;
        synchronized (weakHashMap) {
            info = cache.get(repositoryRoot);
        }
        if (info != null) {
            boolean start = false;
            Set<WorkingCopyInfo> set = repositoriesToRefresh;
            synchronized (set) {
                start = repositoriesToRefresh.add(info);
            }
            if (start) {
                LOG.log(Level.FINE, "Planning refresh for {0}", repositoryRoot);
                refreshTask.schedule(3000);
            }
        }
    }

    public HgLogMessage[] getWorkingCopyParents() {
        return this.parents;
    }

    public String getCurrentBranch() {
        return this.branch;
    }

    private void setParents(List<HgLogMessage> parents) {
        boolean changed;
        HgLogMessage[] oldParents = this.parents;
        boolean bl = changed = oldParents.length != parents.size();
        if (!changed) {
            for (HgLogMessage newParent : parents) {
                boolean contains = false;
                for (HgLogMessage oldParent : oldParents) {
                    if (!oldParent.getCSetShortID().equals(newParent.getCSetShortID()) || oldParent.getTags().length != newParent.getTags().length || !new HashSet<String>(Arrays.asList(oldParent.getTags())).equals(new HashSet<String>(Arrays.asList(newParent.getTags())))) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            HgLogMessage[] newParents = parents.toArray(new HgLogMessage[0]);
            this.parents = newParents;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_WORKING_COPY_PARENT, oldParents, newParents);
        }
    }

    private void setBranch(String branch) {
        if (branch == null) {
            branch = HgBranch.DEFAULT_NAME;
        }
        String oldBranch = this.branch;
        this.branch = branch;
        if (!oldBranch.equals(this.branch)) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_CURRENT_BRANCH, oldBranch, branch);
        }
    }

    private static class RepositoryRefreshTask
    implements Runnable {
        private RepositoryRefreshTask() {
        }

        @Override
        public void run() {
            WorkingCopyInfo info;
            while ((info = this.getNextRepositoryInfo()) != null) {
                info.refresh();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WorkingCopyInfo getNextRepositoryInfo() {
            WorkingCopyInfo info = null;
            Set set = repositoriesToRefresh;
            synchronized (set) {
                Iterator it = repositoriesToRefresh.iterator();
                if (it.hasNext()) {
                    info = (WorkingCopyInfo)it.next();
                    it.remove();
                }
            }
            return info;
        }
    }
}

