/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.DocTreePathHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.javadoc.hints.Bundle;
import org.netbeans.spi.java.hints.JavaFix;

final class RemoveTagFix
extends JavaFix {
    private String tagName;
    private final DocTreePathHandle dtph;
    private static final Logger LOG = Logger.getLogger(RemoveTagFix.class.getName());

    RemoveTagFix(DocTreePathHandle dtph, String tagName) {
        super(dtph.getTreePathHandle());
        this.dtph = dtph;
        this.tagName = tagName;
    }

    public String getText() {
        return Bundle.REMOVE_TAG_HINT(this.tagName);
    }

    protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
        WorkingCopy javac = ctx.getWorkingCopy();
        DocTreePath path = this.dtph.resolve((CompilationInfo)javac);
        if (path == null) {
            LOG.log(Level.WARNING, "Cannot resolve DocTreePathHandle: {0}", this.dtph);
            return;
        }
        DocCommentTree docComment = path.getDocComment();
        TreeMaker make = javac.getTreeMaker();
        LinkedList<DocTree> blockTags = new LinkedList<DocTree>();
        for (DocTree docTree : docComment.getBlockTags()) {
            if (docTree == path.getLeaf()) continue;
            blockTags.add(docTree);
        }
        DocCommentTree newDoc = make.DocComment(docComment.getFullBody(), blockTags);
        Tree tree = ctx.getPath().getLeaf();
        javac.rewrite(tree, (DocTree)docComment, (DocTree)newDoc);
    }
}

