/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.util;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.css.live.LiveUpdater;
import org.netbeans.modules.css.prep.util.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public final class UiUtils {
    static final RequestProcessor RP = new RequestProcessor(UiUtils.class);

    private UiUtils() {
    }

    public static void showOptions() {
        OptionsDisplayer.getDefault().open("Html5/CssPreprocessors");
    }

    public static void invalidScriptProvided(String message) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        UiUtils.informAndOpenOptions((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    public static void processExecutionException(ExecutionException exc) {
        Parameters.notNull((CharSequence)"exc", (Object)exc);
        final Throwable cause = exc.getCause();
        assert (cause != null);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                UiUtils.informAndOpenOptions((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.UiUtils_running_exception(cause.getLocalizedMessage()), 0));
            }
        });
    }

    public static void refreshCssInBrowser(File cssFile) {
        FileObject fob;
        final LiveUpdater liveUpdater = (LiveUpdater)Lookup.getDefault().lookup(LiveUpdater.class);
        if (liveUpdater != null && (fob = FileUtil.toFileObject((File)cssFile)) != null) {
            try {
                DataObject dob = DataObject.find((FileObject)fob);
                EditorCookie cookie = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                if (cookie != null) {
                    final StyledDocument doc = cookie.openDocument();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RP.post(new Runnable(){

                                @Override
                                public void run() {
                                    liveUpdater.update(doc);
                                }
                            });
                        }
                    });
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void informAndOpenOptions(NotifyDescriptor descriptor) {
        assert (descriptor != null);
        DialogDisplayer.getDefault().notify(descriptor);
        UiUtils.showOptions();
    }
}

