/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (~ ivec4(-64, 72, 88, -76)) => ivec4(63, -73, -89, 75)
 * (~ ivec4(64, 72, 88, 76)) => ivec4(-65, -73, -89, -77)
 * (~ ivec4(-24, 40, -23, 64)) => ivec4(23, -41, 22, -65)
 * (~ ivec4(24, 40, 23, 64)) => ivec4(-25, -41, -24, -65)
 */
#version 130

void main()
{
  float[all(equal((~ ivec4(-64, 72, 88, -76)), ivec4(63, -73, -89, 75))) ? 1 : -1] array0;
  float[all(equal((~ ivec4(64, 72, 88, 76)), ivec4(-65, -73, -89, -77))) ? 1 : -1] array1;
  float[all(equal((~ ivec4(-24, 40, -23, 64)), ivec4(23, -41, 22, -65))) ? 1 : -1] array2;
  float[all(equal((~ ivec4(24, 40, 23, 64)), ivec4(-25, -41, -24, -65))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
