/*
 * Decompiled with CFR 0.152.
 */
package processing.net;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import processing.core.PApplet;
import processing.net.Client;

public class Server
implements Runnable {
    PApplet parent;
    Method serverEventMethod;
    Thread thread;
    ServerSocket server;
    int port;
    public int clientCount;
    public Client[] clients;
    int lastAvailable = -1;

    public Server(PApplet pApplet, int n) {
        this.parent = pApplet;
        this.port = n;
        try {
            this.server = new ServerSocket(this.port);
            this.clients = new Client[10];
            this.thread = new Thread(this);
            this.thread.start();
            pApplet.registerDispose((Object)this);
            try {
                this.serverEventMethod = pApplet.getClass().getMethod("serverEvent", Server.class, Client.class);
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.thread = null;
        }
    }

    public void disconnect(Client client) {
        client.dispose();
        int n = this.clientIndex(client);
        if (n != -1) {
            this.removeIndex(n);
        }
    }

    protected void removeIndex(int n) {
        --this.clientCount;
        for (int i = n; i < this.clientCount; ++i) {
            this.clients[i] = this.clients[i + 1];
        }
        this.clients[this.clientCount] = null;
    }

    protected void addClient(Client client) {
        if (this.clientCount == this.clients.length) {
            this.clients = (Client[])PApplet.expand((Object)this.clients);
        }
        this.clients[this.clientCount++] = client;
    }

    protected int clientIndex(Client client) {
        for (int i = 0; i < this.clientCount; ++i) {
            if (this.clients[i] != client) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client available() {
        Client[] clientArray = this.clients;
        synchronized (this.clients) {
            int n = this.lastAvailable + 1;
            if (n >= this.clientCount) {
                n = 0;
            }
            for (int i = 0; i < this.clientCount; ++i) {
                int n2 = (n + i) % this.clientCount;
                Client client = this.clients[n2];
                if (client.available() <= 0) continue;
                this.lastAvailable = n2;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return client;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void stop() {
        this.dispose();
    }

    public void dispose() {
        try {
            this.thread = null;
            if (this.clients != null) {
                for (int i = 0; i < this.clientCount; ++i) {
                    this.disconnect(this.clients[i]);
                }
                this.clientCount = 0;
                this.clients = null;
            }
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (Thread.currentThread() == this.thread) {
            try {
                Socket socket = this.server.accept();
                Client client = new Client(this.parent, socket);
                Client[] clientArray = this.clients;
                // MONITORENTER : this.clients
                this.addClient(client);
                if (this.serverEventMethod != null) {
                    try {
                        this.serverEventMethod.invoke((Object)this.parent, this, client);
                    }
                    catch (Exception exception) {
                        System.err.println("Disabling serverEvent() for port " + this.port);
                        exception.printStackTrace();
                        this.serverEventMethod = null;
                    }
                }
                // MONITOREXIT : clientArray
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.thread = null;
            }
            try {
                Thread.sleep(8L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void write(int n) {
        int n2 = 0;
        while (n2 < this.clientCount) {
            this.clients[n2].write(n);
            if (this.clients[n2].active()) {
                ++n2;
                continue;
            }
            this.removeIndex(n2);
        }
    }

    public void write(byte[] byArray) {
        int n = 0;
        while (n < this.clientCount) {
            this.clients[n].write(byArray);
            if (this.clients[n].active()) {
                ++n;
                continue;
            }
            this.removeIndex(n);
        }
    }

    public void write(String string) {
        int n = 0;
        while (n < this.clientCount) {
            this.clients[n].write(string);
            if (this.clients[n].active()) {
                ++n;
                continue;
            }
            this.removeIndex(n);
        }
    }
}

