/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.toolbar;

import com.projectlibre1.grouping.core.transform.CommonTransformFactory;
import com.projectlibre1.grouping.core.transform.TransformList;
import com.projectlibre1.grouping.core.transform.ViewConfiguration;
import com.projectlibre1.grouping.core.transform.ViewTransformer;
import com.projectlibre1.strings.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class TransformComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    public static final int FILTER = 1;
    public static final int SORTER = 2;
    public static final int GROUPER = 3;
    protected int type;
    protected String stype;
    protected TransformList transformList;
    protected CommonTransformFactory selected;
    protected ViewConfiguration view;
    protected Map viewMap = new HashMap();
    private String tipText;
    protected List factories = null;

    public TransformComboBoxModel(int n) {
        this.type = n;
        switch (n) {
            case 2: {
                this.stype = "user_sorters";
                this.tipText = Messages.getString("Text.Sort");
                break;
            }
            case 3: {
                this.stype = "user_groupers";
                this.tipText = Messages.getString("Text.Group");
                break;
            }
            default: {
                this.stype = "user_filters";
                this.tipText = Messages.getString("Text.Filter");
            }
        }
        this.transformList = TransformList.getInstance(this.stype);
    }

    public void setView(ViewConfiguration viewConfiguration) {
        int n;
        if (viewConfiguration == null) {
            return;
        }
        int n2 = this.getSize() - 1;
        if (n2 >= 0) {
            this.fireIntervalRemoved(this, 0, n2);
        }
        this.view = viewConfiguration;
        this.factories = this.transformList.getFactories(viewConfiguration, this.stype);
        this.selected = (CommonTransformFactory)this.viewMap.get(viewConfiguration);
        if (this.selected == null) {
            ViewTransformer viewTransformer = viewConfiguration.getTransform();
            switch (this.type) {
                case 2: {
                    this.selected = this.transformList.getFactory(viewTransformer.getUserSorterId());
                    break;
                }
                case 3: {
                    this.selected = this.transformList.getFactory(viewTransformer.getUserGrouperId());
                    break;
                }
                default: {
                    this.selected = this.transformList.getFactory(viewTransformer.getUserFilterId());
                }
            }
            this.viewMap.put(viewConfiguration, this.selected);
        }
        if ((n = this.getSize() - 1) >= 0) {
            this.fireIntervalAdded(this, 0, n);
        }
    }

    public ViewConfiguration getView() {
        return this.view;
    }

    public void changeTransform(CommonTransformFactory commonTransformFactory) {
        if (this.view == null) {
            return;
        }
        ViewTransformer viewTransformer = this.view.getTransform();
        switch (this.type) {
            case 2: {
                viewTransformer.setUserSorterId(commonTransformFactory.getId());
                break;
            }
            case 3: {
                viewTransformer.setUserGrouperId(commonTransformFactory.getId());
                break;
            }
            default: {
                viewTransformer.setUserFilterId(commonTransformFactory.getId());
            }
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selected = (CommonTransformFactory)object;
        this.viewMap.put(this.view, this.selected);
    }

    @Override
    public int getSize() {
        if (this.factories == null) {
            return 0;
        }
        return this.factories.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.factories.get(n);
    }

    final String getTipText() {
        return this.tipText;
    }
}

