/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.tok;

import com.thaiopensource.xml.tok.ContentToken;
import com.thaiopensource.xml.tok.EmptyTokenException;
import com.thaiopensource.xml.tok.EndOfPrologException;
import com.thaiopensource.xml.tok.ExtensibleTokenException;
import com.thaiopensource.xml.tok.InvalidTokenException;
import com.thaiopensource.xml.tok.PartialCharException;
import com.thaiopensource.xml.tok.PartialTokenException;
import com.thaiopensource.xml.tok.Position;
import com.thaiopensource.xml.tok.Token;

public class Tokenizer {
    public static final int TOK_DATA_CHARS = 0;
    public static final int TOK_DATA_NEWLINE = 1;
    public static final int TOK_START_TAG_NO_ATTS = 2;
    public static final int TOK_START_TAG_WITH_ATTS = 3;
    public static final int TOK_EMPTY_ELEMENT_NO_ATTS = 4;
    public static final int TOK_EMPTY_ELEMENT_WITH_ATTS = 5;
    public static final int TOK_END_TAG = 6;
    public static final int TOK_CDATA_SECT_OPEN = 7;
    public static final int TOK_CDATA_SECT_CLOSE = 8;
    public static final int TOK_ENTITY_REF = 9;
    public static final int TOK_MAGIC_ENTITY_REF = 10;
    public static final int TOK_CHAR_REF = 11;
    public static final int TOK_CHAR_PAIR_REF = 12;
    public static final int TOK_PI = 13;
    public static final int TOK_XML_DECL = 14;
    public static final int TOK_COMMENT = 15;
    public static final int TOK_ATTRIBUTE_VALUE_S = 16;
    public static final int TOK_PARAM_ENTITY_REF = 17;
    public static final int TOK_PROLOG_S = 18;
    public static final int TOK_DECL_OPEN = 19;
    public static final int TOK_DECL_CLOSE = 20;
    public static final int TOK_NAME = 21;
    public static final int TOK_PREFIXED_NAME = 22;
    public static final int TOK_NMTOKEN = 23;
    public static final int TOK_POUND_NAME = 24;
    public static final int TOK_OR = 25;
    public static final int TOK_PERCENT = 26;
    public static final int TOK_OPEN_PAREN = 27;
    public static final int TOK_CLOSE_PAREN = 28;
    public static final int TOK_OPEN_BRACKET = 29;
    public static final int TOK_CLOSE_BRACKET = 30;
    public static final int TOK_LITERAL = 31;
    public static final int TOK_NAME_QUESTION = 32;
    public static final int TOK_NAME_ASTERISK = 33;
    public static final int TOK_NAME_PLUS = 34;
    public static final int TOK_COND_SECT_OPEN = 35;
    public static final int TOK_COND_SECT_CLOSE = 36;
    public static final int TOK_CLOSE_PAREN_QUESTION = 37;
    public static final int TOK_CLOSE_PAREN_ASTERISK = 38;
    public static final int TOK_CLOSE_PAREN_PLUS = 39;
    public static final int TOK_COMMA = 40;
    static final int CT_LEAD2 = -2;
    static final int CT_NONXML = -3;
    static final int CT_MALFORM = -4;
    static final int CT_LT = -5;
    static final int CT_AMP = -6;
    static final int CT_RSQB = -7;
    static final int CT_CR = -8;
    static final int CT_LF = -9;
    static final int CT_GT = 0;
    static final int CT_QUOT = 1;
    static final int CT_APOS = 2;
    static final int CT_EQUALS = 3;
    static final int CT_QUEST = 4;
    static final int CT_EXCL = 5;
    static final int CT_SOL = 6;
    static final int CT_SEMI = 7;
    static final int CT_NUM = 8;
    static final int CT_LSQB = 9;
    static final int CT_S = 10;
    static final int CT_NMSTRT = 11;
    static final int CT_COLON = 12;
    static final int CT_NAME = 13;
    static final int CT_MINUS = 14;
    static final int CT_OTHER = 15;
    static final int CT_PERCNT = 16;
    static final int CT_LPAR = 17;
    static final int CT_RPAR = 18;
    static final int CT_AST = 19;
    static final int CT_PLUS = 20;
    static final int CT_COMMA = 21;
    static final int CT_VERBAR = 22;
    static final byte[] asciiTypeTable = new byte[]{-3, -3, -3, -3, -3, -3, -3, -3, -3, 10, -9, -3, -3, -8, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, 10, 5, 1, 8, 15, 16, -6, 2, 17, 18, 19, 20, 21, 14, 13, 6, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 12, 7, -5, 3, 0, 4, 15, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 9, 15, -7, 15, 11, 15, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 15, 22, 15, 15, 15};
    private static final String CDATA = "CDATA[";
    private static final String nameStartSingles = ":_\u0386\u038c\u03da\u03dc\u03de\u03e0\u0559\u06d5\u093d\u09b2\u0a5e\u0a8d\u0abd\u0ae0\u0b3d\u0b9c\u0cde\u0e30\u0e84\u0e8a\u0e8d\u0ea5\u0ea7\u0eb0\u0ebd\u1100\u1109\u113c\u113e\u1140\u114c\u114e\u1150\u1159\u1163\u1165\u1167\u1169\u1175\u119e\u11a8\u11ab\u11ba\u11eb\u11f0\u11f9\u1f59\u1f5b\u1f5d\u1fbe\u2126\u212e\u3007";
    private static final String nameStartRanges = "AZaz\u00c0\u00d6\u00d8\u00f6\u00f8\u00ff\u0100\u0131\u0134\u013e\u0141\u0148\u014a\u017e\u0180\u01c3\u01cd\u01f0\u01f4\u01f5\u01fa\u0217\u0250\u02a8\u02bb\u02c1\u0388\u038a\u038e\u03a1\u03a3\u03ce\u03d0\u03d6\u03e2\u03f3\u0401\u040c\u040e\u044f\u0451\u045c\u045e\u0481\u0490\u04c4\u04c7\u04c8\u04cb\u04cc\u04d0\u04eb\u04ee\u04f5\u04f8\u04f9\u0531\u0556\u0561\u0586\u05d0\u05ea\u05f0\u05f2\u0621\u063a\u0641\u064a\u0671\u06b7\u06ba\u06be\u06c0\u06ce\u06d0\u06d3\u06e5\u06e6\u0905\u0939\u0958\u0961\u0985\u098c\u098f\u0990\u0993\u09a8\u09aa\u09b0\u09b6\u09b9\u09dc\u09dd\u09df\u09e1\u09f0\u09f1\u0a05\u0a0a\u0a0f\u0a10\u0a13\u0a28\u0a2a\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59\u0a5c\u0a72\u0a74\u0a85\u0a8b\u0a8f\u0a91\u0a93\u0aa8\u0aaa\u0ab0\u0ab2\u0ab3\u0ab5\u0ab9\u0b05\u0b0c\u0b0f\u0b10\u0b13\u0b28\u0b2a\u0b30\u0b32\u0b33\u0b36\u0b39\u0b5c\u0b5d\u0b5f\u0b61\u0b85\u0b8a\u0b8e\u0b90\u0b92\u0b95\u0b99\u0b9a\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8\u0baa\u0bae\u0bb5\u0bb7\u0bb9\u0c05\u0c0c\u0c0e\u0c10\u0c12\u0c28\u0c2a\u0c33\u0c35\u0c39\u0c60\u0c61\u0c85\u0c8c\u0c8e\u0c90\u0c92\u0ca8\u0caa\u0cb3\u0cb5\u0cb9\u0ce0\u0ce1\u0d05\u0d0c\u0d0e\u0d10\u0d12\u0d28\u0d2a\u0d39\u0d60\u0d61\u0e01\u0e2e\u0e32\u0e33\u0e40\u0e45\u0e81\u0e82\u0e87\u0e88\u0e94\u0e97\u0e99\u0e9f\u0ea1\u0ea3\u0eaa\u0eab\u0ead\u0eae\u0eb2\u0eb3\u0ec0\u0ec4\u0f40\u0f47\u0f49\u0f69\u10a0\u10c5\u10d0\u10f6\u1102\u1103\u1105\u1107\u110b\u110c\u110e\u1112\u1154\u1155\u115f\u1161\u116d\u116e\u1172\u1173\u11ae\u11af\u11b7\u11b8\u11bc\u11c2\u1e00\u1e9b\u1ea0\u1ef9\u1f00\u1f15\u1f18\u1f1d\u1f20\u1f45\u1f48\u1f4d\u1f50\u1f57\u1f5f\u1f7d\u1f80\u1fb4\u1fb6\u1fbc\u1fc2\u1fc4\u1fc6\u1fcc\u1fd0\u1fd3\u1fd6\u1fdb\u1fe0\u1fec\u1ff2\u1ff4\u1ff6\u1ffc\u212a\u212b\u2180\u2182\u3041\u3094\u30a1\u30fa\u3105\u312c\uac00\ud7a3\u4e00\u9fa5\u3021\u3029";
    private static final String nameSingles = "-.\u05bf\u05c4\u0670\u093c\u094d\u09bc\u09be\u09bf\u09d7\u0a02\u0a3c\u0a3e\u0a3f\u0abc\u0b3c\u0bd7\u0d57\u0e31\u0eb1\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f97\u0fb9\u20e1\u3099\u309a\u00b7\u02d0\u02d1\u0387\u0640\u0e46\u0ec6\u3005";
    private static final String nameRanges = "\u0300\u0345\u0360\u0361\u0483\u0486\u0591\u05a1\u05a3\u05b9\u05bb\u05bd\u05c1\u05c2\u064b\u0652\u06d6\u06dc\u06dd\u06df\u06e0\u06e4\u06e7\u06e8\u06ea\u06ed\u0901\u0903\u093e\u094c\u0951\u0954\u0962\u0963\u0981\u0983\u09c0\u09c4\u09c7\u09c8\u09cb\u09cd\u09e2\u09e3\u0a40\u0a42\u0a47\u0a48\u0a4b\u0a4d\u0a70\u0a71\u0a81\u0a83\u0abe\u0ac5\u0ac7\u0ac9\u0acb\u0acd\u0b01\u0b03\u0b3e\u0b43\u0b47\u0b48\u0b4b\u0b4d\u0b56\u0b57\u0b82\u0b83\u0bbe\u0bc2\u0bc6\u0bc8\u0bca\u0bcd\u0c01\u0c03\u0c3e\u0c44\u0c46\u0c48\u0c4a\u0c4d\u0c55\u0c56\u0c82\u0c83\u0cbe\u0cc4\u0cc6\u0cc8\u0cca\u0ccd\u0cd5\u0cd6\u0d02\u0d03\u0d3e\u0d43\u0d46\u0d48\u0d4a\u0d4d\u0e34\u0e3a\u0e47\u0e4e\u0eb4\u0eb9\u0ebb\u0ebc\u0ec8\u0ecd\u0f18\u0f19\u0f71\u0f84\u0f86\u0f8b\u0f90\u0f95\u0f99\u0fad\u0fb1\u0fb7\u20d0\u20dc\u302a\u302f09\u0660\u0669\u06f0\u06f9\u0966\u096f\u09e6\u09ef\u0a66\u0a6f\u0ae6\u0aef\u0b66\u0b6f\u0be7\u0bef\u0c66\u0c6f\u0ce6\u0cef\u0d66\u0d6f\u0e50\u0e59\u0ed0\u0ed9\u0f20\u0f29\u3031\u3035\u309d\u309e\u30fc\u30fe";
    private static final byte[][] charTypeTable = new byte[256][];

    public static void movePosition(char[] cArray, int n, int n2, Position position) {
        int n3 = position.lineNumber;
        int n4 = n - position.columnNumber;
        while (n != n2) {
            switch (cArray[n++]) {
                case '\n': {
                    ++n3;
                    n4 = n;
                    break;
                }
                case '\r': {
                    if (n == n2 || cArray[n] == '\n') {
                        // empty if block
                    }
                    ++n3;
                    n4 = ++n;
                }
            }
        }
        position.lineNumber = n3;
        position.columnNumber = n - n4;
    }

    private static void checkCharMatches(char[] cArray, int n, char c) throws InvalidTokenException {
        if (cArray[n] != c) {
            throw new InvalidTokenException(n);
        }
    }

    private static int scanComment(char[] cArray, int n, int n2, Token token) throws InvalidTokenException, PartialTokenException {
        if (n != n2) {
            Tokenizer.checkCharMatches(cArray, n, '-');
            ++n;
            block5: while (n != n2) {
                switch (Tokenizer.charType(cArray[n])) {
                    case -2: {
                        if (n2 - n < 2) {
                            throw new PartialCharException(n);
                        }
                        Tokenizer.check2(cArray, n);
                        n += 2;
                        break;
                    }
                    case -4: 
                    case -3: {
                        throw new InvalidTokenException(n);
                    }
                    case 14: {
                        if (++n == n2) {
                            throw new PartialTokenException();
                        }
                        if (cArray[n] != '-') continue block5;
                        if (++n == n2) {
                            throw new PartialTokenException();
                        }
                        Tokenizer.checkCharMatches(cArray, n, '>');
                        token.tokenEnd = n + 1;
                        return 15;
                    }
                    default: {
                        ++n;
                    }
                }
            }
        }
        throw new PartialTokenException();
    }

    /*
     * Unable to fully structure code
     */
    private static int scanDecl(char[] var0, int var1_1, int var2_2, Token var3_3) throws InvalidTokenException, PartialTokenException {
        if (var1_1 == var2_2) {
            throw new PartialTokenException();
        }
        switch (Tokenizer.charType(var0[var1_1])) {
            case 14: {
                return Tokenizer.scanComment(var0, var1_1 + 1, var2_2, var3_3);
            }
            case 9: {
                var3_3.tokenEnd = var1_1 + 1;
                return 35;
            }
            case 11: {
                ++var1_1;
                if (true) ** GOTO lbl30
            }
            default: {
                throw new InvalidTokenException(var1_1);
            }
        }
        do {
            switch (Tokenizer.charType(var0[var1_1])) {
                case 16: {
                    if (var1_1 + 1 == var2_2) {
                        throw new PartialTokenException();
                    }
                    switch (Tokenizer.charType(var0[var1_1 + 1])) {
                        case -9: 
                        case -8: 
                        case 10: 
                        case 16: {
                            throw new InvalidTokenException(var1_1);
                        }
                    }
                }
                case -9: 
                case -8: 
                case 10: {
                    var3_3.tokenEnd = var1_1;
                    return 19;
                }
                case 11: {
                    ++var1_1;
                    break;
                }
                default: {
                    throw new InvalidTokenException(var1_1);
                }
            }
lbl30:
            // 2 sources

        } while (var1_1 != var2_2);
        throw new PartialTokenException();
    }

    private static boolean targetIsXml(char[] cArray, int n, int n2) throws InvalidTokenException {
        boolean bl = false;
        if (n2 - n != 3) {
            return false;
        }
        switch (cArray[n]) {
            case 'x': {
                break;
            }
            case 'X': {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        switch (cArray[++n]) {
            case 'm': {
                break;
            }
            case 'M': {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        switch (cArray[++n]) {
            case 'l': {
                break;
            }
            case 'L': {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        if (bl) {
            throw new InvalidTokenException(n, 1);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static int scanPi(char[] var0, int var1_1, int var2_2, Token var3_3) throws PartialTokenException, InvalidTokenException {
        var4_4 = var1_1;
        if (var1_1 == var2_2) {
            throw new PartialTokenException();
        }
        switch (Tokenizer.charType(var0[var1_1])) {
            case 11: {
                ++var1_1;
                ** GOTO lbl63
            }
            case -2: {
                if (var2_2 - var1_1 < 2) {
                    throw new PartialCharException(var1_1);
                }
                if (Tokenizer.charType2(var0, var1_1) != 11) {
                    throw new InvalidTokenException(var1_1);
                }
                var1_1 += 2;
                if (true) ** GOTO lbl63
            }
            default: {
                throw new InvalidTokenException(var1_1);
            }
        }
        do {
            switch (Tokenizer.charType(var0[var1_1])) {
                case 11: 
                case 13: 
                case 14: {
                    ++var1_1;
                    break;
                }
                case -2: {
                    if (var2_2 - var1_1 < 2) {
                        throw new PartialCharException(var1_1);
                    }
                    if (!Tokenizer.isNameChar2(var0, var1_1)) {
                        throw new InvalidTokenException(var1_1);
                    }
                    var1_1 += 2;
                    break;
                }
                case -9: 
                case -8: 
                case 10: {
                    var5_5 = Tokenizer.targetIsXml(var0, var4_4, var1_1);
                    var3_3.nameEnd = var1_1++;
                    block16: while (var1_1 != var2_2) {
                        switch (Tokenizer.charType(var0[var1_1])) {
                            case -2: {
                                if (var2_2 - var1_1 < 2) {
                                    throw new PartialCharException(var1_1);
                                }
                                Tokenizer.check2(var0, var1_1);
                                var1_1 += 2;
                                break;
                            }
                            case -4: 
                            case -3: {
                                throw new InvalidTokenException(var1_1);
                            }
                            case 4: {
                                if (++var1_1 == var2_2) {
                                    throw new PartialTokenException();
                                }
                                if (var0[var1_1] != '>') continue block16;
                                var3_3.tokenEnd = var1_1 + 1;
                                if (var5_5) {
                                    return 14;
                                }
                                return 13;
                            }
                            default: {
                                ++var1_1;
                            }
                        }
                    }
                    throw new PartialTokenException();
                }
                case 4: {
                    var3_3.nameEnd = var1_1++;
                    if (var1_1 == var2_2) {
                        throw new PartialTokenException();
                    }
                    Tokenizer.checkCharMatches(var0, var1_1, '>');
                    var3_3.tokenEnd = var1_1 + 1;
                    return Tokenizer.targetIsXml(var0, var4_4, var3_3.nameEnd) != false ? 14 : 13;
                }
                default: {
                    throw new InvalidTokenException(var1_1);
                }
            }
lbl63:
            // 4 sources

        } while (var1_1 != var2_2);
        throw new PartialTokenException();
    }

    private static int scanCdataSection(char[] cArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException {
        if (n2 - n < 6) {
            throw new PartialTokenException();
        }
        int n3 = 0;
        while (n3 < CDATA.length()) {
            Tokenizer.checkCharMatches(cArray, n, CDATA.charAt(n3));
            ++n3;
            ++n;
        }
        token.tokenEnd = n;
        return 7;
    }

    public static int tokenizeCdataSection(char[] cArray, int n, int n2, Token token) throws EmptyTokenException, PartialTokenException, InvalidTokenException, ExtensibleTokenException {
        if (n == n2) {
            throw new EmptyTokenException();
        }
        switch (Tokenizer.charType(cArray[n])) {
            case -7: {
                if (++n == n2) {
                    throw new PartialTokenException();
                }
                if (cArray[n] != ']') break;
                if (++n == n2) {
                    throw new PartialTokenException();
                }
                if (cArray[n] != '>') {
                    --n;
                    break;
                }
                token.tokenEnd = n + 1;
                return 8;
            }
            case -8: {
                if (++n == n2) {
                    throw new ExtensibleTokenException(1);
                }
                if (Tokenizer.charType(cArray[n]) == -9) {
                    ++n;
                }
                token.tokenEnd = n;
                return 1;
            }
            case -9: {
                token.tokenEnd = n + 1;
                return 1;
            }
            case -4: 
            case -3: {
                throw new InvalidTokenException(n);
            }
            case -2: {
                if (n2 - n < 2) {
                    throw new PartialCharException(n);
                }
                Tokenizer.check2(cArray, n);
                n += 2;
                break;
            }
            default: {
                ++n;
            }
        }
        token.tokenEnd = Tokenizer.extendCdata(cArray, n, n2);
        return 0;
    }

    private static int extendCdata(char[] cArray, int n, int n2) throws InvalidTokenException {
        while (n != n2) {
            switch (Tokenizer.charType(cArray[n])) {
                case -2: {
                    if (n2 - n < 2) {
                        return n;
                    }
                    Tokenizer.check2(cArray, n);
                    n += 2;
                    break;
                }
                case -9: 
                case -8: 
                case -7: 
                case -4: 
                case -3: {
                    return n;
                }
                default: {
                    ++n;
                }
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private static int scanEndTag(char[] var0, int var1_1, int var2_2, Token var3_3) throws PartialTokenException, InvalidTokenException {
        if (var1_1 == var2_2) {
            throw new PartialTokenException();
        }
        switch (Tokenizer.charType(var0[var1_1])) {
            case 11: {
                ++var1_1;
                ** GOTO lbl48
            }
            case -2: {
                if (var2_2 - var1_1 < 2) {
                    throw new PartialCharException(var1_1);
                }
                if (Tokenizer.charType2(var0, var1_1) != 11) {
                    throw new InvalidTokenException(var1_1);
                }
                var1_1 += 2;
                if (true) ** GOTO lbl48
            }
            default: {
                throw new InvalidTokenException(var1_1);
            }
        }
        do {
            switch (Tokenizer.charType(var0[var1_1])) {
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    ++var1_1;
                    break;
                }
                case -2: {
                    if (var2_2 - var1_1 < 2) {
                        throw new PartialCharException(var1_1);
                    }
                    if (!Tokenizer.isNameChar2(var0, var1_1)) {
                        throw new InvalidTokenException(var1_1);
                    }
                    var1_1 += 2;
                    break;
                }
                case -9: 
                case -8: 
                case 10: {
                    var3_3.nameEnd = var1_1++;
                    while (var1_1 != var2_2) {
                        switch (Tokenizer.charType(var0[var1_1])) {
                            case -9: 
                            case -8: 
                            case 10: {
                                break;
                            }
                            case 0: {
                                var3_3.tokenEnd = var1_1 + 1;
                                return 6;
                            }
                            default: {
                                throw new InvalidTokenException(var1_1);
                            }
                        }
                        ++var1_1;
                    }
                    throw new PartialTokenException();
                }
                case 0: {
                    var3_3.nameEnd = var1_1;
                    var3_3.tokenEnd = var1_1 + 1;
                    return 6;
                }
                default: {
                    throw new InvalidTokenException(var1_1);
                }
            }
lbl48:
            // 4 sources

        } while (var1_1 != var2_2);
        throw new PartialTokenException();
    }

    private static int scanHexCharRef(char[] cArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException {
        if (n != n2) {
            int n3;
            char c = cArray[n];
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n3 = c - 48;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    n3 = c - 55;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    n3 = c - 87;
                    break;
                }
                default: {
                    throw new InvalidTokenException(n);
                }
            }
            ++n;
            while (n != n2) {
                c = cArray[n];
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n3 = (n3 << 4) + c - 48;
                        break;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        n3 = (n3 << 4) + c - 55;
                        break;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        n3 = (n3 << 4) + c - 87;
                        break;
                    }
                    case ';': {
                        token.tokenEnd = n + 1;
                        return Tokenizer.setRefChar(n3, token);
                    }
                    default: {
                        throw new InvalidTokenException(n);
                    }
                }
                if (n3 >= 0x110000) {
                    throw new InvalidTokenException(n);
                }
                ++n;
            }
        }
        throw new PartialTokenException();
    }

    private static int scanCharRef(char[] cArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException {
        if (n != n2) {
            char c = cArray[n];
            switch (c) {
                case 'x': {
                    return Tokenizer.scanHexCharRef(cArray, n + 1, n2, token);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    throw new InvalidTokenException(n);
                }
            }
            int n3 = c - 48;
            ++n;
            while (n != n2) {
                c = cArray[n];
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n3 = n3 * 10 + (c - 48);
                        if (n3 < 0x110000) break;
                    }
                    default: {
                        throw new InvalidTokenException(n);
                    }
                    case ';': {
                        token.tokenEnd = n + 1;
                        return Tokenizer.setRefChar(n3, token);
                    }
                }
                ++n;
            }
        }
        throw new PartialTokenException();
    }

    private static int setRefChar(int n, Token token) throws InvalidTokenException {
        if (n < 65536) {
            switch (charTypeTable[n >> 8][n & 0xFF]) {
                case -4: 
                case -3: 
                case -2: {
                    throw new InvalidTokenException(token.tokenEnd - 1);
                }
            }
            token.refChar1 = (char)n;
            return 11;
        }
        token.refChar1 = (char)(((n -= 65536) >> 10) + 55296);
        token.refChar2 = (char)((n & 0x3FF) + 56320);
        return 12;
    }

    private static boolean isMagicEntityRef(char[] cArray, int n, int n2, Token token) {
        switch (cArray[n]) {
            case 'a': {
                if (n2 - n < 4) break;
                switch (cArray[n + 1]) {
                    case 'm': {
                        if (cArray[n + 2] != 'p' || cArray[n + 3] != ';') break;
                        token.tokenEnd = n + 4;
                        token.refChar1 = (char)38;
                        return true;
                    }
                    case 'p': {
                        if (n2 - n < 5 || cArray[n + 2] != 'o' || cArray[n + 3] != 's' || cArray[n + 4] != ';') break;
                        token.tokenEnd = n + 5;
                        token.refChar1 = (char)39;
                        return true;
                    }
                }
                break;
            }
            case 'l': {
                if (n2 - n < 3 || cArray[n + 1] != 't' || cArray[n + 2] != ';') break;
                token.tokenEnd = n + 3;
                token.refChar1 = (char)60;
                return true;
            }
            case 'g': {
                if (n2 - n < 3 || cArray[n + 1] != 't' || cArray[n + 2] != ';') break;
                token.tokenEnd = n + 3;
                token.refChar1 = (char)62;
                return true;
            }
            case 'q': {
                if (n2 - n < 5 || cArray[n + 1] != 'u' || cArray[n + 2] != 'o' || cArray[n + 3] != 't' || cArray[n + 4] != ';') break;
                token.tokenEnd = n + 5;
                token.refChar1 = (char)34;
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static int scanRef(char[] var0, int var1_1, int var2_2, Token var3_3) throws PartialTokenException, InvalidTokenException {
        if (var1_1 == var2_2) {
            throw new PartialTokenException();
        }
        if (Tokenizer.isMagicEntityRef(var0, var1_1, var2_2, var3_3)) {
            return 10;
        }
        switch (Tokenizer.charType(var0[var1_1])) {
            case 11: {
                ++var1_1;
                ** GOTO lbl38
            }
            case -2: {
                if (var2_2 - var1_1 < 2) {
                    throw new PartialCharException(var1_1);
                }
                if (Tokenizer.charType2(var0, var1_1) != 11) {
                    throw new InvalidTokenException(var1_1);
                }
                var1_1 += 2;
                if (true) ** GOTO lbl38
            }
            case 8: {
                return Tokenizer.scanCharRef(var0, var1_1 + 1, var2_2, var3_3);
            }
            default: {
                throw new InvalidTokenException(var1_1);
            }
        }
        do {
            switch (Tokenizer.charType(var0[var1_1])) {
                case 11: 
                case 13: 
                case 14: {
                    ++var1_1;
                    break;
                }
                case -2: {
                    if (var2_2 - var1_1 < 2) {
                        throw new PartialCharException(var1_1);
                    }
                    if (!Tokenizer.isNameChar2(var0, var1_1)) {
                        throw new InvalidTokenException(var1_1);
                    }
                    var1_1 += 2;
                    break;
                }
                case 7: {
                    var3_3.nameEnd = var1_1;
                    var3_3.tokenEnd = var1_1 + 1;
                    return 9;
                }
                default: {
                    throw new InvalidTokenException(var1_1);
                }
            }
lbl38:
            // 4 sources

        } while (var1_1 != var2_2);
        throw new PartialTokenException();
    }

    /*
     * Unable to fully structure code
     */
    private static int scanAtts(int var0, char[] var1_1, int var2_2, int var3_3, ContentToken var4_4) throws PartialTokenException, InvalidTokenException {
        var5_5 = false;
        var6_6 = -1;
        while (var2_2 != var3_3) {
            block0 : switch (Tokenizer.charType(var1_1[var2_2])) {
                case 11: 
                case 13: 
                case 14: {
                    ++var2_2;
                    break;
                }
                case 12: {
                    if (var5_5) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var5_5 = true;
                    if (++var2_2 == var3_3) {
                        throw new PartialTokenException();
                    }
                    switch (Tokenizer.charType(var1_1[var2_2])) {
                        case 11: {
                            ++var2_2;
                            break block0;
                        }
                        case -2: {
                            if (var3_3 - var2_2 < 2) {
                                throw new PartialCharException(var2_2);
                            }
                            if (Tokenizer.charType2(var1_1, var2_2) != 11) {
                                throw new InvalidTokenException(var2_2);
                            }
                            var2_2 += 2;
                            break block0;
                        }
                    }
                    throw new InvalidTokenException(var2_2);
                }
                case -2: {
                    if (var3_3 - var2_2 < 2) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!Tokenizer.isNameChar2(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 2;
                    break;
                }
                case -9: 
                case -8: 
                case 10: {
                    var6_6 = var2_2;
                    block38: while (true) {
                        if (++var2_2 == var3_3) {
                            throw new PartialTokenException();
                        }
                        switch (Tokenizer.charType(var1_1[var2_2])) {
                            case 3: {
                                break block38;
                            }
                            case -9: 
                            case -8: 
                            case 10: {
                                continue block38;
                            }
                            default: {
                                throw new InvalidTokenException(var2_2);
                            }
                        }
                        break;
                    }
                }
                case 3: {
                    if (var6_6 < 0) {
                        var6_6 = var2_2;
                    }
                    var5_5 = false;
                    block39: while (true) {
                        if (++var2_2 == var3_3) {
                            throw new PartialTokenException();
                        }
                        var7_7 = Tokenizer.charType(var1_1[var2_2]);
                        if (var7_7 == 1 || var7_7 == 2) ** GOTO lbl58
                        switch (var7_7) {
                            case -9: 
                            case -8: 
                            case 10: {
                                continue block39;
                            }
                        }
                        break;
                    }
                    throw new InvalidTokenException(var2_2);
lbl58:
                    // 1 sources

                    var8_8 = ++var2_2;
                    var9_9 = true;
                    block40: while (true) {
                        if (var2_2 == var3_3) {
                            throw new PartialTokenException();
                        }
                        var10_10 = Tokenizer.charType(var1_1[var2_2]);
                        if (var10_10 == var7_7) break;
                        switch (var10_10) {
                            case -4: 
                            case -3: {
                                throw new InvalidTokenException(var2_2);
                            }
                            case -2: {
                                if (var3_3 - var2_2 < 2) {
                                    throw new PartialCharException(var2_2);
                                }
                                Tokenizer.check2(var1_1, var2_2);
                                var2_2 += 2;
                                continue block40;
                            }
                            case -6: {
                                var9_9 = false;
                                var11_11 = var4_4.nameEnd;
                                Tokenizer.scanRef(var1_1, var2_2 + 1, var3_3, var4_4);
                                var4_4.nameEnd = var11_11;
                                var2_2 = var4_4.tokenEnd;
                                continue block40;
                            }
                            case 10: {
                                if (var9_9 && (var2_2 == var8_8 || var1_1[var2_2] != ' ' || var2_2 + 1 != var3_3 && (var1_1[var2_2 + 1] == ' ' || Tokenizer.charType(var1_1[var2_2 + 1]) == var7_7))) {
                                    var9_9 = false;
                                }
                                ++var2_2;
                                continue block40;
                            }
                            case -5: {
                                throw new InvalidTokenException(var2_2);
                            }
                            case -9: 
                            case -8: {
                                var9_9 = false;
                            }
                        }
                        ++var2_2;
                    }
                    var4_4.appendAttribute(var0, var6_6, var8_8, var2_2, var9_9);
                    if (++var2_2 == var3_3) {
                        throw new PartialTokenException();
                    }
                    var10_10 = Tokenizer.charType(var1_1[var2_2]);
                    switch (var10_10) {
                        case -9: 
                        case -8: 
                        case 10: {
                            if (++var2_2 == var3_3) {
                                throw new PartialTokenException();
                            }
                            var10_10 = Tokenizer.charType(var1_1[var2_2]);
                            break;
                        }
                        case 0: 
                        case 6: {
                            break;
                        }
                        default: {
                            throw new InvalidTokenException(var2_2);
                        }
                    }
                    block41: while (true) {
                        switch (var10_10) {
                            case 11: {
                                var0 = var2_2++;
                                break block41;
                            }
                            case -2: {
                                if (var3_3 - var2_2 < 2) {
                                    throw new PartialCharException(var2_2);
                                }
                                if (Tokenizer.charType2(var1_1, var2_2) != 11) {
                                    throw new InvalidTokenException(var2_2);
                                }
                                var0 = var2_2;
                                var2_2 += 2;
                                break block41;
                            }
                            case -9: 
                            case -8: 
                            case 10: {
                                break;
                            }
                            case 0: {
                                var4_4.checkAttributeUniqueness(var1_1);
                                var4_4.tokenEnd = var2_2 + 1;
                                return 3;
                            }
                            case 6: {
                                if (++var2_2 == var3_3) {
                                    throw new PartialTokenException();
                                }
                                Tokenizer.checkCharMatches(var1_1, var2_2, '>');
                                var4_4.checkAttributeUniqueness(var1_1);
                                var4_4.tokenEnd = var2_2 + 1;
                                return 5;
                            }
                            default: {
                                throw new InvalidTokenException(var2_2);
                            }
                        }
                        if (++var2_2 == var3_3) {
                            throw new PartialTokenException();
                        }
                        var10_10 = Tokenizer.charType(var1_1[var2_2]);
                    }
                    var6_6 = -1;
                    break;
                }
                default: {
                    throw new InvalidTokenException(var2_2);
                }
            }
        }
        throw new PartialTokenException();
    }

    private static int scanLt(char[] cArray, int n, int n2, ContentToken contentToken) throws PartialTokenException, InvalidTokenException {
        if (n == n2) {
            throw new PartialTokenException();
        }
        switch (Tokenizer.charType(cArray[n])) {
            case 11: {
                ++n;
                break;
            }
            case -2: {
                if (n2 - n < 2) {
                    throw new PartialCharException(n);
                }
                if (Tokenizer.charType2(cArray, n) != 11) {
                    throw new InvalidTokenException(n);
                }
                n += 2;
                break;
            }
            case 5: {
                if (++n == n2) {
                    throw new PartialTokenException();
                }
                switch (Tokenizer.charType(cArray[n])) {
                    case 14: {
                        return Tokenizer.scanComment(cArray, n + 1, n2, contentToken);
                    }
                    case 9: {
                        return Tokenizer.scanCdataSection(cArray, n + 1, n2, contentToken);
                    }
                }
                throw new InvalidTokenException(n);
            }
            case 4: {
                return Tokenizer.scanPi(cArray, n + 1, n2, contentToken);
            }
            case 6: {
                return Tokenizer.scanEndTag(cArray, n + 1, n2, contentToken);
            }
            default: {
                throw new InvalidTokenException(n);
            }
        }
        boolean bl = false;
        contentToken.nameEnd = -1;
        contentToken.clearAttributes();
        while (n != n2) {
            block11 : switch (Tokenizer.charType(cArray[n])) {
                case 11: 
                case 13: 
                case 14: {
                    ++n;
                    break;
                }
                case -2: {
                    if (n2 - n < 2) {
                        throw new PartialCharException(n);
                    }
                    if (!Tokenizer.isNameChar2(cArray, n)) {
                        throw new InvalidTokenException(n);
                    }
                    n += 2;
                    break;
                }
                case 12: {
                    if (bl) {
                        throw new InvalidTokenException(n);
                    }
                    bl = true;
                    if (++n == n2) {
                        throw new PartialTokenException();
                    }
                    switch (Tokenizer.charType(cArray[n])) {
                        case 11: {
                            ++n;
                            break block11;
                        }
                        case -2: {
                            if (n2 - n < 2) {
                                throw new PartialCharException(n);
                            }
                            if (Tokenizer.charType2(cArray, n) != 11) {
                                throw new InvalidTokenException(n);
                            }
                            n += 2;
                            break block11;
                        }
                    }
                    throw new InvalidTokenException(n);
                }
                case -9: 
                case -8: 
                case 10: {
                    contentToken.nameEnd = n++;
                    block30: while (true) {
                        if (n == n2) {
                            throw new PartialTokenException();
                        }
                        switch (Tokenizer.charType(cArray[n])) {
                            case 11: {
                                return Tokenizer.scanAtts(n, cArray, n + 1, n2, contentToken);
                            }
                            case -2: {
                                if (n2 - n < 2) {
                                    throw new PartialCharException(n);
                                }
                                if (Tokenizer.charType2(cArray, n) != 11) {
                                    throw new InvalidTokenException(n);
                                }
                                return Tokenizer.scanAtts(n, cArray, n + 2, n2, contentToken);
                            }
                            case 0: 
                            case 6: {
                                break block11;
                            }
                            case -9: 
                            case -8: 
                            case 10: {
                                ++n;
                                continue block30;
                            }
                        }
                        break;
                    }
                    throw new InvalidTokenException(n);
                }
                case 0: {
                    if (contentToken.nameEnd < 0) {
                        contentToken.nameEnd = n;
                    }
                    contentToken.tokenEnd = n + 1;
                    return 2;
                }
                case 6: {
                    if (contentToken.nameEnd < 0) {
                        contentToken.nameEnd = n;
                    }
                    if (++n == n2) {
                        throw new PartialTokenException();
                    }
                    Tokenizer.checkCharMatches(cArray, n, '>');
                    contentToken.tokenEnd = n + 1;
                    return 4;
                }
                default: {
                    throw new InvalidTokenException(n);
                }
            }
        }
        throw new PartialTokenException();
    }

    public static int tokenizeContent(char[] cArray, int n, int n2, ContentToken contentToken) throws PartialTokenException, InvalidTokenException, EmptyTokenException, ExtensibleTokenException {
        if (n == n2) {
            throw new EmptyTokenException();
        }
        switch (Tokenizer.charType(cArray[n])) {
            case -5: {
                return Tokenizer.scanLt(cArray, n + 1, n2, contentToken);
            }
            case -6: {
                return Tokenizer.scanRef(cArray, n + 1, n2, contentToken);
            }
            case -8: {
                if (++n == n2) {
                    throw new ExtensibleTokenException(1);
                }
                if (Tokenizer.charType(cArray[n]) == -9) {
                    ++n;
                }
                contentToken.tokenEnd = n;
                return 1;
            }
            case -9: {
                contentToken.tokenEnd = n + 1;
                return 1;
            }
            case -7: {
                if (++n == n2) {
                    throw new ExtensibleTokenException(0);
                }
                if (cArray[n] != ']') break;
                if (++n == n2) {
                    throw new ExtensibleTokenException(0);
                }
                if (cArray[n] != '>') {
                    --n;
                    break;
                }
                throw new InvalidTokenException(n);
            }
            case -4: 
            case -3: {
                throw new InvalidTokenException(n);
            }
            case -2: {
                if (n2 - n < 2) {
                    throw new PartialCharException(n);
                }
                Tokenizer.check2(cArray, n);
                n += 2;
                break;
            }
            default: {
                ++n;
            }
        }
        contentToken.tokenEnd = Tokenizer.extendData(cArray, n, n2);
        return 0;
    }

    private static int extendData(char[] cArray, int n, int n2) throws InvalidTokenException {
        while (n != n2) {
            switch (Tokenizer.charType(cArray[n])) {
                case -2: {
                    if (n2 - n < 2) {
                        return n;
                    }
                    Tokenizer.check2(cArray, n);
                    n += 2;
                    break;
                }
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: {
                    return n;
                }
                default: {
                    ++n;
                }
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private static int scanPercent(char[] var0, int var1_1, int var2_2, Token var3_3) throws PartialTokenException, InvalidTokenException {
        if (var1_1 == var2_2) {
            throw new PartialTokenException();
        }
        switch (Tokenizer.charType(var0[var1_1])) {
            case 11: {
                ++var1_1;
                ** GOTO lbl37
            }
            case -2: {
                if (var2_2 - var1_1 < 2) {
                    throw new PartialCharException(var1_1);
                }
                if (Tokenizer.charType2(var0, var1_1) != 11) {
                    throw new InvalidTokenException(var1_1);
                }
                var1_1 += 2;
                if (true) ** GOTO lbl37
            }
            case -9: 
            case -8: 
            case 10: 
            case 16: {
                var3_3.tokenEnd = var1_1;
                return 26;
            }
            default: {
                throw new InvalidTokenException(var1_1);
            }
        }
        do {
            switch (Tokenizer.charType(var0[var1_1])) {
                case 11: 
                case 13: 
                case 14: {
                    ++var1_1;
                    break;
                }
                case -2: {
                    if (var2_2 - var1_1 < 2) {
                        throw new PartialCharException(var1_1);
                    }
                    if (!Tokenizer.isNameChar2(var0, var1_1)) {
                        throw new InvalidTokenException(var1_1);
                    }
                    var1_1 += 2;
                    break;
                }
                case 7: {
                    var3_3.nameEnd = var1_1;
                    var3_3.tokenEnd = var1_1 + 1;
                    return 17;
                }
                default: {
                    throw new InvalidTokenException(var1_1);
                }
            }
lbl37:
            // 4 sources

        } while (var1_1 != var2_2);
        throw new PartialTokenException();
    }

    /*
     * Unable to fully structure code
     */
    private static int scanPoundName(char[] var0, int var1_1, int var2_2, Token var3_3) throws PartialTokenException, InvalidTokenException, ExtensibleTokenException {
        if (var1_1 == var2_2) {
            throw new PartialTokenException();
        }
        switch (Tokenizer.charType(var0[var1_1])) {
            case 11: {
                ++var1_1;
                ** GOTO lbl33
            }
            case -2: {
                if (var2_2 - var1_1 < 2) {
                    throw new PartialCharException(var1_1);
                }
                if (Tokenizer.charType2(var0, var1_1) != 11) {
                    throw new InvalidTokenException(var1_1);
                }
                var1_1 += 2;
                if (true) ** GOTO lbl33
            }
            default: {
                throw new InvalidTokenException(var1_1);
            }
        }
        do {
            switch (Tokenizer.charType(var0[var1_1])) {
                case 11: 
                case 13: 
                case 14: {
                    ++var1_1;
                    break;
                }
                case -2: {
                    if (var2_2 - var1_1 < 2) {
                        throw new PartialCharException(var1_1);
                    }
                    if (!Tokenizer.isNameChar2(var0, var1_1)) {
                        throw new InvalidTokenException(var1_1);
                    }
                    var1_1 += 2;
                    break;
                }
                case -9: 
                case -8: 
                case 0: 
                case 10: 
                case 16: 
                case 18: 
                case 22: {
                    var3_3.tokenEnd = var1_1;
                    return 24;
                }
                default: {
                    throw new InvalidTokenException(var1_1);
                }
            }
lbl33:
            // 4 sources

        } while (var1_1 != var2_2);
        throw new ExtensibleTokenException(24);
    }

    private static int scanLit(int n, char[] cArray, int n2, int n3, Token token) throws PartialTokenException, InvalidTokenException, ExtensibleTokenException {
        block8: while (n2 != n3) {
            int n4 = Tokenizer.charType(cArray[n2]);
            switch (n4) {
                case -2: {
                    if (n3 - n2 < 2) {
                        throw new PartialTokenException();
                    }
                    Tokenizer.check2(cArray, n2);
                    n2 += 2;
                    break;
                }
                case -4: 
                case -3: {
                    throw new InvalidTokenException(n2);
                }
                case 1: 
                case 2: {
                    ++n2;
                    if (n4 != n) continue block8;
                    if (n2 == n3) {
                        throw new ExtensibleTokenException(31);
                    }
                    switch (Tokenizer.charType(cArray[n2])) {
                        case -9: 
                        case -8: 
                        case 0: 
                        case 9: 
                        case 10: 
                        case 16: {
                            token.tokenEnd = n2;
                            return 31;
                        }
                    }
                    throw new InvalidTokenException(n2);
                }
                default: {
                    ++n2;
                }
            }
        }
        throw new PartialTokenException();
    }

    /*
     * Unable to fully structure code
     */
    public static int tokenizeProlog(char[] var0, int var1_1, int var2_2, Token var3_3) throws PartialTokenException, InvalidTokenException, EmptyTokenException, ExtensibleTokenException, EndOfPrologException {
        if (var1_1 == var2_2) {
            throw new EmptyTokenException();
        }
        switch (Tokenizer.charType(var0[var1_1])) {
            case 1: {
                return Tokenizer.scanLit(1, var0, var1_1 + 1, var2_2, var3_3);
            }
            case 2: {
                return Tokenizer.scanLit(2, var0, var1_1 + 1, var2_2, var3_3);
            }
            case -5: {
                if (++var1_1 == var2_2) {
                    throw new PartialTokenException();
                }
                switch (Tokenizer.charType(var0[var1_1])) {
                    case 5: {
                        return Tokenizer.scanDecl(var0, var1_1 + 1, var2_2, var3_3);
                    }
                    case 4: {
                        return Tokenizer.scanPi(var0, var1_1 + 1, var2_2, var3_3);
                    }
                    case -2: 
                    case 11: {
                        var3_3.tokenEnd = var1_1 - 1;
                        throw new EndOfPrologException();
                    }
                }
                throw new InvalidTokenException(var1_1);
            }
            case -8: {
                if (++var1_1 == var2_2) {
                    throw new ExtensibleTokenException(18);
                }
                if (Tokenizer.charType(var0[var1_1]) == -9) {
                    ++var1_1;
                }
                var3_3.tokenEnd = var1_1;
                return 18;
            }
            case -9: 
            case 10: {
                var3_3.tokenEnd = var1_1 + 1;
                return 18;
            }
            case 16: {
                return Tokenizer.scanPercent(var0, var1_1 + 1, var2_2, var3_3);
            }
            case 21: {
                var3_3.tokenEnd = var1_1 + 1;
                return 40;
            }
            case 9: {
                var3_3.tokenEnd = var1_1 + 1;
                return 29;
            }
            case -7: {
                if (++var1_1 == var2_2) {
                    throw new ExtensibleTokenException(30);
                }
                if (var0[var1_1] == ']') {
                    if (var1_1 + 1 == var2_2) {
                        throw new PartialTokenException();
                    }
                    if (var0[var1_1 + 1] == '>') {
                        var3_3.tokenEnd = var1_1 + 2;
                        return 36;
                    }
                }
                var3_3.tokenEnd = var1_1;
                return 30;
            }
            case 17: {
                var3_3.tokenEnd = var1_1 + 1;
                return 27;
            }
            case 18: {
                if (++var1_1 == var2_2) {
                    throw new ExtensibleTokenException(28);
                }
                switch (Tokenizer.charType(var0[var1_1])) {
                    case 19: {
                        var3_3.tokenEnd = var1_1 + 1;
                        return 38;
                    }
                    case 4: {
                        var3_3.tokenEnd = var1_1 + 1;
                        return 37;
                    }
                    case 20: {
                        var3_3.tokenEnd = var1_1 + 1;
                        return 39;
                    }
                    case -9: 
                    case -8: 
                    case 0: 
                    case 10: 
                    case 18: 
                    case 21: 
                    case 22: {
                        var3_3.tokenEnd = var1_1;
                        return 28;
                    }
                }
                throw new InvalidTokenException(var1_1);
            }
            case 22: {
                var3_3.tokenEnd = var1_1 + 1;
                return 25;
            }
            case 0: {
                var3_3.tokenEnd = var1_1 + 1;
                return 20;
            }
            case 8: {
                return Tokenizer.scanPoundName(var0, var1_1 + 1, var2_2, var3_3);
            }
            case -2: {
                if (var2_2 - var1_1 < 2) {
                    throw new PartialCharException(var1_1);
                }
                switch (Tokenizer.charType2(var0, var1_1)) {
                    case 11: {
                        var1_1 += 2;
                        var4_4 = 21;
                        ** GOTO lbl156
                    }
                    case 13: {
                        var1_1 += 2;
                        var4_4 = 23;
                        ** GOTO lbl156
                    }
                    default: {
                        throw new InvalidTokenException(var1_1);
                    }
                }
            }
            case 11: {
                var4_4 = 21;
                ++var1_1;
                ** GOTO lbl156
            }
            case 12: 
            case 13: 
            case 14: {
                var4_4 = 23;
                ++var1_1;
                if (true) ** GOTO lbl156
            }
            default: {
                throw new InvalidTokenException(var1_1);
            }
        }
        block51: do {
            switch (Tokenizer.charType(var0[var1_1])) {
                case 11: 
                case 13: 
                case 14: {
                    ++var1_1;
                    break;
                }
                case -2: {
                    if (var2_2 - var1_1 < 2) {
                        throw new PartialCharException(var1_1);
                    }
                    if (!Tokenizer.isNameChar2(var0, var1_1)) {
                        throw new InvalidTokenException(var1_1);
                    }
                    var1_1 += 2;
                    break;
                }
                case -9: 
                case -8: 
                case 0: 
                case 9: 
                case 10: 
                case 16: 
                case 18: 
                case 21: 
                case 22: {
                    var3_3.tokenEnd = var1_1;
                    return var4_4;
                }
                case 12: {
                    ++var1_1;
                    block43 : switch (var4_4) {
                        case 21: {
                            if (var1_1 == var2_2) {
                                throw new PartialCharException(var1_1);
                            }
                            var4_4 = 22;
                            switch (Tokenizer.charType(var0[var1_1])) {
                                case 11: {
                                    ++var1_1;
                                    break block43;
                                }
                                case -2: {
                                    if (var2_2 - var1_1 < 2) {
                                        throw new PartialCharException(var1_1);
                                    }
                                    if (!Tokenizer.isNameChar2(var0, var1_1)) break;
                                    var1_1 += 2;
                                    break block43;
                                }
                            }
                            var4_4 = 23;
                            break;
                        }
                        case 22: {
                            var4_4 = 23;
                        }
                    }
                    continue block51;
                }
                case 20: {
                    if (var4_4 == 23) {
                        throw new InvalidTokenException(var1_1);
                    }
                    var3_3.tokenEnd = var1_1 + 1;
                    return 34;
                }
                case 19: {
                    if (var4_4 == 23) {
                        throw new InvalidTokenException(var1_1);
                    }
                    var3_3.tokenEnd = var1_1 + 1;
                    return 33;
                }
                case 4: {
                    if (var4_4 == 23) {
                        throw new InvalidTokenException(var1_1);
                    }
                    var3_3.tokenEnd = var1_1 + 1;
                    return 32;
                }
                default: {
                    throw new InvalidTokenException(var1_1);
                }
            }
lbl156:
            // 7 sources

        } while (var1_1 != var2_2);
        throw new ExtensibleTokenException(var4_4);
    }

    public static int tokenizeAttributeValue(char[] cArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException, EmptyTokenException, ExtensibleTokenException {
        if (n == n2) {
            throw new EmptyTokenException();
        }
        int n3 = n;
        while (n != n2) {
            switch (Tokenizer.charType(cArray[n])) {
                case -2: {
                    if (n2 - n < 2) {
                        throw new PartialCharException(n);
                    }
                    n += 2;
                    break;
                }
                case -6: {
                    if (n == n3) {
                        return Tokenizer.scanRef(cArray, n + 1, n2, token);
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -5: {
                    throw new InvalidTokenException(n);
                }
                case 10: {
                    if (n == n3) {
                        token.tokenEnd = n + 1;
                        return 16;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -9: {
                    if (n == n3) {
                        token.tokenEnd = n + 1;
                        return 1;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -8: {
                    if (n == n3) {
                        if (++n == n2) {
                            throw new ExtensibleTokenException(1);
                        }
                        if (Tokenizer.charType(cArray[n]) == -9) {
                            ++n;
                        }
                        token.tokenEnd = n;
                        return 1;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                default: {
                    ++n;
                }
            }
        }
        token.tokenEnd = n;
        return 0;
    }

    public static int tokenizeEntityValue(char[] cArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException, EmptyTokenException, ExtensibleTokenException {
        if (n == n2) {
            throw new EmptyTokenException();
        }
        int n3 = n;
        while (n != n2) {
            switch (Tokenizer.charType(cArray[n])) {
                case -2: {
                    if (n2 - n < 2) {
                        throw new PartialCharException(n);
                    }
                    n += 2;
                    break;
                }
                case -6: {
                    if (n == n3) {
                        return Tokenizer.scanRef(cArray, n + 1, n2, token);
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case 16: {
                    if (n == n3) {
                        int n4 = Tokenizer.scanPercent(cArray, n + 1, n2, token);
                        if (n4 == 26) {
                            throw new InvalidTokenException(n + 1);
                        }
                        return n4;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -9: {
                    if (n == n3) {
                        token.tokenEnd = n + 1;
                        return 1;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -8: {
                    if (n == n3) {
                        if (++n == n2) {
                            throw new ExtensibleTokenException(1);
                        }
                        if (Tokenizer.charType(cArray[n]) == -9) {
                            ++n;
                        }
                        token.tokenEnd = n;
                        return 1;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                default: {
                    ++n;
                }
            }
        }
        token.tokenEnd = n;
        return 0;
    }

    public static int skipIgnoreSect(char[] cArray, int n, int n2) throws PartialTokenException, InvalidTokenException {
        int n3 = 0;
        block6: while (n != n2) {
            switch (Tokenizer.charType(cArray[n])) {
                case -2: {
                    if (n2 - n < 2) {
                        throw new PartialCharException(n);
                    }
                    Tokenizer.check2(cArray, n);
                    n += 2;
                    break;
                }
                case -4: 
                case -3: {
                    throw new InvalidTokenException(n);
                }
                case -5: {
                    if (++n == n2) break block6;
                    if (cArray[n] != '!') continue block6;
                    if (++n == n2) break block6;
                    if (cArray[n] != '[') continue block6;
                    ++n3;
                    ++n;
                    break;
                }
                case -7: {
                    if (++n == n2) break block6;
                    if (cArray[n] != ']') continue block6;
                    if (++n == n2) break block6;
                    if (cArray[n] == '>') {
                        if (n3 == 0) {
                            return n + 1;
                        }
                        --n3;
                    } else if (cArray[n] == ']') continue block6;
                    ++n;
                    break;
                }
                default: {
                    ++n;
                }
            }
        }
        throw new PartialTokenException();
    }

    public static String getPublicId(char[] cArray, int n, int n2) throws InvalidTokenException {
        StringBuffer stringBuffer = new StringBuffer();
        ++n;
        --n2;
        while (n != n2) {
            char c = cArray[n];
            block0 : switch (Tokenizer.charType(cArray[n])) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    stringBuffer.append(c);
                    break;
                }
                case 10: {
                    if (cArray[n] == '\t') {
                        throw new InvalidTokenException(n);
                    }
                }
                case -9: 
                case -8: {
                    if (stringBuffer.length() <= 0 || stringBuffer.charAt(stringBuffer.length() - 1) == ' ') break;
                    stringBuffer.append(' ');
                    break;
                }
                case 11: 
                case 13: {
                    if ((c & 0xFFFFFF80) == 0) {
                        stringBuffer.append(c);
                        break;
                    }
                }
                default: {
                    switch (c) {
                        case '$': 
                        case '@': {
                            break block0;
                        }
                    }
                    throw new InvalidTokenException(n);
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static boolean matchesXMLString(char[] cArray, int n, int n2, String string) {
        int n3 = string.length();
        if (n3 != n2 - n) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (cArray[n] != string.charAt(n4)) {
                return false;
            }
            ++n;
            ++n4;
        }
        return true;
    }

    public static int skipS(char[] cArray, int n, int n2) {
        block3: while (n < n2) {
            switch (Tokenizer.charType(cArray[n])) {
                case -9: 
                case -8: 
                case 10: {
                    ++n;
                    break;
                }
                default: {
                    break block3;
                }
            }
        }
        return n;
    }

    private static boolean isNameChar2(char[] cArray, int n) {
        int n2 = Tokenizer.charType2(cArray, n);
        return n2 == 13 || n2 == 11;
    }

    private static void setCharType(char c, int n) {
        if (c < '\u0080') {
            return;
        }
        int n2 = c >> 8;
        if (charTypeTable[n2] == null) {
            Tokenizer.charTypeTable[n2] = new byte[256];
            int n3 = 0;
            while (n3 < 256) {
                Tokenizer.charTypeTable[n2][n3] = 15;
                ++n3;
            }
        }
        Tokenizer.charTypeTable[n2][c & 0xFF] = (byte)n;
    }

    private static void setCharType(char c, char c2, int n) {
        char c3;
        byte[] byArray = null;
        do {
            if ((c & 0xFF) == 0) {
                while (c + 255 <= c2) {
                    if (byArray == null) {
                        byArray = new byte[256];
                        int n2 = 0;
                        while (n2 < 256) {
                            byArray[n2] = (byte)n;
                            ++n2;
                        }
                    }
                    Tokenizer.charTypeTable[c >> 8] = byArray;
                    if (c + 255 == c2) {
                        return;
                    }
                    c = (char)(c + 256);
                }
            }
            Tokenizer.setCharType(c, n);
            c3 = c;
            c = (char)(c + '\u0001');
        } while (c3 != c2);
    }

    static int charType(char c) {
        return charTypeTable[c >> 8][c & 0xFF];
    }

    private static int charType2(char[] cArray, int n) {
        return 15;
    }

    private static void check2(char[] cArray, int n) throws InvalidTokenException {
    }

    static {
        int n = 0;
        while (n < nameSingles.length()) {
            Tokenizer.setCharType(nameSingles.charAt(n), 13);
            ++n;
        }
        int n2 = 0;
        while (n2 < nameRanges.length()) {
            Tokenizer.setCharType(nameRanges.charAt(n2), nameRanges.charAt(n2 + 1), 13);
            n2 += 2;
        }
        int n3 = 0;
        while (n3 < nameStartSingles.length()) {
            Tokenizer.setCharType(nameStartSingles.charAt(n3), 11);
            ++n3;
        }
        int n4 = 0;
        while (n4 < nameStartRanges.length()) {
            Tokenizer.setCharType(nameStartRanges.charAt(n4), nameStartRanges.charAt(n4 + 1), 11);
            n4 += 2;
        }
        Tokenizer.setCharType('\ud800', '\udbff', -2);
        Tokenizer.setCharType('\udc00', '\udfff', -4);
        Tokenizer.setCharType('\ufffe', '\uffff', -3);
        byte[] byArray = new byte[256];
        int n5 = 0;
        while (n5 < 256) {
            byArray[n5] = 15;
            ++n5;
        }
        int n6 = 0;
        while (n6 < 256) {
            if (charTypeTable[n6] == null) {
                Tokenizer.charTypeTable[n6] = byArray;
            }
            ++n6;
        }
        System.arraycopy(asciiTypeTable, 0, charTypeTable[0], 0, 128);
    }
}

