/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.CharMatcher;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IJSwingUtilities;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.actions.CommandQueueForPythonConsoleService;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import java.awt.Component;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyConsoleUtil {
    public static final String ORDINARY_PROMPT = ">>>";
    public static final String INPUT_PROMPT = ">?";
    public static final String INDENT_PROMPT = "...";
    public static final String IPYTHON_INDENT_PROMPT = "...:";
    public static final String HELP_PROMPT = "help>";
    public static final String EXECUTING_PROMPT = "";
    private static final String IPYTHON_PAGING_PROMPT = "---Return to continue, q to quit---";
    @NonNls
    public static final String ASYNCIO_REPL_ENV = "ASYNCIO_REPL";
    private static final String[] PROMPTS = new String[]{">>>", "...", "help>", "---Return to continue, q to quit---"};
    public static final Key<PythonConsoleData> PYTHON_CONSOLE_DATA = Key.create((String)"python-console-data");

    private PyConsoleUtil() {
    }

    public static boolean isPagingPrompt(@Nullable String prompt) {
        return prompt != null && IPYTHON_PAGING_PROMPT.equals(prompt.trim());
    }

    static String processPrompts(LanguageConsoleView languageConsole, String string) {
        for (String prompt : PROMPTS) {
            if (!string.startsWith(prompt)) continue;
            if (!Strings.areSameInstance((String)prompt, (String)HELP_PROMPT)) {
                StringBuilder builder = new StringBuilder();
                builder.append(prompt).append(prompt);
                while (string.startsWith(builder.toString())) {
                    builder.append(prompt);
                }
                String multiPrompt = builder.substring(prompt.length());
                if (Strings.areSameInstance((String)prompt, (String)INDENT_PROMPT)) {
                    prompt = multiPrompt;
                }
                string = string.substring(multiPrompt.length());
            } else {
                string = string.substring(prompt.length());
            }
            String currentPrompt = languageConsole.getPrompt();
            String trimmedPrompt = prompt.trim();
            if (currentPrompt == null || currentPrompt.equals(trimmedPrompt)) break;
            languageConsole.setPrompt(trimmedPrompt);
            PyConsoleUtil.scrollDown((Editor)languageConsole.getConsoleEditor());
            break;
        }
        return string;
    }

    public static void scrollDown(Editor currentEditor) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!currentEditor.isDisposed()) {
                currentEditor.getCaretModel().moveToOffset(currentEditor.getDocument().getTextLength());
            }
        });
    }

    public static boolean detectIPythonImported(@NotNull String text, ConsoleViewContentType outputType) {
        if (text == null) {
            PyConsoleUtil.$$$reportNull$$$0(0);
        }
        return text.contains("PyDev console: using IPython ");
    }

    public static boolean detectSourcePrinting(@NotNull String text) {
        if (text == null) {
            PyConsoleUtil.$$$reportNull$$$0(1);
        }
        return text.contains("Source:");
    }

    public static boolean detectIPythonStart(@NotNull String text) {
        if (text == null) {
            PyConsoleUtil.$$$reportNull$$$0(2);
        }
        return text.contains("IPython-->");
    }

    public static boolean detectIPythonEnd(@NotNull String text) {
        if (text == null) {
            PyConsoleUtil.$$$reportNull$$$0(3);
        }
        return text.contains("<--IPython");
    }

    public static boolean detectIPythonAutomagicOn(@NotNull String text) {
        if (text == null) {
            PyConsoleUtil.$$$reportNull$$$0(4);
        }
        return text.contains("Automagic is ON, % prefix NOT needed for magic functions.");
    }

    public static boolean detectIPythonAutomagicOff(@NotNull String text) {
        if (text == null) {
            PyConsoleUtil.$$$reportNull$$$0(5);
        }
        return text.contains("Automagic is OFF, % prefix IS needed for magic functions.");
    }

    public static void markIPython(@NotNull VirtualFile file) {
        if (file == null) {
            PyConsoleUtil.$$$reportNull$$$0(6);
        }
        PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        consoleData.setIPythonEnabled(true);
    }

    @NotNull
    public static PythonConsoleData getOrCreateIPythonData(@NotNull VirtualFile file) {
        PythonConsoleData consoleData;
        if (file == null) {
            PyConsoleUtil.$$$reportNull$$$0(7);
        }
        if ((consoleData = (PythonConsoleData)file.getUserData(PYTHON_CONSOLE_DATA)) == null) {
            consoleData = new PythonConsoleData();
            file.putUserData(PYTHON_CONSOLE_DATA, (Object)consoleData);
        }
        PythonConsoleData pythonConsoleData = consoleData;
        if (pythonConsoleData == null) {
            PyConsoleUtil.$$$reportNull$$$0(8);
        }
        return pythonConsoleData;
    }

    public static void setIPythonAutomagic(@NotNull VirtualFile file, boolean detected) {
        if (file == null) {
            PyConsoleUtil.$$$reportNull$$$0(9);
        }
        PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        consoleData.setIPythonAutomagic(detected);
    }

    public static void setCurrentIndentSize(@NotNull VirtualFile file, int indentSize) {
        if (file == null) {
            PyConsoleUtil.$$$reportNull$$$0(10);
        }
        PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        consoleData.setIndentSize(indentSize);
    }

    public static AnAction createTabCompletionAction(final PythonConsoleView consoleView) {
        AnAction runCompletions = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                EditorEx editor2;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LookupManager.getActiveLookup((Editor)(editor2 = consoleView.getConsoleEditor())) != null) {
                    AnAction replace = ActionManager.getInstance().getAction("EditorChooseLookupItemReplace");
                    ActionUtil.performAction((AnAction)replace, (AnActionEvent)e);
                    return;
                }
                AnAction completionAction = ActionManager.getInstance().getAction("CodeCompletion");
                if (completionAction != null) {
                    ActionUtil.performAction((AnAction)completionAction, (AnActionEvent)e);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                e.getPresentation().setVisible(false);
                EditorEx editor2 = consoleView.getConsoleEditor();
                if (LookupManager.getActiveLookup((Editor)editor2) != null) {
                    e.getPresentation().setEnabled(false);
                }
                int offset = editor2.getCaretModel().getOffset();
                Document document = editor2.getDocument();
                int lineStart = document.getLineStartOffset(document.getLineNumber(offset));
                String textToCursor = document.getText(new TextRange(lineStart, offset));
                e.getPresentation().setEnabled(!CharMatcher.whitespace().matchesAllOf((CharSequence)textToCursor));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/console/PyConsoleUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        runCompletions.registerCustomShortcutSet(9, 0, consoleView.getConsoleEditor().getComponent());
        return runCompletions;
    }

    public static AnAction createInterruptAction(final PythonConsoleView consoleView) {
        AnAction anAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ConsoleCommunication consoleCommunication;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((consoleCommunication = consoleView.getExecuteActionHandler().getConsoleCommunication()).isExecuting() || consoleCommunication.isWaitingForInput()) {
                    consoleView.print("^C", ProcessOutputTypes.SYSTEM);
                    consoleCommunication.interrupt();
                } else {
                    DocumentEx document = consoleView.getConsoleEditor().getDocument();
                    if (document.getTextLength() != 0) {
                        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> document.deleteString(0, document.getLineEndOffset(document.getLineCount() - 1))));
                    }
                }
            }

            public void update(@NotNull AnActionEvent e) {
                EditorEx historyViewer;
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setVisible(false);
                boolean enabled = false;
                EditorEx consoleEditor = consoleView.getConsoleEditor();
                if (IJSwingUtilities.hasFocus((Component)consoleEditor.getComponent())) {
                    boolean bl = enabled = !consoleEditor.getSelectionModel().hasSelection();
                }
                if (IJSwingUtilities.hasFocus((Component)(historyViewer = consoleView.getHistoryViewer()).getComponent())) {
                    enabled = !historyViewer.getSelectionModel().hasSelection();
                }
                e.getPresentation().setEnabled(enabled);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/console/PyConsoleUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        anAction.registerCustomShortcutSet(67, 128, consoleView.getConsoleEditor().getComponent());
        anAction.registerCustomShortcutSet(67, 128, consoleView.getHistoryViewer().getComponent());
        return anAction;
    }

    public static AnAction createScrollToEndAction(@NotNull Editor editor2) {
        if (editor2 == null) {
            PyConsoleUtil.$$$reportNull$$$0(11);
        }
        return new ScrollToTheEndToolbarAction(editor2);
    }

    @NotNull
    private static AnActionEvent createActionEvent(@NotNull AnActionEvent e, @NotNull PythonConsoleView consoleView) {
        if (e == null) {
            PyConsoleUtil.$$$reportNull$$$0(12);
        }
        if (consoleView == null) {
            PyConsoleUtil.$$$reportNull$$$0(13);
        }
        DataContext dataContext = SimpleDataContext.builder().setParent(e.getDataContext()).add(CommonDataKeys.EDITOR, (Object)consoleView.getEditor()).build();
        AnActionEvent anActionEvent = e.withDataContext(dataContext);
        if (anActionEvent == null) {
            PyConsoleUtil.$$$reportNull$$$0(14);
        }
        return anActionEvent;
    }

    public static AnAction createPrintAction(final PythonConsoleView consoleView) {
        final AnAction printAction = ActionManager.getInstance().getAction("Print");
        return new DumbAwareAction(){
            {
                ActionUtil.copyFrom((AnAction)this, (String)"Print");
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                printAction.update(PyConsoleUtil.createActionEvent(e, consoleView));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                printAction.actionPerformed(PyConsoleUtil.createActionEvent(e, consoleView));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/console/PyConsoleUtil$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static boolean isCommandQueueEnabled(Project project) {
        return PyConsoleOptions.getInstance(project).isCommandQueueEnabled();
    }

    public static boolean isCommandQueueEmpty(@Nullable ConsoleCommunication communication) {
        if (communication != null) {
            return ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).isEmpty(communication);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PyConsoleUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIPythonData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonImported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "detectSourcePrinting";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonStart";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonEnd";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonAutomagicOn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonAutomagicOff";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markIPython";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateIPythonData";
                break;
            }
            case 8: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIPythonAutomagic";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentIndentSize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createScrollToEndAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createActionEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 14 -> new IllegalStateException(string);
        };
    }
}

