/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.pathValidation;

import com.intellij.execution.Platform;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.pathValidation.PlatformAndRoot;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B1\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0019\u0010\u0010\u001a\u0015\u0012\u0004\u0012\u00020\u0012\u0012\u000b\u0012\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00130\u0011H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/pathValidation/ValidationRequest;", "", "path", "", "fieldIsEmpty", "platformAndRoot", "Lcom/jetbrains/python/pathValidation/PlatformAndRoot;", "component", "Ljavax/swing/JComponent;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/python/pathValidation/PlatformAndRoot;Ljavax/swing/JComponent;)V", "getPath$intellij_python_sdk", "()Ljava/lang/String;", "getFieldIsEmpty", "validate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getMessage", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Lorg/jetbrains/annotations/Nls;", "validate$intellij_python_sdk", "isAbsolutePath", "", "intellij.python.sdk"})
@SourceDebugExtension(value={"SMAP\nPathValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathValidator.kt\ncom/jetbrains/python/pathValidation/ValidationRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class ValidationRequest {
    @Nullable
    private final String path;
    @NotNull
    private final String fieldIsEmpty;
    @NotNull
    private final PlatformAndRoot platformAndRoot;
    @Nullable
    private final JComponent component;

    public ValidationRequest(@NonNls @Nullable String path2, @Nls @NotNull String fieldIsEmpty, @NotNull PlatformAndRoot platformAndRoot, @Nullable JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)fieldIsEmpty, (String)"fieldIsEmpty");
        Intrinsics.checkNotNullParameter((Object)platformAndRoot, (String)"platformAndRoot");
        this.path = path2;
        this.fieldIsEmpty = fieldIsEmpty;
        this.platformAndRoot = platformAndRoot;
        this.component = component2;
    }

    public /* synthetic */ ValidationRequest(String string, String string2, PlatformAndRoot platformAndRoot, JComponent jComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string3 = PySdkBundle.message("path.validation.field.empty", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            string2 = string3;
        }
        if ((n & 8) != 0) {
            jComponent = null;
        }
        this(string, string2, platformAndRoot, jComponent);
    }

    @Nullable
    public final String getPath$intellij_python_sdk() {
        return this.path;
    }

    @NotNull
    public final String getFieldIsEmpty() {
        return this.fieldIsEmpty;
    }

    @Nullable
    public final ValidationInfo validate$intellij_python_sdk(@NotNull Function1<? super Path, String> getMessage) {
        ValidationInfo validationInfo;
        String message;
        String string;
        Intrinsics.checkNotNullParameter(getMessage, (String)"getMessage");
        CharSequence charSequence = this.path;
        if (charSequence == null || charSequence.length() == 0) {
            string = this.fieldIsEmpty;
        } else if (!this.isAbsolutePath(this.path)) {
            string = PySdkBundle.message("path.validation.must.be.absolute", new Object[0]);
        } else if (StringsKt.endsWith$default((String)this.path, (String)" ", (boolean)false, (int)2, null)) {
            string = PySdkBundle.message("path.validation.ends.with.whitespace", new Object[0]);
        } else {
            Path path2 = this.platformAndRoot.getRoot();
            if (path2 != null) {
                String string2;
                Path it = path2;
                boolean bl = false;
                try {
                    Path nioPath = it.resolve(this.path);
                    Intrinsics.checkNotNull((Object)nioPath);
                    string2 = (String)getMessage.invoke((Object)nioPath);
                }
                catch (InvalidPathException e) {
                    Object[] objectArray = new Object[]{e.getMessage()};
                    string2 = PySdkBundle.message("path.validation.invalid", objectArray);
                }
                catch (IOException e) {
                    Object[] objectArray = new Object[]{e.getMessage()};
                    string2 = PySdkBundle.message("path.validation.inaccessible", objectArray);
                }
                string = string2;
            } else {
                string = null;
            }
        }
        String string3 = message = string;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            validationInfo = new ValidationInfo(it, this.component);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private final boolean isAbsolutePath(String path2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.platformAndRoot.getPlatform().ordinal()]) {
            case 1 -> StringsKt.startsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null);
            case 2 -> {
                if (OSAgnosticPathUtil.isAbsoluteDosPath((String)path2) || StringsKt.startsWith$default((String)path2, (String)"\\\\wsl", (boolean)false, (int)2, null)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Platform.values().length];
            try {
                nArray[Platform.UNIX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.WINDOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

