/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import org.apache.solr.client.api.endpoint.UnloadCoreApi;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UnloadCoreRequestBody;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.TestInjection;

public class UnloadCore
extends CoreAdminAPIBase
implements UnloadCoreApi {
    @Inject
    public UnloadCore(CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, coreAdminAsyncTracker, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public SolrJerseyResponse unloadCore(String coreName, UnloadCoreRequestBody requestBody) throws Exception {
        this.ensureRequiredParameterProvided("coreName", coreName);
        SolrJerseyResponse solrJerseyResponse = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        if (requestBody == null) {
            requestBody = new UnloadCoreRequestBody();
        }
        UnloadCoreRequestBody requestBodyFinal = requestBody;
        return this.handlePotentiallyAsynchronousTask(solrJerseyResponse, coreName, requestBody.async, "unload", () -> {
            CoreDescriptor cdescr = this.coreContainer.getCoreDescriptor(coreName);
            this.coreContainer.unload(coreName, requestBodyFinal.deleteIndex == null ? false : requestBodyFinal.deleteIndex, requestBodyFinal.deleteDataDir == null ? false : requestBodyFinal.deleteDataDir, requestBodyFinal.deleteInstanceDir == null ? false : requestBodyFinal.deleteInstanceDir);
            assert (TestInjection.injectNonExistentCoreExceptionAfterUnload(coreName));
            return solrJerseyResponse;
        });
    }
}

