/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.OutputStreamEncryption;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPublicKeyRecipient;
import com.lowagie.text.pdf.PdfPublicKeySecurityHandler;
import com.lowagie.text.pdf.StandardDecryption;
import com.lowagie.text.pdf.crypto.ARCFOUREncryption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;

public class PdfEncryption {
    public static final int STANDARD_ENCRYPTION_40 = 2;
    public static final int STANDARD_ENCRYPTION_128 = 3;
    public static final int AES_128 = 4;
    private static final byte[] pad = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final byte[] salt = new byte[]{115, 65, 108, 84};
    private static final byte[] metadataPad = new byte[]{-1, -1, -1, -1};
    byte[] key;
    int keySize;
    byte[] mkey;
    byte[] extra = new byte[5];
    MessageDigest md5;
    byte[] ownerKey = new byte[32];
    byte[] userKey = new byte[32];
    protected PdfPublicKeySecurityHandler publicKeyHandler = null;
    int permissions;
    byte[] documentID;
    static long seq = System.currentTimeMillis();
    private int revision;
    private ARCFOUREncryption arcfour = new ARCFOUREncryption();
    private int keyLength;
    private boolean encryptMetadata;
    private boolean embeddedFilesOnly;
    private int cryptoMode;

    public PdfEncryption() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.publicKeyHandler = new PdfPublicKeySecurityHandler();
    }

    public PdfEncryption(PdfEncryption pdfEncryption) {
        this();
        this.mkey = (byte[])pdfEncryption.mkey.clone();
        this.ownerKey = (byte[])pdfEncryption.ownerKey.clone();
        this.userKey = (byte[])pdfEncryption.userKey.clone();
        this.permissions = pdfEncryption.permissions;
        if (pdfEncryption.documentID != null) {
            this.documentID = (byte[])pdfEncryption.documentID.clone();
        }
        this.revision = pdfEncryption.revision;
        this.keyLength = pdfEncryption.keyLength;
        this.encryptMetadata = pdfEncryption.encryptMetadata;
        this.embeddedFilesOnly = pdfEncryption.embeddedFilesOnly;
        this.publicKeyHandler = pdfEncryption.publicKeyHandler;
    }

    public void setCryptoMode(int n, int n2) {
        this.cryptoMode = n;
        this.encryptMetadata = (n & 8) == 0;
        this.embeddedFilesOnly = (n & 0x18) != 0;
        switch (n &= 7) {
            case 0: {
                this.encryptMetadata = true;
                this.embeddedFilesOnly = false;
                this.keyLength = 40;
                this.revision = 2;
                break;
            }
            case 1: {
                this.embeddedFilesOnly = false;
                this.keyLength = n2 > 0 ? n2 : 128;
                this.revision = 3;
                break;
            }
            case 2: {
                this.keyLength = 128;
                this.revision = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("No valid encryption mode");
            }
        }
    }

    public int getCryptoMode() {
        return this.cryptoMode;
    }

    public boolean isMetadataEncrypted() {
        return this.encryptMetadata;
    }

    public boolean isEmbeddedFilesOnly() {
        return this.embeddedFilesOnly;
    }

    private byte[] padPassword(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        if (byArray == null) {
            System.arraycopy(pad, 0, byArray2, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 32));
            if (byArray.length < 32) {
                System.arraycopy(pad, 0, byArray2, byArray.length, 32 - byArray.length);
            }
        }
        return byArray2;
    }

    private byte[] computeOwnerKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = this.md5.digest(byArray2);
        if (this.revision == 3 || this.revision == 4) {
            int n;
            byte[] byArray5 = new byte[this.keyLength / 8];
            for (n = 0; n < 50; ++n) {
                System.arraycopy(this.md5.digest(byArray4), 0, byArray4, 0, byArray5.length);
            }
            System.arraycopy(byArray, 0, byArray3, 0, 32);
            for (n = 0; n < 20; ++n) {
                for (int i = 0; i < byArray5.length; ++i) {
                    byArray5[i] = (byte)(byArray4[i] ^ n);
                }
                this.arcfour.prepareARCFOURKey(byArray5);
                this.arcfour.encryptARCFOUR(byArray3);
            }
        } else {
            this.arcfour.prepareARCFOURKey(byArray4, 0, 5);
            this.arcfour.encryptARCFOUR(byArray, byArray3);
        }
        return byArray3;
    }

    private void setupGlobalEncryptionKey(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        this.documentID = byArray;
        this.ownerKey = byArray3;
        this.permissions = n;
        this.mkey = new byte[this.keyLength / 8];
        this.md5.reset();
        this.md5.update(byArray2);
        this.md5.update(byArray3);
        byte[] byArray4 = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        this.md5.update(byArray4, 0, 4);
        if (byArray != null) {
            this.md5.update(byArray);
        }
        if (!this.encryptMetadata) {
            this.md5.update(metadataPad);
        }
        byte[] byArray5 = new byte[this.mkey.length];
        System.arraycopy(this.md5.digest(), 0, byArray5, 0, this.mkey.length);
        if (this.revision == 3 || this.revision == 4) {
            for (int i = 0; i < 50; ++i) {
                System.arraycopy(this.md5.digest(byArray5), 0, byArray5, 0, this.mkey.length);
            }
        }
        System.arraycopy(byArray5, 0, this.mkey, 0, this.mkey.length);
    }

    private void setupUserKey() {
        if (this.revision == 3 || this.revision == 4) {
            int n;
            this.md5.update(pad);
            byte[] byArray = this.md5.digest(this.documentID);
            System.arraycopy(byArray, 0, this.userKey, 0, 16);
            for (n = 16; n < 32; ++n) {
                this.userKey[n] = 0;
            }
            for (n = 0; n < 20; ++n) {
                for (int i = 0; i < this.mkey.length; ++i) {
                    byArray[i] = (byte)(this.mkey[i] ^ n);
                }
                this.arcfour.prepareARCFOURKey(byArray, 0, this.mkey.length);
                this.arcfour.encryptARCFOUR(this.userKey, 0, 16);
            }
        } else {
            this.arcfour.prepareARCFOURKey(this.mkey);
            this.arcfour.encryptARCFOUR(pad, this.userKey);
        }
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2 == null || byArray2.length == 0) {
            byArray2 = this.md5.digest(PdfEncryption.createDocumentId());
        }
        n |= this.revision == 3 || this.revision == 4 ? -3904 : -64;
        byte[] byArray3 = this.padPassword(byArray);
        byte[] byArray4 = this.padPassword(byArray2);
        this.ownerKey = this.computeOwnerKey(byArray3, byArray4);
        this.documentID = PdfEncryption.createDocumentId();
        this.setupByUserPad(this.documentID, byArray3, this.ownerKey, n &= 0xFFFFFFFC);
    }

    public static byte[] createDocumentId() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        long l = System.currentTimeMillis();
        long l2 = Runtime.getRuntime().freeMemory();
        String string = l + "+" + l2 + "+" + seq++;
        return messageDigest.digest(string.getBytes());
    }

    public void setupByUserPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        this.setupByUserPad(byArray, this.padPassword(byArray2), byArray3, n);
    }

    private void setupByUserPad(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        this.setupGlobalEncryptionKey(byArray, byArray2, byArray3, n);
        this.setupUserKey();
    }

    public void setupByOwnerPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
        this.setupByOwnerPad(byArray, this.padPassword(byArray2), byArray3, byArray4, n);
    }

    private void setupByOwnerPad(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
        byte[] byArray5 = this.computeOwnerKey(byArray4, byArray2);
        this.setupGlobalEncryptionKey(byArray, byArray5, byArray4, n);
        this.setupUserKey();
    }

    public void setupByEncryptionKey(byte[] byArray, int n) {
        this.mkey = new byte[n / 8];
        System.arraycopy(byArray, 0, this.mkey, 0, this.mkey.length);
    }

    public void setHashKey(int n, int n2) {
        this.md5.reset();
        this.extra[0] = (byte)n;
        this.extra[1] = (byte)(n >> 8);
        this.extra[2] = (byte)(n >> 16);
        this.extra[3] = (byte)n2;
        this.extra[4] = (byte)(n2 >> 8);
        this.md5.update(this.mkey);
        this.md5.update(this.extra);
        if (this.revision == 4) {
            this.md5.update(salt);
        }
        this.key = this.md5.digest();
        this.keySize = this.mkey.length + 5;
        if (this.keySize > 16) {
            this.keySize = 16;
        }
    }

    public static PdfObject createInfoId(byte[] byArray) {
        int n;
        ByteBuffer byteBuffer = new ByteBuffer(90);
        byteBuffer.append('[').append('<');
        for (n = 0; n < 16; ++n) {
            byteBuffer.appendHex(byArray[n]);
        }
        byteBuffer.append('>').append('<');
        byArray = PdfEncryption.createDocumentId();
        for (n = 0; n < 16; ++n) {
            byteBuffer.appendHex(byArray[n]);
        }
        byteBuffer.append('>').append(']');
        return new PdfLiteral(byteBuffer.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (this.publicKeyHandler.getRecipientsSize() > 0) {
            Object object;
            Object object2;
            PdfArray pdfArray = null;
            pdfDictionary.put(PdfName.FILTER, PdfName.PUBSEC);
            pdfDictionary.put(PdfName.R, new PdfNumber(this.revision));
            try {
                pdfArray = this.publicKeyHandler.getEncodedRecipients();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            if (this.revision == 2) {
                pdfDictionary.put(PdfName.V, new PdfNumber(1));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S4);
                pdfDictionary.put(PdfName.RECIPIENTS, pdfArray);
            } else if (this.revision == 3 && this.encryptMetadata) {
                pdfDictionary.put(PdfName.V, new PdfNumber(2));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S4);
                pdfDictionary.put(PdfName.RECIPIENTS, pdfArray);
            } else {
                pdfDictionary.put(PdfName.R, new PdfNumber(4));
                pdfDictionary.put(PdfName.V, new PdfNumber(4));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S5);
                object2 = new PdfDictionary();
                ((PdfDictionary)object2).put(PdfName.RECIPIENTS, pdfArray);
                if (!this.encryptMetadata) {
                    ((PdfDictionary)object2).put(PdfName.ENCRYPTMETADATA, PdfBoolean.PDFFALSE);
                }
                if (this.revision == 4) {
                    ((PdfDictionary)object2).put(PdfName.CFM, PdfName.AESV2);
                } else {
                    ((PdfDictionary)object2).put(PdfName.CFM, PdfName.V2);
                }
                object = new PdfDictionary();
                ((PdfDictionary)object).put(PdfName.DEFAULTCRYPTFILER, (PdfObject)object2);
                pdfDictionary.put(PdfName.CF, (PdfObject)object);
                if (this.embeddedFilesOnly) {
                    pdfDictionary.put(PdfName.EFF, PdfName.DEFAULTCRYPTFILER);
                    pdfDictionary.put(PdfName.STRF, PdfName.IDENTITY);
                    pdfDictionary.put(PdfName.STMF, PdfName.IDENTITY);
                } else {
                    pdfDictionary.put(PdfName.STRF, PdfName.DEFAULTCRYPTFILER);
                    pdfDictionary.put(PdfName.STMF, PdfName.DEFAULTCRYPTFILER);
                }
            }
            object2 = null;
            object = null;
            try {
                object2 = MessageDigest.getInstance("SHA-1");
                ((MessageDigest)object2).update(this.publicKeyHandler.getSeed());
                for (int i = 0; i < this.publicKeyHandler.getRecipientsSize(); ++i) {
                    object = this.publicKeyHandler.getEncodedRecipient(i);
                    ((MessageDigest)object2).update((byte[])object);
                }
                if (!this.encryptMetadata) {
                    ((MessageDigest)object2).update(new byte[]{-1, -1, -1, -1});
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            byte[] byArray = ((MessageDigest)object2).digest();
            this.setupByEncryptionKey(byArray, this.keyLength);
        } else {
            pdfDictionary.put(PdfName.FILTER, PdfName.STANDARD);
            pdfDictionary.put(PdfName.O, new PdfLiteral(PdfContentByte.escapeString(this.ownerKey)));
            pdfDictionary.put(PdfName.U, new PdfLiteral(PdfContentByte.escapeString(this.userKey)));
            pdfDictionary.put(PdfName.P, new PdfNumber(this.permissions));
            pdfDictionary.put(PdfName.R, new PdfNumber(this.revision));
            if (this.revision == 2) {
                pdfDictionary.put(PdfName.V, new PdfNumber(1));
            } else if (this.revision == 3 && this.encryptMetadata) {
                pdfDictionary.put(PdfName.V, new PdfNumber(2));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
            } else {
                if (!this.encryptMetadata) {
                    pdfDictionary.put(PdfName.ENCRYPTMETADATA, PdfBoolean.PDFFALSE);
                }
                pdfDictionary.put(PdfName.R, new PdfNumber(4));
                pdfDictionary.put(PdfName.V, new PdfNumber(4));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
                PdfDictionary pdfDictionary2 = new PdfDictionary();
                pdfDictionary2.put(PdfName.LENGTH, new PdfNumber(16));
                if (this.embeddedFilesOnly) {
                    pdfDictionary2.put(PdfName.AUTHEVENT, PdfName.EFOPEN);
                    pdfDictionary.put(PdfName.EFF, PdfName.STDCF);
                    pdfDictionary.put(PdfName.STRF, PdfName.IDENTITY);
                    pdfDictionary.put(PdfName.STMF, PdfName.IDENTITY);
                } else {
                    pdfDictionary2.put(PdfName.AUTHEVENT, PdfName.DOCOPEN);
                    pdfDictionary.put(PdfName.STRF, PdfName.STDCF);
                    pdfDictionary.put(PdfName.STMF, PdfName.STDCF);
                }
                if (this.revision == 4) {
                    pdfDictionary2.put(PdfName.CFM, PdfName.AESV2);
                } else {
                    pdfDictionary2.put(PdfName.CFM, PdfName.V2);
                }
                PdfDictionary pdfDictionary3 = new PdfDictionary();
                pdfDictionary3.put(PdfName.STDCF, pdfDictionary2);
                pdfDictionary.put(PdfName.CF, pdfDictionary3);
            }
        }
        return pdfDictionary;
    }

    public PdfObject getFileID() {
        return PdfEncryption.createInfoId(this.documentID);
    }

    public OutputStreamEncryption getEncryptionStream(OutputStream outputStream) {
        return new OutputStreamEncryption(outputStream, this.key, 0, this.keySize, this.revision);
    }

    public int calculateStreamSize(int n) {
        if (this.revision == 4) {
            return (n & 0x7FFFFFF0) + 32;
        }
        return n;
    }

    public byte[] encryptByteArray(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamEncryption outputStreamEncryption = this.getEncryptionStream(byteArrayOutputStream);
            outputStreamEncryption.write(byArray);
            outputStreamEncryption.finish();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public StandardDecryption getDecryptor() {
        return new StandardDecryption(this.key, 0, this.keySize, this.revision);
    }

    public byte[] decryptByteArray(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StandardDecryption standardDecryption = this.getDecryptor();
            byte[] byArray2 = standardDecryption.update(byArray, 0, byArray.length);
            if (byArray2 != null) {
                byteArrayOutputStream.write(byArray2);
            }
            if ((byArray2 = standardDecryption.finish()) != null) {
                byteArrayOutputStream.write(byArray2);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void addRecipient(Certificate certificate, int n) {
        this.documentID = PdfEncryption.createDocumentId();
        this.publicKeyHandler.addRecipient(new PdfPublicKeyRecipient(certificate, n));
    }

    public byte[] computeUserPassword(byte[] byArray) {
        byte[] byArray2 = this.computeOwnerKey(this.ownerKey, this.padPassword(byArray));
        for (int i = 0; i < byArray2.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < byArray2.length - i; ++j) {
                if (byArray2[i + j] == pad[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            byte[] byArray3 = new byte[i];
            System.arraycopy(byArray2, 0, byArray3, 0, i);
            return byArray3;
        }
        return byArray2;
    }
}

