/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.certificate.ocsp;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.encoder.Asn1Encoder;
import de.rub.nds.asn1.model.Asn1EncapsulatingOctetString;
import de.rub.nds.asn1.model.Asn1Explicit;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1Null;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1PrimitiveOctetString;
import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.tlsattacker.core.certificate.ObjectIdentifierTranslator;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponseTypes;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Random;
import org.apache.commons.lang3.NotImplementedException;

public class OCSPRequestMessage {
    Asn1Sequence tbsRequestWrapper = new Asn1Sequence();
    Asn1Sequence tbsRequest = new Asn1Sequence();
    Asn1Sequence requestList = new Asn1Sequence();
    Asn1Sequence extensionSequence = new Asn1Sequence();
    Asn1Explicit extensionExplicitSequence = new Asn1Explicit();
    BigInteger nonce;
    private static final int EXTENSION_ASN1_EXPLICIT_OFFSET = 2;
    private static final int NONCE_RANDOM_SEED = 42;
    private static final int NONCE_LENGTH_BIT = 128;
    boolean extensionsSet = false;

    public OCSPRequestMessage() {
        this.tbsRequest.addChild((Asn1Encodable)this.requestList);
        this.tbsRequestWrapper.addChild((Asn1Encodable)this.tbsRequest);
        this.extensionExplicitSequence.setOffset(2);
        this.extensionExplicitSequence.addChild((Asn1Encodable)this.extensionSequence);
    }

    public OCSPRequestMessage(byte[] issuerNameHashValue, byte[] issuerKeyHashValue, BigInteger serialNumberValue) {
        this.addToRequest(issuerNameHashValue, issuerKeyHashValue, serialNumberValue);
        this.tbsRequest.addChild((Asn1Encodable)this.requestList);
        this.tbsRequestWrapper.addChild((Asn1Encodable)this.tbsRequest);
        this.extensionExplicitSequence.setOffset(2);
        this.extensionExplicitSequence.addChild((Asn1Encodable)this.extensionSequence);
    }

    public Asn1Sequence getTbsRequestWrapper() {
        return this.tbsRequestWrapper;
    }

    public void setTbsRequestWrapper(Asn1Sequence tbsRequestWrapper) {
        this.tbsRequestWrapper = tbsRequestWrapper;
    }

    public Asn1Sequence getTbsRequest() {
        return this.tbsRequest;
    }

    public void setTbsRequest(Asn1Sequence tbsRequest) {
        this.tbsRequest = tbsRequest;
    }

    public Asn1Sequence getRequestList() {
        return this.requestList;
    }

    public void setRequestList(Asn1Sequence requestList) {
        this.requestList = requestList;
    }

    public Asn1Sequence getExtensionSequence() {
        return this.extensionSequence;
    }

    public void setExtensionSequence(Asn1Sequence extensionSequence) {
        this.extensionSequence = extensionSequence;
    }

    public Asn1Explicit getExtensionExplicitSequence() {
        return this.extensionExplicitSequence;
    }

    public void setExtensionExplicitSequence(Asn1Explicit extensionExplicitSequence) {
        this.extensionExplicitSequence = extensionExplicitSequence;
    }

    public boolean isExtensionsSet() {
        return this.extensionsSet;
    }

    public void setExtensionsSet(boolean extensionsSet) {
        this.extensionsSet = extensionsSet;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public void addToRequest(byte[] issuerNameHashValue, byte[] issuerKeyHashValue, BigInteger serialNumberValue) {
        Asn1Sequence request = new Asn1Sequence();
        Asn1Sequence reqCert = new Asn1Sequence();
        Asn1Sequence hashAlgorithm = new Asn1Sequence();
        Asn1Null hashAlgorithmFiller = new Asn1Null();
        Asn1ObjectIdentifier hashAlgorithmId = new Asn1ObjectIdentifier();
        Asn1PrimitiveOctetString issuerNameHash = new Asn1PrimitiveOctetString();
        Asn1PrimitiveOctetString issuerKeyHash = new Asn1PrimitiveOctetString();
        Asn1Integer serialNumber = new Asn1Integer();
        serialNumber.setValue(serialNumberValue);
        issuerNameHash.setValue(issuerNameHashValue);
        issuerKeyHash.setValue(issuerKeyHashValue);
        hashAlgorithmId.setValue(ObjectIdentifierTranslator.translate("SHA1"));
        hashAlgorithm.addChild((Asn1Encodable)hashAlgorithmId);
        hashAlgorithm.addChild((Asn1Encodable)hashAlgorithmFiller);
        reqCert.addChild((Asn1Encodable)hashAlgorithm);
        reqCert.addChild((Asn1Encodable)issuerNameHash);
        reqCert.addChild((Asn1Encodable)issuerKeyHash);
        reqCert.addChild((Asn1Encodable)serialNumber);
        request.addChild((Asn1Encodable)reqCert);
        this.requestList.addChild((Asn1Encodable)request);
    }

    public byte[] getEncodedRequest() {
        LinkedList<Asn1Sequence> asn1Encodables = new LinkedList<Asn1Sequence>();
        asn1Encodables.add(this.tbsRequestWrapper);
        Asn1Encoder asn1Encoder = new Asn1Encoder(asn1Encodables);
        return asn1Encoder.encode();
    }

    public void addExtension(String extensionOid) {
        if (!extensionOid.equals(OCSPResponseTypes.NONCE.getOID()) && !extensionOid.equals(OCSPResponseTypes.ACCEPTABLE_RESPONSES.getOID())) {
            throw new NotImplementedException("This extension is not supported yet.");
        }
        Asn1Sequence innerExtensionSequence = new Asn1Sequence();
        Asn1ObjectIdentifier oid = new Asn1ObjectIdentifier();
        oid.setValue(extensionOid);
        innerExtensionSequence.addChild((Asn1Encodable)oid);
        Asn1EncapsulatingOctetString encapsulatingOctetString = new Asn1EncapsulatingOctetString();
        if (extensionOid.equals(OCSPResponseTypes.NONCE.getOID())) {
            Asn1PrimitiveOctetString nonceOctetString = new Asn1PrimitiveOctetString();
            Random rand = new Random(42L);
            if (this.nonce == null) {
                this.nonce = new BigInteger(128, rand);
            }
            nonceOctetString.setValue(this.nonce.toByteArray());
            encapsulatingOctetString.addChild((Asn1Encodable)nonceOctetString);
        } else if (extensionOid.equals(OCSPResponseTypes.ACCEPTABLE_RESPONSES.getOID())) {
            Asn1Sequence oidSequence = new Asn1Sequence();
            Asn1ObjectIdentifier acceptedResponseOid = new Asn1ObjectIdentifier();
            acceptedResponseOid.setValue(OCSPResponseTypes.BASIC.getOID());
            oidSequence.addChild((Asn1Encodable)acceptedResponseOid);
            encapsulatingOctetString.addChild((Asn1Encodable)oidSequence);
        }
        innerExtensionSequence.addChild((Asn1Encodable)encapsulatingOctetString);
        this.extensionSequence.addChild((Asn1Encodable)innerExtensionSequence);
        if (!this.extensionsSet) {
            this.tbsRequest.addChild((Asn1Encodable)this.extensionExplicitSequence);
            this.extensionsSet = true;
        }
    }
}

