/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.mtls;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.auth.mtls.CertificateSourceUnavailableException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class WorkloadCertificateConfiguration {
    private String certPath;
    private String privateKeyPath;
    private static JsonFactory jsonFactory = GsonFactory.getDefaultInstance();
    private static JsonObjectParser parser = new JsonObjectParser(jsonFactory);

    WorkloadCertificateConfiguration(String certPath, String privateKeyPath) {
        this.certPath = certPath;
        this.privateKeyPath = privateKeyPath;
    }

    String getCertPath() {
        return this.certPath;
    }

    String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    static WorkloadCertificateConfiguration fromCertificateConfigurationStream(InputStream certConfigStream) throws IOException {
        Preconditions.checkNotNull((Object)certConfigStream);
        GenericJson fileContents = (GenericJson)parser.parseAndClose(certConfigStream, StandardCharsets.UTF_8, GenericJson.class);
        Map certConfigs = (Map)fileContents.get((Object)"cert_configs");
        if (certConfigs == null) {
            throw new IllegalArgumentException("The cert_configs object must be provided in the certificate configuration file.");
        }
        Map workloadConfig = (Map)certConfigs.get("workload");
        if (workloadConfig == null) {
            throw new CertificateSourceUnavailableException("A workload certificate configuration must be provided in the cert_configs object.");
        }
        String certPath = (String)workloadConfig.get("cert_path");
        if (Strings.isNullOrEmpty((String)certPath)) {
            throw new IllegalArgumentException("The cert_path field must be provided in the workload certificate configuration.");
        }
        String privateKeyPath = (String)workloadConfig.get("key_path");
        if (Strings.isNullOrEmpty((String)privateKeyPath)) {
            throw new IllegalArgumentException("The key_path field must be provided in the workload certificate configuration.");
        }
        return new WorkloadCertificateConfiguration(certPath, privateKeyPath);
    }
}

