/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Hyn600ProtocolDecoder
extends BaseProtocolDecoder {
    public Hyn600ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodeReport(DeviceSession deviceSession, ByteBuf buf) {
        DateBuilder dateBuilder;
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        long mask = buf.readUnsignedInt();
        if (BitUtil.check(mask, 0)) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
        }
        if (BitUtil.check(mask, 1)) {
            buf.readUnsignedByte();
        }
        if (BitUtil.check(mask, 2)) {
            position.set("battery", (double)buf.readUnsignedShort() / 100.0);
            position.set("batteryLevel", buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 3)) {
            position.setValid(buf.readUnsignedByte() > 0);
            position.set("hdop", buf.readUnsignedByte());
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
            position.setCourse(buf.readUnsignedShort());
            position.setAltitude(buf.readShort());
            position.setLatitude((double)buf.readUnsignedInt() / 1000000.0);
            position.setLongitude((double)buf.readUnsignedInt() / 1000000.0);
            dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(buf, 4)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
            position.setFixTime(dateBuilder.getDate());
        } else {
            this.getLastLocation(position, null);
        }
        if (BitUtil.check(mask, 4)) {
            position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedInt(), buf.readUnsignedByte())));
        }
        if (BitUtil.check(mask, 7)) {
            buf.readUnsignedByte();
            buf.readUnsignedShort();
        }
        if (BitUtil.check(mask, 8)) {
            long eventMask = buf.readUnsignedInt();
            if (BitUtil.check(eventMask, 0)) {
                position.set("power", (double)buf.readUnsignedShort() / 1000.0);
            }
            if (BitUtil.check(eventMask, 1)) {
                short adcIndex = buf.readUnsignedByte();
                position.set("adc" + adcIndex, (double)buf.readUnsignedShort() / 1000.0);
            }
            if (BitUtil.check(eventMask, 2)) {
                short status = buf.readUnsignedByte();
                position.set("ignition", status >= 32);
                position.set("motion", (status & 0xF) >= 2);
            }
            if (BitUtil.check(eventMask, 3)) {
                position.set("input", buf.readUnsignedByte());
            }
            if (BitUtil.check(eventMask, 4)) {
                position.set("output", buf.readUnsignedByte());
            }
            if (BitUtil.check(eventMask, 5)) {
                position.set("tripOdometer", buf.readUnsignedShort() * 100);
                position.set("odometer", buf.readUnsignedInt() * 100L);
            }
            if (BitUtil.check(eventMask, 6)) {
                short satelliteMask = buf.readUnsignedByte();
                if (BitUtil.check(satelliteMask, 0)) {
                    buf.readUnsignedByte();
                }
                if (BitUtil.check(satelliteMask, 1)) {
                    buf.readUnsignedByte();
                }
                if (BitUtil.check(satelliteMask, 2)) {
                    buf.readUnsignedByte();
                }
                if (BitUtil.check(satelliteMask, 3)) {
                    buf.readUnsignedByte();
                }
            }
            if (BitUtil.check(eventMask, 7)) {
                buf.readUnsignedInt();
            }
            if (BitUtil.check(eventMask, 8)) {
                buf.skipBytes((int)buf.readUnsignedByte());
            }
            if (BitUtil.check(eventMask, 9)) {
                int count = buf.readUnsignedByte();
                for (int i = 0; i < count; ++i) {
                    buf.skipBytes(8);
                    short dataMask = buf.readUnsignedByte();
                    if (BitUtil.check(dataMask, 0)) {
                        buf.readUnsignedShort();
                    }
                    if (!BitUtil.check(dataMask, 1)) continue;
                    buf.readUnsignedByte();
                }
            }
            if (BitUtil.check(eventMask, 10)) {
                buf.skipBytes(3);
                buf.skipBytes(5);
            }
            if (BitUtil.check(eventMask, 11)) {
                buf.skipBytes(9);
            }
            if (BitUtil.check(eventMask, 11)) {
                buf.skipBytes(8);
            }
        }
        if (BitUtil.check(mask, 16)) {
            long bleMask = buf.readUnsignedInt();
            if (BitUtil.check(bleMask, 0)) {
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                short relayMask = buf.readUnsignedByte();
                if (BitUtil.check(relayMask, 0)) {
                    buf.skipBytes(6);
                }
                if (BitUtil.check(relayMask, 1)) {
                    buf.readUnsignedShort();
                }
                if (BitUtil.check(relayMask, 2)) {
                    buf.readUnsignedByte();
                }
                if (BitUtil.check(relayMask, 3)) {
                    buf.readUnsignedByte();
                }
                if (BitUtil.check(relayMask, 4)) {
                    buf.readUnsignedByte();
                }
            }
            if (BitUtil.check(bleMask, 1)) {
                buf.readUnsignedShort();
                buf.readUnsignedByte();
                short beaconMask = buf.readUnsignedByte();
                if (BitUtil.check(beaconMask, 0)) {
                    buf.skipBytes(6);
                }
                if (BitUtil.check(beaconMask, 1)) {
                    buf.readUnsignedShort();
                }
                if (BitUtil.check(beaconMask, 2)) {
                    buf.readUnsignedShort();
                }
            }
        }
        dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(buf, 4)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
        position.setDeviceTime(dateBuilder.getDate());
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        String header = buf.readCharSequence(5, StandardCharsets.UTF_8).toString();
        buf.readUnsignedShort();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        if (header.endsWith("RPT:")) {
            return this.decodeReport(deviceSession, buf);
        }
        return null;
    }
}

