import { Zcl } from "zigbee-herdsman";
import type { ElectricityMeterArgs } from "./modernExtend";
import type { KeyValue, ModernExtend } from "./types";
export declare const manufacturerOptions: {
    manufacturerCode: Zcl.ManufacturerCode;
};
interface BoschGeneralEnergyDeviceCluster {
    attributes: {
        /** ID: 6 | Type: BOOLEAN */
        autoOffEnabled: number;
        /** ID: 7 | Type: UINT16 */
        autoOffTime: number;
    };
    commands: never;
    commandResponses: never;
}
export declare const boschGeneralExtend: {
    handleZclVersionReadRequest: () => ModernExtend;
    customSeMeteringCluster: () => ModernExtend;
    resetEnergyMeters: () => ModernExtend;
    autoOff: (args?: {
        endpoint: number;
    }) => ModernExtend;
};
export interface BoschBmctCluster extends BoschGeneralEnergyDeviceCluster {
    attributes: {
        /** ID: 0 | Type: ENUM8 | Only used by BMCT-SLZ */
        deviceMode: number;
        /** ID: 1 | Type: ENUM8 */
        switchType: number;
        /** ID: 2 | Type: UINT32 | Only used by BMCT-SLZ */
        calibrationOpeningTime: number;
        /** ID: 3 | Type: UINT32 | Only used by BMCT-SLZ */
        calibrationClosingTime: number;
        /** ID: 4 | Type: BITMAP8 | Used by all BMCT devices, but function is unknown */
        unknownAttributeOne: number;
        /** ID: 5 | Type: UINT8 | Only used by BMCT-SLZ */
        calibrationButtonHoldTime: number;
        /** ID: 6 | Type: BOOLEAN | Only used by BMCT-RZ and BMCT-SLZ */
        autoOffEnabled: number;
        /** ID: 7 | Type: UINT16 | Only used by BMCT-RZ and BMCT-SLZ */
        autoOffTime: number;
        /** ID: 8 | Type: BOOLEAN */
        childLock: number;
        /** ID: 10 | Type: UINT32 | Only used by BMCT-SLZ */
        slatRotationDurationOne: number;
        /** ID: 11 | Type: UINT32 | Only used by BMCT-SLZ */
        slatRotationDurationTwo: number;
        /** ID: 13 | Type: ENUM8 | Only used by BMCT-SLZ */
        motorState: number;
        /** ID: 15 | Type: UINT8 | Only used by BMCT-SLZ */
        calibrationMotorStartDelay: number;
        /** ID: 21 | Type: UINT8 | Only used by BMCT-SLZ */
        calibrationMotorEndPosition: number;
        /** ID: 22 | Type: ENUM8 | Only used by BMCT-DZ */
        dimmerType: number;
        /** ID: 24 | Type: UINT16 | Only used by BMCT-RZ */
        pulseLength: number;
        /** ID: 25 | Type: UINT8 | Only used by BMCT-DZ */
        minimumBrightness: number;
        /** ID: 26 | Type: UINT8 | Only used by BMCT-DZ */
        maximumBrightness: number;
        /** ID: 31 | Type: BOOLEAN on BMCT-DZ and BMCT-RZ, UINT8 on BMCT-SLZ */
        switchMode: number;
        /** ID: 33 | Type: UINT16 | Only used by BMCT-SLZ */
        calibrationNewMotorStartDelay: number;
        /** ID: 34 | Type: ENUM8 | Only used by BMCT-RZ */
        actuatorType: number;
        /** ID: 42 | Type: BOOLEAN | Only used by BMCT-SLZ */
        unknownAttributeTwo: number;
    };
    commands: never;
    commandResponses: never;
}
export declare const boschBmctExtend: {
    switchMode: (args: {
        endpoint?: number;
        deviceModeLookup?: KeyValue;
        switchModeLookup: KeyValue;
        switchTypeLookup: KeyValue;
    }) => ModernExtend;
    childLock: (args?: {
        endpoint?: number;
    }) => ModernExtend;
    actuatorType: () => ModernExtend;
    dimmerType: () => ModernExtend;
    brightnessRange: () => ModernExtend;
    rzDeviceModes: (args: {
        deviceModesLookup: KeyValue;
    }) => ModernExtend;
    pulseLength: (args: {
        updateDeviceMode: boolean;
        deviceModesLookup?: KeyValue;
    }) => ModernExtend;
    switchType: (args: {
        switchTypeLookup: KeyValue;
    }) => ModernExtend;
    reportSwitchAction: (args: {
        switchTypeLookup: KeyValue;
        hasDualSwitchInputs: boolean;
    }) => ModernExtend;
    slzExtends: () => ModernExtend;
};
export interface BoschBsirPowerCfgCluster {
    attributes: {
        /** ID: 40960 | Type: UINT16 */
        solarPanelVoltage: number;
        /** ID: 40961 | Type: UINT8 |
         * This was 1 in most of the cases during testing.
         * Only when the solar panel delivered high voltages
         * did I record 2 and 3 for pretty short times.
         * But was unable to find a clear linkage to the
         * charging behavior. That's why I haven't exposed it yet. */
        unknownAttribute: number;
        /** ID: 40962 | Type: UINT8 */
        primaryPowerSource: number;
    };
    commands: never;
    commandResponses: never;
}
export interface BoschBsirIasZoneCluster {
    attributes: {
        /** ID: 40960 | Type: UINT8 */
        currentPowerSource: number;
    };
    commands: {
        /** ID: 243 */
        acknowledgeStatusChange: {
            /** Type: UINT8 */
            data: number;
        };
    };
    commandResponses: never;
}
export interface BoschBsirIasWdCluster {
    attributes: {
        /** ID: 40960 | Type: UINT8 */
        sirenDuration: number;
        /** ID: 40961 | Type: UINT8 */
        alarmMode: number;
        /** ID: 40962 | Type: UINT8 */
        sirenVolume: number;
        /** ID: 40963 | Type: UINT16 */
        sirenDelay: number;
        /** ID: 40964 | Type: UINT16 */
        lightDelay: number;
        /** ID: 40965 | Type: UINT8 */
        lightDuration: number;
        /** ID: 40966 | Type: UINT8 */
        deviceState: number;
    };
    commands: {
        /** ID: 243 */
        alarmControl: {
            /** Type: UINT16 */
            data: number;
        };
    };
    commandResponses: never;
}
export declare const boschBsirExtend: {
    customPowerCfgCluster: () => ModernExtend;
    customIasZoneCluster: () => ModernExtend;
    customIasWdCluster: () => ModernExtend;
    alarmControl: () => ModernExtend;
    deviceState: () => ModernExtend;
    battery: () => ModernExtend;
    lightDelay: () => ModernExtend;
    sirenDelay: () => ModernExtend;
    sirenDuration: () => ModernExtend;
    lightDuration: () => ModernExtend;
    sirenVolume: () => ModernExtend;
    alarmMode: () => ModernExtend;
    primaryPowerSource: () => ModernExtend;
    iasZoneStatus: () => ModernExtend;
    currentPowerSource: () => ModernExtend;
    solarPanelVoltage: () => ModernExtend;
};
export declare const boschDoorWindowContactExtend: {
    doorWindowContactCluster: () => ModernExtend;
    battery: () => ModernExtend;
    reportContactState: () => ModernExtend;
    reportButtonActions: (args?: {
        doublePressSupported: boolean;
    }) => ModernExtend;
    breakFunctionality: () => ModernExtend;
    vibrationDetection: () => ModernExtend;
};
export declare const boschBsenExtend: {
    customIasZoneCluster: () => ModernExtend;
    battery: () => ModernExtend;
    illuminance: () => ModernExtend;
    temperature: () => ModernExtend;
    tamperAndOccupancyAlarm: () => ModernExtend;
    sensitivityLevel: () => ModernExtend;
    changedCheckinInterval: () => ModernExtend;
    testMode: () => ModernExtend;
};
export declare const boschSmartPlugExtend: {
    smartPlugCluster: () => ModernExtend;
    onOff: () => ModernExtend;
    ledBrightness: () => ModernExtend;
    energySavingMode: () => ModernExtend;
    electricityMeter: (args?: ElectricityMeterArgs) => ModernExtend;
};
export {};
//# sourceMappingURL=bosch.d.ts.map