import type { ExtendedPanId } from "./tstypes";
/** Current supported Zigbee revision: https://csa-iot.org/wp-content/uploads/2023/04/05-3474-23-csg-zigbee-specification-compressed.pdf */
export declare const ZIGBEE_REVISION = 23;
/** The network ID of the coordinator in a ZigBee network is 0x0000. */
export declare const COORDINATOR_ADDRESS = 0;
/** Endpoint profile ID for Zigbee 3.0. "Home Automation" */
export declare const HA_PROFILE_ID = 260;
/** Endpoint profile ID for Smart Energy */
export declare const SE_PROFILE_ID = 265;
/** Endpoint profile ID for Green Power */
export declare const GP_PROFILE_ID = 41440;
/** The touchlink (ZigBee Light Link/ZLL) Profile ID. */
export declare const TOUCHLINK_PROFILE_ID = 49246;
/** The profile ID used to address all the public profiles. */
export declare const WILDCARD_PROFILE_ID = 65535;
/** The profile ID used to access Shelly devices custom clusters. */
export declare const CUSTOM_SHELLY_PROFILE_ID = 49153;
/** The default HA endpoint. */
export declare const HA_ENDPOINT = 1;
/** The GP endpoint, as defined in the ZigBee spec. */
export declare const GP_ENDPOINT = 242;
export declare const GP_GROUP_ID = 2948;
/** The maximum 802.15.4 channel number is 26. */
export declare const MAX_802_15_4_CHANNEL_NUMBER = 26;
/** The minimum 2.4GHz 802.15.4 channel number is 11. */
export declare const MIN_802_15_4_CHANNEL_NUMBER = 11;
/** There are sixteen 802.15.4 channels. */
export declare const NUM_802_15_4_CHANNELS: number;
/** A bitmask to scan all 2.4 GHz 802.15.4 channels. */
export declare const ALL_802_15_4_CHANNELS_MASK = 134215680;
/** A bitmask of the preferred 2.4 GHz 802.15.4 channels to scan. */
export declare const PREFERRED_802_15_4_CHANNELS_MASK = 51955712;
/** List of all Zigbee channels */
export declare const ALL_802_15_4_CHANNELS: number[];
/** List of preferred Zigbee channels */
export declare const PREFERRED_802_15_4_CHANNELS: number[];
/** A blank (also used as "wildcard") EUI64 hex string prefixed with 0x */
export declare const BLANK_EUI64 = "0xFFFFFFFFFFFFFFFF";
/** A blank extended PAN ID. (null/not present) */
export declare const BLANK_EXTENDED_PAN_ID: Readonly<ExtendedPanId>;
/** An invalid profile ID. This is a reserved profileId. */
export declare const INVALID_PROFILE_ID = 65535;
/** An invalid cluster ID. */
export declare const INVALID_CLUSTER_ID = 65535;
/** An invalid PAN ID. */
export declare const INVALID_PAN_ID = 65535;
/** A distinguished network ID that will never be assigned to any node. It is used to indicate the absence of a node ID. */
export declare const NULL_NODE_ID = 65535;
/** A distinguished binding index used to indicate the absence of a binding. */
export declare const NULL_BINDING = 255;
/** This key is "ZigBeeAlliance09" */
export declare const INTEROPERABILITY_LINK_KEY: readonly number[];
export declare const PERMIT_JOIN_FOREVER = 255;
export declare const PERMIT_JOIN_MAX_TIMEOUT = 254;
/** Size of EUI64 (an IEEE address) in bytes. */
export declare const EUI64_SIZE = 8;
/** Size of an PAN identifier in bytes. */
export declare const PAN_ID_SIZE = 2;
/** Size of an extended PAN identifier in bytes. */
export declare const EXTENDED_PAN_ID_SIZE = 8;
/** Size of an encryption key in bytes. */
export declare const DEFAULT_ENCRYPTION_KEY_SIZE = 16;
/** Size of a AES-128-MMO (Matyas-Meyer-Oseas) block in bytes. */
export declare const AES_MMO_128_BLOCK_SIZE = 16;
/**
 * Valid install code sizes, including `INSTALL_CODE_CRC_SIZE`.
 *
 * NOTE: 18 is now standard, first for iterations, order after is important (8 before 10)!
 */
export declare const INSTALL_CODE_SIZES: ReadonlyArray<number>;
/** Size of the CRC appended to install codes. */
export declare const INSTALL_CODE_CRC_SIZE = 2;
//# sourceMappingURL=consts.d.ts.map