/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.samples.svg.io.SVGInputFormat;

public class SVGZInputFormat
extends SVGInputFormat {
    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("Scalable Vector Graphics (SVG, SVGZ)", new String[]{"svg", "svgz"});
    }

    @Override
    public void read(InputStream inputStream, Drawing drawing, boolean bl) throws IOException {
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        bufferedInputStream.mark(2);
        int n = bufferedInputStream.read() & 0xFF | (bufferedInputStream.read() & 0xFF) << 8;
        bufferedInputStream.reset();
        if (n == 35615) {
            super.read(new GZIPInputStream(bufferedInputStream), drawing, bl);
        } else {
            super.read(bufferedInputStream, drawing, bl);
        }
    }
}

