/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.execution.WorkValidationWarningReporter;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.ValidateStep;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkValidationWarningRecorder
implements ValidateStep.ValidationWarningRecorder,
WorkValidationWarningReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkValidationWarningRecorder.class);
    private final AtomicInteger workWithFailuresCount = new AtomicInteger();

    public void recordValidationWarnings(UnitOfWork work, Collection<? extends InternalProblem> warnings) {
        this.workWithFailuresCount.incrementAndGet();
        String uniqueWarnings = warnings.stream().map(warning -> TypeValidationProblemRenderer.convertToSingleLine((String)TypeValidationProblemRenderer.renderMinimalInformationAbout((InternalProblem)warning, (boolean)true, (boolean)false))).map(warning -> "\n  - " + warning).distinct().collect(Collectors.joining());
        LOGGER.warn("Execution optimizations have been disabled for {} to ensure correctness due to the following reasons:{}", (Object)work.getDisplayName(), (Object)uniqueWarnings);
        warnings.forEach(warning -> DeprecationMessageBuilder.withDocumentation((InternalProblem)warning, (DeprecationMessageBuilder.WithDeprecationTimeline)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)TypeValidationProblemRenderer.convertToSingleLine((String)TypeValidationProblemRenderer.renderMinimalInformationAbout((InternalProblem)warning, (boolean)false, (boolean)false))).withContext("Execution optimizations are disabled to ensure correctness.")).willBeRemovedInGradle9()).nagUser());
    }

    @Override
    public void reportWorkValidationWarningsAtEndOfBuild() {
        int workWithFailures = this.workWithFailuresCount.getAndSet(0);
        if (workWithFailures > 0) {
            LOGGER.warn("\nExecution optimizations have been disabled for {} invalid unit(s) of work during this build to ensure correctness.\nPlease consult deprecation warnings for more details.", (Object)workWithFailures);
        }
    }
}

