/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.InsnNode;

public class NewArrayNode
extends InsnNode {
    private final ArgType arrType;

    public NewArrayNode(ArgType arrType, int argsCount) {
        super(InsnType.NEW_ARRAY, argsCount);
        this.arrType = arrType;
    }

    public ArgType getArrayType() {
        return this.arrType;
    }

    public int getDimension() {
        return this.arrType.getArrayDimension();
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NewArrayNode) || !super.isSame(obj)) {
            return false;
        }
        NewArrayNode other = (NewArrayNode)obj;
        return this.arrType == other.arrType;
    }

    @Override
    public InsnNode copy() {
        return this.copyCommonParams(new NewArrayNode(this.arrType, this.getArgsCount()));
    }

    @Override
    public String toString() {
        return super.toString() + " type: " + this.arrType;
    }
}

