/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.mappers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.security.mappers.NameRewriter;
import org.wildfly.common.Assert;

public final class RegexNameRewriter
implements NameRewriter {
    private final Pattern pattern;
    private final String replacement;
    private final boolean replaceAll;

    public RegexNameRewriter(Pattern pattern, String replacement, boolean replaceAll) {
        this.pattern = (Pattern)Assert.checkNotNullParam((String)"pattern", (Object)pattern);
        this.replacement = replacement;
        this.replaceAll = replaceAll;
    }

    @Override
    public String rewriteName(String original) {
        if (original == null) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(original);
        return this.replaceAll ? matcher.replaceAll(this.replacement) : matcher.replaceFirst(this.replacement);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public boolean isReplaceAll() {
        return this.replaceAll;
    }
}

