/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.network;

import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.pm.graphic.graph.Graph;
import com.projectlibre1.pm.graphic.graph.GraphParams;
import com.projectlibre1.pm.graphic.graph.LinkRouting;
import com.projectlibre1.pm.graphic.network.NetworkModel;
import com.projectlibre1.pm.graphic.network.NetworkParams;
import com.projectlibre1.pm.graphic.network.NetworkUI;
import com.projectlibre1.pm.graphic.network.layout.NetworkLayout;
import com.projectlibre1.pm.graphic.network.layout.NetworkLayoutEvent;
import com.projectlibre1.pm.graphic.network.layout.NetworkLayoutListener;
import com.projectlibre1.pm.graphic.network.link_routing.DefaultNetworkLinkRouting;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.workspace.SavableToWorkspace;
import com.projectlibre1.workspace.WorkspaceSetting;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.JViewport;

public class Network
extends Graph
implements NetworkLayoutListener,
NetworkParams,
SavableToWorkspace {
    private static final long serialVersionUID = -7976852605189565105L;
    protected AffineTransform transform;
    protected int zoom;
    protected LinkRouting routing = new DefaultNetworkLinkRouting();

    public Network(Project project, String string) {
        this(new NetworkModel(project, string), project);
        this.transform = new AffineTransform();
    }

    protected Network(NetworkModel networkModel, Project project) {
        super(networkModel, project);
    }

    public void updateSize() {
        Rectangle rectangle = ((NetworkModel)this.getModel()).getBounds();
        GraphicConfiguration graphicConfiguration = GraphicConfiguration.getInstance();
        this.setPreferredSize(new Dimension(rectangle.x + rectangle.width + graphicConfiguration.getPertXOffset(), rectangle.y + rectangle.height + graphicConfiguration.getPertYOffset()));
    }

    @Override
    public void layoutChanged(NetworkLayoutEvent networkLayoutEvent) {
        this.updateSize();
        this.revalidate();
        this.repaint();
    }

    public void zoomIn() {
        if (this.zoom == this.barStyles.getMaxZoom()) {
            return;
        }
        ((NetworkUI)this.ui).resetForms();
        this.transform.concatenate(AffineTransform.getScaleInstance(this.barStyles.getRatioX(this.zoom, true), this.barStyles.getRatioY(this.zoom++, true)));
        ((NetworkModel)this.getModel()).updateCellBounds();
    }

    public void zoomOut() {
        if (this.zoom == this.barStyles.getMinZoom()) {
            return;
        }
        ((NetworkUI)this.ui).resetForms();
        this.transform.concatenate(AffineTransform.getScaleInstance(this.barStyles.getRatioX(this.zoom, false), this.barStyles.getRatioY(this.zoom--, false)));
        ((NetworkModel)this.getModel()).updateCellBounds();
    }

    public boolean canZoomIn() {
        return this.zoom != this.barStyles.getMaxZoom();
    }

    public boolean canZoomOut() {
        return this.zoom != this.barStyles.getMinZoom();
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public GeneralPath scale(GeneralPath generalPath) {
        if (generalPath == null) {
            return null;
        }
        GeneralPath generalPath2 = (GeneralPath)generalPath.clone();
        generalPath2.transform(this.getTransform());
        return generalPath2;
    }

    @Override
    public Point2D scale(Point2D point2D) {
        AffineTransform affineTransform = this.getTransform();
        return new Point2D.Double(point2D.getX() * affineTransform.getScaleX() + affineTransform.getTranslateX(), point2D.getY() * affineTransform.getScaleY() + affineTransform.getTranslateY());
    }

    @Override
    public Point2D scaleVector(Point2D point2D) {
        AffineTransform affineTransform = this.getTransform();
        return new Point2D.Double(point2D.getX() * affineTransform.getScaleX(), point2D.getY() * affineTransform.getScaleY());
    }

    @Override
    public Point2D scaleVector_1(Point2D point2D) {
        AffineTransform affineTransform = this.getTransform();
        return new Point2D.Double(point2D.getX() / affineTransform.getScaleX(), point2D.getY() / affineTransform.getScaleY());
    }

    @Override
    public Rectangle scale(Rectangle rectangle) {
        AffineTransform affineTransform = this.getTransform();
        if (affineTransform == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setFrameFromDiagonal(rectangle.getMinX() * affineTransform.getScaleX() + affineTransform.getTranslateX(), rectangle.getMinY() * affineTransform.getScaleY() + affineTransform.getTranslateY(), rectangle.getMaxX() * affineTransform.getScaleX() + affineTransform.getTranslateX(), rectangle.getMaxY() * affineTransform.getScaleY() + affineTransform.getTranslateY());
        return rectangle2;
    }

    @Override
    public LinkRouting getRouting() {
        return this.routing;
    }

    @Override
    public void setRouting(LinkRouting linkRouting) {
        this.routing = linkRouting;
    }

    private void makeZoom(int n) {
        int n2 = n - this.zoom;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                this.zoomIn();
            }
        } else {
            for (int i = 0; i > n2; --i) {
                this.zoomOut();
            }
        }
    }

    @Override
    public boolean useTextures() {
        return true;
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.makeZoom(workspace.zoom);
        Container container = this.getParent();
        if (container instanceof JViewport && workspace.viewPosition != null) {
            try {
                ((JViewport)container).setViewPosition(workspace.viewPosition);
            }
            catch (RuntimeException runtimeException) {
                System.out.println("problem restoring viewport to point " + workspace.viewPosition);
            }
        }
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.zoom = this.zoom;
        Container container = this.getParent();
        if (container instanceof JViewport) {
            workspace.viewPosition = ((JViewport)container).getViewPosition();
        }
        return workspace;
    }

    @Override
    public Rectangle getPrintBounds() {
        return null;
    }

    @Override
    public void setPrintBounds(Rectangle rectangle) {
    }

    @Override
    public int getPrintCols() {
        return 0;
    }

    @Override
    public int getPrintRows() {
        return 0;
    }

    @Override
    public NetworkLayout getNetworkLayout() {
        return ((NetworkModel)this.getModel()).getNetworkLayout();
    }

    @Override
    public boolean isLeftPartVisible() {
        return true;
    }

    @Override
    public boolean isRightPartVisible() {
        return true;
    }

    @Override
    public void setLeftPartVisible(boolean bl) {
    }

    @Override
    public void setRightPartVisible(boolean bl) {
    }

    @Override
    public boolean isSupportLeftAndRightParts() {
        return false;
    }

    @Override
    public void setSupportLeftAndRightParts(boolean bl) {
    }

    @Override
    public GraphParams createSafePrintCopy() {
        return this;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = 7804032466144588065L;
        int zoom;
        Point viewPosition = null;

        public int getZoom() {
            return this.zoom;
        }

        public void setZoom(int n) {
            this.zoom = n;
        }

        public Point getViewPosition() {
            return this.viewPosition;
        }

        public void setViewPosition(Point point) {
            this.viewPosition = point;
        }
    }
}

