/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements.inspections.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackageInstallUtils;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.ui.PythonPackageManagerUI;
import com.jetbrains.python.packaging.management.ui.PythonPackageManagerUiExtensionsKt;
import com.jetbrains.python.packaging.utils.PyPackageCoroutine;
import com.jetbrains.python.requirements.PackageUtilsKt;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/requirements/inspections/quickfixes/InstallAllRequirementsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "requirements", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "<init>", "(Ljava/util/List;)V", "getRequirements", "()Ljava/util/List;", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "startInWriteAction", "", "intellij.python.community.impl"})
public final class InstallAllRequirementsQuickFix
implements LocalQuickFix {
    @NotNull
    private final List<PyRequirement> requirements;

    public InstallAllRequirementsQuickFix(@NotNull List<? extends PyRequirement> requirements) {
        Intrinsics.checkNotNullParameter(requirements, (String)"requirements");
        this.requirements = requirements;
    }

    @NotNull
    public final List<PyRequirement> getRequirements() {
        return this.requirements;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.NAME.install.all.requirements", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Set<PyRequirement> confirmedPackages = PyPackageInstallUtils.INSTANCE.getConfirmedPackages$intellij_python_community_impl(this.requirements, project);
        if (confirmedPackages.isEmpty()) {
            return;
        }
        PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        BuildersKt.launch$default((CoroutineScope)PyPackageCoroutine.Companion.getScope(project), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, project, confirmedPackages, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ Set<PyRequirement> $confirmedPackages;
            {
                this.$file = $file;
                this.$project = $project;
                this.$confirmedPackages = $confirmedPackages;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Sdk sdk2 = PackageUtilsKt.getPythonSdk(this.$file);
                        if (sdk2 == null) {
                            return Unit.INSTANCE;
                        }
                        Sdk sdk3 = sdk2;
                        PythonPackageManagerUI manager = PythonPackageManagerUI.Companion.forSdk$default(PythonPackageManagerUI.Companion, this.$project, sdk3, null, 4, null);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)sdk3);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)manager);
                        this.label = 1;
                        Object object2 = PythonPackageManagerUiExtensionsKt.installPyRequirementsBackground(manager, CollectionsKt.toList((Iterable)this.$confirmedPackages), CollectionsKt.emptyList(), (Continuation<? super List<? extends PythonPackage>>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        PythonPackageManagerUI manager = (PythonPackageManagerUI)this.L$1;
                        Sdk sdk4 = (Sdk)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

